#if !defined (TDESKTOP)              // Prevents multiple declarations errors
#define TDESKTOP


/*
   Module        : TDESKTOP.HPP
   Version       : 2.00
   Revision date : July 3rd, 1993
   Author(s)     : Remy Gendron

   Description   : Member functions of {tdesktop} class.
*/


// Headers ------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>
#include "scrfcts.h"
#include "tmenubar.hpp"
#include "tstatusline.hpp"


// Macros -------------------------------------------------------------------

#include "stdmacro.h"                           // Standard macro definitions


// TypeDefs -----------------------------------------------------------------

#include "stdtype.h"                             // Standard type definitions


// Prototypes ---------------------------------------------------------------

class tdesktop
{
   int              deskbackcolor ;             // Desktop's background color
   int              deskforecolor ;             // Desktop's foreground color
   char             desktexture ;             // ASCII code to create desktop
   char        huge *desktitle ;                           // Desktop's title
   int              desktitlebackcolor ;          // Title's background color
   int              desktitleforecolor ;          // Title's foreground color
   int              desktextmode ;        // Text mode to use to open desktop
   bool             deskbbg ;     // If TRUE, bright background colors enable
   text_info        desklastti ;      // To save previous screen's attributes
   cur_info         desklastci ;      // To save previous cursor's attributes
   char        huge *desksavedscr ;               // To save screen's content
   int              deskstatus ;                         // 0:closed 1:opened

   int              deskscreenheight ;             // Current screen's height
   int              deskscreenwidth ;               // Current screen's width


public:

far tdesktop () ;                                              // Constructor

far ~tdesktop () ;                                              // Destructor

void far tdesktop::getsize                          // Returns desktop's size
(
   int huge *height,                           // Ptrs to ints to return size
   int huge *width
) ;

void far tdesktop::settextmode                               // Sets textmode
(
   int  mode=C80,                                     // Textmode code number
   bool brightbackground=FALSE   // If true, bright background colors enabled
) ;

void far tdesktop::setdeskcolors                     // Sets desktop's colors
(
   int back=LIGHTGRAY,                          // Desktop's background color
   int fore=BLUE,                               // Desktop's foreground color
   int clockback=RED,                                          // Clock color
   int clockfore=WHITE
) ;

void far tdesktop::settexture                        // Set's desktop texture
(
   char asciicode=''            // ASCII code of character to use as texture
) ;

void far tdesktop::settitle                           // Sets desktop's title
(
   char huge *text=NULL,                                   // Desktop's title
   int  back=EV_DEF,                              // Title's background color
   int  fore=EV_DEF                               // Title's foreground color
) ;

void far tdesktop::open () ;                                 // Opens desktop

void far tdesktop::close () ;                  // Restores pre-desktop screen

void far tdesktop::refresh () ;    // Redraws desktop, statusline and menubar


private:

void far tdesktop::display () ;    // Draws the desktop from current settings


} ;

// --------------------------------------------------------------------------

extern tdesktop desktop ;           // Reference to the desktop global object


// End Header File ----------------------------------------------------------

#endif
