/******************************************************************************
* Module    :   Utility Routines --- Replacement functions for compiler
*               library functions.  This module exists to avoid having to
*               if def the hell out of the code for systems that, for
*               example, have bcopy, but not memmove.
*
* Author    :   John W. M. Stevens
******************************************************************************/

#include    "compiler.h"

#include    "utils.h"

/*-----------------------------------------------------------------------------
| Routine   :   StrDup() --- String duplication function.
|
| Inputs    :   Str - A pointer to the string to duplicate.
-----------------------------------------------------------------------------*/

char    *StrDup(char    *Str)
{
    register    int     StrLen;
    auto        char    *Tmp;
    extern      FILE    *ErrFile;

    /*  Determine lenght of string to duplicate.    */
    StrLen = strlen( Str ) + 1;

    /*  Allocate the memory.    */
    if ((Tmp = calloc(1, StrLen)) == NULL)
    {
        fprintf(ErrFile,
                "%s %d : Error - out of memory.\n",
                __FILE__,
                __LINE__);
        exit( 1 );
    }

    /*  Copy string contents in.    */
    strcpy(Tmp, Str);
    return( Tmp );
}

/*-----------------------------------------------------------------------------
| Routine   :   FileExists() --- Check to see if a file already exists.
|
| Inputs    :   FlName  - Name of file.
|
| Returns   :   Returns zero for file does not exist, non-zero for it does.
-----------------------------------------------------------------------------*/

int     FileExists(char     *FlName)
{
    auto    FILE    *fp;

    /*  Attempt to open the file as read only to determine if it exists.
    *   Don't you wish that ANSI C had a standard library function for
    *   this?
    */
    if ((fp = fopen(FlName, TXT_READ)) != NULL)
    {
        /*  It exists, so close it and return.  */
        fclose( fp );
        return( 1 );
    }
    return( 0 );
}

/*-----------------------------------------------------------------------------
| Routine   :   MemCopy() --- Copy memory.
|
| Inputs    :   Dest    - Destination address.
|               Source  - Source address.
|               NoBytes - Number of bytes to copy.
-----------------------------------------------------------------------------*/

void    MemCopy(void    *Dest,
                void    *Source,
                int     NoBytes)
{
    register    int     i;
    auto        char    *d;
    auto        char    *s;

    /*  Copy bytes. */
    for (d = (char *) Dest, s = (char *) Source, i = 0;
         i < NoBytes;
         i++)
        *d++ = *s++;
}

/*-----------------------------------------------------------------------------
| Routine   :   MemMv() --- Move memory, taking into account possible
|               overlap.
|
| Inputs    :   Dest    - Destination address.
|               Source  - Source address.
|               NoBytes - Number of bytes to copy.
-----------------------------------------------------------------------------*/

void    MemMv(void    *Dest,
              void    *Source,
              int     NoBytes)
{
    register    int     i;
    auto        char    *d;
    auto        char    *s;

    /*  Pointer conversion. */
    d = (char *) Dest;
    s = (char *) Source;

    /*  Check copy direction.   */
    if (d < s)
    {
        /*  Copy up.    */
        for (i = 0; i < NoBytes; i++)
            *d++ = *s++;
    }
    else if (d > s)
    {
        /*  Copy down.  */
        for (d += NoBytes - 1, s += NoBytes - 1, i = 0;
             i < NoBytes;
             i++)
            *d-- = *s--;
    }
}
