UNIT dmouse;
{$F+}  (* FAR calls are required for the mouse. *)

(* ----------------------------------------------------------------------
   Part of 4DESC - A Simple 4DOS File Description Editor

   (c) Copyright 1993 by

       David Frey,         & Tom Bowden
       Urdorferstrasse 30    1575 Canberra Drive
       8952 Schlieren ZH     Stone Mountain, GA 30088-3629
       Switzerland           USA

       Code created using Turbo Pascal 6.0 (c) Borland International 1990

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.

   This unit handles the (very rudimentary) mouse functions of 4DESC.

   ----------------------------------------------------------------------- *)


INTERFACE USES Dos;

CONST  Left  = 0;  (* Mouse buttons *)
       Right = 1;

VAR    Regs         : Registers;
       MouseLoaded  : Boolean;     (* TRUE if mouse driver is active *)
       ReleaseCount : Integer;     (* Number of button releases *)
       VMickey      : Integer;     (* Vertical mouse movement in mickeys *)
       HMickey      : Integer;     (* Horizontal mouse movement in mickeys *)
       VMickeysPerKeyPress: INTEGER; (* After a move of
                                        VMickeysPerKeyPress mickeys an
                                        up/down keypress will be emulated *)
       HMickeysPerKeyPress: INTEGER; (* After a move of
                                        VMickeysPerKeyPress mickeys an
                                        up/down keypress will be emulated *)

PROCEDURE MouseReset;
PROCEDURE ButtonReleased (Button : INTEGER);
PROCEDURE MouseMotion;

IMPLEMENTATION USES HandleINIFile;

PROCEDURE MouseReset;
BEGIN
  Regs.ax := 0;
  Intr ($33, Regs);        (* The mouse driver uses interrupt $33 *)
  IF Regs.ax <> 0 THEN
      MouseLoaded := TRUE
  ELSE
      MouseLoaded := FALSE;
END; (* MouseReset *)


PROCEDURE ButtonReleased;
BEGIN
  Regs.ax := 6;
  Regs.bx := Button;
  Intr ($33, Regs);
  ReleaseCount := Regs.bx;
END; (* ButtonReleased *)


PROCEDURE MouseMotion;
BEGIN
  Regs.ax := 11;
  Intr ($33, Regs);
  VMickey := Regs.dx;
  HMickey := Regs.cx;
END; (* MouseMotion *)


BEGIN
  MouseReset;
  VMickeysPerKeyPress := ReadSettingsInt('mouse','VMickeysPerKeypress',2);
  HMickeysPerKeyPress := ReadSettingsInt('mouse','HMickeysPerKeypress',2);
END.
