/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: modes.c $
* Version:      $Revision: 1.1 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  Module to implement support for SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: modes.c 1.1 1993/09/19 01:26:00 kjb release $
*
* Revision History:
* -----------------
*
* $Log: modes.c $
* Revision 1.1  1993/09/19  01:26:00  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

int ATIModes[] = {      0x54, 0,        /* 800x600 16 color     */
                        0x55, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x61, 0,        /* 640x400 256 color    */
                        0x62, 0,        /* 640x480 256 color    */
                        0x63, 0,        /* 800x600 256 color    */
                        0x64, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x72, 0,        /* 640x480 32k color    */
                        0x73, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int AHEADAModes[] = {   0x71, 0,        /* 800x600 16 color     */
                        0x74, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x60, 0,        /* 640x400 256 color    */
                        0x61, 0,        /* 640x480 256 color    */
                        0x62, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int AHEADBModes[] = {   0x71, 0,        /* 800x600 16 color     */
                        0x74, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x60, 0,        /* 640x400 256 color    */
                        0x61, 0,        /* 640x480 256 color    */
                        0x62, 0,        /* 800x600 256 color    */
                        0x63, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int CHIPSModes[] = {    0x70, 0,        /* 800x600 16 color     */
                        0x72, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x78, 0,        /* 640x400 256 color    */
                        0x79, 0,        /* 640x480 256 color    */
                        0x7B, 0,        /* 800x600 256 color    */
                        0x7E, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int EVEREXModes[] = {   0x70, 0x02,     /* 800x600 16 color     */
                        0x70, 0x20,     /* 1024x768 16 color    */
                        0x70, 0x21,     /* 1280x1024 16 color   */
                        0x70, 0x13,     /* 640x350 256 color    */
                        0x70, 0x14,     /* 640x400 256 color    */
                        0x70, 0x30,     /* 640x480 256 color    */
                        0x70, 0x31,     /* 800x600 256 color    */
                        0x70, 0x32,     /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0x70, 0x62,     /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x70, 0x71,     /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x70, 0x77,     /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int GENOAModes[] = {    0x79, 0,        /* 800x600 16 color     */
                        0x5F, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0x5B, 0,        /* 640x350 256 color    */
                        0x7E, 0,        /* 640x400 256 color    */
                        0x5C, 0,        /* 640x480 256 color    */
                        0x5E, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int OAKModes[] = {      0x52, 0,        /* 800x600 16 color     */
                        0x56, 0,        /* 1024x768 16 color    */
                        0x58, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x53, 0,        /* 640x480 256 color    */
                        0x54, 0,        /* 800x600 256 color    */
                        0x59, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0x5B, 0,        /* 640x400 32k color    */
                        0x5C, 0,        /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int PARADISEModes[] = { 0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0x64, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5E, 0,        /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0x60, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x62, 0,        /* 640x480 32k color    */
                        0x63, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int TRID88Modes[] = {   0x5B, 0,        /* 800x600 16 color     */
                        0x5F, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5C, 0,        /* 640x400 256 color    */
                        0x5D, 0,        /* 640x480 256 color    */
                        0x5E, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int TRID89Modes[] = {   0x5B, 0,        /* 800x600 16 color     */
                        0x5F, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5C, 0,        /* 640x400 256 color    */
                        0x5D, 0,        /* 640x480 256 color    */
                        0x5E, 0,        /* 800x600 256 color    */
                        0x62, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x74, 0,        /* 640x480 32k color    */
                        0x76, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x75, 0,        /* 640x480 64k color    */
                        0x77, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int VIDEO7Modes[] = {   0x6F05, 0x62,   /* 800x600 16 color     */
                        0x6F05, 0x65,   /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x6F05, 0x66,   /* 640x400 256 color    */
                        0x6F05, 0x67,   /* 640x480 256 color    */
                        0x6F05, 0x69,   /* 800x600 256 color    */
                        0x6F05, 0x6A,   /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int ET3000Modes[] = {   0x29, 0,        /* 800x600 16 color     */
                        0x37, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0x2D, 0,        /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x2E, 0,        /* 640x480 256 color    */
                        0x30, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int ET4000Modes[] = {   0x29, 0,        /* 800x600 16 color     */
                        0x37, 0,        /* 1024x768 16 color    */
                        0x3D, 0,        /* 1280x1024 16 color   */
                        0x2D, 0,        /* 640x350 256 color    */
                        0x2F, 0,        /* 640x400 256 color    */
                        0x2E, 0,        /* 640x480 256 color    */
                        0x30, 0,        /* 800x600 256 color    */
                        0x38, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0x10F0, 0x13,   /* 320x200 32k color    */
                        0x10F0, 0x2D,   /* 640x350 32k color    */
                        0x10F0, 0x2F,   /* 640x400 32k color    */
                        0x10F0, 0x2E,   /* 640x480 32k color    */
                        0x10F0, 0x30,   /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x10F0 | 0x8000, 0x13,  /* 320x200 64k color    */
                        0x10F0 | 0x8000, 0x2D,  /* 640x350 64k color    */
                        0x10F0 | 0x8000, 0x2F,  /* 640x400 64k color    */
                        0x10F0 | 0x8000, 0x2E,  /* 640x480 64k color    */
                        0x10F0 | 0x8000, 0x30,  /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0x10F0, 0x2DFF, /* 640x350 16m color    */
                        0x10F0, 0x2FFF, /* 640x400 16m color    */
                        0x10F0, 0x2EFF, /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int NCRModes[] = {      0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0x67, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5E, 0,        /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0x61, 0,        /* 1024x768 256 color   */
                        0x6A, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x71, 0,        /* 640x480 32k color    */
                        0x72, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x78, 0,        /* 640x480 64k color    */
                        0x79, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int S3Modes[] = {       0x4F02, 0x102,  /* 800x600 16 color     */
                        0x4F02, 0x104,  /* 1024x768 16 color    */
                        0x4F02, 0x106,  /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x4F02, 0x101,  /* 640x480 256 color    */
                        0x4F02, 0x103,  /* 800x600 256 color    */
                        0x4F02, 0x105,  /* 1024x768 256 color   */
                        0x4F02, 0x107,  /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x4F02, 0x301,  /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x4F02, 0x111,  /* 640x480 64k color    */
                        0x4F02, 0x114,  /* 800x600 64k color    */
                        0x4F02, 0x117,  /* 1024x768 64k color   */
                        0x4F02, 0x11A,  /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x4F02, 0x112,  /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int ACUMOSModes[] = {   0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x5E, 0,        /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0, 0,           /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int AL2101Modes[] = {   0x2B, 0,        /* 800x600 16 color     */
                        0x30, 0,        /* 1024x768 16 color    */
                        0x36, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x29, 0,        /* 640x400 256 color    */
                        0x2A, 0,        /* 640x480 256 color    */
                        0x2C, 0,        /* 800x600 256 color    */
                        0x31, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x40, 0,        /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0x42, 0,        /* 640x400 64k color    */
                        0x43, 0,        /* 640x480 64k color    */
                        0x44, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int MXICModes[] = {     0x55, 0,        /* 800x600 16 color     */
                        0x56, 0,        /* 1024x768 16 color    */
                        0, 0,           /* 1280x1024 16 color   */
                        0x57, 0,        /* 640x350 256 color    */
                        0x58, 0,        /* 640x400 256 color    */
                        0x59, 0,        /* 640x480 256 color    */
                        0x5A, 0,        /* 800x600 256 color    */
                        0x5B, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int P2000Modes[] = {    0x2A, 0,        /* 800x600 16 color     */
                        0x30, 0,        /* 1024x768 16 color    */
                        0x36, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x2C, 0,        /* 640x400 256 color    */
                        0x2D, 0,        /* 640x480 256 color    */
                        0x2B, 0,        /* 800x600 256 color    */
                        0x31, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0x42, 0,        /* 640x350 32k color    */
                        0x43, 0,        /* 640x400 32k color    */
                        0x44, 0,        /* 640x480 32k color    */
                        0x45, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0x42 | 0x8000, 0,   /* 640x350 64k color    */
                        0x43 | 0x8000, 0,   /* 640x400 64k color    */
                        0x44 | 0x8000, 0,   /* 640x480 64k color    */
                        0x45 | 0x8000, 0,   /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int RT3106Modes[] = {   0x1F, 0,        /* 800x600 16 color     */
                        0x21, 0,        /* 1024x768 16 color    */
                        0x2A, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0x25, 0,        /* 640x400 256 color    */
                        0x26, 0,        /* 640x480 256 color    */
                        0x27, 0,        /* 800x600 256 color    */
                        0x28, 0,        /* 1024x768 256 color   */
                        0x37, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0, 0,           /* 640x480 32k color    */
                        0, 0,           /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0, 0,           /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0, 0,           /* 640x480 64k color    */
                        0, 0,           /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0, 0,           /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0, 0,           /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

int CIRRUSModes[] = {   0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0x6C, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0x60, 0,        /* 1024x768 256 color   */
                        0, 0,           /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x66, 0,        /* 640x480 32k color    */
                        0x67, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x6F, 0,        /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x64, 0,        /* 640x480 64k color    */
                        0x65, 0,        /* 800x600 64k color    */
                        0, 0,           /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0x70, 0,        /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x71, 0,        /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

/* Lookup table to find the correct mode table for a specific video
 * adapter board.
 */

int *ModeTables[] = {
    ATIModes,
    AHEADAModes,
    AHEADBModes,
    CHIPSModes,
    EVEREXModes,
    GENOAModes,
    OAKModes,
    PARADISEModes,
    TRID88Modes,
    TRID89Modes,
    VIDEO7Modes,
    ET3000Modes,
    ET4000Modes,
    NCRModes,
    S3Modes,
    ACUMOSModes,
    AL2101Modes,
    MXICModes,
    P2000Modes,
    RT3106Modes,
    CIRRUSModes,
    };
