/****************************************************************************
*
*                         The Universal VESA VBE
*
*                   Copyright (C) 1993 Kendall Bennett.
*                           All rights reserved.
*
* Filename:     $RCSfile: _cirrus.c $
* Version:      $Revision: 1.2 $
*
* Language:     ANSI C
* Environment:  IBM PC (MS DOS)
*
* Description:  C language support routines for Cirrus SuperVGA's. Contains
*               detection code, mode translation tables and chipset
*               names.
*
* $Id: _cirrus.c 1.2 1993/09/24 05:22:30 kjb release $
*
* Revision History:
* -----------------
*
* $Log: _cirrus.c $
* Revision 1.2  1993/09/24  05:22:30  kjb
* Fixed a number of bugs.
*
* Revision 1.1  1993/09/19  01:26:26  kjb
* Initial revision
*
****************************************************************************/

/* Mode translation table to determine the values to place into
 * AX and BX in order to initialise a particular video mode
 * via int 10h.
 */

short CIRRUSModes[] = { 0x58, 0,        /* 800x600 16 color     */
                        0x5D, 0,        /* 1024x768 16 color    */
                        0x6C, 0,        /* 1280x1024 16 color   */
                        0, 0,           /* 640x350 256 color    */
                        0, 0,           /* 640x400 256 color    */
                        0x5F, 0,        /* 640x480 256 color    */
                        0x5C, 0,        /* 800x600 256 color    */
                        0x60, 0,        /* 1024x768 256 color   */
						0x6D, 0,        /* 1280x1024 256 color  */
                        0, 0,           /* 320x200 32k color    */
                        0, 0,           /* 640x350 32k color    */
                        0, 0,           /* 640x400 32k color    */
                        0x66, 0,        /* 640x480 32k color    */
                        0x67, 0,        /* 800x600 32k color    */
                        0, 0,           /* 1024x768 32k color   */
                        0, 0,           /* 1280x1024 32k color  */
                        0x6F, 0,        /* 320x200 64k color    */
                        0, 0,           /* 640x350 64k color    */
                        0, 0,           /* 640x400 64k color    */
                        0x64, 0,        /* 640x480 64k color    */
                        0x65, 0,        /* 800x600 64k color    */
						0x74, 0,        /* 1024x768 64k color   */
                        0, 0,           /* 1280x1024 64k color  */
                        0x70, 0,        /* 320x200 16m color    */
                        0, 0,           /* 640x350 16m color    */
                        0, 0,           /* 640x400 16m color    */
                        0x71, 0,        /* 640x480 16m color    */
                        0, 0,           /* 800x600 16m color    */
                        0, 0,           /* 1024x768 16m color   */
                        0, 0,           /* 1280x1024 16m color  */
                        };

typedef enum {
    grCIRRUS_5420,          /* Cirrus 5420 SuperVGA chip                */
    grCIRRUS_5422,          /* Cirrus 5422 SuperVGA chip                */
    grCIRRUS_5424,          /* Cirrus 5424 SuperVGA chip                */
    grCIRRUS_5426,          /* Cirrus 5426 SuperVGA chip                */
    grCIRRUS_5428,          /* Cirrus 5428 SuperVGA chip                */
    } CIRRUS_chipsets;

/* Names of chip revision id's. */

char *CirrusNames[] = {
    "CL-GD5420",
    "CL-GD5422",
    "CL-GD5424",
    "CL-GD5426",
    "CL-GD5428",
    };

bool findCirrus(int *superVGA,int *chipID,int *memory,int *dac,int *pageFlip)
/****************************************************************************
*
* Function:     findCirrus
* Parameters:   superVGA    - ID of the SuperVGA card
*               chipID      - Internal chip ID number
*               memory      - Amount of memory of card
*               dac         - Type of DAC installed
*               pageFlip    - True if page flipping supported
* Returns:      True if card was detected
*
* Description:  Detects the presence of Cirrus Logic based SuperVGA's.
*
****************************************************************************/
{
    int old,mem;

    old = rdinx(SEQ,6);
    wrinx(SEQ,6,0x12);              /* Enable extended registers        */
    if (rdinx(SEQ,6) != 0x12)
        goto NoCirrus;
    if (!tstinx(SEQ,0x1E,0x3F))
        goto NoCirrus;
    if (!tstinx(CRTC,0x1B,0xFF))
        goto NoCirrus;

    /* We have a Cirrus SuperVGA */

    *superVGA = grSVGA_CIRRUS;
    *pageFlip = true;

    switch (rdinx(CRTC,0x27)) {
        case 0x8A:  *chipID = grCIRRUS_5420;    break;
        case 0x8C:
        case 0x8D:
        case 0x8E:
        case 0x8F:  *chipID = grCIRRUS_5422;    break;
        case 0x94:
        case 0x95:
        case 0x96:
        case 0x97:  *chipID = grCIRRUS_5424;    break;
        case 0x90:  *chipID = grCIRRUS_5426;    break;
        case 0x91:  *chipID = grCIRRUS_5428;    break;
        }

    mem = ((rdinx(SEQ,0xA) >> 3) & 3);
    switch (mem) {
        case 0: *memory = 256;  break;
        case 1: *memory = 512;  break;
        case 2: *memory = 1024; break;
        case 3: *memory = 2048; break;
        }

    /* Modify the bytes per line values for some video modes */

    setBytesPerLine(vbe_320x200x16m,2048);
    setBytesPerLine(vbe_640x480x16m,2048);
    return true;

NoCirrus:
    wrinx(SEQ,6,old);
    return false;
}
