;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _genoa.asm $
;* Version:     $Revision: 1.2 $
;*
;* Language:    8086 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Assembly language support routines for Genoa SuperVGA's.
;*
;*              Contains code to perform initialisation, bank switching
;*              and extended page flipping if possible.
;*
;* $Id: _genoa.asm 1.2 1993/09/24 05:23:19 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _genoa.asm $
;* Revision 1.2  1993/09/24  05:23:19  kjb
;* Fixed a number of bugs.
;*
;* Revision 1.1  1993/09/19  01:26:54  kjb
;* Initial revision
;*
;****************************************************************************

;----------------------------------------------------------------------------
; GENOA_bank    Change to a new 64k bank (reading and writing)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    GENOA_bank  far

		push    ax
        push    dx
        mov     ah,al               ; Put read bank in bits 2-0 ...
        shl     al,3                ; ...  write bank in bits 5-3
        or      ah,al
        or      ah,40h              ; Set MEM bit
        mov     al,6                ; Index of Memory Segment Register
        mov     dx,3C4h
        out     dx,ax               ; Set the read/write banks
        pop     dx
        pop     ax
		ret

ENDP    GENOA_bank

GENOA_bank_len      =   ($-GENOA_bank)

;----------------------------------------------------------------------------
; GENOA_rbank   Change to a new 64k read bank (reading only)
;----------------------------------------------------------------------------
;
; Entry:        AX  - Number of 64k bank
;
; Registers:    All preserved!
;
;----------------------------------------------------------------------------
PROC    GENOA_rbank far

		push    ax
        push    dx
        and     al,7                ; Mask out bottom three bits
        mov     ah,al
        mov     dx,3C4h
        mov     al,6                ; Index of Memory Segment Register
        out     dx,al               ; Output index
        inc     dl
        in      al,dx               ; Read current value
        and     al,0F8h             ; Zero bits 2-0
        or      al,ah               ; Or in new value
        out     dx,al               ; Output the new bank
        pop     dx
        pop     ax
		ret

ENDP    GENOA_rbank

GENOA_rbank_len     =   ($-GENOA_rbank)

;----------------------------------------------------------------------------
; GENOA_init
;----------------------------------------------------------------------------
; We have a Genoa GVGA based SuperVGA, so set up vectors for this card.
;----------------------------------------------------------------------------
PROC    GENOA_init

; Setup the correct vectors to use the Genoa bank switching and paging
; routines.

        mov     [TwoBanks],true
        mov     [WriteBank16],offset GENOA_bank
        mov     [WriteBank16Len],GENOA_bank_len
        mov     [WriteBank256],offset GENOA_bank
        mov     [WriteBank256Len],GENOA_bank_len
        mov     [ReadBank16],offset GENOA_rbank
        mov     [ReadBank16Len],GENOA_rbank_len
        mov     [ReadBank256],offset GENOA_rbank
        mov     [ReadBank256Len],GENOA_rbank_len
        ret

ENDP    GENOA_init
