;****************************************************************************
;*
;*                        The Universal VESA VBE
;*
;*                  Copyright (C) 1993 Kendall Bennett.
;*                          All rights reserved.
;*
;* Filename:    $RCSfile: _tables.asm $
;* Version:     $Revision: 1.1 $
;*
;* Language:    80386 Assembler
;* Environment: IBM PC (MS DOS)
;*
;* Description: Module containing the lookup tables for finding the
;*              correct initialisation routine for each supported
;*              SuperVGA adapter.
;*
;* $Id: _tables.asm 1.1 1993/09/19 01:27:05 kjb release $
;*
;* Revision History:
;* -----------------
;*
;* $Log: _tables.asm $
;* Revision 1.1  1993/09/19  01:27:05  kjb
;* Initial revision
;*
;****************************************************************************

; Table of SuperVGA initialisation routines by video card.

SVGAInitTable:
    dw  ATI_init
    dw  AHEAD_init
    dw  CHIPS_init
    dw  EVEREX_init
    dw  GENOA_init
    dw  OAK_init
    dw  PARADISE_init
    dw  TRIDENT_init
    dw  VIDEO7_init
    dw  TSENG_init
    dw  NCR_init
    dw  S3_init
    dw  ACUMOS_init
    dw  AVANCE_init
    dw  MXIC_init
    dw  PRIMUS_init
    dw  REALTEK_init
    dw  CIRRUS_init

;----------------------------------------------------------------------------
; SetupSuperVGA     Initialise the SuperVGA for operation.
;----------------------------------------------------------------------------
;
; Given the id of the SuperVGA card that is installed, this routine looks
; up the correct SuperVGA initialisation routine and gets it to set up
; the correct values for operation with that SuperVGA card.
;
; Registers:    AX,CX,SI,DI
;
;----------------------------------------------------------------------------
PROC    SetupSuperVGA   near

        mov     si,offset SVGAInitTable
        mov     ax,[CntSuperVGA]    ; AX := number of current SuperVGA
        shl     ax,1                ; AX *= 2
        add     si,ax
        call    [WORD cs:si]        ; Call the initialisation routine
        ret

ENDP    SetupSuperVGA
