	.align 2
.global _AckBuildCeilingFloor

.equ CFBkgdBuffer,    8
.equ CFLightFlag,    12
.equ CFTopColor,     16
.equ CFBottomColor,  20
.equ CFWinStartY,    24
.equ CFWinEndY,      28
.equ CFCenterRow,    32

/*===================================================================*
 *
 * void AckBuildCeilingFloor(UCHAR far *,int,int,int,int,int,int);
 *
 *===================================================================*/
_AckBuildCeilingFloor:
	pushl   %ebp
	movl    %esp,%ebp
	pushl	%esi
	pushl	%edi

        movl    CFBkgdBuffer(%ebp), %edi

	testb	$1, CFLightFlag(%ebp)  		/* Is shading on        */
	jz	bcf_normal			/* nope */
	jmp	bcf_shade			/* else create shaded buffer    */

bcf_normal:
	movw	CFCenterRow(%ebp), %cx
	subw	CFWinStartY(%ebp), %cx
	inc	%cx
	imul	$320, %cx
	mov	CFTopColor(%ebp), %ax
        rep
        stosb					/* no need to be fast here      */
	movw	CFWinEndY(%ebp), %cx
	subw	CFCenterRow(%ebp), %cx
	imul	$320, %cx
	mov	CFBottomColor(%ebp), %ax
        rep
        stosb
	jmp	bcf_done			/* exit routine */

bcf_shade:
	mov	CFCenterRow(%ebp), %bx
	sub	CFWinStartY(%ebp), %bx                /* Number of video rows */
	inc	%bx
	mov	%bx,%cx				/* Hold onto total rows */
	shr	$3, %bx				/* Turn into 8 zones    */
	mov	CFTopColor(%ebp), %ax
	mov	%al,%ah				/* Top color to use     */
	mov	$0x4000, %dx			/* set shading for next zone    */
	call	_FillInZone
	mov	$0x4040, %dx
	call	_FillInZone
	mov	$0x8040, %dx
	call	_FillInZone
	mov	$0x8080, %dx
	call	_FillInZone
	mov	$0x0C080, %dx
	call	_FillInZone
	mov	$0x0C0C0, %dx
	call	_FillInZone
	mov	$0x0FFC0, %dx
	call	_FillInZone		/* This takes care of top 8 zones       */
	mov	$0x0FFFFH, %dx
	call	_FillInZone
	xchg	%ax,%bx			/* %ax has rows per zone        */
	xchg	%cx,%bx			/* %bx has total rows for top color     */
	shl	$3, %ax			/* x 8 to get total rows        */
	sub	%ax,%bx			/* get remaining rows if odd    */
	jz	bcf010			/* no odd rows to fill  */
	mov	$0x0FFFFH, %dx
	call	_FillInZone

bcf010:
	mov	CFWinEndY(%ebp), %bx
	sub	CFCenterRow(%ebp), %bx
	mov	%bx,%cx
	shr	$3, %bx
	mov	%bx,%ax
	shl	$3, %ax
	sub	%ax,%cx		/* any odd rows to fill?        */
	jz	bcf020		/* nope */
	push	%bx		/* save rows per zone   */
	mov	%cx,%bx
	mov	$0x0FFFFH, %dx
	call	_FillInZone
	pop	%bx

bcf020:
	mov	CFBottomColor(%ebp), %ax
	mov	%al,%ah
	mov	$0x0FFFF, %dx
	call	_FillInZone
	mov	$0x0FFC0, %dx
	call	_FillInZone
	mov	$0x0C0C0, %dx
	call	_FillInZone
	mov	$0x0C080, %dx
	call	_FillInZone
	mov	$0x8080, %dx
	call	_FillInZone
	mov	$0x8040, %dx
	call	_FillInZone
	mov	$0x4040, %dx
	call	_FillInZone
	mov	$0x4000, %dx
	call	_FillInZone


bcf_done:
	pop	%edi
	pop	%esi
L2:
	leave
	ret


/*===================================================================*
 * Local routine, called by BuildCeilingFloor
 * Entry: BX = number of rows to fill
 *        DX = Shading values for odd/even rows
 *        AX = base color value
 *
 * Exit: %di advanced %bx * 160 bytes, all other registers preserved
 *
 *===================================================================*/
	.align 2
.globl _FillInZone
_FillInZone:
	push	%bx
	push	%cx
	push	%si
	mov	%ax, %si

fiz010:
	testb	$1, %bx				/* check odd/even row   */
	jz	fiz020
	or	%dx,%ax
	jmp	fiz030
fiz020:
	or	%dh,%al				/* swap which bytes are used    */
	or	%ah,%dl
fiz030:
	mov	$160, %cx			/* move in one row      */
        rep
        stosw
	mov	%si, %ax			/* restore base color   */
	dec	%bx				/* bump number of rows  */
	jnz	fiz010

	pop	%si
	pop	%cx
	pop	%bx
	ret


