        .file   "ackfade.s"

.text
AFIbeg          =  8
AFIcnt          = 12
AFIpal          = 16
/*===================================================================*
 * Fade the screen in from black to the palette specified
 * Contributed by Mark Betz
 *===================================================================*/

        .align 2
.global  _AckFadeIn
_AckFadeIn:
        push    %ebp
        mov     %esp,%ebp

        push    %esi
        push    %edi

        pushl   $_WorkPalette   /* call a C routine to go get palette   */
        call    _getPal         /* because of PM vs RM conflicts        */
        movl    $_WorkPalette, %edi  /* offset of pal                   */

       /*--------------------------------------------------------------*
        * get the palette pointer, then calculate the offset to the    *
        * first byte processed, based on start, and the number of      *
        * bytes to process based on count. Use the offset to adjust    *
        * the string pointers in %esi and %edi, and leave the byte     *
        * count in %eax                                                *
        *--------------------------------------------------------------*/

        movl    AFIpal(%ebp),%esi       /* get address of target palette*/
        movl    AFIbeg(%ebp),%eax       /* get offset of first palette  */
        movl    $3, %ebx                /* byte to be processed         */
        mull    %ebx
        addl    %eax, %esi      /* adjust %edi and %esi point first byte*/
        addl    %eax, %edi      /* in the target and temporary palettes */
        movl    AFIcnt(%ebp),%eax       /* find the number of bytes to  */
                                        /* be processed                 */
        mov     $3, %ebx
        mul     %ebx                    /* leave it in %eax             */

       /*--------------------------------------------------------------*
        * clear the bytes in the triplets which will be operated on by *
        * the fade. All other registers are unaffected                 *
        *--------------------------------------------------------------*/

        pushl   %edi            /* save the starting offset into pal    */
        pushl   %eax            /* save the number of bytes to process  */
        movl    %eax, %ecx      /* set up a loop counter                */
        xorl    %eax, %eax      /* clear %ax                            */
        rep
        stosb                   /* fill relevant range of pal with 0's  */
        popl    %eax            /* restore number of bytes to process   */
        popl    %edi            /* restore the starting offset into pal */
        movl    $64, %ecx       /* 64 passes through fade loop          */

       /*--------------------------------------------------------------*
        * the fade loop will execute 64 times. On each pass the inner  *
        * loop adjusts the working palette, then waits for a blanking  *
        * interval, and loads the working palette into the DAC         *
        *--------------------------------------------------------------*/

fade_loop:
        push    %ecx            /* save the fade loop counter           */
        push    %edi            /* save offset of 1st byte processed in */
        push    %esi            /* temp and target palettes             */
        movb    %cl, %bl        /* outer loop count into %bl            */
        movl    %eax, %ecx      /* number of bytes to process into %ecx */

       /*--------------------------------------------------------------*
        * inner loop makes one pass through the palette for each pass  *
        * through the outer loop. Each byte is incremented if it's     *
        * target value is one greater than the outer loop count. Using *
        * this logic ensures that all bytes arrive at their target     *
        * values on the same pass through the outer loop               *
        *--------------------------------------------------------------*/

pal_cmp_loop:
        cmpb    %bl, (%esi)     /* start incrementing when palette value*/
        jns     no_add          /* is one greater than loop count       */
        incb    (%edi)
no_add:
        inc     %esi            /* point to the next byte in both palettes*/
        inc     %edi
        loop    pal_cmp_loop    /* do the next byte                     */

       /*--------------------------------------------------------------*
        * setup for palette load. As much as possible was moved above  *
        * the blanking interval wait, in order to maximize the amount  *
        * of the blanking interval remaining in which to do the        *
        * palette loading                                              *
        *--------------------------------------------------------------*/

        movl    %esp, %ebx
        movl    %ss:4(%ebx),%edi /* restore offset into pal without popping    */
        mov     AFIcnt(%ebp),%ecx/* number of triplets to process       */
        push    %eax             /* need to use %ax for port i/o        */

       /*--------------------------------------------------------------*
        * monitor bit 1 of CRT controller's input status 1 register to *
        * sense a vertical blanking interval. Wait for any current vbi *
        * to end, then wait for the next full one to begin.            *
        *--------------------------------------------------------------*/

        movl    $0x03DA, %edx   /* CRT controller input status 1 reg    */
vbi_1:
        inb     %dx, %al        /* watch vertical blanking bit          */
        testb   $8, %al         /* wait for it to clear to make sure    */
        jnz     vbi_1           /* we're not in a blanking interval     */
vbi_2:
        inb     %dx, %al        /* now wait for the start of the        */
        testb   $8, %al         /* next blanking interval               */
        jz      vbi_2

       /*--------------------------------------------------------------*
        * load the relevant triplets from pal into the VGA DAC palette *
        *--------------------------------------------------------------*/

        movb    AFIbeg(%ebp),%ah /* get first register to process into ah*/
        movl    $0x03c8, %edx   /* DAC palette index register           */
pal_load_loop:
        movb    %ah, %al        /* get next palette number to write     */
        outb    %al, %dx        /* write the register number to the dac */
        incl    %edx            /* address dac data register            */
        movb    (%edi), %al     /* get first byte of triplet            */
        outb    %al, %dx        /* write it to the dac data register    */
        incl    %edi            /* point to second byte                 */
        movb    (%edi), %al     /* get second byte of triplet           */
        outb    %al, %dx        /* write it to the dac data register    */
        incl    %edi            /* point to third byte                  */
        movb    (%edi), %al     /* get third byte of triplet            */
        outb    %al, %dx        /* write it to the dac data register    */
        incl    %edi            /* point to first byte of next triplet  */
        decl    %edx            /* address the dac index register       */
        incb    %ah             /* point to next palette register       */
        loop    pal_load_loop   /* process next triplet                 */

       /*--------------------------------------------------------------*
        * clean-up for the next pass through the fade loop             *
        *--------------------------------------------------------------*/

        popl    %eax            /* restore %eax                         */
        popl    %esi            /* restore the offset into palette      */
        popl    %edi            /* restore the offset into pal          */
        popl    %ecx            /* restore the fade loop counter        */
        loop    fade_loop       /* do the next pass thru the fade loop  */

        pop     %edi
        pop     %esi

        leave
        ret

/*===================================================================*
 * void AckFadeOut(int Begin,int Count);
 * Contributed by Mark Betz
 *===================================================================*/
/************************************************
AFObeg	equ	[%bp+6]
AFOcnt	equ	[%bp+8]

PBEGIN _AckFadeOut
	push	%bp
	mov	%bp,sp
	push	%ds
	push	%si
	push	%di

	push	%ds		  ; get data segment into %es
	pop	%es
	mov	%dx, offset DGROUP:_WorkPalette
	push	%dx		  ; save offset of opal
	xor	%bx, %bx
	mov	%cx, 100h
	mov	%ax, 1017h	  ; bios read dac registers function
	int	10h		  ; read the palette registers into opal
	pop	%di		  ; offset of opal, was in %dx!
	mov	%ax, AFObeg	  ; get offset of first palette byte to
	mov	%bx, 3		  ; be proc%essed
	mul	%bx
	add	%di, %ax		  ; adjust offset into opal
	mov	%ax, AFOcnt	  ; find the number of byt%es to be proc%essed
	mov	%bx, 3
	mul	%bx		  ; leave it in %ax
	mov	%cx, 64		  ; 64 pass%es through fade loop
o_fade_loop:
	push	%cx		  ; save the fade loop counter
	push	%di		  ; save offset of first byte proc%essed in
	mov	%bl, %cl		  ; we'll use the pass number as a thr%eshold
	mov	%cx, %ax		  ; load number of byt%es to proc%ess into %cx
o_pal_cmp_loop:
	cmp	%bl, %es:[%di]	  ; start decrementing when palette value
	jnz	o_no_dec	  ; is equal loop count (it will stay equal
	dec	BYTE PTR %es:[%di]  ; to loop count for the r%est of this pass)
o_no_dec:
	inc	%di
	loop	o_pal_cmp_loop	    ; do the next byte

	mov	%bx, sp		    ; need the stack pointer for a moment
	mov	%di, ss:[%bx]	    ; r%estore offset into pal without popping
	mov	%cx, AFOcnt	    ; number of triplets to proc%ess
	push	%ax		    ; need to use %ax for port i/o

	    mov %dx, 03DAh		; CRT controller input status 1 register
o_vbi_1:
		in al, %dx		    ; watch vertical blanking bit
		t%est al,08h		    ; wait for it to clear to make sure
		jnz o_vbi_1		    ; we're not in a blanking interval
o_vbi_2:
		in al, %dx		    ; now wait for the start of the
		t%est al,08h		    ; next blanking interval
		jz o_vbi_2

	mov	ah, BYTE PTR AFObeg ; get first register to proc%ess into ah
	mov	%dx, 03c8h	    ; DAC palette index register
o_pal_load_loop:
	mov	al, ah		    ; get next palette number to write
	out	%dx, al		    ; write the register number to the dac
	inc	%dx		    ; addr%ess dac data register
	mov	al, BYTE PTR %es:[%di] ; get first byte of triplet
	out	%dx, al		     ; write it to the dac data register
	inc	%di		     ; point to second byte
	mov	al, BYTE PTR %es:[%di] ; get second byte of triplet
	out	%dx, al		     ; write it to the dac data register
	inc	%di		     ; point to third byte
	mov	al, BYTE PTR %es:[%di] ; get third byte of triplet
	out	%dx, al		     ; write it to the dac data register
	inc	%di		     ; point to first byte of next triplet
	dec	%dx		     ; addr%ess the dac index register
	inc	ah		     ; point to next palette register
	loop	o_pal_load_loop	     ; proc%ess next triplet

	pop	%ax		  ; r%estore %ax
	pop	%di		  ; r%estore the offset into pal
	pop	%cx		  ; r%estore the fade loop counter
	loop	o_fade_loop	  ; do the next pass through the fade loop



	pop	%di
	pop	%si
	pop	%ds
	pop	%bp
	ret
_AckFadeOut endp


