        .file   "ackmse.s"
.data

        .global _vga_mouse_modifier
_vga_mouse_modifier:
        .int      2

.text

        .align 2
.global _mouse_installed
_mouse_installed:
        pushl   %ebp
        movl    $0, %eax
        int     $0x33
        cwde                    /* result in %ax - extend to DW */
        popl    %ebp
        ret

        .align 2
.global _mouse_show_cursor
_mouse_show_cursor:
        pushl   %ebp
        movl    $1, %eax
        int     $0x33

        popl    %ebp
        ret

        .align 2
.global _mouse_hide_cursor
_mouse_hide_cursor:
        pushl   %ebp
        movl    $2, %eax
        int     $0x33

        popl    %ebp
        ret


        .align 2
.global _mouse_read_cursor
_mouse_read_cursor:
	pushl   %ebp
	movl    %esp, %ebp
	pushl   %esi
	pushl   %ebx
        pushl   %ecx
        pushl   %edx

        movl    $3, %eax
        int     $0x33

        /* *bstatus = BX       */
        movl    8(%ebp), %esi
	movl    %ebx, (%esi)

        /* *mrow = DX   */
	movl    12(%ebp),%esi
	movl    %edx,(%esi)

        /* *mcol = CX / vga_mouse_modifier */
	movl    16(%ebp),%esi
	movl    %ecx,%eax

	cltd
	idivl   _vga_mouse_modifier, %eax

	movl    %eax,(%esi)

        popl    %edx
        popl    %ecx
	popl    %ebx
	popl    %esi
        popl    %ebp
	ret

        .align 2
.global _mouse_set_cursor
/*
 * void mouse_set_cursor(int mrow, int mcol);   
 */
_mouse_set_cursor:
        pushl   %ebp
        movl    %esp, %ebp
        movl    $4, %eax
        movl    12(%ebp), %ecx
        movl    8(%ebp), %edx
        imull   _vga_mouse_modifier, %ecx
        int     $0x33

        popl    %ebp
        ret

        .align 2
.global _mouse_press_info
_mouse_press_info:
	pushl   %ebp
	movl    %esp,%ebp
	pushl   %esi
	pushl   %ebx
        pushl   %ecx
        pushl   %edx

        movl    8(%ebp), %esi
        movl    (%esi), %ebx
        movl    $5, %eax
        int     $0x33

        /* *bstatus = AX       */
        movl    8(%ebp), %esi
	movl    %eax, (%esi)

        /* *bcount = BX       */
        movl    8(%ebp), %esi
	movl    %ebx, (%esi)

        /* *mrow = DX   */
	movl    16(%ebp),%esi
	movl    %edx,(%esi)

        /* *mcol = CX / vga_mouse_modifier */
	movl    20(%ebp),%esi
	movl    %ecx,%eax
	cltd
	idivl   _vga_mouse_modifier
	movl    %eax,(%esi)

        popl    %edx
        popl    %ecx
	popl    %ebx
	popl    %esi
        popl    %ebp
	ret

        .align 2
.global _mouse_release_info
_mouse_release_info:
	pushl   %ebp
	movl    %esp,%ebp
	pushl   %esi
	pushl   %ebx
        pushl   %ecx
        pushl   %edx
        
        /* BX = *bstatus        */
        movl    8(%ebp), %esi
        movl    (%esi), %ebx
        movl    $6, %eax
        int     $0x33

        /* *bstatus = AX       */
        movl    8(%ebp), %esi
	movl    %eax, (%esi)

        /* *bcount = BX       */
        movl    8(%ebp), %esi
	movl    %ebx, (%esi)

        /* *mrow = DX   */
	movl    16(%ebp),%esi
	movl    %edx,(%esi)

        /* *mcol = CX / vga_mouse_modifier */
	movl    20(%ebp),%esi
	movl    %ecx,%eax
	cltd
	idivl   _vga_mouse_modifier
	movl    %eax,(%esi)

        popl    %edx
        popl    %ecx
	popl    %ebx
	popl    %esi
        popl    %ebp
	ret

        .align 2
.global _mouse_set_minmax_columns
_mouse_set_minmax_columns:
        pushl   %ebp
	movl    %esp,%ebp

        movl    $7, %eax
        movl    8(%ebp), %ecx
        movl    12(%ebp), %edx
        int     $0x33

        popl    %ebp
        ret

        .align 2
.global _mouse_set_minmax_rows
_mouse_set_minmax_rows:
        pushl   %ebp
	movl    %esp,%ebp

        movl    $8, %eax
        movl    8(%ebp), %ecx
        movl    12(%ebp), %edx
        int     $0x33

        popl    %ebp
        ret

        .align 2
.global _mouse_set_mickey_pixel_ratio
_mouse_set_mickey_pixel_ratio:
        pushl   %ebp
	movl    %esp,%ebp

        movl    $15, %eax
        movl    8(%ebp), %ecx
        movl    12(%ebp), %edx
        int     $0x33

        popl    %ebp
        ret


