/******************* ( Animation Construction Kit 3D ) ***********************/
/*			Overlay Creation Routines			     */
/* CopyRight (c) 1993	   Author: Lary Myers				     */
/*****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
#include "ack3d.h"
#include "ackeng.h"

/****************************************************************************
** This routine "compiles" the source buffer (sBuf) into a series of draw  **
** commands to speed up the overlay drawing. The commands are then placed  **
** into the OverlayBuffer for later use. The application should use this   **
** call if it wishes to use an irregular viewport for the display.	   **
**									   **
****************************************************************************/
int AckCreateOverlay(ACKENG *ae,UCHAR far *sBuf)
{
    UINT    bPos,vPos,vLen;
    UINT    len,sPos,sPos1;

vLen = (ae->WinEndY - ae->WinStartY) * BYTES_PER_ROW;
vPos = ae->WinStartY * BYTES_PER_ROW;
bPos = 0;
sPos = vPos;

while (vLen > 0)
    {
    if (sBuf[sPos])
	{
	sPos1 = sPos;
	while (vLen > 0 && sBuf[sPos1++])
	    vLen--;

	len = (sPos1 - sPos) - 1;
	(*(int *)&ae->ScreenBuffer[bPos]) = len;
	bPos += 2;
	(*(int *)&ae->ScreenBuffer[bPos]) = sPos;
	bPos += 2;
	memmove(&ae->ScreenBuffer[bPos],&sBuf[sPos],len);
	bPos += len;
	sPos = sPos1;
	}
    else
	{
	sPos++;
	vLen--;
	}
    }

(*(int *)&ae->ScreenBuffer[bPos]) = 0;
bPos += 2;

ae->OverlayBuffer = malloc(bPos);

if (ae->OverlayBuffer != NULL)
    {
    memmove(ae->OverlayBuffer,ae->ScreenBuffer,bPos);
    return(0);
    }

return(ERR_NOMEMORY);
}


