/*=========================================================*
 |                                                         |
 | ACKPCX_R.C                                              |
 |                                                         |
 *=========================================================*
 | PCX Graphics File Format input routines.                |
 *=========================================================*
 | Copyright (c) 1991,1994 kgraham  All Rights Reserved    |
 | These routines are being included with the ACK 3D       |
 | Construction Kit and are subject to the licensing       |
 | restrictions of said software.                          |
 *=========================================================*/
#include <stdio.h>
#include <malloc.h>
#include "ack3d.h"
#include "ackpcx.h"

extern int   ErrorCode;      /* Ack version of errno                */
extern UCHAR colordat[768];  /* maximum it can be...256 colors      */

/*********************************************************************
** read pcx picture file into memory and return a pointer to it.    **
**                                                                  **
** Caveat: This routine does not do scaling or clipping, so the     **
**         PCX file must be 64x64x1 bit plane to succeed.           **
*********************************************************************/
UCHAR *AckReadpcx( char *filename )
{
    int     i;
    UINT    size;
    UINT    len;
    UINT    count;
    UCHAR  *pic;
    UCHAR   chr;
    FILE   *fp;
    PCXHDR  hdr;

    /*
     * open specified file
     */
    if ((fp = fopen(filename, "rb")) == NULL) {
        ErrorCode = ERR_BADFILE;
        return(NULL);
    }
    /*
     * read PCX header in
     */
    if (fread(&hdr, sizeof(PCXHDR), 1, fp) != 1) {
        ErrorCode = ERR_BADFILE;
        fclose(fp);
        return(NULL);
    }
    /*
     * check for 1 color plane (ackpcx won't do 4 color planes yet)
     */
    if (hdr.nplanes != 1) {
        ErrorCode = ERR_BADPICFILE;
        fclose(fp);
        return(NULL);
    }
    /*
     * get size from header and malloc a buffer
     * 4 chars bigger to hold 2 shorts (xsize & ysize)
     */
    size = (hdr.x2+1) * (hdr.y2+1);
    if ((pic = malloc(size+4)) == NULL) {
        ErrorCode = ERR_NOMEMORY;
        fclose(fp);
        return(NULL);
    }
    /*
     * put size into buffer (some routines care, some don't)
     */
    pic[0] = (UCHAR)(hdr.x2+1)%256;     /* put width & height   */
    pic[1] = (UCHAR)(hdr.x2+1)/256;     /* into first 4 bytes   */
    pic[2] = (UCHAR)(hdr.y2+1)%256;     /* to match AckReadiff  */
    pic[3] = (UCHAR)(hdr.y2+1)/256;     /* routine.             */
    len = 4;
    /*
     * check heading for RLE (Run Length Encoding) compression
     */
    if (hdr.encoding == 1) {
        while (len < size) {            /* pic is RLE encoded       */
            chr = (UCHAR)fgetc(fp);
            if ((chr & 0xC0) == 0xC0) { /* check for repeat count   */
                count = chr & 0x3F;
                chr = (UCHAR)fgetc(fp);
                for (i=0;i<count;i++) {
                    pic[len++] = chr;
                }
            }
            else {
                pic[len++] = chr;
            }
        }
    }
    else {                              /* no encoding - just read it   */
        if (fread(pic, size, 1, fp) != 1) {
            ErrorCode = ERR_BADPICFILE;
            fclose(fp);
            return(NULL);
        }
    }
    /*
     * check for 256 color palette "magic cookie"
     */
    if ((chr = (UCHAR)fgetc(fp)) == PALFLAG) {
        fread(colordat, 768, 1, fp);    /* read 256 color palette   */
    }
    ErrorCode = 0;
    return(pic);
}
