/******************* ( Animation Construction Kit 3D ) **********************
 *                          Wrapup Routines                                 *
 * CopyRight (c) 1993   Author: Lary Myers                                  *
 *                  GNU C Mods: Ken Graham                                  *
 ****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <memory.h>
#include <malloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
#include "ack3d.h"
#include "ackeng.h"
#include "ackext.h"

/****************************************************************************
** This routine **MUST** be called by the application prior to exiting to  **
** allow XMS memory to be returned to the system. Failure to do so will	   **
** cause the XMS memory to become unavailable to other applications.	   **
**                                                                         **
** Note: XMS part has been removed. kag                                    **
****************************************************************************/
int AckWrapUp(ACKENG *ae)
{

    free(LongTanTable);
    free(LongInvTanTable);
    free(CosTable);
    free(SinTable);
    free(InvSinTable);
    free(InvCosTable);
    free(LongCosTable);
    free(xNextTable);
    free(yNextTable);
    free(ViewCosTable);

    if (ae->OverlayBuffer != NULL)
        free(ae->OverlayBuffer);
    ae->OverlayBuffer = NULL;

    if (ae->BkgdBuffer != NULL)
        free(ae->BkgdBuffer);
    ae->BkgdBuffer = NULL;

    if (ae->ScreenBuffer != NULL)
        free(ae->ScreenBuffer);
    ae->ScreenBuffer = NULL;

    return(0);
}

