/************************************************************
 *                                                          *
 * ack2neo.c                                                *
 *                                                          *
 *----------------------------------------------------------*
 * A quick and dirty conversion routine to convert a raw    *
 * palette file (used by the ACK3D Construction Kit) to the *
 * palette format used by NeoPaint.                         *
 *----------------------------------------------------------*
 * Copyright (c) 1994 ken graham, All Rights Reserved       *
 *----------------------------------------------------------*
 * This routine is being included with the ACK3D            *
 * Construction Kit.                                        *
 ************************************************************/
#include <stdio.h>

char *Header1   = {"NeoPaint Palette File"};
char *Header2   = {"(C)1992 OSCS Software Development, Inc."};

unsigned char pal[3*256];

void main(int argc, char *argv[])
{
    int      i;
    FILE    *fp;

    if ((fp = fopen(argv[1], "rb")) == NULL) {
        fprintf(stderr, "Unable to open palette file: '%s'\n", argv[1]);
        exit(1);
    }
    if (fread(pal, 256*3, 1, fp) != 1) {
        fclose(fp);
        fprintf(stderr, "Unable to read palette.\n");
        exit(1);
    }
    printf("%s\n", Header1);
    printf("%s\n", Header2);
    printf("256\n");
    for (i=0;i<256;i++) {
        printf("%d %d %d\n", pal[i*3], pal[i*3+1], pal[i*3+2]);
    }
    fclose(fp);
    exit(0);
}
