/*****************************************************************************
*   This is an UNTESTED port of the DrawCol2 routine from ACK3D file ACKASM  *
* to allow conversion to other compilers and platforms. It is released into  *
* the public domain as an accompanying file to the ACK3D series of source    *
* files and can be freely used under the same restrictions as the original   *
* ACK source.                                                                *
*                                                                            *
* Copyright (c) 1994                                                         *
* Author: Lary Myers                                                         *
*****************************************************************************/

/*
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <mem.h>
#include <alloc.h>
#include <io.h>
#include <fcntl.h>
#include <time.h>
#include <string.h>
#include <sys\stat.h>
*/
#include <stdio.h>
#include "ack3d.h"
#include "ackeng.h"
#include "ackext.h"


/*****************************************************************************
 *                                                                           *
 *****************************************************************************/
void draw_col2( int Col, int slice, int dist, int width, int ht, UCHAR *Wall,
                UCHAR *Screen, UCHAR *Pal, int light, int offset)
{
    UINT    height;
    UINT    UpperHeight;
    UINT    bmOffset;
    int     PalDist;
    int     DCangle = 0;
    UCHAR   *Screen2;
    UCHAR   bmByte;

    PalDist = dist >> 6;        /* Divide by 64 to get palette range */
    if (PalDist > 15) {
        PalDist = 15;
    }


    if (light) {                   /* If shading is ON */
        Pal += (PalDist << 8);  /* Point to correct palette table */
    }

    Screen += (offset + Col);   /* Point to center row + current column */
    Screen2 = Screen + width;   /* Point one row down from screen */

    slice = slice << 6;            /* Point to correct bitmap row */
    height = 0;

    while (DCangle++ < ht) {
        UpperHeight = height >> 8;  /* Get high byte of current height */
        if (UpperHeight >= 32) {    /* We've done both halves of bitmap */
            break;
        }

        bmOffset = slice + (31 - UpperHeight);
        if ((bmByte = Wall[bmOffset]) != 0) {
            *Screen = Pal[bmByte];
        }

        bmOffset = slice + 32 + UpperHeight;
        if ((bmByte = Wall[bmOffset]) != 0) {
            *Screen2 = Pal[bmByte];
        }

        Screen -= width;
        Screen2 += width;
        height += dist;
    }
}

void draw_col2x(int Col, int slice, int dist, int width, int ht, UCHAR *Wall,
                UCHAR *Screen, UCHAR *Pal, int light, int offset)
{
    UINT    height;
    UINT    UpperHeight;
    UINT    bmOffset;
    int     PalDist;
    int     DCangle = 0;
    int     pflag   = 0;
    UCHAR   *Screen2;
    UCHAR   bmByte;
    extern int  onetime;

    PalDist = dist >> 6;        /* Divide by 64 to get palette range */
    if (PalDist > 15) {
        PalDist = 15;
    }


    if (light) {                /* If shading is ON */
        Pal += (PalDist << 8);  /* Point to correct palette table */
    }

    Screen += (offset + Col);   /* Point to center row + current column */
    Screen2 = Screen + width;   /* Point one row down from screen */

    slice = slice << 6;         /* Point to correct bitmap row */
    height = 0;

    if (onetime) {
        printf("[Pal     = 0x%x]\n", Pal);
        printf("[Wall    = 0x%x]\n", Wall);
        printf("[ht      = 0x%x]\n", ht);
        printf("[PalDist = 0x%x]\n", PalDist);
    }
    while (DCangle++ < ht) {
        UpperHeight = (height >> 8);  /* Get high byte of current height */
        if (UpperHeight >= 32) {    /* We've done both halves of bitmap */
            break;
        }

        bmOffset = slice + (31 - UpperHeight);
        if ((bmByte = Wall[bmOffset]) != 0) {
            *Screen = Pal[bmByte];
            if (onetime) {
                printf("[0x%04x:0x%02x]", (unsigned int)bmByte, (unsigned char)Pal[bmByte]);
                pflag = 1;
            }
        }

        bmOffset = slice + 32 + UpperHeight;
        if ((bmByte = Wall[bmOffset]) != 0) {
            *Screen2 = Pal[bmByte];
            if (onetime) {
                printf("{0x%04x:0x%02x}", (unsigned int)bmByte, (unsigned char)Pal[bmByte]);
                pflag = 1;
            }
        }

        Screen  -= width;
        Screen2 += width;
        height  += dist;
    }
    if (pflag) {
        printf("\n");
    }
}
