	.file	"drawcol2.s"

.text
/*======================================================================*
 * draw_col2(int Col,int slice,int %dist,int width,int ht,UCHAR far *Wall,
 *	    UCHAR far *Screen,UCHAR far *Pal,int light,int offset);
 * Contributed by Jaimi McEntire
 * Modified for 32 bit GNU assembler by k. graham
 *======================================================================*/

.equ	DCcol,    8
.equ	DCslice, 12
.equ	DCdist,  16
.equ	DCwidth, 20
.equ	DCht,    24
.equ	DCwall,  28
.equ	DCscrn,  32
.equ	DCPal,   36
.equ	DClight, 40
.equ	DChoff,  44

.equ	DCangle, -4

        .align 2
.global _draw_col2
_draw_col2:
	pushl	%ebp                    /* build stack frame            */
	movl	%esp, %ebp
	sub	$4, %esp
	push	%ds
	push	%esi
	push	%edi

	movl	$0, DCangle(%ebp)
	movl    $0, %edx
	movl    $0, %esi

	movl    DCdist(%ebp), %eax      /* get distance to object       */
	shr	$6, %eax                /* divide it by 64 to get zones.*/

	cmp	$15, %eax               /* make sure zone doesn't go    */
                                        /* beyond 15                    */
	jl	zoneokay
	movl    $15, %eax

zoneokay:
/*
 * Good place for light modifier to modify zone
 */
	 shl    $8, %eax                /* mult by 256 to get offset    */
                                        /* into paltables.              */
	 movl   DCPal(%ebp), %edx       /* point EDX at PalTables       */
	 cmpw	$0, DClight(%ebp)
	 jz	zonelight
	 add    %eax, %edx              /* FS:DX points to corrected    */
                                        /* palette for zone.            */
zonelight:
        movl    DCscrn(%ebp), %edi      /* EDI points to painting area  */
	movl	DCwall(%ebp), %esi      /* DS:SI point to wall buffer   */
	mov     DChoff(%ebp), %ebx      /* Pick up offset to center of  */
                                        /* viewport                     */
	addl    DCcol(%ebp), %ebx
	addl    %ebx, %edi              /* %edi now point at starting   */
                                        /* area (top run)               */
	movl    %edi, %ebx
	addl    DCwidth(%ebp), %ebx     /* %ebx points to 1 down (for   */
                                        /* bottom run)                  */

	movl    $0, %ecx                /* ht.                          */
	movl    DCslice(%ebp), %eax
	shl     $6, %eax                /* mult slice by 64             */
	addl    %esi, %eax              /* add in offset to wall bitmap */
	movl    %eax, DCslice(%ebp)     /* save it                      */
	movl    $0, %eax

looptop:
	movzbl	%ch, %eax	        /* current ht                   */
	movl    $31, %esi		/* base to start with           */
	subl    %eax, %esi              /* base - ht = row              */
	addl    DCslice(%ebp), %esi     /* plus column start to point   */
                                        /* at the pixel.                */
	movb	(%esi), %al             /* mov al,offset slice[%esi]    */
	or	%al, %al                /* see if transparent           */
	jz	blank		        /* yes, don't draw this pixel   */
	movb    (%edx,%eax), %al        /* added this line to get       */
                                        /* correct shading.             */
	movb	%al, (%edi)

blank:
	movzbl  %ch, %esi               /* use a cool 386 instruction   */
                                        /* to accomplish                */
	addl	$32, %esi               /* same as mov %ax,%cx          */
                                        /* shr %ax,8 !!                 */
	addl	DCslice(%ebp), %esi     /* add in starting column       */
	movb	(%esi), %al
	or	%al, %al
	je	blank2
	movb	(%edx,%eax), %al        /* added this line to shade it. */
	movb	%al, (%ebx)

blank2:
	mov	DCwidth(%ebp), %eax
	sub	%eax, %edi              /* point to next two dest pixels*/
	add	%eax, %ebx              /* point to next two dest pixels*/
	add	DCdist(%ebp), %cx       /* add distance to ht adjuster. */

	cmp	$32, %ch                /* cmp to 32 (half our bmp size)*/
	jge	outtahere		/* get out if bitmap done.      */

	movl    DCangle(%ebp), %eax
	inc	%eax
	cmp	DCht(%ebp), %eax        /* if half height,              */
	jge	outtahere               /* then leave.                  */
	movl    %eax, DCangle(%ebp)
	jmp	looptop

outtahere:

	pop	%edi
	pop	%esi
	pop	%ds

        leave
	ret

