/********************************************************************
 *                                                                  *
 * xdump_r.c                                                        *
 *                                                                  *
 *------------------------------------------------------------------*
 * hex dump with ASCII routine. Call with pointer to buffer, length *
 * and file pointer. Call with fp = stdout to print to screen.      *
 *------------------------------------------------------------------*
 * Copyright (c) 1991,1992,1993,1994 ken graham All Rights Reserved *
 * This file is being released as part of the ACK3D Construction    *
 * Set. For any other use please contact the author.                *
 ********************************************************************/
#include <stdio.h>

void xdump(char *inbuff, int len, FILE *fp)
{
    long    i = 0L;
    long    imod;
    char    buffer[16];
    unsigned int    chr;

    fprintf(fp,"_______ 00_01_02_03_04_05_06_07_08_09_0A_0B_0C_0D_0E_0F_ 0123456789ABCDEF\n");
    while (i < len) {
        chr = *inbuff++;
        if ((imod = i%16) == 0) {
            if (i) {
                fprintf(fp," %s\n", buffer);
            }
            fprintf(fp,"%06lx: ", i);
        }
        fprintf(fp,"%02x ", (unsigned char)chr);
        if (chr > 0x1f && chr < 0x7f) {
            buffer[imod] = chr;
        }
        else {
            buffer[imod] = '.';
        }
        i++;
    }
    if ((imod = i%16) != 0) {
        buffer[imod] = '\0';
        for (;imod<16;imod++) {
            fprintf(fp,"   ");
        }
    }
    fprintf(fp," %s\n", buffer);
    exit(0);
}

