/*** PCL4C.H ***/

#if __cplusplus
/* External Library Function Prototypes for C++ */
extern "C" int FAR PASCAL SioBaud(int, int);
extern "C" int FAR PASCAL SioBrkSig(int, char);
extern "C" int FAR PASCAL SioCTS(int);
extern "C" int FAR PASCAL SioDCD(int);
extern "C" int FAR PASCAL SioDSR(int);
extern "C" int FAR PASCAL SioDTR(int, char);
extern "C" int FAR PASCAL SioDone(int);
extern "C" int FAR PASCAL SioFIFO(int, int);
extern "C" int FAR PASCAL SioFlow(int, int);
extern "C" int FAR PASCAL SioGetc(int);
extern "C" int FAR PASCAL SioInfo(char);
extern "C" int FAR PASCAL SioIRQ(int, int);
extern "C" int FAR PASCAL SioLine(int);
extern "C" int FAR PASCAL SioLoopBack(int);
extern "C" int FAR PASCAL SioModem(int, char);
extern "C" int FAR PASCAL SioParms(int, int, int, int);
extern "C" int FAR PASCAL SioPorts(int,int,int);
extern "C" int FAR PASCAL SioPutc(int, char);
extern "C" int FAR PASCAL SioRead(int, int);
extern "C" int FAR PASCAL SioReset(int, int);
extern "C" int FAR PASCAL SioRI(int);
extern "C" int FAR PASCAL SioRTS(int, char);
extern "C" int FAR PASCAL SioRxBuf(int, int, int);
extern "C" int FAR PASCAL SioRxFlush(int);
extern "C" int FAR PASCAL SioRxQue(int);
extern "C" int FAR PASCAL SioTxBuf(int, int, int);
extern "C" int FAR PASCAL SioTxFlush(int);
extern "C" int FAR PASCAL SioTxQue(int);
extern "C" int FAR PASCAL SioUART(int, int);
extern "C" int FAR PASCAL SioUnGetc(int, char);
extern "C" int FAR PASCAL SioDebug(int);
#else
/* External Library Function Prototypes for C */
extern int FAR PASCAL SioBaud(int, int);
extern int FAR PASCAL SioBrkSig(int, char);
extern int FAR PASCAL SioCTS(int);
extern int FAR PASCAL SioDCD(int);
extern int FAR PASCAL SioDSR(int);
extern int FAR PASCAL SioDTR(int, char);
extern int FAR PASCAL SioDone(int);
extern int FAR PASCAL SioFIFO(int, int);
extern int FAR PASCAL SioFlow(int, int);
extern int FAR PASCAL SioGetc(int);
extern int FAR PASCAL SioInfo(char);
extern int FAR PASCAL SioIRQ(int, int);
extern int FAR PASCAL SioLine(int);
extern int FAR PASCAL SioLoopBack(int);
extern int FAR PASCAL SioModem(int, char);
extern int FAR PASCAL SioParms(int, int, int, int);
extern int FAR PASCAL SioPorts(int,int,int);
extern int FAR PASCAL SioPutc(int, char);
extern int FAR PASCAL SioRead(int, int);
extern int FAR PASCAL SioReset(int, int);
extern int FAR PASCAL SioRI(int);
extern int FAR PASCAL SioRTS(int, char);
extern int FAR PASCAL SioRxBuf(int, int, int);
extern int FAR PASCAL SioRxFlush(int);
extern int FAR PASCAL SioRxQue(int);
extern int FAR PASCAL SioTxBuf(int, int, int);
extern int FAR PASCAL SioTxFlush(int);
extern int FAR PASCAL SioTxQue(int);
extern int FAR PASCAL SioUART(int, int);
extern int FAR PASCAL SioUnGetc(int, char);
extern int FAR PASCAL SioDebug(int);
#endif

/* Port Codes */

#define COM1   0
#define COM2   1
#define COM3   2
#define COM4   3
#define COM5   4
#define COM6   5
#define COM7   6
#define COM8   7
#define COM9   8
#define COM10  9

/* Baud Rate Codes */

#define Baud300 0
#define Baud600 1
#define Baud1200 2
#define Baud2400 3
#define Baud4800 4
#define Baud9600 5
#define Baud19200 6
#define Baud38400 7
#define Baud57600 8
#define Baud115200 9

#define NORESET -1

/* Parity Codes */

#define NoParity 0
#define OddParity  1
#define EvenParity 3
#define MarkParity 5
#define SpaceParity 7

/* Stop Bit Codes */

#define OneStopBit  0
#define TwoStopBits 1

/* Word Length Codes */

#define WordLength5  0
#define WordLength6  1
#define WordLength7  2
#define WordLength8  3

/* Buffer Size Codes */

#define Size8    0
#define Size16   1
#define Size32   2
#define Size64   3
#define Size128  4
#define Size256  5
#define Size512  6
#define Size1024 7
#define Size2048 8
#define Size4096 9
#define Size8192  10
#define Size16384 11
#define Size32768 12
#define Size1K   7
#define Size2K   8
#define Size4K   9
#define Size8K  10
#define Size16K 11
#define Size32K 12

/* Line Status Masks */

#define TransBufferEmpty 0x20
#define BreakDetect  0x10
#define FramingError 0x08
#define ParityError  0x04
#define OverrunError 0x02
#define DataReady    0x01

/* Modem Status Masks */

#define DCD 0x80
#define RI  0x40
#define DSR 0x20
#define CTS 0x10
#define DeltaDCD 0x08
#define DeltaRI  0x04
#define DeltaDSR 0x02
#define DeltaCTS 0x01

/* Break Signal Commands */

#define ASSERT_BREAK 'A'
#define CANCEL_BREAK 'C'
#define DETECT_BREAK 'D'

/* SioDTR & SioRTS Commands */

#define SET_LINE   'S'
#define CLEAR_LINE 'C'
#define READ_LINE  'R'

/* FIFO level codes */
#define FIFO_OFF -1
#define LEVEL_1   0
#define LEVEL_4   1
#define LEVEL_8   2
#define LEVEL_14  3

/* IRQ codes */

#define IRQ2  2
#define IRQ3  3
#define IRQ4  4
#define IRQ5  5
#define IRQ6  6
#define IRQ7  7

/* SioInfo Commands */

#define VERSION 'V'
#define M_MODEL 'M'
