/*
**                    --- simple.c ---
**
**  EXAMPLE CODE: Very simple terminal emulator.
**
**  This example program (not the PCL4C library) is donated to
**  the Public Domain by MarshallSoft Computing, Inc. It is
**  provided as an example of the use of the PCL4W.
**
*/

#include "windows.h"
#include "simple.h"
#include "pcl4w.h"
#include "sioerror.h"
#include "ascii.h"
#include "simpl_io.h"
#include "expect.h"
#include "config.h"
#include "paint.h"
#include "line.h"
#include "about.h"

/* public globals */
HWND hMainWnd;            /* main window handle */
HWND hInfoWnd;            /* popup handle */
HANDLE hInstance;         /* program instance */
int OnLineFlag = FALSE;   /* TRUE: online */
int FatalFlag = FALSE;    /* TRUE: fatal error */
/* miscellaneous functions */
void ErrorCheck(int);

/*
** PostMainHandle() is required only for the
** Shareware version of PCL4W.
*/

#if __cplusplus
extern "C" void FAR PASCAL PostMainHandle(HWND);
#else
extern void FAR PASCAL PostMainHandle(HWND);
#endif

int PASCAL WinMain(HANDLE hInst,HANDLE hPrevInstance,
                   LPSTR lpCmdLine,int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "SimpleIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "SimpleMenu";
    wc.lpszClassName = "SimpleWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "SimpleWClass",   "Simple",       WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,    CW_USEDEFAULT,
        CW_USEDEFAULT,    CW_USEDEFAULT,
        NULL,             NULL,
        hInstance,        NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,NULL,NULL))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

long FAR PASCAL MainWndProc(HWND hWindow,UINT message,WPARAM wParam,LPARAM lParam)
{
 UINT idTimer;
 HDC hDC;
 PAINTSTRUCT ps;
 int i;
 int TheChar;
 char Temp[82];
 HMENU hMenu;
 int Count;
 static FARPROC lpProcAbout;
 static int ThePort;

 hMainWnd = hWindow;
 switch (message)
    {
     case WM_COMMAND:
         switch(wParam)
           {case MSG_ABOUT:
              DialogBox(hInstance,"AboutBox",hMainWnd,lpProcAbout);
              break;

            case MSG_LOAD:
              if(!ExpectOffLine()) break;
              LoadConfig();
              break;

            case MSG_SAVE:
              if(!ExpectOffLine()) break;
              SaveConfig();
              SetTitle();
              break;

            case MSG_ONLINE:
              if(!ExpectOffLine()) break;
              if(FatalFlag) ErrorMessage("Fatal Error");
              else
                {/* try to go on-line */
                 GoOnLine();
                 if(!OnLineFlag) break;
                 ThePort = GetPort();
                }
              break;

            case MSG_OFFLINE:
              GoOffLine();
              break;

            case MSG_EXIT:
              GoOffLine();
              KillTimer(hMainWnd,idTimer);
              PostQuitMessage(0);
              break;

            case MSG_1200:
              SetBaud(Baud1200);
              break;

            case MSG_2400:
              SetBaud(Baud2400);
              break;

            case MSG_4800:
              SetBaud(Baud4800);
              break;

            case MSG_9600:
              SetBaud(Baud9600);
              break;

            case MSG_19200:
              SetBaud(Baud19200);
              break;

            case MSG_38400:
              SetBaud(Baud38400);
              break;

            case MSG_57600:
              SetBaud(Baud57600);
              break;

            case MSG_115200:
              SetBaud(Baud115200);
              break;

            case MSG_COM1:
              SetPort(COM1);
              break;

            case MSG_COM2:
              SetPort(COM2);
              break;

            case MSG_COM3:
              SetPort(COM3);
              break;

            case MSG_COM4:
              SetPort(COM4);
              break;

            case MSG_NONE:
              SetParity(NoParity);
              break;

            case MSG_EVEN:
              SetParity(EvenParity);
              break;

            case MSG_ODD:
              SetParity(OddParity);
              break;

            case MSG_1_SB:
              SetStopBits(OneStopBit);
              break;

            case MSG_2_SB:
              SetStopBits(TwoStopBits);
              break;

            case MSG_7_DB:
              SetWordLength(WordLength7);
              break;

            case MSG_8_DB:
              SetWordLength(WordLength8);
              break;

            default:
              return (DefWindowProc(hMainWnd, message, wParam, lParam));
           }
         break;

    case WM_CREATE:

/*
** You must call PostMainHandle() before attemping to go online.
** This is required only for the Shareware version of PCL4W.
*/
      PostMainHandle(hMainWnd);

      /* check "OFFLINE" menu item */
      hMenu = GetMenu(hMainWnd);
      CheckMenuItem(hMenu,MSG_OFFLINE,MF_BYCOMMAND | MF_CHECKED);
      /* create AboutDlgProc() thunk */
      lpProcAbout = MakeProcInstance(AboutDlgProc, hInstance);
      /* init configuration */
      InitConfig();
      LoadConfig();
      /* initialize paint module */
      InitPaint();
      /* start timer */
      idTimer = SetTimer(hMainWnd,1,125,NULL);
      if(idTimer==0)
         {ErrorMessage("No timers remaining !");
          FatalFlag = TRUE;
         }

#if 1
 /*** Custom Configuration: DigiBoard PC/8 for COM3 - COM10 ***/
 /* use 0x140 for odd IRQs & 0x141 for even IRQs */
 SioPorts(10,COM3,0x140);
 /* set DigiBoard UART addresses for COM3 to COM10 */
 for(i=0;i<8;i++)
   {/* set DigiBoard port address */
    ErrorCheck(SioUART(COM3+i,0x100+8*i) );
    /* set DigiBoard for IRQ5 */
    ErrorCheck(SioIRQ(COM3+i,IRQ5) );
   }
#endif

      break;

    case WM_CHAR:
      PutChar(ThePort, (char)wParam );
      break;

    case WM_TIMER:
      /* fatal error ? */
      if(FatalFlag) break;
      if(!OnLineFlag) break;
      /* fetch line of up to 82 chars */
      Count = 0;
      for(i=0;i<82;i++)
        {TheChar = GetChar(ThePort);
         /* character available ? */
         if(TheChar==-1) break;
         Temp[Count++] = TheChar;
         if((char)TheChar==(char)LF) break;
        } /* end while */
      if(Count>0) WriteTheString(Temp,Count);
      break;

    case WM_SETFOCUS:
      /* create client area caret */
      CreateCaret(hMainWnd,NULL,3,10);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      ShowCaret(hMainWnd);
      break;

    case WM_KILLFOCUS:
      DestroyCaret();
      break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(GetXposition(),GetYposition());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      GoOffLine();
      if(idTimer) KillTimer(hMainWnd,idTimer);
      PostQuitMessage(0);
      break;

    default:
      return (DefWindowProc(hMainWnd, message, wParam, lParam));
   }
 return (NULL);
} /* end MainWndProc */

void ErrorCheck(int Code)
{/* trap PCL error codes */
 if(Code<0)
     {SioDone(GetPort());
      FatalFlag = TRUE;
     }
} /* end ErrorCheck */
