{{$DEFINE Trans}         {* do only enable if you have TRANS.L *}

program XplainToSQL;

uses Objects, BBError, BBFile, BBStrRes, BBUtil,
     SqlXplMn, Drivers, Views, TextView,
     {$IFDEF Trans}
     Trans, DVAPI
     {$ENDIF}
     App, HelpFile;


type
  PSQLWindow = ^TSQLWindow;
  TSQLWindow = object(TWindow)
    Interior : PTerminal;
    constructor Init(var Bounds : TRect; BufSize : Word);
  end;

  PXplainStatementDlg = ^TXplainStatementDlg;
  TXplainStatementDlg = object(SqlXplMn.TXplainStatementDlg)
    procedure HandleEvent(var Event : TEvent);  virtual;
  end;

  TSqlXplApp = object(SqlXplMn.TSqlXplApp)
    procedure HandleEvent(var Event : TEvent);  virtual;
  end;


constructor TSQLWindow.Init(var Bounds : TRect; BufSize : Word);
var
  R : TRect;
  vSB, hSB : PScrollBar;
begin
  inherited Init(Bounds, 'Xplain to SQL translation', wnNoNumber);
  vSB := StandardScrollBar(sbVertical + sbHandleKeyboard);
  Insert(vSB);
  hsb := StandardScrollBar(sbHorizontal + sbHandleKeyboard);
  Insert(hSB);
  GetExtent(R);
  R.Grow(-1, -1);
  Interior := New(PTerminal, Init(R, hSB, vSB, BufSize));
  Insert(Interior);
  AssignDevice(Output, Interior);
  Rewrite(Output);
end;


procedure TXplainStatementDlg.HandleEvent(var Event : TEvent);
var
  r : TXplainStatementDlgRec;
  i : integer;
  t : text;
  s : string;
begin
  inherited HandleEvent(Event);
  if Event.What and evCommand <> 0 then  begin
    case Event.Command of
      cmTranslate : begin

        {* get entered statement *}
          GetData(r);

{$IFDEF Trans}
        {* write statement to file *}
          Assign(t, 'XPLAIN.OUT');
          Rewrite(t);
          for i := 0 to r.Statement.Length-1 do
            write(t, r.Statement.Buffer[i]);
          writeln(t, '.');
          System.Close(t);

        {* translate Xplain to SQL *}
          Translate;

        {* output translated SQL statement to window *}
          Assign(t, 'SQL.IN');
          Reset(t);
          while not eof(t) do   begin
            readln(t, s);
            writeln(s);
          end;
          System.Close(t);
{$ELSE}
          for i := 0 to r.Statement.Length-1 do
            write(r.Statement.Buffer[i]);
{$ENDIF}

        end;
      SqlXplMn.cmClear : begin
          r.Statement.Length := 0;
          SetData(r);
        end;
    end; { of case }
  end;
end;


procedure TSqlXplApp.HandleEvent(var Event : TEvent);
var
  R : TRect;
begin
  inherited HandleEvent(Event);
  if (Event.What and evCommand <> 0) and (Event.Command = cmOpenTranslateDlg) then  begin
    R.Assign(0,0,50,10);
    DeskTop^.Insert(New(PSQLWindow, Init(R, 4096)));
    DeskTop^.Insert(New(PXplainStatementDlg, Init));
  end;
end;


var
  MyApp : TSqlXplApp;
  Event : TEvent;
begin
  PrintStr(prnCR+'Xplain to SQL 1.00  (c) 1993 by Berend de Boer and Ronald Breedveld');
  RegisterType(RStringList);
  LoadStrings;

  InstallExitHandler('XPL2SQL.LOG', nil);

  RegisterHelpFile;

{$IFDEF Trans}
  dv_api_init;
{$ENDIF}

  MyApp.Init;
  Event.What := evCommand;
  Event.Command := cmOpenTranslateDlg;
  MyApp.PutEvent(Event);
  MyApp.Run;
  Close(Output);
  MyApp.Done;

{$IFDEF Trans}
  dv_api_exit;
{$ENDIF}
end.
