
                    CHORDMASTER - Unregistered Version 2.0
                      Chord Chemistry Program for Guitar
                  Copyright (c) 1991,1992,1993 Robert Watson
                            All Rights Reserved


      This software and the disks on which it contained is licensed to
      you, for your own use.  This is copyrighted software.  You are not
      obtaining title to the software or any copyright rights.  You may
      not sublicense, rent, lease, convey, modify, translate, convert to
      another programming language, decompile, or disassemble the software
      for any purpose.
           You may make as many copies of this software as you need for
      back-up purposes.  You may use this software on more than one computer,
      provided there is no chance that it will be used simultaneously on more
      than one computer.  If you need to use the software on more than one 
      computer simultaneously, please contact us for information about site
      licenses.



                                 DISCLAIMER


      ROBERT WATSON DISCLAIMS ALL WARRANTIES RELATING TO THIS SOFTWARE,
      WHETHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED 
      WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE,
      AND ALL SUCH WARRANTIES ARE EXPRESSLY AND SPECIFICALLY DISCLAIMED.
      NEITHER ROBERT WATSON OR ANYONE ELSE WHO HAS BEEN INVOLVED IN THE
      CREATION, PRODUCTION, OR DELIVERY OF THIS SOFTWARE SHALL BE LIABLE
      FOR ANY INDIRECT, CONSEQUENTIAL, OR INCIDENTAL DAMAGES ARISING OUT
      OF THE USE OR INABILITY TO USE SUCH SOFTWARE EVEN IF ROBERT WATSON
      HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES OR CLAIMS.  IN
      NO EVENT SHALL ROBERT WATSON'S LIABILITY FOR ANY DAMAGES EVER EXCEED 
      THE PRICE PAID FOR THE LICENSE TO USE THE SOFTWARE, REGARDLESS OF THE 
      FORM OF THE CLAIM.  THE PERSON USING THE SOFTWARE BEARS ALL RISK AS TO 
      THE QUALITY AND PERFORMANCE OF THE SOFTWARE.
           Some states do not allow the exclusion of the limit of liability
      for consequential or incidental damages, so the above limitation may
      not apply to you.
          This agreement shall be governed by the laws of the State of
      California and shall inure to the benefit of Robert Watson and 
      any successors, administrators, heirs and assigns.  Any action or 
      proceeding brought by either party against the other arising out of 
      or related to this agreement shall be brought only in a STATE or 
      FEDERAL COURT of competent jurisdiction located in Los Angeles County, 
      California.  The parties hereby consent to in personam jurisdiction of 
      said courts.













***


                               CHORDMASTER
                    Chord Chemistry Program for Guitar


                               USERS MANUAL




                             TABLE OF CONTENTS


            INTRODUCTION ............................... 1

            INSTALLATION ............................... 2

            CHORD ENTRY ................................ 3
               CHORD ENTRY METHODS ..................... 3
               CHORD ENTRY TABLE ....................... 3
               CHORD ENTRY TABLE OPTIONS ............... 4
               COMMAND LINE ENTRY ...................... 4
                  IDENTIFIERS........................... 4
               NOTE ENTRY .............................. 5
               ERRORS .................................. 5

            SCREEN FORMAT .............................. 6
            FRETBOARD COMMANDS ......................... 7

            TAB VIEW SEQUENCER ......................... 8
               TIMING ROW .............................. 8
               POSITION ROW ............................ 8
               BUTTON ROW .............................. 9
               SEQUENCE EDITING ........................ 9
                  ADDING NOTES ......................... 9
                  SETTING NOTE LENGTHS ................ 10
                  DELETING/ERASING NOTES .............. 10
                  BLOCK OPERATIONS .................... 10
                  HINTS ............................... 11

            MAIN MENU ................................. 10
               FILES .................................. 12
                  PRINTING ............................ 12
                  EXPORTING ........................... 13
               SEQUENCER .............................. 14
                  SONG SETTINGS ....................... 14
                     MIDI ............................. 14
                     SOUND CARD ....................... 14
                  METER & TEMPO MAPS .................. 15
                  TIMINGS ............................. 15
               CHORDINGS .............................. 16
                  DISPLAYING .......................... 16
               TUNINGS ................................ 18
               OPTIONS ................................ 19










***




                                INTRODUCTION

   CHORDMASTER is state-of-the-art chord chemistry software designed 
   specifically for guitarists.  CHORDMASTER PRO PLUS is not only a valuable
   aid and reference, useful for a variety of educational purposes; but a 
   unique compositional tool that uses the guitar fretboard as a metaphor.  
   This unregistered version demonstrates some of capabilities of the      
   CHORDMASTER programs.  See the README.DOC file for more details.


   CHORDMASTER PRO PLUS VERSION 2.0 FEATURES -

            NEW!!! - Tab View Sequencer plays songs in tablature while
             fingerings are shown on the active fretboard.

            NEW!!! - "Point and Shoot" Editor lets you create new songs
             by using your mouse to select notes on the fretboard.

            NEW!!! - The Guitarist's File Standard, the "AXE" file stores 
             fingering, timing, tuning and patch data.  AXE2MIDI file export 
             utility lets your transfer your work to a MIDI file.

            NEW!!! - Sequencer supports Tempo and Meter mapping, as well
             as STEP mode.

            NEW!!! - Rudimentary string by string transposition of pieces
             into different tunings.

            NEW!!! - Tablature can be output to printer or text files.

            NEW!!! - Improved chord resolution capability enhances synonym
             recognition, and identifying of obscure inputs.

            NEW!!! - Integrated Guitar Tuner.

            Support for MIDI, Sound Blaster and other sound cards.

            Interactive Chord Entry Table for easy input of chord entries.

            Chord entries can quickly be transposed to different keys.

            Notes for two chords can be overlayed on one fretboard,
             allowing analysis of similarities and differences.

            Chords can be input by name or by specifying notes to be resolved 
            to a known chording.  Chords can be resolved to up to five chord 
            synonyms. Obscure inputs can be resolved to proper chords.

            Chords libraries are provided, allowing for the display of
             thousands of individual chordings. User chord libraries can
             be maintained for custom chord display capabilities.

            Individual chord display can be limited to certain string
             and fret ranges.

            Context-sensitive HELP screens, mouse and printer support.

                                   - 1 -



***




                               INSTALLATION

   CHORDMASTER requires about 550 Kbytes of disk space, and can be run
   from either a floppy or hard disk.

   Unregistered versions of CHORDMASTER are distributed in ZIP format and 
   require PKUNZIP to install.  Here's a sample hard drive installation that 
   assumes that the CHORDZ.ZIP file is in the current directory.


      Example:    MD \CHORDS <enter>                (create chord directory)
                  PKUNZIP CHORDZ \CHORDS <enter>    (unzip CHORDMASTER)
                  CD \CHORDS                        (log the chord directory)
                  SETUP                             (creates subdirectories)
                  CHORDS <enter>                    (executes the program)





   WINDOWS USERS - 

   CHORDMASTER will run either full screen or windowed in WINDOWS 3.x.  A
   windows icon (CHORDS.ICO) and PIF file (CHORDS.PIF) are included.  To 
   create your own PIF file for CHORDMASTER using the PIF editor, consider  
   the following.  384K of RAM is required.  To run CHORDMASTER in its
   own window, WINDOWS must be started in 386 enhanced mode.  If using the  
   enhanced mode add a 'w' in the Optional Parameters box of the PIF screen.
   This will disable CHORDMASTER's graphical startup screen and avoid a video
   error in WINDOWS.

   When CHORDMASTER is run in a window, mouse functions will only work if the
   program is first started as a full screen application, and switched to a
   window via ALT-SPACEBAR.

   Because CHORDMASTER takes control of specific timing functions, chords and
   songs may not play smoothly under windows.




















                                   - 2 -



***




                                CHORD ENTRY

   After the opening screens the program will display a blank fretboard
   and wait for commands from the the main menu.  There are several ways 
   to enter chords.
   
   CHORD ENTRY METHODS

      Chord Entry Table  -  A quick interactive method for chord entry.

      Command Line       -  Type in the name of a chord.

      Note Entry         -  Specify the notes in a chord and let CHORDMASTER
                            identify it.

      Each of these methods is discussed below:


   CHORD ENTRY TABLE

   CHORDMASTER's Chord Entry Table is a quick, convenient way to enter a 
   chord to be displayed.  The table can be accessed by via the CHORDINGS
   submenu.
      
   The Chord Entry Table consists of four component sections: KEY, SUFFIX,
   ADD, and ALTER.  The first and second sections, KEY and SUFFIX, are   
   essential and one item from each is always selected.  The ADD and ALTER
   sections are not essential and selections in them are optional.


   MAKING SELECTIONS  

        TAB         to move from section to section.
     ARROW keys     to move around within a section.
     SPACE BAR      selects/deselects the highlighted item in the ADD/ALTER
                     section.

      MOUSE USERS : Click on an item to select it, click again to deselect.


   Note that at any given time certain ADD/ALTER selections are darkened and
   not available.  Which selections are available will depend on which SUFFIX
   and other ADD/ALTER selections are made.  The Chord Entry Table reacts 
   interactively, showing which combinations are musically permissible.
   












                                   - 3 -



***




   CHORD ENTRY TABLE - OPTIONS

      FREE ARROW KEYS     - Some keyboard users will find this option a 
                            more convenient way to traverse the table.  
                            Using this method the ARROW keys can traverse 
                            the table, moving from section to section.  The
                            TAB key need only be used to anchor selections 
                            in the leftmost columns of the KEY or SUFFIX 
                            areas.  This method requires fewer keystrokes
                            to accomplish many of the same tasks.

      REMEMBER LAST CHORD - This option makes the Chord Entry Table remember
                            the previous chording that was entered with the
                            table.  This is useful when entering successive
                            chords that are similar in some respect.



   COMMAND LINE CHORD ENTRY

   Use the following format for entering a chord by name:

                  [A-G][#,b(optional)] [chord identifier options]

   At the very least you must enter an uppercase letter in the range of
   'A' through 'G'.  Optionally, you may indicate that the note is to be
   sharped or flatted by adding a '#' for a sharp or a lowercase 'b' for
   a flat.  Why the preoccupation with upper and lowercase?  Consider a
   B flat chord.  It looks fine as 'Bb', but kind of silly as 'bb', 'BB',
   or 'bB'.

   So you must enter the key or root of the chord you want to work with.
   If this is all you enter it is assumed that you are looking for a
   major chord.  To specify other chords you must add one or more chord
   identifier options, separated by spaces.

   The following are legitimate identifier options:

   FIRST GROUP

      maj             maj6             maj7             maj9
      maj11           maj13            minmaj7          minmaj9
      min             min6             min7             min9
      min11           min13            dim              dim7
      5               6                7                9
      11              13               aug              aug9
      aug11           noroot


   SECOND GROUP

      add or /        sus              + or -    (followed by numbers 2 - 13)





                                   - 4 -



***




   Identifiers may be combined, separated by a space, in any combination that
   is musically sensible.  Now, what is musically sensible may vary according
   to whose rules you are following.  For the most part you will use one of
   the identifier options in the first group, optionally followed by one or
   more of the identifier combinations in the second group.

   The identifiers in the first group are common in describing chords.  See
   a book on chord theory for an explanation of these identifiers.  

   The identifiers in the second group are less common and are often written
   in different ways.  Here is brief explanation of the second group:

      add   or   /      -  Used to add a tone to tone to a chord.  These
                           are useful in creating common and exotic chords
                           and scales.  The catch is that the tone to be
                           added must not have been described in a previous
                           identifier or an error message will result.
      sus               -  Generally used to add a 2nd or 4th tone to a
                           chord at the expense of the 3rd.
      +    or    -      -  used to add an altered tone, or alter an existing
                           tone, to an existing chord.


   Here are some of the errors that can be encountered during chord entry.
   Errors only occur when using the command-line input method.

         ILLEGAL                    -  What you typed is nonsensible.
         STEP ALREADY EXISTS        -  Your trying to add (add or /) a tone
                                       that has already been established.
         TONE SPECIFIED IS > 13     -  You've tried to add or alter a tone
                                       that is greater than 13.
         ILLEGAL TONE SPECIFIED     -  You've tried add or alter a
                                       non-numeric entity.


   NOTE ENTRY

   Entry can also be accomplished by specifying the notes to be used in the
   chord.  CHORDMASTER then attempts to identify the chord.  Note entry is
   particularly easy with a mouse.  Non-mouse users should use NOTE ENTRY 
   under the CHORDINGS submenu.

   NOTE ENTRY with a mouse:

      Enter a chord's notes by clicking on the desired fret positions on
      the active fretboard.  Clicking on a previously selected note will
      de-select it.  Once the desired notes have been selected, click on
      the word PROCESS which will appear above the active fretboard.  If
      the notes can be identified as a chord, its name will be displayed.
      The lowest note selected will be considered as the primary root for
      the resulting chord.






                                   - 5 -



***




   Once a valid chord has been entered, all the notes in the chord are
   displayed on a fretboard and the notes are sounded through the system
   speaker.  Additionally, a display appears above and to the right of the
   fretboard showing the relationship of the notes in the chord to the tones
   in a scale.  This display is the chord formula header.

   For instance, if 'A' is entered; the chord formula header will display
   the following:
                        1   2   3   4   5   6   7
                        A       C#      E

   This indicates that the 'A' major chord that was entered has three tones
   in it; a 1st or root, a 3rd and a 5th.  Therefore, an 'A' major chord has
   a formula of 1, 3, 5 .  The established spacing of these notes is function
   of established music theory and will not be discussed in this section.  It
   is not necessary to fully understand these mechanisms to begin using and
   enjoying CHORDMASTER.

   An additional line of text appears immediately below the fretboard, this
   is called the RESOLVE line.  If you entered 'A', as in the example above,
   this line would simply read 'A MAJ'.  This may seem kind of redundant at
   this point, but as you will see as you read on, the RESOLVE line is one of
   CHORDMASTER's most powerful features.

   Let's look again at the fretboard.  If you have entered the simple example
   chord shown above, the fretboard shows all the notes in an 'A' major chord
   scattered about the fretboard.  This is a powerful visual tool.  It allows
   the user to visualize an entire section of fretboard.  In this case, any
   fingerable combination of notes that contains at least one 'A', one 'C#'
   and one 'E', is a legitimate 'A' major chord.  Don't worry, CHORDMASTER
   can also display individual chord fingerings as we will see shortly.


























                                   - 6 -



***




                             FRETBOARD COMMANDS

   There are several quick key combinations available after a chord is 
   entered, they are:

         <- or ->    -  Shifts the fretboard view range left or right.
                        At any one time 16 frets are visible, over a range
                        of 25.

            P        -  Repeats the playing of the tones in the chord.

         -  or  +    -  Changes the timing of the playing of the tones
                        in the chord.

            D        -  Displays individual fingerings for the entered chord.

   UP or DOWN arrows -  TRANSPOSE the most recent entry to a higher
                        or lower key.

            T        -  Switch between like keys. For example 'C#' to 'Db'.

            S        -  Brings up the Tab View Sequencer window.


   MOUSE USERS :  DISPLAY of individual chordings can be initiated by
                  clicking on the DISPLAY box which will appear above the
                  active fretboard.

                  Entries can be TRANSPOSED thru keys by clicking on the
                  appropriate side of the TRANSPOSE button.  Clicking in
                  the middle of the button will switch between like keys.
                  For example 'C#' to 'Db'.
























                                   
                                   - 7 -



***




                               SEQUENCE CHART

 The Tab View Sequencer window can be accessed in many ways, including: 
 opening an AXE file under the FILES menu, selecting SEQUENCE WINDOW from  
 the SEQUENCER menu, or by pressing 'S'.  Most CHORDMASTER options, including 
 Chord Entry and Display, are still available when the Sequencer Window is 
 open.

                             TAB VIEW SEQUENCER

 Tab View combines standard guitar tablature with timing information in a
 way that makes it easy to visualize, play and edit songs, without having
 to read music.

 TIME SIGNATURE
       |          
       --------  4/4  001 -  |  -  |  -  |  - 002 -  |    --- TIMING ROW
                    E
                    B
                    G            STRING/NOTE
   STRING ROWS      D               AREA
                    A
                    E
                   BPM                                     --- POSITION ROW
                  120   INFO   ZOOM     STEP    --- BUTTON ROW
                  

 PARTS OF THE TAB VIEW WINDOW

 STRING NOTE AREA - The fret numbers of fingered (and open) notes are
                    displayed on the row associated with a given guitar
                    string.  The notes are spaced horizontally to indicate
                    their proper timing.  Sustained notes are shown with
                    dashes following for the length of the note.

 TIMING ROW       - The top row of the Tab View Window is the Timing Row.
                    In the upper left, is the Time Signature of a song.
                    The numbers across the timing row serve as measure
                    markers, and the vertical bars reflect the beats as
                    described in the Time Signature.  CHORDMASTER supports
                    Meter Mapping, allowing Time Signatures to change
                    throughout a song.  To access the meter map press 'M'
                    or use the mouse to click on the Time Signature.

 POSITION ROW     - The triangular Position Marker moves as the song is
                    played, indicating the current position in the song.
                    When a song is not being played a mouse click on the
                    row moves the marker to that position.  Click on the
                    left and right arrows at either end of the marker row
                    to single step the marker in that direction.  Editing
                    functions affect data at the marker position.






                                   - 8 -



***




 BUTTON ROW       - Provides quick access to the most commonly used
                    sequencing functions:

              BPM   Use mouse to click on the left and right segments of
                    this button to change the tempo of a piece.  The keyboard
                    equivalents are CTRL+ and CTRL-.

             INFO   Brings up CHORDMASTER's integrated text editor.  Use
                    this to add comments, explanations or other information
                    about a particular piece of music.  This text becomes
                    part of the SONG file.

             ZOOM   Controls the density of notes pictured in the Tab View
                    window.  The minimum zoom is dependent on the shortest
                    note in the piece.  Use the mouse, or 'Z' and 'ALT Z' to
                    zoom in and out, respectively.

      REWIND / FF   These button segments imitate the associated tape
                    recorder functions.  The outer button segments are the
                    full Rewind and full Fast Forward buttons.  These move
                    the Position Marker to the beginning or end of the song,
                    respectively.  The inner button segments are used to
                    step thru the song a screen at a time in the appropriate
                    direction.  Keyboard: Use 'R','CTRL R', 'CTRL F', 'F'.

          EXECUTE   Starts and stops the playing of a song.

                                 SHORTCUTS

   Each of above functions can be accessed by clicking with the mouse or
   by using the highlighted hot keys associated with each button.  
   
   METER MAPPING  -  Can be accessed by pressing 'M' or clicking on the
                     Time Signature symbol at the upper left corner of
                     the Tab View window.

   TEMPO MAPPING  -  Can be accessed by pressing 'B' or clicking on the
                     BPM symbol at the lower left corner of the Tab View 
                     window.

                             SEQUENCE EDITING

   Sequence editing is not available in this unregistered version.  The 
   following text shows how easy it is!  See README.DOC for information 
   on ordering CHORDMASTER PRO PLUS.  Sequence editing requires a mouse.

   ADDING NOTES

         Move the Position Marker to the desired point as described above.
         Add notes by clicking on the active fretboard at the desired frets.
         When the mouse cursor is over the fretboard, a left click adds a
         note, while a right click moves the Position Marker to the right.

         Whole chords can be added in while in DISPLAY mode by left clicking
         on the Timing Row at the desired position.


                                   - 9 -



***




   SETTING NOTE LENGTHS

         There are two ways to set the length of a note:

            (1) Adjust the length of existing notes by left clicking at a
                position to the right of the note.  Dashes will appear,
                indicating the new length.

            (2) When adding a note by left clicking on the fretboard,
                additional clicks will cycle the length of the note
                from the shortest length to a whole note.  When a note
                length is established in this way, it becomes the default
                note length for future entries.

         Left clicking directly on an extended note truncates its length to
         the shortest length (for a given resolution).  Left clicking again
         erases the note.


   DELETING/ERASING NOTES

         Single notes may be erased by clicking directly on the note.

         All notes at a position may be erased by right clicking on the
         Timing Row above the target position.

         All notes at a position may be deleted by double right clicking on
         the Position Row below the target position.

   MANIPULATING A RANGE OF A SONG

   A marked range of notes may be deleted, copied or moved.

         Mark a range by positioning the mouse cursor over one end of the
         range, depressing and holding the right mouse button, and dragging
         the cursor.  When the desired range is highlighted, release the
         right button.

         Once a range is marked it can be manipulated via the EDIT submenu.
         Open the EDIT submenu from the main menu at the top of the screen.
         If the main menu is not visible, left click at the top of the
         screen to access it.  The EDIT menu functions are analagous to those
         of a typical word processor.

         CUT     - Deletes the marked section from the song, but preserves
                   it in the Clipboard, at least until the next CUT or COPY.

         COPY    - Copies the marked section to the clipboard, leaving the
                   song unaltered.

         PASTE   - Inserts the contents of the Clipboard at the current
                   marker position.

         CLEAR   - Deletes the marked section from the song.  BE CAREFUL!!!



                                  - 10 -



***




   HINTS -

      The shortest length for a note depends on the selected ZOOM setting.
      For instance, in 4/4 time, if the ZOOM is set at 8 positions per
      measure, the smallest note that can be entered is an 1/8 note.
      When entering a new song, always start by setting the ZOOM at the
      coarsest appropriate setting.  For instance, if the shortest note
      in a piece is a 1/4 note, and there are no dotted quarter notes,
      set the ZOOM at four positions per measure.  In this way only notes
      longer than a 1/4 note will need to be extended.


   The True Power of "AXE" Files . . .

   Finally, a way for guitarists to exchange and store music!  The "AXE" file
   stores the fingering, timing, tuning, and patch information created in the
   "Tab View" Sequencer/Editor.

   Better yet, "AXE" files can be exported or converted to standard MIDI
   (.MID) Type I files!  Multiple tracks can be created in CHORDMASTER,
   exported in the MIDI format, and merged into your favorite standard MIDI
   sequencer!  Why create guitar (or any other tracks!) in a keyboard-based
   sequencer if your more comfortable with a guitar fretboard?

   All new versions of CHORDMASTER come with AXE2MIDI.EXE, a standalone 
   AXE to MIDI file convertor that you can include with your compositions.  
   In this way you can share your compositions with others, whether they 
   have CHORDMASTER or not!


   LIMITATIONS - 

      While CHORDMASTER is a powerful compositional tool, and can be used to 
      create songs in a variety of styles and instrument types; it has some
      limitations.  The sequencer does not support note lengths that are not
      multiples of a 1/32 note.  Triplets, quintuplets, and so on, are not
      supported.  Certain effects possible with stringed instruments can not
      be duplicated; these include vibrato, tremolo, bending, harmonics, etc.
      Many of these effects can be added in work-arounds when files are
      exported to a MIDI sequencer.

      The inclusion of most of the above features was precluded by the nature
      of the interface used for this version.  While DOS text mode, allows the
      greatest number of PC users to enjoy CHORDMASTER, a graphical interface
      (such as MS Windows) will allow for more capability.  An MS Windows  
      version IS in the works.











                                  - 11 -



***




                               MAIN MENU


   Let's examine the various features in the main menu.  We will work
   through the drop-down menus left to right.

   FILES MENU


      NEW     - Use this selection to create a new piece of music in 
                CHORDMASTER's sequencer (not available in this version).

      OPEN    - Use this selection to open an existing piece of music for 
                playing or printing.

      SAVE    - Use this selection to save the current contents of the 
                Tab View Sequencer to a disk file.  A name must be supplied 
                if the sequence hasn't been saved previously.  An existing 
                file of the same name is overwritten.

      SAVE AS - Use this selection to save the current contents of the 
                Tab View Sequencer to a disk file.  To avoid overwriting 
                the previous version, if any, give the file a new name.


   PRINT

      This menu selection accesses CHORDMASTERS print menu; providing a 
      means to print fretboards or sequences.

      PRINT ACTIVE   - Prints the active fretboard on the printer.

      PRINT ALL      - Prints the entire screen on the printer.

      PRINT TOP      - Prints the top fretboard on the printer.

      PRINT BOTTOM   - Prints the bottom fretboard on the printer.

      PRINT SEQUENCE - Prints the currently loaded sequence.


      PRINT TO FILE  - Print to a file rather than the printer.

      PRINT GRAPHICS - Use this selection to enable printing of graphics
                       characters on printers that support graphics.  This
                       should work with most dot-matrix and laser printers.

      PRINT PORT     - Select the desired printer port. Valid selections
                       are LPT1, LPT2 or LPT3.








                                  - 12 -



***




   FILE EXPORT

   The export utility saves the song currently in CHORDMASTER's sequencer
   to a MIDI type 1 file.

   Enter a valid filename. and press ENTER to complete the conversion.  Be
   sure to save your work as a ".AXE" file for later use in CHORDMASTER.

   Technical : The type 1 MIDI files created by this function consist of two
               tracks.  The first track contains tempo and meter data, while
               the second contains the actual music.  These files can be
               played and combined in a standard MIDI sequencer application.
               When creating pieces of music to be merged later; be sure to
               use the same Tempo and Meter Map for each piece (duplicate
               tempo and meter tracks can be eliminated from the merged file).

               The export utility calls the AXE2MIDI.EXE program to perform
               the conversion.  This file must exist in the CHORDMASTER base
               directory, or a system error will result.  AXE2MIDI.EXE can
               also be used at the DOS command-line.





































                                  - 13 -



***




   SEQUENCER MENU

   The Sequencer Menu provides access to many of the functions related
   to the Tab View Sequencer.  Some of these functions may be accessed  
   directly from the Tab View window.


   SEQUENCE WINDOW

      This selection accesses CHORDMASTER's Tab View Sequencer window.  Once 
      visible, songs can be played, or printed.  The window can be hidden by 
      pressing ESC.


   SONG SETTINGS

      This menu selection accesses MIDI and sound card selections that 
      determine how a song will be played thru these devices.

      This information is stored in the CHORDMASTER song (.AXE)
      file when it is saved to disk.  This data is overwritten
      when an existing file is loaded.


      SEQUENCE STRUM FACTOR

         Use this value to set the amount of stagger for the attack of
         individual notes in a chord.  A larger number results in a slow
         stroke of a chord, while a smaller number gives a faster attack.
         A zero value causes all notes to be sounded simultaneously.


      MIDI SETTINGS

         Various MIDI settings can be selected for playback of sequences,
         and stored in a sequence (.AXE) file.  These settings are the
         same as those used for general PLAY SETTINGS under the OPTIONS
         menu.  See page 20 for an explanation of these settings.  The PLAY
         SETTINGS under the OPTIONS menu become the default settings for
         this menu.


      SOUND CARD INSTRUMENTS

         This menu selects an instrument for the current piece of music.  The 
         selection list appears with the currently selected instrument hi-lited.  

         NOTE : Sound Card output must have been enabled in the OPTIONS/PLAY 
                SETTINGS submenu before sound can be output during playback .  
             
         Instrument voices are stored in the CHORDS.IBK file.  Other voices
         can be read from other .IBK or .SBI files supplied by the user.  In
         the case of duplicate voice names, voices stored in .IBK files take
         precedence.  

         The desired selection is stored in each sequence (.AXE) file when it
         is saved.

                                  - 14 -


***




   METER MAP

      This selection accesses the METER MAP, used to set one or more time 
      signatures for a piece of music in the Tab View sequencer.  Meter 
      information is stored in the sequence(.AXE) file when it is saved
      to disk.  The Meter Map can also be accessed by clicking on the
      Time Signature in the upper left hand corner of Sequence Window.

   TEMPO MAP

      This selection accesses the TEMPO MAP, used to set one or more tempos 
      for a piece of music in the Tab View sequencer. Tempo information is 
      stored in the sequence(.AXE) file when it is saved to disk.  The Tempo
      Map can also be accessed by clicking on the BPM symbol.

   SEQUENCE TIMING SETTINGS

      This menu selection accesses controls that affect the playing of 
      sequences in CHORDMASTER.  Generally these settings will not need 
      adjustment on an AT or better class PC.

      WARNING: Improper adjustment of these settings may degrade
               sequencer performance!

      DRAW COMPENSATION

         On slower machines the timing of a sequence being played may be 
         affected as the screen is updated at the end of each frame. This 
         effect will be heard as a 'hunting' at the end of each frame and 
         is most obvious when rapidly playing a series of 1/16 notes.

         The DrawComp value should reflect the number of milliseconds
         required to update the screen.  This value is subtracted from
         the time allotted for the final step on each screen, in effect
         forcing the screen redraw to become part of that delay.

         Typical values are from 0 - 50 milliseconds.  On faster machines no 
         or a little compensation is required.  Too much compensation may have 
         a reversed effect, whereby the last element of each frame sounds 
         accelerated.

      MILLISECONDS PER SECOND

         This value is critical for the proper tempo of sequences.  There
         SHOULD be 1000 milliseconds in a second.  However, for CHORDMASTER's
         purposes this may appear to vary from machine to machine.

         When the AutoCalc feature is engaged CHORDMASTER attempts to set
         the ideal value for this settings.  On faster machines this number
         should be close to 1000.  However, on slower machines and in multi-
         tasking environments this value may have to be determined manually.

         To determine this value manually, disengage the AutoCalc feature,
         and load the TIMING.AXE sequence or some other piece with an easily
         measurable tempo and time.  Adjust this value until the proper tempo
         is achieved.  If this value is set manually, be sure to lock in the 
         changes for future sessions by choosing OPTIONS - SAVE CONFIGURATION 
         before exiting CHORDMASTER.
                                    
                                  - 15 -

***



   CHORDINGS MENU

      Use these menu selections to enter and resolve chord entries.


      CHORD ENTRY

         Use this selection to enter chords at CHORDMASTER's command line.  
         This provides a wide variety of entry possibilities. See page 4 
         for a complete description of the Chord Entry syntax.


      CHORD ENTRY TABLE

         An interactive method of entering chords; the CHORD ENTRY TABLE
         provides an error proof way of exploring chord chemistry.  See
         page 3 for more details.


      OVERLAY

         Allows entry of another chord, whose notes will appear in combination 
         with those already on the active fretboard.  On a color monitor, the 
         results may be particularly revealing.


      SWITCH

         Opens a fretboard on the opposite half of the display.


      CLEAR

         Clears the active fretboard.


      DISPLAY

         Once a valid chord is entered on fretboard, individual chordings can 
         be displayed.  This can be accomplished by pressing a 'D' on the
         keyboard or selecting DISPLAY from the CHORDINGS submenu.

         During DISPLAY the following keys are active:

               <-  and  ->      previous and next chords
                +  and  -       to change play timing
                    P           repeat chord play
                   ESC          to quit DISPLAY


         MOUSE USERS : If mouse hardware is detected, buttons for some of the
                       functions listed above will appear above the active
                       fretboard.  Simply click on the desired button to 
                       display chords.






                                  - 16 -

***




      RESOLVE

         Analyzes the most recent chord entry; figuring synonyms, etc.
         Resolve is performed automatically when a chord is entered, so
         generally you would only use this selection to re-resolve a
         chord entry when the RESOLVE SETTINGS have been changed.  See
         the discussion of RESOLVE on page 21.


      NOTE ENTRY

         Use note entry to identify an unknown chord.  Enter the names of
         the notes, separated by a space.  CHORDMASTER then attempts to
         identify the chord.  Note entry is particularly easy with a mouse.
         Non-mouse users should use NOTE ENTRY under the CHORDINGS submenu.

         NOTE ENTRY with a mouse:

            Enter a chord's notes by clicking on the desired fret positions
            on the active fretboard.  Clicking on a previously selected note
            will de-select it.  Once the desired notes have been selected,
            click on the word PROCESS which will appear above the active
            fretboard.  If the notes can be identified as a chord, its name
            will be displayed.  The lowest note selected will be considered
            as the primary root for the resulting chord.


      INTERVALS

         This menu selection offers a choice between displaying notes on the
         fretboard by their musical names (i.e. A, F#, D, etc.), or by the
         number of the scale step that they represent in the selected chord.

























                                  - 17 -



***




   TUNINGS MENU

      The TUNINGS menu allows for a quick change to STANDARD, OPEN A, OPEN C, 
      OPEN D, OPEN E or OPEN G tunings; as well as CUSTOM TUNINGS, in which 
      any string can be altered from the standard tuning over a ten step range.

      NOTE : Individual chord DISPLAY is only available for standard tuning.

      When a sequence is loaded and a tuning change is attempted, CHORDMASTER
      attempts to transpose the sequence into the desired tuning.  If this is
      not possible, the existing sequence must be cleared or the sequence
      window must be closed.

      When a newly loaded sequence does not match the current fretboard
      tuning, the user may be given a choice to either retune the fretboard
      OR transpose the sequence.

      NOTE: Attempted transpositions are of the rudimentary "string by string"
            method, and may make the piece more difficult to finger.

      AUDIO TRANSPOSE

         Use this transpose setting to affect the pitch of tones sounded
         in CHORDMASTER.  This does not change the key of the song or the
         notes displayed by CHORDMASTER; only the pitch of notes played.

         Normally this setting is '0', indicating normal pitch (A=440).
         The available range for this setting is -14 thru +14.  This provides
         enough range to accommodate bass lines as well as the '-1' step
         tuning used in many rock tunes (Hendrix, Van Halen, etc.).

         This setting is stored in CHORDMASTER's '.AXE' files, and is
         therefore implimented when these files are exported to the standard
         MIDI format.


      TUNER

         This menu selection accesses CHORDMASTER's guitar tuner.

         Start with the string you wish to tune and select SOUND to enable
         the tones.  Select each tone (using arrow keys or mouse) and tones
         will sound.

         CYCLE will cause the tones to be repeated every few seconds.

         Tones will depend on the currently selected tuning and audio
         transpose settings.








                                  - 18 -



***




   OPTIONS MENU 

      DISPLAY SETUP

      This menu selection brings up the DISPLAY SETUP menu.  The DISPLAY
      SETUP menu allows the user to specify the fret range, strings, and
      number of notes allowed for the chords to be displayed.

      Move from from field to field by pressing the up or down arrow keys,
      TAB or ENTER.  When the setup is as desired press F7 to save.  Press
      ESC to exit and ignore changes.

      For each STRING use the SPACEBAR to indicate whether it should be used 
      for DISPLAY.  If too many strings are disabled an error message will 
      appear.  The number of strings required will vary according to the
      formula of the most recently entered chord.

      Specify the fret range over which chords should be displayed by 
      adjusting the LOW FRET and HIGH FRET entries.  Remember, not more than 
      16 frets can be diplayed at one time.  However, individual chordings 
      may be displayed over a smaller range of frets.

      Select the MINIMUM and MAXIMUM number of notes in chords to be 
      displayed.  The MAXIMUM number of notes depends on how many strings 
      are used, the MINIMUM limit is determined by the formula of the chord.

      Select which tone in the chord should be the BASS NOTE.  Most commonly
      '1' would be entered to select the root note as the bass.  However, more 
      chords will be displayed if '0' is entered, indicating no preference.

      The NOTE BLINK selection toggles the blinking of notes in a chord as 
      they are displayed.
   
      MOUSE USERS : Click on a field to move cursor, click on a command
                    to execute it.


      PLAY SETTINGS

      The PLAY SETTINGS menu accesses options that affect when and how
      sounds are played by CHORDMASTER.

      By default CHORDMASTER plays tones through the systems internal
      speaker when chords are entered or displayed.  Optionally, chords
      can be sounded through a MIDI device or sound card.  Output from
      CHORDMASTER's sequencer can onlly be played through a MIDI device 
      or sound card.


      PLAY EVENTS

         PLAY ON ENTRY   - This selection allows the user to enable/disable
                           the sounding of notes when a chord is entered.

         PLAY ON DISPLAY - This selection allows the user to enable/disable 
                           the sounding of notes in DISPLAY mode.


                                  - 19 -


***




      PLAY TIMINGS

         STRUM  - The separation between notes in a sounded chord.

         LENGTH - The length of time the the chord sounds.


      SOUND OUTPUT OPTIONS

         Sounds can be played through a MIDI device and/or Sound Card, by 
         enabling these via the appropriate Check Boxes.  If either of these 
         devices exist, additional menus will be available.  Press 'F2' for 
         MIDI settings or 'F3' to set instruments for a Sound Card.

         These settings become the default settings for songs created in
         CHORDMASTER's Tab View Sequencer.


      MIDI SETTINGS

         SEND PATCH DATA -  Use this check box to force the indicated patch
                            to be sent to your MIDI device.  

         LOWEST PATCH    -  Some midi devices use 'zero'-based patches, while
                            others use 'one'-based patches.  Select the the
                            setting that best suits your needs.

         PATCH DATA      -  Set the desired patch number to be transmitted 
                            to the MIDI device prior to playing.  

         KEY VELOCITY    -  Set the MIDI key velocity as desired.  The default
                            is 127.

         LOWEST MIDI CH  -  While the MIDI specification describes numbers
                            '0 - 15' for MIDI channel numbers, most devices
                            use numbers '1 - 16'.  Specify the desired scheme
                            here.  The default is '1'.

         MIDI CHANNEL    -  Specify which channel MIDI data should be sent on.
                            Use numbers '0 - 15' or '1 - 16' depending on the 
                            setting of the LOWEST MIDI CHANNEL selection.


   SOUND CARD INSTRUMENTS

      Use this selection menu to tryout and/or select different instrument
      sounds when using a Sound Card.  The selection list appears with the
      currently selected instrument hi-lited.  If a new instrument can be
      tested by selecting it from the list and using 'T' to play a test
      chord.

      NOTE : Sound Card output must have been enabled in the previous menu
             for a chord to be played.  
             
      Once the desired selection has been made, it may be locked for future
      sessions by using the SAVE CONFIGURATION item under the OPTIONS menu.


                                  - 20 -


***




   RESOLVE SETTINGS

      The RESOLVE drop-down menu consists of selections that control the way
      chordings are resolved and displayed.

      RESOLVE performs two important functions.  First, RESOLVE can take an
      awkward chord entry and show a more eloquent method of achieving the
      same result.

      For instance, if you entered 'A MIN /2 /7', RESOLVE would "correct" your
      entry by responding with 'A MIN9'.  This is a useful educational tool,
      helping to reinforce the user's understanding of chord chemistry.

      Secondly, RESOLVE's perform is critical to the DISPLAY of individual
      chordings.  This is very important, so it should be emphasized that
      DISPLAY WILL NOT BE AVAILABLE FOR A CHORD UNLESS IT IS RESOLVED TO A
      CHORD WITH A ROOT, AND A CHORD FILE EXISTS FOR AT LEAST ONE RESOLUTION.

      RESOLVE is capable of revealing chord synonyms.  Factory settings limit
      the RESOLVE line display to three resolutions, but by altering these
      settings up to five synonyms or near matches can be displayed.  These
      synonyms may or may not include NOROOT chords depending on the settings.
      This has implications in DISPLAY mode; if a chord is resolved to more
      than one perfect match by RESOLVE, chord fingering data for both chords
      would be combined and the resultant chordings DISPLAYed.  While this
      increase in DISPLAYed chordings is usually modest, it does provide a
      means by which NOROOT chords can be DISPLAYed, despite the fact that no
      chord library files exist for them.  To see this mechanism in action
      use the RESOLVE dropdown menu to set RESOLVE as follows DISPLAY ON, SET
      COUNT=2, PERFECT ONLY ON and NO ROOT OFF.  Obtain a clear fretboard for
      entry and enter 'A MIN6'.  The RESOLVE line now indicates 'A MIN6
      F#MIN7 -5'.  Upon DISPLAY data for both chords will be combined.


   Here's a description of the RESOLVE setup functions:

      RESOLVE COUNT       -   Sets the number of resolutions RESOLVE will
                              attempt to achieve.

      SHOW RESOLVE LINE   -   Enables or disables the display of the resolve
                              line.  Either way RESOLVE still occurs and the
                              results affect DISPLAY.

      RESOLVE NO ROOT     -   This setting decides whether NOROOT chords will
                              be resolved.

      RESOLVE NO3RD/NO5TH -   This menu selection allows chords (with 4 or
                              more notes in their formula) that are missing
                              a 3rd and/or 5th to be considered as chord
                              synonyms during resolution.  This considerably
                              broadens the resolve count and helps in proper
                              resolution of unknown inputs, as complex chords
                              are typically missing a 3rd, 5th or root.

      PERFECT ONLY        -   This setting decides whether or not non-perfect
                              chord synonyms will be resolved.  On the resolve
                              line perfect synonyms are shown in reverse video.

                                  - 21 -


***




   SAVE CONFIGURATION

      The selection saves information about current program settings in a
      file called CHORD.CFG.  The settings saved in this file are restored
      every time the program is started.


   FACTORY SETTINGS

      Restores program settings to the original settings distributed with
      the program.



                                   










































                                  - 22 -



***

