// File    : BLDRSC.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Fri 01/14/94 20:12:22
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1
//
// This file contains the standard resource file builder.
// Modify or add the necessary items and compile.
//
// NOTE: If compiling this *without* the changes to the TV library described
//       in COLUPDT.DOC, be sure that UNMODIFIED_TURBO_VISION is #defined
//       in TVCOLR.H!
//

#define RSC_FILENAME    "DEMO.RSC"   // File to create.
                                     // Works for either demo.  Just specify
                                     // /RDEMO.RSC on its command line.

#define WriteResource(a,b,c) \
    cout << c << endl; \
    a = b(); \
    if( a == 0 ) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#define WriteObject(a,c) \
    cout << c << endl; \
    if(a == 0) \
    { \
        strcpy(endString, RSC_FILENAME ": Creation failure\n"); \
        TObject::destroy(rsc); \
        exit(1); \
    } \
    rsc->put(a,c); \
    TObject::destroy(a)

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define Uses_TButton
#define Uses_TColorDialog
#define Uses_TColorGroup
#define Uses_TColorItem
#define Uses_TDialog
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TResourceFile
#define Uses_TStaticText
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#define Uses_TVCOLR             // Use this if you modified the TV.H file.
#define Uses_fpstream
#include <tv.h>

#if !defined(cpDefSize)
// Use this if you chose not to modify the Turbo Vision files.
#include <tvcolr.h>
#endif

#include <tcoltxt.h>

#include "link.h"           // Resource file link definitions.
#include "demo.h"

// ============================================================================
TDialog *Colors(void);
TDialog *AboutBox(void);

TMenuBar *initMenuBar(void);
TStatusLine *initStatusLine(void);

// ============================================================================

fpstream *s;
TResourceFile* rsc;
char endString[255] = "";

// ============================================================================

void exitfunc(void)
{
   cout << endl << endString << endl;
}

#pragma exit exitfunc 31

void main(void)
{
    TDialog *dlg;
    TMenuBar *menuBar;
    TStatusLine *statusLine;

    cout << "Creating " RSC_FILENAME << endl;

    // Construct stream and resource file.
    s = new fpstream (RSC_FILENAME, ios::trunc | ios::binary);
    rsc = new TResourceFile(s);

    // Create all of the necessary dialogs for the demo.
    WriteResource(dlg, AboutBox, "AboutBox");
    WriteResource(dlg, Colors, "ColorDlg");

    // Create the menus and status line.
    WriteResource(menuBar, initMenuBar, "MenuBar");
    WriteResource(statusLine, initStatusLine, "StatusLine");

    TObject::destroy(rsc);
    strcpy(endString, RSC_FILENAME " creation completed.");
}

// ============================================================================
TDialog *AboutBox(void)
{
    TDialog *aboutBox = new TDialog(TRect(0, 0, 46, 11), "About");
    aboutBox->options |= ofCentered;

    aboutBox->insert(new TColorText(TRect(1, 1, 45, 7),
            "\n\003TVCOLR/COLUPDT Changes Demo\n\003\n"
            "\003by Eric Woodruff\n\003CIS ID: 72134,1150\n", eTxtInfo));

    TButton *b = new TButton(TRect(11,8,23,10), "O~K~", cmOK, bfDefault);
    b->options |= ofCenterX;
    aboutBox->insert(b);

    return aboutBox;
}

TDialog *Colors(void)
{
    TColorGroup &group1 =
        *new TColorGroup("Desktop") +
            *new TColorItem("Background",        1)+

        *new TColorGroup("Menus") +
            *new TColorItem("Normal text",       2)+
            *new TColorItem("Disabled text",     3)+
            *new TColorItem("Shortcut key",      4)+
            *new TColorItem("Selection bar",     5)+
            *new TColorItem("Selected disabled", 6)+
            *new TColorItem("Shortcut selected", 7);

    TColorGroup &group2 =
        *new TColorGroup("Blue Window") +
            *new TColorItem("Frame inactive",    8)+
            *new TColorItem("Frame active",      9)+
            *new TColorItem("Frame icons",      10)+
            *new TColorItem("Scrollbar page",   11)+
            *new TColorItem("Scrollbar icons",  12)+
            *new TColorItem("Normal text",      13)+
            *new TColorItem("Selected text",    14)+

        *new TColorGroup("Cyan Window") +
            *new TColorItem("Frame inactive",  16)+
            *new TColorItem("Frame active",    17)+
            *new TColorItem("Frame icons",     18)+
            *new TColorItem("Scrollbar page",  19)+
            *new TColorItem("Scrollbar icons", 20)+
            *new TColorItem("Normal text",     21)+
            *new TColorItem("Selected text",   22)+

        *new TColorGroup("Gray Window") +
            *new TColorItem("Frame inactive",  24)+
            *new TColorItem("Frame active",    25)+
            *new TColorItem("Frame icons",     26)+
            *new TColorItem("Scrollbar page",  27)+
            *new TColorItem("Scrollbar icons", 28)+
            *new TColorItem("Normal text",     29)+
            *new TColorItem("Selected text",   30) +

        *new TColorGroup("Dialog Box") +
            *new TColorItem("Frame inactive",   32)+
            *new TColorItem("Frame active",     33)+
            *new TColorItem("Frame icons",      34)+
            *new TColorItem("Scrollbar page",   35)+
            *new TColorItem("Scrollbar icons",  36);

    TColorGroup &group3 =
        // The last four Dialog Text colors can be set, but are only
        // accessible when using the alternate mapColor() routine
        // from TVCOLR.ZIP.
        *new TColorGroup("Dialog Text") +
            *new TColorItem("Normal",       37)+
            *new TColorItem("Information",  cCTxtInfoColor)+    // Extended
            *new TColorItem("Notification", cCTxtNotifyColor)+  // Extended
            *new TColorItem("Warning",      cCTxtWarnColor)+    // Extended
            *new TColorItem("Error",        cCTxtErrorColor)+   // Extended

        // Selected Shortcut is only applicable if you made the
        // changes described in COLUPDT.DOC in TVCOLR.ZIP.
        *new TColorGroup("Dialog Label") +
            *new TColorItem("Normal",            38)+
            *new TColorItem("Selected",          39)+
            *new TColorItem("Shortcut key",      40)+
#ifndef UNMODIFIED_TURBO_VISION
            *new TColorItem("Selected shortcut", 66)+   // Added by me
#endif

        // Default and Selected Shortcut are only applicable if you made
        // the changes described in COLUPDT.DOC in TVCOLR.ZIP
        *new TColorGroup("Dialog Button") +
            *new TColorItem("Normal",            41)+
            *new TColorItem("Default",           42)+
            *new TColorItem("Selected",          43)+
            *new TColorItem("Disabled",          44)+
            *new TColorItem("Shortcut key",      45)+
#ifndef UNMODIFIED_TURBO_VISION
            *new TColorItem("Default shortcut",  64)+   // Added by me
            *new TColorItem("Selected shortcut", 65)+   // Added by me
#endif
            *new TColorItem("Shadow",            46)+

        *new TColorGroup("Dialog Cluster") +
            *new TColorItem("Normal",    47)+
            *new TColorItem("Selected",  48)+
            *new TColorItem("Shortcut",  49);

    TColorGroup &group4 =
        *new TColorGroup("Dialog Input") +
            *new TColorItem("Input normal",      50)+
            *new TColorItem("Input selected",    51)+
            *new TColorItem("Input arrow",       52)+
            *new TColorItem("History button",    53)+
            *new TColorItem("History sides",     54)+
            *new TColorItem("History scrollbar", 55)+
            *new TColorItem("History icons",     56)+

        *new TColorGroup("Dialog List") +
            *new TColorItem("Normal item",       57)+
            *new TColorItem("Focused item",      58)+
            *new TColorItem("Selected item",     59)+
            *new TColorItem("Divider",           60)+
            *new TColorItem("Information pane",  61)+

#ifndef UNMODIFIED_TURBO_VISION
        *new TColorGroup("Help Window") +
            *new TColorItem("Frame inactive",   67)+
            *new TColorItem("Frame active",     68)+
            *new TColorItem("Frame icons",      69)+
            *new TColorItem("Scrollbar page",   70)+
            *new TColorItem("Scrollbar icons",  71)+
            *new TColorItem("Normal text",      72)+
            *new TColorItem("Keyword",          73)+
            *new TColorItem("Selected keyword", 74);
#else
        *new TColorGroup("Help Window") +
            *new TColorItem("Frame inactive",   64)+
            *new TColorItem("Frame active",     65)+
            *new TColorItem("Frame icons",      66)+
            *new TColorItem("Scrollbar page",   67)+
            *new TColorItem("Scrollbar icons",  68)+
            *new TColorItem("Normal text",      69)+
            *new TColorItem("Keyword",          70)+
            *new TColorItem("Selected keyword", 71);
#endif

    TColorGroup &group5 = group1 + group2 + group3 + group4;

    // See the notes in handleEvent() about the proper usage of TColorDialog.
    TColorDialog *c = new TColorDialog((TPalette*)0, &group5);

    return c;
}

TMenuBar *initMenuBar(void)
{
    TSubMenu& MiscMenu = *new TSubMenu( "~\xF0~", 0) +
        *new TMenuItem( "~A~bout...", cmAbout, kbNoKey)+
        *new TMenuItem( "~R~epaint desktop", cmRepaint, kbNoKey);

    TSubMenu& FileMenu = *new TSubMenu("~D~emo", 0) +
        *new TMenuItem( "Insert ~B~lue Window", cmBlueWindow, kbF2, hcNoContext, "F2" ) +
        *new TMenuItem( "Insert ~G~ray Window", cmGrayWindow, kbF3, hcNoContext, "F3" ) +
        *new TMenuItem( "Insert ~C~yan Window", cmCyanWindow, kbF7, hcNoContext, "F7" ) +
        *new TMenuItem( "Insert ~D~ialog Box",  cmDialogBox,  kbF8, hcNoContext, "F8" ) +
        *new TMenuItem( "Insert ~H~elp Window", cmHelpWindow, kbF9, hcNoContext, "F9" ) +
            newLine() +
        *new TMenuItem( "~D~OS shell", cmDOSshell, kbNoKey) +
        *new TMenuItem( "~Q~uit", cmQuit, kbAltX, hcNoContext, "Alt+X" );

    TSubMenu& WindowMenu = *new TSubMenu( "~W~indows", 0) +
        *new TMenuItem( "~S~ize/Move", cmResize, kbCtrlF5, hcNoContext, "Ctrl+F5" ) +
        *new TMenuItem( "~Z~oom", cmZoom, kbF5, hcNoContext, "F5" ) +
        *new TMenuItem( "C~a~scade", cmCascade, kbNoKey) +
        *new TMenuItem( "~T~ile", cmTile, kbNoKey) +
        *new TMenuItem( "Ne~x~t", cmNext, kbF6, hcNoContext, "F6" ) +
        *new TMenuItem( "~P~revious", cmPrev, kbShiftF6, hcNoContext, "Shift+F6" ) +
        *new TMenuItem( "~C~lose", cmClose, kbAltF3, hcNoContext, "Alt+F3" ) +
        *new TMenuItem( "Clos~e~ all", cmCloseTileable, kbNoKey) +
            newLine() +
        *new TMenuItem( "To~g~gle Screen Size", cmScreenSize, kbNoKey) +
        *new TMenuItem( "~U~ser screen", cmUserScreen, kbAltF5, hcNoContext, "Alt+F5");

    TSubMenu& OptionsMenu = *new TSubMenu("~O~ptions", 0) +
        *new TMenuItem( "~C~olors...", cmColors, kbNoKey ) +
        *new TMenuItem( "C~h~ange palettes", cmChangePalettes, kbNoKey ) +
        *new TMenuItem( "~M~ake palette strings text file", cmMakeStrings, kbNoKey) +
            newLine() +
        *new TMenuItem( "~L~oad configuration...", cmLoadCfg, kbNoKey) +
        *new TMenuItem( "~S~ave configuration...", cmSaveCfg, kbNoKey);

    return new TMenuBar(TRect(0, 0, 80, 1), MiscMenu + FileMenu +
        WindowMenu + OptionsMenu);
}

TStatusLine *initStatusLine(void)
{
    return new TStatusLine( TRect(0, 24, 80, 25),
      *new TStatusDef( 0, 0xFFFF ) +
        *new TStatusItem(0, kbF10, cmMenu) +
        *new TStatusItem( "~F1~ Help", kbF1, cmHelp ) +
        *new TStatusItem( "~Alt+X~ Exit", kbAltX, cmQuit ) +
        *new TStatusItem( "~Alt+F3~ Close", kbAltF3, cmClose));
}
