// File    : DEMO.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Fri 01/14/94 20:16:59
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1
//
// Header file for the TVCOLR modifications demo.
//

// Miscellaneous definitions.

const int
    cmAbout         = 100,      // Standard event values.
    cmRepaint       = 101,
    cmDOSshell      = 102,
    cmColors        = 103,
    cmChangePalettes = 104,
    cmLoadCfg       = 105,
    cmSaveCfg       = 106,
    cmCloseTileable = 107,
    cmScreenSize    = 108,
    cmUserScreen    = 109,

    cmBlueWindow   = 110,       // Other command values.
    cmGrayWindow   = 111,
    cmCyanWindow   = 112,
    cmDialogBox    = 113,
    cmHelpWindow   = 114,
    cmMakeStrings  = 115;

#if defined(Uses_DemoApp)

// Exit code values.
#define EXIT_NOERR      0
#define EXIT_RSCERR     1
#define EXIT_SYNTAX     2
#define EXIT_SWERR      3

class far TDeskTop;
class far TDialog;
class far TEvent;
class far TMenuBar;
class far TStatusLine;
class far TPalette;
//class far THeapView;
class far TDemoHelpWindow;

// Class declarations.
class TDemoApp : public TApplication
{
public:
    TDemoApp(void);
    static TMenuBar *initMenuBar(TRect r);
    static TStatusLine *initStatusLine(TRect r);
    static TDeskTop *initDeskTop(TRect r);

    virtual void initScreen();                  // Sets correct palette.
    virtual void idle(void);
    virtual void handleEvent(TEvent& Event);
    virtual void outOfMemory(void);
    virtual TPalette& getPalette() const;

    void loadConfig(Boolean UseFileSetting);
    void saveConfig(void);

// ***************************************************************************
    TWindow *createDemoWindow(char *aTitle);
    TDemoHelpWindow *createDemoHelpWindow(void);
};

// A couple of useful functions.
ushort execDialog(TDialog *d, void *data);
Boolean isTileable(TView *p, void *);

// ***************************************************************************
// Interior class for displaying window colors.
class TInterior : public TView
{
public:
    TInterior(TRect &r) : TView(r) {};
    virtual void draw(void);
};

// Window for demonstrating the help window colors to insure they are
// still in the right place.
class TDemoHelpWindow : public TWindow
{
public:
    TDemoHelpWindow(TRect &r) :
       TWindow(r, "Help Window", wnNoNumber),
       TWindowInit( &TDemoHelpWindow::initFrame) {};

    virtual TPalette& getPalette() const;
};

// Interior class for displaying help window colors.
class THelpInterior : public TView
{
public:
    THelpInterior(TRect &r) : TView(r) {};
    virtual void draw(void);
    virtual TPalette& getPalette() const;
};

#endif
