// File    : TCOLTXT.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Fri 01/14/94 20:18:42
// Note    : Hereby declared public domain
// Compiler: Borland C++ 3.1
//
// Header file for the TColorText class.  Demonstrates the use of the
// concepts described in TVCOLR.DOC.
//

class far TRect;
class far TStaticText;

// Color type offsets used by the call to getColor() in the draw function.
enum eCType { eTxtNormal = 0, eTxtInfo, eTxtNotify, eTxtWarn, eTxtError };

class TColorText : public TStaticText
{
private:
    short ColorType;        // Type of TColorText

public:
    TColorText::TColorText(const TRect &bounds, const char *aText,
	  eCType CTextType) :
        TStaticText(bounds, aText),
        ColorType(CTextType) {}

    virtual void draw();
    virtual TPalette& getPalette() const;

// This stuff makes it streamable.
private:
    virtual const char *streamableName() const
	    { return name; }

protected:
    TColorText( StreamableInit ) : TStaticText( streamableInit ) {}

public:
    static const char * const near name;
    static TStreamable *build();

protected:
    virtual void write( opstream& );
    virtual void *read( ipstream& );
};

inline ipstream& operator >> ( ipstream& is, TColorText& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TColorText*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TColorText& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TColorText* cl )
    { return os << (TStreamable *)cl; }
