;**************************************************************************
;
; FILE NAME          : COUNTER.ASM
; DATE LAST MODIFIED : 8-19-90
; WRITTEN BY         : MICHAEL MCCARRICK
; DESCRIPTION:
;  THIS PROGRAM COUNTS PULSES APPLIED TO THE T0 PIN ON THE 8748
;  IF T1 == 0 THE COUNTER IS INCREMENTED BY 703125
;  IF T1 == 1 THE COUNTER IS DECREMENTED BY 703125
;  WHEN THE COUNT REACHES 360000000 IN THE POS DIRECTION IT IS RESET TO ZERO
;  WHEN THE COUNT REACHES ZERO IN THE NEG DIRECTION IT IS RESET TO 359296875
;
;  THE COUNT IS RETAINED IN MEMORY LOCATIONS STARTING WITH DIG0 (L.S.D.)
;  IN BCD FORMAT, ONE DIGIT TO MEMORY LOCATION.  THE FOUR MOST SIGNIFICANT
;  DIGITS ARE DISPLAYED.
;
;  R0 IS USED AS A STACK POINTER BY THE SUBROUTINES PUSH AND POP
;
;**************************************************************************

DIG1    EQU     32
DIG2    EQU     33
DIG3    EQU     34
DIG4    EQU     35
DIG5    EQU     36
DIG6    EQU     37
DIG7    EQU     38
DIG8    EQU     39
DIG9    EQU     40
STACK   EQU     41

;**************************************************************************

        ORG     0
        JMP     START

        ORG     3
        JMP     ISR

        ORG     7               ; TIMER INTERRUPT
        INC     R7
        RETR

;**************************************************************************

ISR:    NOP
        JMP     ISR
        RETR


START:
        MOV     R0,#STACK       ; INIT STACK POINTER TO START OF DATA STORE
        MOV     R7,#0

        CALL    ZERSET

        CALL    DISPLAY         ; DISPLAY COUNTERS

        EN      I
        STRT    T
        EN      TCNTI

        JT0     ST1             ; IF INITIALLY HIGH GO STRAIGHT TO ST1
MN1:    JNT0    MN1             ; ELSE WAIT FOR IT TO GO HIGH

ST1:    JT0     ST1             ; WAIT FOR T0 TO GO LOW
;        JT0     ST1
;        JT0     ST1
;        JT0     ST1

        JT1     ST2             ; IF (T1 == 1) THEN DECREMENT COUNT
        CALL    INCR            ; ELSE INCREMENT COUNT
        JMP     ST3

ST2:    CALL    DECR            ; DECREMENT COUNT

ST3:    CALL    DISPLAY         ; DISPLAY NEW COUNT
;ST4:    JNT0    ST4             ; WAIT FOR T0 TO GO HIGH
        JMP     ST1

;***********************************************************************
; ZERSET -- ZEROS COUNTER MEMORY LOCATIONS
ZERSET:
        MOV     A,#0
        MOV     R1,#DIG9
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        DEC     R1
        MOV     @R1,A
        RET

;***********************************************************************
; PUSH -- MOVES THE CONTENTS OF ACC TO THE LOCATION POINTED TO BY R0
;         THEN INCREMENTS R0.
PUSH:
        MOV     @R0,A
        INC     R0
        RET

;***********************************************************************
; POP -- DECREMENTS R0 AND THEN MOVES THE CONTENTS OF THE LOCATION POINTED
;        TO BY R0 TO ACC
POP:
        DEC     R0
        MOV     A,@R0
        RET

;***********************************************************************
; INCR -- INCREMENTS THE COUNTER REGISTERS BY 0000703125 BCD
INCR:
        MOV     R1,#DIG1
        MOV     A,@R1
        SWAP    A               ; SWAP SO ADDITION CAN GENERATE CARRY
        ADD     A,#50H
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG2
        MOV     A,@R1
        SWAP    A
        JNC     INC1
        ADD     A,#30H
        JMP     INC2
INC1:
        ADD     A,#20H
INC2:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG3
        MOV     A,@R1
        SWAP    A
        JNC     INC3
        ADD     A,#20H
        JMP     INC4
INC3:
        ADD     A,#10H
INC4:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG4
        MOV     A,@R1
        SWAP    A
        JNC     INC5
        ADD     A,#40H
        JMP     INC6
INC5:
        ADD     A,#30H
INC6:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG5
        MOV     A,@R1
        SWAP    A
        JNC     INC7
        ADD     A,#10H
        JMP     INC8
INC7:
        ADD     A,#00H
INC8:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG6
        MOV     A,@R1
        SWAP    A
        JNC     INC9
        ADD     A,#80H
        JMP     INC10
INC9:
        ADD     A,#70H
INC10:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG7
        MOV     A,@R1
        SWAP    A
        JNC     INC11
        ADD     A,#10H
        JMP     INC12
INC11:
        ADD     A,#00H
INC12:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG8
        MOV     A,@R1
        SWAP    A
        JNC     INC13
        ADD     A,#10H
        JMP     INC14
INC13:
        ADD     A,#00H
INC14:
        DA      A
        SWAP    A
        MOV     @R1,A

        INC     R1              ; POINT TO DIG9, DON'T TEST FOR CARRY
        MOV     A,@R1
        JNC     INC15
        ADD     A,#1
INC15:
        DA      A
        MOV     @R1,A

; TEST FOR 360 (R7 == 3, R6 == 60) COUNT, IF SO SET COUNTERS TO ZERO

        MOV     R1,#DIG9        ; IF (DIG9 == 3) THEN CHECK DIG8
        MOV     A,#3
        CPL     A
        ADD     A,@R1
        INC     A
        JNZ     INCEND

        DEC     R1              ; IF (DIG8 == 6) THEN CHECK DIG7
        MOV     A,#6
        CPL     A
        ADD     A,@R1
        INC     A
        JNZ     INCEND

        DEC     R1              ; IF (DIG7 == 0) THEN RESET
        MOV     A,@R1
        JNZ     INCEND

        CALL    ZERSET          ; IF HERE THEN R7 == 3 && R6 == 60
                                ;   ZERO COUNTERS
INCEND:
        RET

;***********************************************************************
; SUB -- SUBRATCTS FROM @R1 THE BCD DIGIT IN THE LOWER NIBBLE OF ACC
;        RESULT RETURNED IN @R1, R2 IS USED TO STORE BORROWS BETWEEN CALLS
;        R3 USED AS LOOP COUNTER, NOT RESTORED
SUB:
        ADD     A,R2            ; ADD IN BORROW FROM PREVIOUS CALLS
        MOV     R3,A            ; R3 == AMOUNT TO SUBTRACT
        MOV     R2,#0           ; ZERO BORROW FOR NEXT CALL

        JNZ     SUB1            ; IF (R3 == 0) THEN RET
        RET
SUB1:
        MOV     A,@R1           ; GET DIGIT TO SUBTRACT FROM
SUB2:
        JZ      SUB3            ; IF ZERO SET TO 9
        DEC     A
        JMP     SUB4

SUB3:   MOV     A,#9
        MOV     R2,#1
SUB4:
        DJNZ    R3,SUB5
        JMP     SUB6
SUB5:   JMP     SUB2
SUB6:
        MOV     @R1,A
        RET

;***********************************************************************
; DECR -- DECREMENTS THE COUNTER REGISTERS BY 00 00 70 31 25
DECR:
        CALL    ZERO            ; TEST IF COUNT IS CURRENTLY ZERO
        JNZ     DEC1            ; IF != 0 THEN PROCEED WITH DECREMENT
        JMP     DEC10

DEC1:
        MOV     R2,#0           ; ZERO BORROW FOR FIRST ADDITION

        MOV     R1,#DIG1        ; DIGIT #1
        MOV     A,#5
        CALL    SUB

        INC     R1              ; DIGIT #2
        MOV     A,#2
        CALL    SUB

        INC     R1              ; DIGIT #3
        MOV     A,#1
        CALL    SUB

        INC     R1              ; DIGIT #4
        MOV     A,#3
        CALL    SUB

        INC     R1              ; DIGIT #5
        MOV     A,#0
        CALL    SUB

        INC     R1              ; DIGIT #6
        MOV     A,#7
        CALL    SUB

        INC     R1              ; DIGIT #7
        MOV     A,#0
        CALL    SUB

        INC     R1              ; DIGIT #8
        MOV     A,#0
        CALL    SUB

        INC     R1              ; DIGIT #9
        MOV     A,#0
        CALL    SUB

DEC10:
        RET

;***********************************************************************
; ZERO -- TEST IF COUNTERS == 0, IF SO COUNT IS RESET
;         TO 3 5 9 2 9 6 8 7 5 BCD
ZERO:
        MOV     R2,#8           ; LOOP COUNTER FOR 9 DIGITS
        MOV     R1,#DIG1-1
ZER1:
        INC     R1
        MOV     A,@R1
        JNZ     ZER4
        DJNZ    R2,ZER1

        MOV     R1,#DIG1        ; RESET COUNTER MEMORY LOCATIONS
        MOV     @R1,#5
        INC     R1
        MOV     @R1,#7
        INC     R1
        MOV     @R1,#8
        INC     R1
        MOV     @R1,#6
        INC     R1
        MOV     @R1,#9
        INC     R1
        MOV     @R1,#2
        INC     R1
        MOV     @R1,#9
        INC     R1
        MOV     @R1,#5
        INC     R1
        MOV     @R1,#3

        MOV     A,#0            ; COUNTERS == ZERO FLAG
        JMP     ZER5

ZER4:   MOV     A,#1            ; COUNTERS != ZERO FLAG
ZER5:
        RET

;*************************************************************************
; DISPLAY -- DISPLAYS THE 4 DIGIT BCD NUMBER CONTAINED IN R7, R6 AND R5
DISPLAY:
        MOV     R1,#DIG9
        MOV     A,@R1
        SWAP    A
        DEC     R1
        ADD     A,@R1
        OUTL    P2,A            ; DISPLAY ON PORT

        DEC     R1
        MOV     A,@R1
        SWAP    A
        DEC     R1
        ADD     A,@R1
        OUTL    P1,A            ; DISPLAY ON PORT

;        CALL    REGPAC

DISPEND: RET

        END
