/*	PCXDISP.c   -  Load pictures into RAM and display them
*/


#include "lib.h"
#include "pcx.h"

extern int pcx_md;

void pcx_load_palette( pic )
PCXPIC *pic;
{
	int p;

	if ( pcx_md )
	{  /* this part NOT TESTED */
	   VGR_CPAL( pic->hdr.triple[0].red / 16, pic->hdr.triple[1].red / 32 );
	   return;
	};

	for ( p=0; p < 16; p++ )
	   VGR_PALETTE( p, pic->hdr.triple[p].red   / 85,
	                   pic->hdr.triple[p].green / 85,
	                   pic->hdr.triple[p].blue  / 85 );
}


void pcx_showpic( pic, hoffs, voffs, load_palette_flg )
int load_palette_flg, hoffs, voffs;
PCXPIC *pic;
{
	int plane, row, nrows, nplan, nbytes;

	nrows = pic->hdr.y2 - pic->hdr.y1 +1;
	nplan = pic->hdr.nplanes;
	nbytes= pic->hdr.bpl;

	nrows  = nrows  > VGR_VRES ? VGR_VRES : nrows;
	nbytes = nbytes > VGR_NBPL ? VGR_NBPL : nbytes;

	for ( plane = 0; plane < nplan; plane++ )
	{  VGR_PLANE(plane ? plane : -0x0f);
	   for ( row = 0; row < nrows; row++ )
	      VGR_ROW( row, pic->rows[plane][row+voffs] + hoffs, nbytes );
	};

	if ( load_palette_flg )
	   pcx_load_palette( pic );
}



