// ObjectWindows - (C) Copyright 1992 by Borland International
//
// tscrnsav.cpp
//
// Modified by Philip VanBaren (71214,2302 or phillipv@engin.umich.edu)
// to enable the screen saver to work with NDW's Sleeper program.  
//
// The main modifications are:
//   1) Window class is "WindowsScreenSaverClass"  (this is required for the
//        saver to work properly with Sleeper.
//   2) IdleAction does screen saver things on only 1 out of 100 calls,
//        thereby allowing background events (backups, printing, etc.) to  
//        retain most of the processing power when they need it.
//   3) "-c", "/c", "c", "-s", "/s", "s", and "" are accepted as valid command
//        line parameters.  (Sleeper passes "c" and "-s" to start the configure
//        and saver routines, respectively.)
//   4) Allow some slop in mouse movement before aborting the screen saver,
//        so that the screen saver doesn't abort whenever the desk is bumped.

#include <owl.h>
#include <ctype.h>
#include "tscrnsav.h"

#ifndef SC_SCREENSAVE
#define SC_SCREENSAVE 0xF140
#endif

TScrnSavWindow::TScrnSavWindow( PTWindowsObject AParent, LPSTR ATitle,
                                PTModule AModule ) :
                TWindow( AParent, ATitle, AModule )
{
    /*
     *  Hide the cursor.
     */
    while(ShowCursor( FALSE ) >= 0);
    Attr.Style  = WS_POPUP;
}


TScrnSavWindow::~TScrnSavWindow()
{
    ShowCursor( TRUE );
}

void TScrnSavWindow::GetWindowClass( WNDCLASS & AWndClass )
{
    TWindow::GetWindowClass( AWndClass );
    AWndClass.hIcon  = ( HICON )NULL;
    AWndClass.style |= CS_SAVEBITS;
    AWndClass.hbrBackground = ( HBRUSH )GetStockObject( NULL_BRUSH );
}


void TScrnSavWindow::SetupWindow( void )
{
    RECT rc;

    TWindow::SetupWindow();
    GetCursorPos( &prevPt );
    GetWindowRect( GetDesktopWindow(), &rc );
    MoveWindow( HWindow, rc.left, rc.top, rc.right, rc.bottom, TRUE );
}


void TScrnSavWindow::DefWndProc( RTMessage msg )
{
    switch( msg.Message )
    {
        case WM_MOUSEMOVE:
             /*
              *  If the mouse moves more than 10 pixels,
              *  abort the screen saver.
              *  This allows for some slop so that bumping the desk
              *  will not abort the screen saver.
              */
             if ( (abs(MAKEPOINT( msg.LParam ).x-prevPt.x)
                  +abs(MAKEPOINT( msg.LParam ).y-prevPt.y)) < 10 )
                 break;

        case WM_ACTIVATE:
        case WM_ACTIVATEAPP:
             if ( msg.WParam != 0 )
                 break;

        case WM_KEYDOWN:
        case WM_SYSKEYDOWN:
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
        case WM_RBUTTONDOWN:
             PostMessage( HWindow, WM_CLOSE, 0, 0L );

        default:
             break;
    }
    TWindow::DefWndProc( msg );
}


void TScrnSavWindow::WMSysCommand( RTMessage msg )
{
   if (( msg.WParam & 0xFFF0 ) == SC_SCREENSAVE )
   {
      msg.Result = TRUE;
   }
   else
      DefWndProc( msg );
}


void TScrnSavWindow::AnimateScreen()
{}



void TScrnSavApp::InitMainWindow()
{
   int cmdswitch;

   cmdswitch=toupper(lpCmdLine[0]);
   if((cmdswitch == '/') || (cmdswitch == '-'))
      cmdswitch=toupper(lpCmdLine[1]);

   if(cmdswitch == 'S')
   {
      fConfigureFlag = FALSE;
      InitScrnSavWindow();
      if ( pScrnSavWnd )
         MainWindow = pScrnSavWnd;
   }
   else
   {
      fConfigureFlag = TRUE;
      InitConfigDialog();
      if ( pConfigureDialog )
         MainWindow = pConfigureDialog;
   }
}


void TScrnSavApp::InitScrnSavWindow()
{
    pScrnSavWnd = new TScrnSavWindow( NULL, NULL, NULL );
    j=0;
}


void TScrnSavApp::IdleAction()
{
   if ( fConfigureFlag == FALSE  &&  pScrnSavWnd != NULL )
   {
      /*
       *  Only allow screen saver to use 1% of available time so that
       *  background processing (such as printing) is not slowed down.
       */
      j++;
      if(j>100)
      {
         pScrnSavWnd->AnimateScreen();
         j=0;
      }
   }
}
