(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:GrafText                                                   *)
(* Zweck:Anzeigen von Strings im Grafik-Modus                      *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

IMPLEMENTATION MODULE GrafText;

FROM CoreGraph IMPORT _plot;
  (*Punkt zeichnen*)

FROM MATHLIB IMPORT Sqrt;
  (*Wurzel ziehen*)

FROM Lib IMPORT Sound,Delay,NoSound,Intr;
  (*Erzeugt Ton/Unterbricht Programmablauf kurzzeitig/Beendet Tonerzeugung/
    Interrupt-Aufruf*)

FROM Lib IMPORT RANDOM;
  (*Erzeugt Zufallszahl*)

FROM Str IMPORT Length;
  (*Bestimmt Lnge eines Strings*)

TYPE BIT_SET    = SET OF [SHORTCARD(0)..SHORTCARD(7)];
     BIT_ARRAY    = ARRAY [0..7] OF BIT_SET;

VAR Adress,AdressASCII,AdressExtASCII: RECORD CASE : CARDINAL OF
                               | 0: A       :POINTER TO CARDINAL;
                               | 1: P       :POINTER TO BIT_ARRAY;
                               | 2: Off,Seg :CARDINAL;
                              END; END;

    SlowDown,ExtASCII,SoundOn                                        :BOOLEAN;
    chH,chW,CharItalics,xCharStripes,yCharStripes,CharSlope,xBold,
    yBold,xCharSharp,yCharSharp,xCharSpike,yCharSpike,CharLength,Freq:INTEGER;
    CharBottom,CharTop,CharLeft,CharRight,xSpace,
    Music,SoundSpeed,CharSpeed,Wait                                  :CARDINAL;


(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStr(x,y:INTEGER;str:ARRAY OF CHAR;color,speed,colstep:CARDINAL);

  VAR pixels     :BIT_ARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:CARDINAL;
BEGIN
  changecol:=color;
  IF speed>0 THEN SlowDown:=TRUE ELSE SlowDown:=FALSE END;
  CharLength:=Length(str);
  FOR m:=0 TO CharLength-1 DO     (*    Schleife, um die einzelnen Buchstaben*)
                                  (*    zu zeichnen                          *)
                                  (*    Block Buchstaben zeichnen **Anfang** *)
    IF (colstep>64) THEN                      (* Falls colstep grer als 64 *)
      changecol:=changecol+colstep-64;        (* wird es um 64 verkleinert   *)
    END;                                      (* und an changecol bergeben  *)

    IF (changecol<17) AND (changecol>0) THEN  (* Farbe wird von Buchstabe    *)
      changecol:=color;                       (* zu Buchstabe gendert       *)
    END;

    ordCh:=ORD(str[m]);
    Plotx:=x+chW*7;
    Ploty:=y-chH*7;
    xa:=Plotx;

                                  (*    Block ASCII lesen **Anfang**         *)
    IF (ordCh>127) AND NOT ExtASCII THEN
      ordCh:=ORD('*');
    END;
    IF (ordCh<=127) THEN
      Adress.Seg:=AdressASCII.Seg;
      Adress.Off:=AdressASCII.Off+CARDINAL(ordCh)*8;
    ELSE
      Adress.Seg:=AdressExtASCII.Seg;
      Adress.Off:=AdressExtASCII.Off+(CARDINAL(ordCh)-128)*8
    END;
    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)

    FOR k:=1 TO chH+xBold DO      (*    Schleife fr Buchstabenhhe          *)

      IF SoundOn THEN             (*    Sound 5,6 und 7                      *)
        CASE Music OF
          5:IF ODD(m) THEN Sound(m*Freq) ELSE Sound(m*Freq+300);
            END;Delay(3*SoundSpeed);NoSound
        | 6:Sound(Freq*4-k*Freq);Delay(3*SoundSpeed);NoSound;
        | 7:Sound(RANDOM(Freq*30)+100);Delay(3*SoundSpeed);NoSound
        END;
      END;

      FOR l:=1 TO chW+yBold DO    (*    Schleife fr Buchstabenbreite        *)

        IF SoundOn THEN           (*    Sound 5,6 und 7                      *)
          CASE Music OF
            8:Sound((Freq DIV 10)*k*k*k*l);Delay(SoundSpeed);NoSound;
          | 9:Sound(ABS((ordCh-64)*(Freq DIV 2)-k*120));Delay(SoundSpeed);NoSound;
          |10:Sound(RANDOM(Freq)*CARDINAL(k)*CARDINAL(l));Delay(SoundSpeed);NoSound;
          END;
        END;

        FOR j:=CharTop TO 7-CharBottom DO     (* Schleife fr vertikale Pixel*)

          IF SlowDown THEN Delay(speed);END;

          FOR i:=CharRight TO 7-CharLeft DO   (* Schleife fr horizont. Pixel*)

            IF (SHORTCARD(i) IN pixels[j]) THEN

                                  (*    eigentlicher Zeichnen-Befehl         *)
              _plot(Plotx-i*chW-(j*CharItalics DIV 2)-
                   (i*yCharStripes DIV 2)+l*xCharSharp+k*xCharSpike,
                   Ploty+j*chH+(j*xCharStripes DIV 2)+CharSlope*i
                   +l*yCharSharp+k*yCharSpike,changecol);
                                  (*die Buchstaben werden pixelweise gebildet*)

            END;
            IF (colstep>0) AND (colstep<17) THEN
              INC(changecol,colstep);
            END;
          END;                                    (* Hier wird je nach Gre *)
          IF (colstep>16) AND (colstep<33) THEN   (* von colstep die Farbe   *)
            INC(changecol,colstep-16);            (* gewechselt. Die unter-  *)
          END;                                    (* schiedlichen Effekte    *)
        END;                                      (* resultieren aus der     *)
        IF (colstep>32) AND (colstep<49) THEN     (* unterschiedlichen Posi- *)
          INC(changecol,colstep-32);              (* tion des Befehls INC.   *)
        END;                                      (* Er befindet sich jeweils*)
        INC(Plotx);                               (* vor dem Ende einer der  *)
      END;                                        (* Schleifen fr das       *)
      IF (colstep>48) AND (colstep<65) THEN       (* Zeichnen der Buchstaben.*)
        INC(changecol,colstep-48);                (* Je nach Position wird   *)
      END;                                        (* die Farbe verschieden   *)
      Plotx:=xa;                                  (* oft gewechselt          *)
      INC(Ploty);
    END;

    IF (colstep>64) THEN                          (* Hiermit wird vermieden, *)
      changecol:=changecol+colstep-64;            (* da die Variable change-*)
    END;                                          (* col berlaufen kann.    *)

                                  (*    Block Buchstaben zeichnen **Ende**   *)

    IF SoundOn THEN               (*    Sound 1,2,3 und 4                    *)
      CASE Music OF
       1:Sound(Freq*2+20);
         Delay(5*SoundSpeed);
         NoSound;Delay(5*SoundSpeed);
     | 2:Sound(Freq*20-m*Freq+100);Delay(5*SoundSpeed);NoSound
     | 3:Sound(RANDOM(Freq*20)+10);Delay(5*SoundSpeed);NoSound
     | 4:Sound(RANDOM(m*50)+CARDINAL(Freq)*2);Delay(5*SoundSpeed);NoSound
      END;
    END;

    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
    changecol:=color;
  END;
  changecol:=0;colstep:=0;
END PlotStr;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast(x,y:INTEGER;str:ARRAY OF CHAR;color,colstep:CARDINAL);

  VAR pixels     :BIT_ARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:CARDINAL;
BEGIN
  changecol:=color;
  xSpace:=28;

  FOR m:=0 TO Length(str)-1 DO
                                  (*    Block Buchstaben zeichnen **Anfang** *)
    ordCh:=ORD(str[m]);
    Plotx:=x+21;
    Ploty:=y-21;
    xa:=Plotx;
                                  (*    Block ASCII lesen **Anfang**         *)

    (***
    IF (ordCh>127) AND NOT ExtASCII THEN (* wenn keine Buchstaben des        *)
      ordCh:=ORD('*');                   (* erweiterten ASCII-Modus verwendet*)
    END;                                 (* werden, kann dieser Block        *)
                                         (* ausgeklammert werden             *)

    ***)

    (***IF (ordCh<=127) THEN***)
      Adress.Seg:=AdressASCII.Seg;       (* die IF-Anweisung bentigen Sie,  *)
      Adress.Off:=AdressASCII.Off        (* falls Sie Buchstaben aus dem     *)
      +CARDINAL(ordCh)*8;                (* erweiterten ASCII-Modus bentigen*)
    (***ELSE
      Adress.Seg:=AdressExtASCII.Seg;    (* diese Zeilen holen die Buchstaben*)
      Adress.Off:=AdressExtASCII.Off     (* aus dem erweiterten ASCII-Modus  *)
      +(CARDINAL(ordCh)-128)*8
    END;***)

    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)
    FOR k:=1 TO 2 DO
      FOR l:=1 TO 2 DO                            (* Aufgrund der fest vorge-*)
        FOR j:=0 TO 7 DO                          (* gebenen Variablen ver-  *)
          FOR i:=0 TO 7 DO                        (* krzt sich der Quellcode*)
            IF (SHORTCARD(i) IN pixels[j]) THEN   (* enorm und die Prozedur  *)
              _plot(Plotx-i*3+l,                  (* luft sprbar schneller *)
                    Ploty+j*3-l,changecol);       (* ab.                     *)
            END;
          END;
        END;

        IF colstep>0 THEN                         (* Hier wird die Farbe in  *)
          INC(changecol,8);                       (* der Schleife fr die    *)
        END;                                      (* Breite (Var l) gendert.*)

        INC(Plotx);
      END;

      Plotx:=xa;
      INC(Ploty);
    END;
                                  (*    Block Buchstaben zeichnen **Ende**   *)
    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
  END;
END PlotStrFast;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast2(x,y:INTEGER;str:ARRAY OF CHAR;color,colstep:CARDINAL);

  VAR pixels     :BIT_ARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:CARDINAL;
BEGIN
  changecol:=color;
  xSpace:=22;
  FOR m:=0 TO Length(str)-1 DO
                                  (*    Block Buchstaben zeichnen **Anfang** *)
    ordCh:=ORD(str[m]);
    Plotx:=x+14;
    Ploty:=y-14;
    xa:=Plotx;
                                  (*    Block ASCII lesen **Anfang**         *)
    IF (ordCh>127) AND NOT ExtASCII THEN
      ordCh:=ORD('*');
    END;
    IF (ordCh<=127) THEN                          (* Hier wurde die Abfrage  *)
      Adress.Seg:=AdressASCII.Seg;                (* fr erweiterten ASCII-  *)
      Adress.Off:=AdressASCII.Off                 (* Modus belassen. In      *)
      +CARDINAL(ordCh)*8                          (* PlotStrFast ist Sie     *)
    ELSE                                          (* ausgeklammert.          *)
      Adress.Seg:=AdressExtASCII.Seg;             (* Werden also aus dem er- *)
      Adress.Off:=AdressExtASCII.Off              (* weiterten ASCII-Modus   *)
      +(CARDINAL(ordCh)-128)*8                    (* keine Zeichen bentigt, *)
    END;                                          (* kann es auch hier ausge-*)
                                                  (* klammert werde, um Zeit *)
                                                  (* zu sparen.              *)
    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)
    FOR k:=1 TO 2 DO
      FOR l:=1 TO 2 DO                            (* Aufgrund der fest vorge-*)
        FOR j:=0 TO 7 DO                          (* gebenen Variablen ver-  *)
          FOR i:=0 TO 7 DO                        (* krzt sich der Quellcode*)
            IF (SHORTCARD(i) IN pixels[j]) THEN   (* enorm und die Prozedur  *)
              _plot(Plotx-i*2-j DIV 2,            (* luft sprbar schneller *)
                    Ploty+j*2-k,changecol);       (* ab.                     *)
            END;
          END;
        END;

        IF colstep>0 THEN                         (* Hier wird die Farbe in  *)
          INC(changecol,8);                       (* der Schleife fr die    *)
        END;                                      (* Breite (Var l) gendert.*)

        INC(Plotx);
      END;
      Plotx:=xa;
      INC(Ploty);
    END;
                                  (*    Block Buchstaben zeichnen **Ende**   *)
    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
  END;
END PlotStrFast2;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSize(CHeight,CWeight:CARDINAL;CSpace:INTEGER);

BEGIN
  chH:=CHeight;                   (* Werte mssen nur an globale Variablen   *)
  chW:=CWeight;                   (* bergeben werden                        *)
  xSpace:=CARDINAL(TRUNC(         (* Hier wird der Abstand zwischen den      *)
          REAL(chH)*REAL(chW)*    (* Zeichen in Abhngigkeit von Breite und  *)
          8.0*((REAL(CSpace)/     (* Hhe und der whlbaren Variable CSpace  *)
          10.)+1.0)));            (* berechnet.                              *)
END CharSize;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharType(CItal,CSlope:INTEGER;xCBold,yCBold:INTEGER);

BEGIN
  CharItalics:=CItal;
  CharSlope:=CSlope;              (* Werte mssen nur an globale Variablen   *)
  xBold:=xCBold;                  (* bergeben werden                        *)
  yBold:=yCBold;
END CharType;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharEffect(xCStripe,yCStripe,xCSharp,yCSharp,xCSpike,yCSpike:INTEGER);

BEGIN
  xCharStripes:=xCStripe;
  yCharStripes:=yCStripe;
  xCharSharp:=xCSharp;            (* Werte mssen nur an globale Variablen   *)
  yCharSharp:=yCSharp;            (* bergeben werden                        *)
  xCharSpike:=xCSpike;
  yCharSpike:=yCSpike;
END CharEffect;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSound(CFreq,CSpeed,CMusic:CARDINAL);
BEGIN
  Freq:=CFreq;                    (* Werte mssen nur an globale Variablen   *)
  SoundSpeed:=CSpeed;             (* bergeben werden                        *)
  Music:=CMusic;
  IF CMusic>0 THEN
    SoundOn:=TRUE ELSE SoundOn:=FALSE;
  END;
END CharSound;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharCut(CBottom,CTop,CLeft,CRight:CARDINAL);

BEGIN
  CharBottom:=CBottom;
  CharTop:=CTop;                  (* Werte mssen nur an globale Variablen   *)
  CharLeft:=CLeft;                (* bergeben werden                        *)
  CharRight:=CRight;
END CharCut;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharInit();

BEGIN
  CharItalics:=0;                 (* Initialisieren aller globalen Variablen,*)
  CharSlope:=0;                   (* d.h. alle globalen Variablen erhalten   *)
  xCharStripes:=0;                (* Standardwerte.                          *)
  yCharStripes:=0;
  xCharSharp:=0;
  yCharSharp:=0;                  (* Diese Prozedur mu vor dem Benutzen     *)
  xCharSpike:=0;                  (* der Prozeduren PlotStr oder PlotStrFast *)
  yCharSpike:=0;                  (* aufgerufen werden. Sonst haben alle     *)
  CharBottom:=0;                  (* globalen Variablen unbestimmte Werte!   *)
  CharTop:=0;
  CharLeft:=0;
  CharRight:=0;
  Freq:=0;
  SoundSpeed:=0;
  Music:=0;
  CharSpeed:=0;
  SlowDown:=FALSE;
  chH:=1;
  chW:=1;
  xSpace:=8;
  xBold:=0;
  yBold:=0;
END CharInit;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

BEGIN

  AdressASCII.Seg:=0F000H; AdressASCII.Off:=0FA6EH;
  Adress.Seg:=0000H; Adress.Off:=007EH;           (* Initialisierung der     *)
  AdressExtASCII.Seg:=Adress.A^;                  (* Variablen und Zeiger    *)
  Adress.Off:=007CH;
  AdressExtASCII.Off:=Adress.A^;

  IF (AdressExtASCII.Off=0) AND (AdressExtASCII.Seg=0) THEN
    ExtASCII:=FALSE;              (* berprfen, ob erweiterte ASCII-Tabelle *)
      ELSE                        (* geladen, d.h. ob die Pixelmatrizen fr  *)
    ExtASCII:=TRUE;               (* ORD>127 vorhanden sind.                 *)
  END;

END GrafText.