(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:Zeit                                                       *)
(* Zweck:Parallele Prozesse (Zeitanzeige)                          *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

MODULE ZeitIV;

FROM GrafText IMPORT PlotStrFast,PlotStrFast2,CharInit;
FROM Lib IMPORT Dos,Intr,Delay;
FROM CoreGraph IMPORT _hline;
IMPORT SYSTEM,Str,IO,Graph;

VAR ZeitStr:ARRAY[1..3] OF CHAR;
    PunkteStr:ARRAY[1..4] OF CHAR;
    ok:BOOLEAN;
    Secs,AlteZeit,ZeitSek,Punkte:CARDINAL;
    Y:CARDINAL;
    cpu:SYSTEM.Registers;

BEGIN
  CharInit;
  ZeitSek:=0;
  Punkte:=0;
  Graph.InitVGA;
  Graph.GraphMode;
  cpu.AH:=0;
  cpu.AL:=12H;
  Intr(cpu,10H);
  cpu.AH:=2CH;
  Dos(cpu);
  AlteZeit:=CARDINAL(cpu.DH);
  Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
  REPEAT
    cpu.AH:=2CH;
    Dos(cpu);
    Secs:=CARDINAL(cpu.DH);
  UNTIL (Secs>AlteZeit) OR ((Secs=0) AND (AlteZeit>50));
  AlteZeit:=Secs;
  IF ZeitSek<10 THEN PlotStrFast(300,383,ZeitStr,1,1);
    ELSIF ZeitSek<100 THEN PlotStrFast(278,383,ZeitStr,1,1);
    ELSE PlotStrFast(256,383,ZeitStr,1,1);
  END;
  Str.CardToStr(LONGCARD(Punkte),PunkteStr,10,ok);
  IF Punkte<10 THEN PlotStrFast2(300,100,PunkteStr,4,49);
    ELSIF Punkte<100 THEN PlotStrFast2(278,100,PunkteStr,4,49);
    ELSIF Punkte<1000 THEN PlotStrFast2(256,100,PunkteStr,4,49);
    ELSE PlotStrFast2(234,100,PunkteStr,4,49);
  END;
  LOOP
    (****Prozedur 1: Punkte anzeigen****)
    INC(Punkte);
    Str.CardToStr(LONGCARD(Punkte),PunkteStr,10,ok);
    FOR Y:= 80 TO 101 DO _hline(232,Y,325,0);END;
    IF Punkte<10 THEN PlotStrFast2(300,100,PunkteStr,4,49);
      ELSIF Punkte<100 THEN PlotStrFast2(278,100,PunkteStr,4,49);
      ELSIF Punkte<1000 THEN PlotStrFast2(256,100,PunkteStr,4,49);
      ELSE PlotStrFast2(234,100,PunkteStr,4,49);
    END;
    cpu.AH:=2CH;
    Dos(cpu);
    Secs:=CARDINAL(cpu.DH);
    (****Prozedur 2: Zeit anzeigen****)
    IF (Secs=0) AND (AlteZeit>50) OR (Secs>AlteZeit) THEN
      Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
      IF ZeitSek<10 THEN PlotStrFast(300,383,ZeitStr,0,0);
        ELSIF ZeitSek<100 THEN PlotStrFast(278,383,ZeitStr,0,0);
        ELSE PlotStrFast(256,383,ZeitStr,0,0);
      END;
      INC(ZeitSek);
      Str.CardToStr(LONGCARD(ZeitSek),ZeitStr,10,ok);
      IF ZeitSek<10 THEN PlotStrFast(300,383,ZeitStr,1,1);
        ELSIF ZeitSek<100 THEN PlotStrFast(278,383,ZeitStr,1,1);
        ELSE PlotStrFast(256,383,ZeitStr,1,1);
      END;
      AlteZeit:=Secs;
    END;
    IF IO.KeyPressed() THEN EXIT;END;
  END;
  Delay(1000);
END ZeitIV.