(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:VGA136                                                     *)
(* Zweck:Mischfarben im 16-Farb-Modus                              *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

IMPLEMENTATION MODULE VGA136;

FROM Graph IMPORT Plot,HLine;
   (*Punkt zeichnen/Horizontale Linie zeichnen*)

FROM VGABIOS IMPORT SetPalette;
   (*ndert die Farbregister der 15 VGA-Farben*)

FROM SYSTEM IMPORT Registers;
   (* Zugriff auf CPU-Register *)

FROM Lib IMPORT Intr;
   (* Interrupt-Aufruf *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE FarbPalette;
   (*Der Prozedur SetPalette mu ein ARRAY mit den Werten fr Rot-,
     Grn- und Blauanteil bergeben werden. Jeder Anteil kann
     Werte von 0 bis 63 annehmen. Hier wird eine solche Farbpalette
     in dem ARRAY B angelegt und anschlieend durch Aufruf von
     SetPalette auch in die Farbregister geladen*)

VAR B:ARRAY [0..44] OF SHORTCARD;
    cpu:Registers;
    Farbe:BYTE;

BEGIN
  B[42]:=38;B[43]:=40;B[44]:=39;  (* Farbe Nr.15 *)
  B[39]:=17;B[40]:=18;B[41]:=18;  (* Farbe Nr.14 *)
  B[36]:=33;B[37]:=35;B[38]:=34;  (* Farbe Nr.13 *)
  B[33]:=12;B[34]:=13;B[35]:=12;  (* Farbe Nr.12 *)
  B[30]:=27;B[31]:=29;B[32]:=28;  (* Farbe Nr.11 *)
  B[27]:=22;B[28]:=23;B[29]:=23;  (* Farbe Nr.10 *)
  B[24]:=16;B[25]:=13;B[26]:=18;  (* Farbe Nr.9  *) (* Farbe Nr.0 entsprche *)
  B[21]:=43;B[22]:=35;B[23]:=30;  (* Farbe Nr.8  *) (* dem Hintergrund, der  *)
  B[18]:=63;B[19]:=50;B[20]:=20;  (* Farbe Nr.7  *) (* hier nicht gesetzt    *)
  B[15]:=5;B[16]:=5;B[17]:=63;    (* Farbe Nr.6  *) (* wird und somit schwarz*)
  B[12]:=37;B[13]:=26;B[14]:=39;  (* Farbe Nr.5  *) (* bleibt.               *)
  B[9]:=21;B[10]:=10;B[11]:=23;   (* Farbe Nr.4  *)
  B[6]:=55;B[7]:=30;B[8]:=34;     (* Farbe Nr.3  *)
  B[3]:=43;B[4]:=18;B[5]:=30;     (* Farbe Nr.2  *)
  B[0]:=28;B[1]:=10;B[2]:=26;     (* Farbe Nr.1  *)

                             (* Interrupt:Mehrere DAC-Register setzen        *)
  cpu.AH:=10H;               (* Interrupt Nummer 10H                         *)
  cpu.AL:=12H;               (* Interrupt-Funktionsnummer                    *)
  cpu.BX:=1H;                (* Nummer des ersten DAC-Registers              *)
  cpu.CX:=0FH;               (* Anzahl der Register                          *)
  cpu.ES:=Seg(B);            (* Segment der Parameter-Tabelle Y              *)
  cpu.DX:=Ofs(B);            (* Offset der Parameter-Tabelle Y               *)
  Intr(cpu,10H);

  FOR Farbe:=1 TO 15 DO
                             (* Interrupt:Einzelnes Paletten-Register setzen *)
    cpu.AH:=10H;             (* Interrupt Nummer 10H                         *)
    cpu.AL:=0H;              (* Interrupt-Funktionsnummer                    *)
    cpu.BL:=Farbe;           (* Nummer des Paletten-Registers                *)
    cpu.BH:=Farbe;           (* Farbwert (zugewiesenes DAC-Register)         *)
    Intr(cpu,10H)

  END
END FarbPalette;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE XHLine(X1,Y,X2,Farbe1,Farbe2:CARDINAL);

VAR X:CARDINAL;

BEGIN

  (*Hier wird eine horizontale Linie gezeichnet, die abwechselnd aus Punkten
    der beiden Farben gezeichnet wird. Damit bei Flchen auch in vertikaler
    Richtung die Farbe auch wechselt, wird berprft, ob die Koordinaten
    gerade oder ungerade sind.*)

  IF ODD(Y) THEN

    FOR X:=X1 TO X2 DO                   (* Wenn Y ungerade, dann abwechselnd*)
      IF ODD(X) THEN Plot(X,Y,Farbe1);   (* Farbe 1 und Farbe 2 pixelweise   *)
      ELSE Plot(X,Y,Farbe2);END;         (* setzen.                          *)
    END;

  ELSE

    FOR X:=X1 TO X2 DO                   (* Wenn Y gerade, dann abwechselnd  *)
      IF ODD(X) THEN Plot(X,Y,Farbe2);   (* Farbe 2 und Farbe 1 pixelweise   *)
      ELSE Plot(X,Y,Farbe1);END;         (* setzen.                          *)
    END;

  END;
END XHLine;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE XVLine(Y1,X,Y2,Farbe1,Farbe2:CARDINAL);

VAR Y:CARDINAL;

BEGIN

  (*Das gleiche wie XHLine, jetzt aber vertikale Linie.*)

  IF ODD(X) THEN

    FOR Y:=Y1 TO Y2 DO                   (* Wenn X ungerade, dann abwechselnd*)
      IF ODD(Y) THEN Plot(X,Y,Farbe1);   (* Farbe 1 und Farbe 2 pixelweise   *)
      ELSE Plot(X,Y,Farbe2);END;         (* setzen.                          *)
    END;

  ELSE

    FOR Y:=Y1 TO Y2 DO                   (* Wenn X ungerade, dann abwechselnd*)
      IF ODD(Y) THEN Plot(X,Y,Farbe2);   (* Farbe 2 und Farbe 1 pixelweise   *)
      ELSE Plot(X,Y,Farbe1);END;         (* setzen.                          *)
    END;

  END;
END XVLine;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE Demo(X,Y,Farbe:CARDINAL);

VAR YY,XX:CARDINAL;

BEGIN

  (*Diese Prozedur zeichnet ein Schokostckchen aus dem Spiel Hotdog.*)

  FOR YY:=Y+5 TO Y+28  DO            (* Oberflche zeichnen                  *)
    HLine(X+5,YY,X+28,Farbe);
  END;

  XHLine(X+4,Y+4,X+29,Farbe,13);
  XHLine(X+5,Y+29,X+28,Farbe,12);
  XVLine(Y+5,X+4,Y+29,Farbe,11);
  XVLine(Y+5,X+29,Y+29,Farbe,10);

  XHLine(X+3,Y+3,X+30,Farbe,13);     (* Dies sind die Linien fr die         *)
  XHLine(X+4,Y+30,X+29,Farbe,12);    (* Auenflchen. Sie werden von innen   *)
  XVLine(Y+4,X+3,Y+30,Farbe,11);     (* nach auen gezeichnet, um ein        *)
  XVLine(Y+4,X+30,Y+30,Farbe,10);    (* gleichmiges Erscheinen des Schoko- *)

  XHLine(X+2,Y+2,X+31,Farbe,13);     (* stckchens zu ermglichen. Bei sehr  *)
  XHLine(X+3,Y+31,X+30,Farbe,12);    (* langsamen Computern meint man, das   *)
  XVLine(Y+3,X+2,Y+31,Farbe,11);     (* Schokostckchen wrde aus dem        *)
  XVLine(Y+3,X+31,Y+31,Farbe,10);    (* Hintergrund "auftauchen".            *)

  XHLine(X+1,Y+1,X+32,Farbe,13);
  XHLine(X+2,Y+32,X+31,Farbe,12);    (* Dies knnen Sie auch bei schnellen   *)
  XVLine(Y+2,X+1,Y+32,Farbe,11);     (* Computern ermglichen, wenn Sie nach *)
  XVLine(Y+2,X+32,Y+32,Farbe,10);    (* jedem vierten X*Line-Befehl ein Delay*)

  XHLine(X,Y,X+33,Farbe,13);         (* einfgen. Nach jeweils vier X*Line-  *)
  XHLine(X+1,Y+33,X+32,Farbe,12);    (* Befehlen ist genau ein ganzer Umfang *)
  XVLine(Y+1,X,Y+33,Farbe,11);       (* gezeichnet. XHLine zeichnet die Ober-*)
  XVLine(Y+1,X+33,Y+33,Farbe,10);    (* und Unterseite, XVLine die rechte und*)
                                     (* linke Seite der Schokostckchen.     *)
END Demo;                            

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

END VGA136.

