//Here is an OWL serial program written for Borland Turbo C++ 3.1 .
//
//Most of it was taken from the program file wmseri.zip and also from the book
//"Windows Programmer's Guide to Serial Communications" by Timothy S. Monk.
//Both of these were written in C and I add the C++ stuff and the OWL parts.
//
//The program wmserial does not repaint the screen so I added that part from
//Timothy S. Monk's book.
//
//There is a problem with the character buffer used to repaint the screen
//after a WM_PAINT msg.  After the buffer is full and the screen has been
//scrolled the buffer gets corrupted and some garbage is written to the 
//screen.
//
//If anyone can fix the buffer I sure would like to know how to do it.
//
//Scott Gustafson
//76250,1460

#define _MAIN
#include <owl.h>
#include <edit.h>
#include <stdio.h>
#include "owlcomm.h"
#include <string.h>
#include <inputdia.h>
int nComID;
HWND hComPortWnd;
HANDLE hWriteBuffer;
LPSTR szData="";
LPSTR szWriteBuffer;
const MAX_STRINGS = 10;
const MAX_STRING_LEN = 40;
const LINE_INCR = 20;


class Tcomopn : public TApplication
{
public:
  Tcomopn(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
    virtual void InitMainWindow();
};


class TMainWindow : public TWindow
{
public:
   TMainWindow(PTWindowsObject AParent, LPSTR ATitle);
   virtual void DialDlg(RTMessage Msg) = [CM_FIRST + IDM_DIAL];
   virtual void HangUp(RTMessage Msg) = [CM_FIRST + IDM_HANGUP];
   virtual void Exit(RTMessage Msg) = [CM_FIRST + IDM_EXIT];
   virtual void WMCHAR(RTMessage Msg) = [WM_FIRST + WM_CHAR];
   virtual void WMCOMMNOTIFY(RTMessage Msg) = [WM_FIRST + WM_COMMNOTIFY];
   virtual void WMKEYDOWN(RTMessage Msg)= [WM_FIRST + WM_KEYDOWN];
   virtual void WMKILLFOCUS(RTMessage Msg) = [WM_FIRST + WM_KILLFOCUS];
   virtual void WMSETFOCUS(RTMessage Msg) = [WM_FIRST + WM_SETFOCUS];
   virtual void WMSize(RTMessage Msg) = [WM_FIRST + WM_SIZE];
   virtual void Paint(HDC DC,PAINTSTRUCT &PaintInfo);
   virtual void TMainWindow::SetupWindow();
   ~TMainWindow();
protected:
	virtual void GetWindowClass(WNDCLASS _FAR & AWndClass);
   	virtual LPSTR GetClassName();

};


TMainWindow::TMainWindow(PTWindowsObject AParent, LPSTR ATitle)
                         : TWindow(AParent, ATitle)
{
   AssignMenu("owlcomm");


}
TMainWindow::~TMainWindow()
{

}

LPSTR TMainWindow::GetClassName()
{
   return "MainWindow";
}

void TMainWindow::GetWindowClass(WNDCLASS _FAR & AWndClass)
{
   TWindow::GetWindowClass(AWndClass);
   AWndClass.hIcon = LoadIcon(GetApplication()->hInstance, "OWLCOMMICO");

}

void TMainWindow::SetupWindow()
{
	TTYInit(HWindow);
	Connect(HWindow) ;
}

void TMainWindow::DialDlg(RTMessage)
{
     char Input[45]="";
     if (GetApplication()->ExecDialog(new TInputDialog(this,
       "OWL TInputDialog", "Enter number to dial:",Input,
       sizeof(Input))) == IDOK)
	{
      Dial(Input);
      }; 
}

void TMainWindow::HangUp(RTMessage)
{
     HangUpModem(nActiveComPort);
}

void TMainWindow::Exit(RTMessage)
{
	   Disconnect();
           DestroyWindow( HWindow );
	   PostQuitMessage( 0 );
}

void Tcomopn::InitMainWindow()
{
   MainWindow = new TMainWindow(NULL, Name);
}


int PASCAL WinMain(HINSTANCE hInstance,
                   HINSTANCE hPrevInstance,
                   LPSTR lpCmdLine,
                   int nCmdShow)
{

   Tcomopn comopn ("OWL Comm Program", hInstance, hPrevInstance,
      lpCmdLine, nCmdShow);

   comopn.Run();

   return comopn.Status;
}


void TMainWindow::WMSETFOCUS(RTMessage Msg)
{
	CreateCaret( HWindow, NULL, nXChar, nYChar );
      	SetCaretPos( nCurrCol * nXChar, nCurrRow * nYChar );
      	ShowCaret( HWindow );

}

void TMainWindow::WMSize(RTMessage Msg)
{
	nRows= Msg.LP.Hi /nYChar;
 	nCols= Msg.LP.Lo /nXChar;
	nCurrRow= nCurrCol =0;
		
}

void TMainWindow::WMKILLFOCUS(RTMessage Msg)
{
      HideCaret( HWindow );
      DestroyCaret();
}


void TMainWindow::WMKEYDOWN(RTMessage Msg)
{
		   switch (Msg.WParam )
               {
               case VK_RETURN:
                   WriteComPort( nActiveComPort,"\r",1 );
                   CheckComPort( nActiveComPort,NULL );
		     default:
				   DefWndProc(Msg);
               }

}

void TMainWindow::WMCHAR(RTMessage Msg)
{
	   char szTemp[3];
		switch( Msg.WParam )
               {
               case '\r':
               case '\n':
                   break;

               default:
		   szTemp[0] = (char)Msg.WParam;
                   szTemp[1] = '\0';
		   WriteComPort( nActiveComPort,szTemp,1 );
		   CheckComPort( nActiveComPort,NULL );
		   break;
               }
          

}
 void TMainWindow::Paint(HDC DC,PAINTSTRUCT &PaintInfo)
{

   int nChars;

   nCurrCol = nCurrRow = 0;
   nChars = nBufferTail - nBufferHead;
   if ( nChars < 0 )
      nChars += CHAR_BUFFER_SIZE;

   if ( nChars > 0 ) {
      	bBufferChars = FALSE;
	TTYWriteScreen(&szCharBuffer[nBufferHead],nChars);
	bBufferChars = TRUE;
   }


}

void TMainWindow::WMCOMMNOTIFY(RTMessage Msg)
{
   ProcessCommNotify( HWindow, Msg.WParam, Msg.LP.Lo);
   CheckComPort(  Msg.WParam,NULL );

}

