
#define QBUFFSIZE      4096

#define COMPORT        "COM2"
#define BAUDRATE       "2400"
#define PARITY         "E"
#define DATABITS       "7"
#define STOPBITS       "1"
#define CHAR_BUFFER_SIZE      1024


// Defines for menu item IDs
#define   IDM_DIAL                     101
#define   IDM_HANGUP	  	       102
#define   IDM_EXIT		       103




#ifdef _MAIN
int     nXChar;
int     nYChar;
int     nRows;
int     nCols;
int 	nCurrRow ;
int 	nCurrCol;
int     nSaveCol;
int     nSaveRow;
int 	nActiveComPort;
int     nBufferHead;
int     nBufferTail;
char    szCharBuffer[ CHAR_BUFFER_SIZE ];
BOOL 	bScroll;
BOOL	bConnected;
//BOOL 	bEcho = FALSE;
BOOL	bBufferChars;
DWORD   dwTextColor;
DWORD   dwBkGndColor;
HBRUSH  hBkBrush;

#else

extern int     nXChar;
extern int     nYChar;
extern int     nRows;
extern int     nCols;
extern int 	nCurrRow ;
extern int 	nCurrCol;
extern int     nSaveCol;
extern int     nSaveRow;
extern int 	nActiveComPort;
extern int     nBufferHead;
extern int     nBufferTail;
extern char    szCharBuffer[ CHAR_BUFFER_SIZE ];
extern BOOL 	bScroll;
extern BOOL	bConnected;
///extern BOOL 	bEcho = FALSE;
extern BOOL	bBufferChars;
extern DWORD   dwTextColor;
extern DWORD   dwBkGndColor;
extern HBRUSH  hBkBrush;

#endif


// Function declarations


// Window functions ( WMSERIAL.C )

HWND InitWinApp(HANDLE hInstance, HANDLE hPrevious,
               LPSTR lpszCmdLine, int nCmdShow);

LRESULT CALLBACK _export WndProc (HWND hWnd, UINT message, 
                                  WPARAM wParam, LPARAM lParam);



// Process Comm Notification Procedure ( WNOTIFY.C )

int ProcessCommNotify(HWND hWnd, int nComID, int nNotification);



// High level communication functions ( WCONNECT.C )

BOOL Connect(HWND);
BOOL Dial( char *DailInput);
void Disconnect(void);



// Modem functions ( WMODEM.C )

BOOL InitModem(HWND hWnd, int nComID);
int GetModemResponse(int nComID, LPSTR szDest, int nMaxLength, int Wait);
int HangUpModem(int nComID);



// Com Port functions ( WCOM.C )

int InitComPort( HWND hWnd, LPSTR ComName );
int CloseComPort( int nComID );
int ReadComPort( int nComID , LPSTR Data , int nMaxLength );
int WriteComPort( int nComID , LPSTR Data , int nLength );
int CheckComPort( int nComID , COMSTAT *Status );



// TTY functions ( WTTY.C )

void TTYInit(HWND hWnd);
void TTYWriteScreen( LPCSTR lpOutString, int nNumChars );
void TTYRemoveBufferChars( void );
void TTYDisplayChar( HWND HWindow, char cChar );








