//

// WNOTIFY.C

#include <windows.h>
#include "owlcomm.h"
#include <string.h>

int ProcessCommNotify(HWND HWindow, int nComID, int nNotification)
   {
   HANDLE hBufferMem;
   extern LPSTR szData;
   int nResult;

   // Process Receive Notice    
   if ( nNotification & CN_RECEIVE )
       {
       // Get memory for data
       hBufferMem = GlobalAlloc( GMEM_MOVEABLE, QBUFFSIZE );
       if (!hBufferMem)
           {
           MessageBeep(MB_ICONEXCLAMATION);
           MessageBox(NULL,"Not enough memory for initializing modem.","Example Windows Terminal",MB_ICONSTOP);
	   PostMessage(NULL,WM_CLOSE,0,0L);
           return NULL;
           }
       szData = (LPSTR) GlobalLock(hBufferMem);

       nResult = ReadComPort ( nComID, szData, QBUFFSIZE-1 );
       if (nResult > 0)
           {
           szData[nResult] = 0;
		   TTYWriteScreen(szData,strlen(szData));
           }
       else if (nResult < 0)
           {
           szData[-nResult] = 0;
		   TTYWriteScreen(szData,strlen(szData));
           GlobalUnlock(hBufferMem);       
           return nResult;
           }
       GlobalUnlock(hBufferMem);
       CheckComPort(nComID,NULL);
       }


   // Process Transmit Notice
   if ( nNotification & CN_TRANSMIT )
       nResult = WriteComPort(nComID, NULL, NULL);
       // Last Error is left for CheckComPort() call


   return nResult;
   }

