
// WTTY.C

#include <windows.h>
#include "owlcomm.h"



static HWND hTTYWnd;
void TTYInit(HWND HWindow)
{
   HDC hDC;
   TEXTMETRIC TextMetric;
   RECT TTYRect;

   // TTY Window Handle
   hTTYWnd = HWindow;

   // Window Position
   nCurrRow = 0;
   nCurrCol = 0;

   // Window Text Metrics
   hDC = GetDC( hTTYWnd );
      dwTextColor  = RGB(255,255,255);
   dwBkGndColor = RGB(0,0,255);
   hBkBrush = CreateSolidBrush( RGB(0,0,255) );
   if ( hBkBrush )
	  SetClassWord( HWindow, GCW_HBRBACKGROUND, (WORD)hBkBrush );


   SelectObject( hDC,
                 GetStockObject( OEM_FIXED_FONT ) );

   GetTextMetrics( hDC, &TextMetric );
   ReleaseDC( hTTYWnd, hDC );
   nXChar = TextMetric.tmAveCharWidth;
   nYChar = TextMetric.tmHeight +
            TextMetric.tmExternalLeading;

   GetClientRect(hTTYWnd,&TTYRect);
   nRows = (TTYRect.bottom - TTYRect.top)  /  nYChar;
   nCols = (TTYRect.right - TTYRect.left) /  nXChar;
   nSaveCol = nSaveRow = 0;

   nBufferHead = nBufferTail = 0;
   bBufferChars = TRUE;

}



void TTYWriteScreen( LPCSTR szChars, int nNumChars )
   {
   int   i;

   LPSTR lpCurrChar;

   //
   // loop through each character received
   //
   for ( i = 0, lpCurrChar = (LPSTR)szChars; i < nNumChars;
                                           i++, lpCurrChar++ ) {
      //
      // add the character to the buffer if the program is
      // currently buffering characters
      //
      if ( bBufferChars ) {
	 szCharBuffer[ nBufferTail ] = *lpCurrChar;
         nBufferTail++;
         if ( nBufferTail == CHAR_BUFFER_SIZE )
            nBufferTail = 0;
            }

    TTYDisplayChar( hTTYWnd, *lpCurrChar );
   }

}



void TTYDisplayChar( HWND hTTYWnd, char cChar )
{
   HDC   hDC;

      hDC = GetDC( hTTYWnd );
   SelectObject( hDC, GetStockObject( OEM_FIXED_FONT ) );
   SetTextColor(hDC,RGB(255,255,255));
   SetBkColor(hDC,RGB(0,0,255));
   SetBkMode(hDC,OPAQUE);
   HideCaret( hTTYWnd );
   switch ( cChar ) {
      case VK_RETURN:
	 nCurrCol = 0;
         break;

      case 0xA:
         //
         // process a new line
         //
         nCurrRow++;
         if ( nCurrRow == ( nRows - 1 ) ) {
	    TTYRemoveBufferChars();
	    ScrollWindow( hTTYWnd, 0, -nYChar, NULL, NULL );
	    ValidateRect( hTTYWnd, NULL );
	    UpdateWindow( hTTYWnd );
            nCurrRow = nRows - 2;
         }
         break;

      case VK_BACK:
         //
         // process a backspace
         //
         if ( nCurrCol )
            nCurrCol--;
         break;

      default:
         //
         // process the "normal" characters  display it on the
         // window
         //
	 TextOut( hDC, nCurrCol * nXChar, nCurrRow * nYChar,
                  (LPSTR)&cChar, 1 );

	 //
         // increment the column and see whether it is at the end
         // of a line
         //
         nCurrCol++;
         if ( nCurrCol == ( nCols - 1 ) ) {
            //
            // end of a line
	       nCurrCol = 0;
               nCurrRow++;

               //
               // does program need to scroll the window?
               //
               if ( nCurrRow == ( nRows - 1 ) ) {
		  TTYRemoveBufferChars();
		  ScrollWindow( hTTYWnd, 0, -nYChar, NULL, NULL );
		  ValidateRect( hTTYWnd, NULL );
		  UpdateWindow( hTTYWnd );
                  nCurrRow = nRows - 2;
               }
	 }
         break;
   }

   SetCaretPos( nCurrCol * nXChar, nCurrRow * nYChar );
   ShowCaret( hTTYWnd );
   ReleaseDC( hTTYWnd, hDC );
}

void TTYRemoveBufferChars( void )
{
   BOOL  bContinue = TRUE;
   while ( bContinue ) {
      //
      // see whether the head and tail are the same
      //
      if ( nBufferHead == nBufferTail ) {
         bContinue = FALSE;
         continue;
      }

      //
      // see whether the head points to a line feed
      //
      if ( szCharBuffer[ nBufferHead ] == 0xA )
         bContinue = FALSE;

      //
      // update the buffer head pointer
      //
      nBufferHead++;
      if ( nBufferHead == CHAR_BUFFER_SIZE )
         nBufferHead = 0;
   }
}

