// Persistence Of Vision raytracer version 1.0 sample file.

// This scene file makes a good starting point for developing tests and
// new scene files.  It is also used as the benchmark for the timing tests.

#include "colors.inc"
#include "textures.inc"
#include "stones.inc"

camera {
   location <-40.0,  20.0,  -80.0>
//   direction <0.0, 0.0,  1.0>
   up  <0.0,  1.0,  0.0>
   right <1.33333, 0.0, 0.0>
   look_at <0, 0, 0>
}

// Light source
object {
   light_source {
      <100, 200, -300>
      color White
   }
}

// Light source
object {
   light_source {
      <-200, 200, -100>
      color White
   }
}

// Light source
object {
   light_source {
      <200, 200, 100>
      color White
   }
}



// Whitish background
object {
   sphere { <0, 0, 0> 10000 }
   texture {
   finish       { ambient 0.6  // Bath it in so much "light" that it doesn't have any shadows 
				diffuse 0.7
				brilliance 2
			}
	pigment {
				color Wheat;
			}
		} // end texture
}

#declare TEXTURE_1 = texture { 
	pigment {
				colour Orange
			}
	finish  {
			phong_size 1
			}
	}

#include "temp.pov"

object {
		TheFormObject
		scale <100,100,100>
}

// Floor plane , sort of greenish
object {
   plane { <0.0, -1.0, 0.0> 0.0 }
   translate <0, -100, 0 >
   texture {
		pigment {
				colour HuntersGreen
				}
		finish  {
				ambient 0.15
				diffuse 0.8
				}
   }
}
