//lRegen_FileHeading
//lRegen_FileHeading

     /********************************************************************
      *
      *   Source File:  toptool2.c                                        
      *   Author:       Miles Dempsey / Ray                               
      *   Module:       Source for toolbars application                   
      *   Program Desc: ToolBars Example                                                                
      *   Date:         Fri Nov 12 18:15:16 1993                          
      *
      ********************************************************************/

#include "toolbars.h"


//lRegen_Variables
extern VIEW     hViewSpread;

void fnSetToZero(float *fPtrTarget);    // function descriptions at
void fnTotalColumn(float *fPtrTarget);    //   function code below
void fnGetSource(float *fPtrSource);    //   this module
void fnAdd(float *fPtrSource, float *fPtrTarget);
void fnSubtract(float *fPtrSource, float *fPtrTarget);
void fnCopy(float *fPtrSource, float *fPtrTarget);

extern HWND hWndHelpLine2;

BOOL bBut1;

float SourceColumn[5];
//lRegen_Variables

LRESULT CALLBACK __export MouseNear(HWND, UINT, WPARAM, LPARAM);
VIEW     hViewtoptool2;
HWND     hWndtoptool2;
LRESULT CALLBACK __export fntoptool2WndProc(HWND, UINT, WPARAM, LPARAM);


#pragma argsused
int fntoptool2(HWND hParentWnd, UINT iData, void FAR *lpData)
{
   int   ReturnCode;

   //lRegen_BeginFunction
   //lRegen_BeginFunction

   //lRegen_InitDlg
   //lRegen_InitDlg

   if(!(hViewtoptool2 = vwCreateView(hInst,
                   "toptool2",
                   hParentWnd,
                   (VIEWPROC)fntoptool2WndProc,
                   NULL)))
   {
         //lRegen_Create
         //lRegen_Create
        return FALSE;
   }
   vwSetFieldProc(hViewtoptool2, IDC_BUTTON1, MouseNear);
   vwSetFieldProc(hViewtoptool2, IDC_BUTTON2, MouseNear);
   vwSetFieldProc(hViewtoptool2, IDC_BUTTON3, MouseNear);
   vwSetFieldProc(hViewtoptool2, IDC_BUTTON4, MouseNear);
   vwSetFieldProc(hViewtoptool2, IDC_BUTTON5, MouseNear);
   //lRegen_InitView
   //lRegen_InitView
   if((ReturnCode = vwShowModalView(hViewtoptool2)) == -1)
   {
        MessageBox(NULL, "Unable to display view", "System Error",
                   MB_SYSTEMMODAL | MB_ICONHAND | MB_OK);
        return FALSE;
   }

   //lRegen_TermView
   //lRegen_TermView
   return(ReturnCode);
}

LRESULT CALLBACK __export fntoptool2WndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   GETVIEW;
   //lRegen_WindowProcVariables
   //lRegen_WindowProcVariables

   switch(wMessage)
   {
      //lRegen_WndProc
      //lRegen_WndProc

      case WM_INITDIALOG :
         //Regen_WM_INITDIALOG
         //Regen_WM_INITDIALOG
         return TRUE;

      case WM_COMMAND :
         switch(wParam)
         {
            case IDC_BUTTON1 :
               //Regen_IDC_BUTTON1
	       // Clears Target
	       if (bTarget1) fnSetToZero((float *) &Column1);
	       if (bTarget2) fnSetToZero((float *) &Column2);
	       if (bTarget3) fnSetToZero((float *) &Column3);
	       if (bTarget4) fnSetToZero((float *) &Column4);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_IDC_BUTTON1
               break; 

            case IDC_BUTTON2 :
               //Regen_IDC_BUTTON2
	       // Totals Target
	       vwUpdateApp(vwGetView(GetParent(hWnd)));
	       if (bTarget1) fnTotalColumn((float *) &Column1);
	       if (bTarget2) fnTotalColumn((float *) &Column2);
	       if (bTarget3) fnTotalColumn((float *) &Column3);
	       if (bTarget4) fnTotalColumn((float *) &Column4);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_IDC_BUTTON2
               break; 

            case IDC_BUTTON3 :
               //Regen_IDC_BUTTON3
	       // Copies Source over Target
	       vwUpdateApp(vwGetView(GetParent(hWnd)));
	       fnGetSource((float *) &SourceColumn);
	       if (bTarget1) fnCopy((float *) &SourceColumn,(float *) &Column1);
	       if (bTarget2) fnCopy((float *) &SourceColumn,(float *) &Column2);
	       if (bTarget3) fnCopy((float *) &SourceColumn,(float *) &Column3);
	       if (bTarget4) fnCopy((float *) &SourceColumn,(float *) &Column4);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_IDC_BUTTON3
               break; 

            case IDC_BUTTON4 :
               //Regen_IDC_BUTTON4
	       //Adds Source to Target
	       vwUpdateApp(vwGetView(GetParent(hWnd)));
	       fnGetSource((float *) &SourceColumn);
	       if (bTarget1) fnAdd((float *) &SourceColumn,(float *) &Column1);
	       if (bTarget2) fnAdd((float *) &SourceColumn,(float *) &Column2);
	       if (bTarget3) fnAdd((float *) &SourceColumn,(float *) &Column3);
	       if (bTarget4) fnAdd((float *) &SourceColumn,(float *) &Column4);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_IDC_BUTTON4
               break; 

            case IDC_BUTTON5 :
               //Regen_IDC_BUTTON5
	       //Subtracts Source from Target
	       vwUpdateApp(vwGetView(GetParent(hWnd)));
	       fnGetSource((float *) &SourceColumn);
	       if (bTarget1) fnSubtract((float *) &SourceColumn,(float *) &Column1);
	       if (bTarget2) fnSubtract((float *) &SourceColumn,(float *) &Column2);
	       if (bTarget3) fnSubtract((float *) &SourceColumn,(float *) &Column3);
	       if (bTarget4) fnSubtract((float *) &SourceColumn,(float *) &Column4);
	       vwUpdateScreen(vwGetView(GetParent(hWnd)));
               //Regen_IDC_BUTTON5
               break; 

            //lRegen_CustomCommand
            //lRegen_CustomCommand
            }
            break;

   }
   return DefViewProc(hWnd, wMessage, wParam, lParam);
}

LRESULT CALLBACK __export MouseNear(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   GETVIEW;
   GETFIELD;
   switch(wMessage)
   {
      //Regen_MouseNear
      //Regen_MouseNear
      case WM_MOUSEMOVE :
         //Regen_IDC_BUTTON1_WM_MOUSEMOVE
	    switch(Field)
	    {
		case IDC_BUTTON1 :
                  if (hWnd != bBut1) {
		    SetWindowText (vwGetDSLWindow(hViewSpread), "Erase Target Column to Zero.");
		    bBut1= hWnd;
                  }
		  break;
		case IDC_BUTTON2 :
                  if (hWnd != bBut1) {
		    SetWindowText (vwGetDSLWindow(hViewSpread), "Total Target Column.");
		    bBut1=hWnd;
                  }
		  break;
		case IDC_BUTTON3 :
		  if (hWnd != bBut1) {
		    SetWindowText (vwGetDSLWindow(hViewSpread), "Copy Source Column to Target Column.");
		    bBut1=hWnd;
                  }
		  break;
		case IDC_BUTTON4 :
		  if (hWnd != bBut1) {
		    SetWindowText (vwGetDSLWindow(hViewSpread), "Add Source Column to Target Column.");
		    bBut1=hWnd;
                  }
		  break;
		case IDC_BUTTON5 :
		  if (hWnd != bBut1) {
		    SetWindowText (vwGetDSLWindow(hViewSpread), "Subtract Source Column from Target Column.");
		    bBut1=hWnd;
                  }
		  break;
            }

         //Regen_IDC_BUTTON1_WM_MOUSEMOVE
         break;

   }

   return(vwGetDefFieldProc(View, Field)(hWnd, wMessage, wParam, lParam));
}
//Regen_CustomCode

void fnSetToZero(float *fPtrTarget) {
		// Sets Target Array to all zeros

  int loop;

  for (loop=0; loop<=4; loop++)
    fPtrTarget[loop]=0.0;

}

void fnTotalColumn(float *fPtrTarget) {
		// Totals Target Array elements

  int loop;

  fPtrTarget[4]=0.0;
  for (loop=0; loop<=3; loop++)
    fPtrTarget[4]=fPtrTarget[4]+fPtrTarget[loop];

}

void fnGetSource(float *fPtrSource) {
		// Copies Array selected as source into the
                // array SourceColumn

  int loop;

  if (bSource1) {
    for (loop=0; loop<=3; loop++)
      fPtrSource[loop]=Column1[loop];
    fPtrSource[4]=0.0;
  }
  if (bSource2) {
    for (loop=0; loop<=3; loop++)
      fPtrSource[loop]=Column2[loop];
    fPtrSource[4]=0.0;
  }
  if (bSource3) {
    for (loop=0; loop<=3; loop++)
      fPtrSource[loop]=Column3[loop];
    fPtrSource[4]=0.0;
  }
  if (bSource4) {
    for (loop=0; loop<=3; loop++)
      fPtrSource[loop]=Column4[loop];
    fPtrSource[4]=0.0;
  }

}

void fnAdd(float *fPtrSource, float *fPtrTarget) {
		// Adds SourceColumn array into Target array

  int loop;

  for (loop=0; loop<=3; loop++)
    fPtrTarget[loop]=fPtrTarget[loop]+fPtrSource[loop];
  fnTotalColumn( &(*fPtrTarget));
}

void fnSubtract(float *fPtrSource, float *fPtrTarget) {
		// Subtracts SourceColumn array from Target array
  int loop;

  for (loop=0; loop<=3; loop++)
    fPtrTarget[loop]=fPtrTarget[loop]-fPtrSource[loop];
  fnTotalColumn( &(*fPtrTarget));
}

void fnCopy(float *fPtrSource, float *fPtrTarget) {
		// Copies SourceColumn array into Target array

  int loop;

  for (loop=0; loop<=4; loop++)
    fPtrTarget[loop]=fPtrSource[loop];
  fnTotalColumn( &(fPtrTarget));

}
//Regen_CustomCode
