#if !defined (RESOURCEdotH)
#define RESOURCEdotH


#include "file.h"
#include "portable.h"


//*****
//***** Structures used by the Resource class.
//*****

#if defined(__TURBOC__)
  #pragma option -a-
#elif defined(_MSC_VER) || defined(__WATCOM__)
  #pragma pack(1)
#elif defined(__ZTC__)
  #pragma ZTC align 1
#elif defined(__GNUC__)
#else
  #error Insert byte-aligning #pragma here.
#endif

struct FileHeader
{
#if defined(__GNUC__)
  char filename[13] __attribute__ ((aligned (1)));
  biguint fileSize __attribute__ ((aligned (1)));
  biguint fileOffset __attribute__ ((aligned (1)));
#else
  char filename[13];
  biguint fileSize;
  biguint fileOffset;
#endif
};

#if defined(__TURBOC__)
  #pragma option -a.
#elif defined(_MSC_VER) || defined(__WATCOM__)
  #pragma pack()
#elif defined(__ZTC__)
  #pragma ZTC align
#elif defined(__GNUC__)
#else
  #error Insert normal-aligning #pragma here.
#endif


struct FileEntry
{
  struct FileHeader header;
  int addedFlag;
  char *sourceFilename;
  bigint curOff;
  FileEntry *prev, *next;
  FileEntry(char *filename);
  FileEntry(void);
  ~FileEntry(void);
};


//*****
//***** Resource file manipulation class.
//*****

class Resource
{
  File resFile;
  char resFilename[80];
  FileEntry *listBase;
  unsigned short maxFile;
  int changedFlag, numErrors, resExists;
public:
  Resource(void);
  ~Resource(void);
  int open(char *filename);
  void add(char *filename);
  void del(char *filename);
  int extract(char *filename, char *outputPath=NULL);
  void _far *load(char *file, void _far *buf=NULL, biguint numBytes=0,
        bigint startOff=-1);
  int seek(char *filename, bigint offset, int whence);
  int rewind(char *filename)    { return (seek(filename,0,0));        }
  biguint fileSize(char *filename);
  int exists(void)              { return (resExists);                 }
  int status(void)              { return (numErrors); numErrors=0;    }
  int pack(void);
  FileEntry *getFileList(void)  { return (listBase);                  }
private:
  void killFileList(void);
  int appendFile(char *sourceFilename, File *destFile);
  int appendFile(File *sourceFile, biguint bytes, File *destFile);
};


#endif
