ComState        dw      0                       ;
        public  ComResp
ComResp         dw      0                       ;
                ;------ set IRQ mask number ------------------
Mask            db      0feh,0fdh,0fbh,0f7h,0efh,0dfh,0bfh,07fh
ComIrqnum       db      4                       ;
ComBaddr        dw      3F8h                    ;
IrqNum          db      0                       ;
IrqMsk          db      0                       ;
ComIIR          dw      0                       ;
ComIER          dw      0                       ;
ComMCR          dw      0                       ;
ComMSR          dw      0                       ;
ComRBR          dw      0                       ;
ComLSR          dw      0                       ;
ComLCR          dw      0                       ;
;------------------------------------------------
HostLCR         db      0                       ;
HostMCR         db      0                       ;
HostIER         db      0                       ;
HostIIR         db      0                       ;
HostLSB         db      0                       ;
HostMSB         db      0                       ;

debugl          dw      0                       ;
debugh          dw      0                       ;

;------------------------------------------------
comrdbuf        db      COMBUFLENGTH+20 dup(0)   ;
DiscMsg         db      30      dup(0)          ;
ConnMsg         db      50      dup(0)          ;
resprdbuf       db      100     dup(0)          ;
resprdbase      dw      offset resprdbuf        ;
resprdend       dw      offset resprdbuf+100    ;
resprdhead      dw      offset resprdbuf        ;
;------------------------------------------------
comrdbase       dw      offset comrdbuf         ;
comrdend        dw      offset comrdbuf+COMBUFLENGTH
comrdhead       dw      offset comrdbuf         ;
comrdcnt        dw      0                       ;
comrdflag       dw      0                       ;
pageflag        db      0                       ;
;------------------------------------------------
InitStr0        db      'ATL'
SpeakVol        db      '2N'
RingVol         db      '2M1#T0#B0+FCLASS=6',0
AnsStr          db      'ATA',13,10,0
ModeStr1        db      'AT#P'                  ;
ModemDIS        db      21      dup(0)          ;
ModeStr         db      'AT',0
CrLfStr         db      13,10,0                 ;

;***********************************************
;*              InitCom
;*
;*      Initial Communication port
;*
;*      bx - comport number
;*
;***********************************************
public          InitCom
InitCom         proc    near

                mov     ax,cs:ComBaddr          ;RBR
                mov     cs:ComRBR,ax            ;8
                inc     ax                      ;IER
                mov     cs:ComIER,ax            ;9
                inc     ax                      ;IIR
                mov     cs:ComIIR,ax            ;a
                inc     ax                      ;LCR
                mov     cs:ComLCR,ax            ;b
                inc     ax                      ;MCR
                mov     cs:ComMCR,ax            ;c
                inc     ax                      ;LSR
                mov     cs:ComLSR,ax            ;d
                inc     ax                      ;MSR
                mov     cs:ComMSR,ax            ;e
                ;--------------------------------
                xor     bx,bx                   ;
                mov     bl,cs:ComIrqnum         ;
                mov     cs:IrqNum,bl            ;
                add     cs:IrqNum,8             ;
                add     bx,offset cs:Mask       ;
                mov     bl,cs:[bx]              ;
                mov     cs:IrqMsk,bl            ;
                ;---------------------------------
                mov     dx,cs:ComLCR            ;
                in      al,dx                   ;
                mov     cs:HostLCR,al           ;
                and     al,7fh                  ;
                out     dx,al                   ;
                mov     dx,cs:ComMCR            ;
                in      al,dx                   ;
                mov     cs:HostMCR,al           ;
                mov     dx,cs:ComIER            ;
                in      al,dx                   ;
                mov     cs:HostIER,al           ;
                mov     dx,cs:ComIIR            ;
                in      al,dx                   ;
                mov     cs:HostIIR,al           ;
                mov     dx,cs:ComLCR            ;
                in      al,dx                   ;
                or      al,80h                  ;
                out     dx,al                   ;
                mov     dx,cs:ComRBR            ;
                in      al,dx                   ;
                mov     cs:HostLSB,al           ;
                mov     ah,al                   ;
                inc     dx                      ;
                in      al,dx                   ;
                mov     cs:HostMSB,al           ;
                xchg    al,ah                   ;
                cmp     ax,6                    ;
                jle     ?1                      ;
                ;---------------------------------
                call    SetSpeed                ;
                ;-------------------------------------
?1:             mov     dx,cs:ComLCR            ;
                mov     al,03h                  ;set parity ...
                out     dx,al                   ;
                cli                             ;
                push    ds                      ;
                mov     al,cs:IrqNum            ;
                mov     ah,35h                  ;
                int     21h                     ;
                mov     cs:hostcom_o,bx         ;
                mov     cs:[hostcom_o+2],es     ;
                mov     dx,cs                   ;
                mov     ds,dx                   ;
                mov     ah,25h                  ;
                lea     dx,cs:tsrintcom         ;
                int     21h                     ;
                pop     ds                      ;
                sti                             ;
                ;-------------------------------------
                mov     cs:ComState,COMM_IDLE   ;wait for response
                mov     bx,cs:rtcbase           ;
                mov     cs:rtchead,bx           ;
                call    ClearCom                ;
                ret

InitCom         endp


;***********************************************
;*              SetSpeed
;*
;*      Set the UART DTE speed
;*      cx - divisor value
;*
;***********************************************
SetSpeed        proc    near

                mov     dx,cs:ComLCR            ;
                in      al,dx                   ;
                or      al,80h                  ;
                out     dx,al                   ;
                mov     dx,cs:ComRBR            ;
                mov     al,6                    ;19200
                out     dx,al                   ;
                inc     dx                      ;
                xor     al,al                   ;
                out     dx,al                   ;
                ret


SetSpeed        endp


;***********************************************
;*              ClearCom
;*
;*      Clear UART register and enable COM interrupt
;*      bx - 2*comport number
;*
;***********************************************
ClearCom        proc    near

                mov     al,0bh                  ;
                mov     dx,cs:ComMCR            ;
                out     dx,al                   ;
                ;-------------------------------
                mov     dx,cs:ComLCR            ;
                in      al,dx                   ;
                and     al,7fh                  ;
                out     dx,al                   ;
                ;-------------------------------
                mov     dx,cs:ComMSR            ;
                in      al,dx                   ;
                mov     dx,cs:ComLSR            ;
                in      al,dx                   ;
                mov     dx,cs:ComRBR            ;
                in      al,dx                   ;
                ;-------------------------------
                mov     al,09h                  ;enable RBR and MSR interrupt
                mov     dx,cs:ComIER            ;
                out     dx,al                   ;
                ;-------------------------------
                mov     dx,cs:ComIIR            ;
                mov     al,01h                  ;check for 16550
                out     dx,al                   ;
                jmp     ?clear0                 ;
?clear0:        in      al,dx                   ;
                test    al,80h                  ;
                jz      ?clear1                 ;
                mov     al,87h                  ;set FIFO = 8
                out     dx,al                   ;
                jmp     ?clear1                 ;
?clear1:        cli                             ;
                in      al,21h                  ;
                and     al,cs:IrqMsk            ;al=irq maskn
                out     21h,al                  ;
                sti                             ;enable interrupt
                ret

ClearCom        endp


;***********************************************
;*              ResetCom
;*
;*      Clear UART register and enable COM interrupt
;*      bx - 2*comport number
;*
;***********************************************
ResetCom        proc    near

                mov     dx,cs:ComLCR            ;3FB
                in      al,dx                   ;
                mov     bl,al                   ;
                or      ax,0080h                ;
                out     dx,al                   ;
                mov     dx,cs:ComRBR            ;3F8
                mov     al,cs:HostLSB           ;
                out     dx,al                   ;
                inc     dx                      ;
                mov     al,cs:HostMSB           ;
                out     dx,al                   ;
                mov     dx,cs:ComLCR            ;3FB
                in      al,dx                   ;
                and     al,7fh                  ;
                out     dx,al                   ;
                mov     ax,18*3                 ;
                lea     si,cs:ModeStr           ;
                call    SendCmd                 ;
                mov     dx,cs:ComIER            ;3F9
                mov     al,cs:HostIER           ;
                out     dx,al                   ;
                mov     dx,cs:ComMCR            ;3FC
                mov     al,cs:HostMCR           ;
                out     dx,al                   ;
                mov     dx,cs:ComIIR            ;3FA
                mov     al,cs:HostIIR           ;
                xor     al,al                   ;
                out     dx,al                   ;
                mov     dx,cs:ComLCR            ;3FB
                mov     al,cs:HostLCR           ;
                out     dx,al                   ;
                cli                             ;
                push    ds                      ;
                mov     al,cs:IrqNum            ;ah=irq#, al=irq maskn
                lds     dx,dword ptr cs:hostcom_o
                mov     ah,25h                  ;
                int     21h                     ;
                pop     ds                      ;
                sti                             ;

                ret                             ;

ResetCom        endp


;***********************************************
;*              CheckIrq
;*
;*      Initial Communication port
;*
;*      bx - comport number
;*
;***********************************************
CheckIrq        proc    near

                mov     al,cs:IrqNum            ;ah=irq#, al=irq maskn
                mov     ah,35h                  ;
                int     21h                     ;
                cmp     bx,offset cs:tsrintcom  ;
                jnz     checkirq_err            ;
                mov     bx,cs                   ;
                mov     dx,es                   ;
                cmp     bx,dx                   ;
                jz      checkirq_ret            ;
                ;-------------------------------
checkirq_err:   stc                             ;
checkirq_ret:   ret

CheckIrq        endp
public          rtcbase
Rcvrtc          dw      0                       ;
rtcbase         dw      offset rcvrtc_1d        ;
rtchead         dw      offset rcvrtc_1d        ;
hostcom_o       dw      0,0                     ;
rcvrtc_1d       db      00h,08h,80h,00h,08h,80h,00h,08h,80h,0ffh
rcvrtc_2d       db      00h,18h,00h,03h,00h,06h,00h,0ch,80h,01h,30h,00h,0ffh
; **************************************************************************
; *             tsrintcom
; *
; *     A common entry point into the "save the registers and call the right
; *     interrupt service routine".
; *
; *     A little twist:  if it does not appear the interrupt came from a
; *     source we expect, then jump to the old interrupt vector
; **************************************************************************
public          tsrintcom
tsrintcom       proc    far

                .push   ax,bx,dx,ds             ;

                mov     ax,cs                   ;
                mov     ds,ax                   ;
tsrcom_000:     mov     dx,ds:ComIIR            ;3FA, IIR
                in      al,dx                   ;
                test    al,01h                  ;any pending ?
                jnz     tsrcom_001              ;no.
                and     al,06h                  ;
                jz      tsrcom_100              ;MSR interrupt
                cmp     al,04h                  ;
                jnz     tsrcom_001              ;
                jmp     tsrcom_200              ;RBR interrupt
                ;-------------------------------
tsrcom_001:     cmp     ds:ComState,COMM_CONN   ;in the connect state
                jnz     tsrcom_ret              ;
tsrcom_002:    ;mov     ds:PopUpState,POPUP_NONE;
                cmp     ds:comrdcnt,COMBUFLENGTH;buffer full ?
                jb      tsrcom_ret              ;not yet,
                mov     al,09h                  ;yes, low RTS.
                mov     dx,ds:ComMCR            ;MCR
                out     dx,al                   ;RTS low
                mov     ds:PopUpState,POPUP_DISK;
                mov     ds:TsrPopReq,1          ;
tsrcom_ret:     cli                             ;
                mov     al,20h                  ;interrupts on the 8259
                out     20h,al                  ;
                sti                             ;
                .pop    ax,bx,dx,ds             ;
                iret
                ;-------------------------------
                ; MSR
tsrcom_100:     mov     dx,ds:ComMSR            ;
                in      al,dx                   ;
                cmp     ds:ComState,COMM_IDLE   ;in idle state ?
                jz      tsrcom_101              ;yes,
                test    al,80h                  ;DCD on ?
                jnz     tsrcom_104              ;yes.
                mov     ds:ComState,COMM_IDLE   ;
                mov     ds:TsrPopReq,1          ;
                mov     ds:PopUpState,POPUP_DISC;
                jmp     tsrcom_104              ;
tsrcom_101:     test    al,04h                  ;ring int ?
                jz      tsrcom_104              ;no,
                cmp     ds:ComRing,0            ;auto answer ?
                jz      tsrcom_104              ;no,
                cmp     ds:Ringcnt1,0           ;
                jnz     tsrcom_104              ;
                push    cx                      ;
                mov     cx,10                   ;
tsrcom_102:     in      al,dx                   ;
                test    al,40h                  ;RING on ?
                jnz     tsrcom_103              ;no, false alarm.
                loop    tsrcom_102              ;
                mov     ds:Ringtime,0           ;reset ring second timer
                inc     ds:Ringcnt0             ;increase ring counter
                mov     ax,ds:Ringcnt0          ;
                cmp     ax,ds:ComRing           ;up to ring counter ?
                jl      tsrcom_103              ;not yet.
                cmp     ds:TsrPopReq,1          ;already popup req ?
                jz      tsrcom_103              ;yes
                mov     ds:PopUpState,POPUP_ATA ;
                mov     ds:TsrPopReq,1          ;
tsrcom_103:     pop     cx                      ;
tsrcom_104:     jmp     tsrcom_000              ;
                ;-------------------------------
                ; RBR
tsrcom_200:     mov     dx,ds:ComRBR            ;
                in      al,dx                   ;
                cmp     ds:ComState,COMM_CONN   ;in the connect state
                jz      tsrcom_300              ;
                mov     bx,ds:resprdhead        ;
                cmp     al,0ah                  ;
                jnz     tsrcom_201              ;
                cmp     byte ptr [bx-1],0dh     ;
                jnz     tsrcom_201              ;
                dec     bx                      ;
                cmp     bx,ds:resprdbase        ;
                mov     bx,ds:resprdbase        ;yes,
                mov     ds:resprdhead,bx        ;
                jz      tsrcom_203              ;
tsrcom_204:     call    ChkResp                 ;check response
                jl      tsrcom_203              ;
                call    ManResp                 ;manage response
tsrcom_203:     jmp     tsrcom_000              ;
                ;-------------------------------
tsrcom_201:     mov     ds:[bx],al              ;
                inc     bx                      ;no,
                cmp     bx,ds:resprdend         ;to bottom of buffer ?
                jb      tsrcom_202              ;no,
                mov     bx,ds:resprdbase        ;yes,
tsrcom_202:     mov     ds:resprdhead,bx        ;
                sub     bx,ds:resprdbase        ;
                cmp     bx,39                   ;
                jne     tsrcom_203              ;
                cmp     ds:resprdbuf,'/'        ;
                jnz     tsrcom_203              ;
                cmp     ds:[resprdbuf+1],'S'    ;
                jnz     tsrcom_203              ;
                mov     bx,ds:resprdbase        ;
                mov     ds:resprdhead,bx        ;
                jmp     tsrcom_204              ;
                ;-------------------------------
tsrcom_300:     add     ds:debugl,1             ;
                adc     ds:debugh,0             ;
                mov     ds:TimerCom,18*40       ;wait for 60 seconds
                mov     bx,ds:comrdhead         ;
                mov     ds:[bx],al              ;
                inc     bx                      ;no,
                inc     ds:comrdcnt             ;
                mov     ds:comrdhead,bx         ;update the read head ptr.
                ;--------------------------------
                mov     ds:Rcvrtc,0             ;
                mov     bx,ds:rtchead           ;check for the RTC
                cmp     al,ds:[bx]              ;next ?
                jz      tsrcom_301              ;yes,
                mov     bx,ds:rtcbase           ;
                cmp     al,0                    ;first byte ?
                jnz     tsrcom_302              ;no,
tsrcom_301:     inc     bx                      ;yes.
                cmp     byte ptr ds:[bx],0ffh   ;
                jnz     tsrcom_302              ;
                mov     ds:Rcvrtc,1             ;
                inc     ds:head_pages           ;
                mov     bx,ds:rtcbase           ;
tsrcom_302:     mov     ds:rtchead,bx           ;
                jmp     tsrcom_000              ;


tsrintcom       endp


; **************************************************************************
; *             ManResp
; *
; **************************************************************************
ManResp         proc    near

                cmp     ds:ComResp,RESP_RING    ;ring income ?
                jnz     manresp_000             ;no,
                cmp     ds:ComRing,0            ;auto answer ?
                jz      ?mret                   ;no,
                cmp     ds:Ringcnt0,0           ;
                jnz     ?mret                   ;
                mov     ds:Ringtime,0           ;reset ring second timer
                inc     ds:Ringcnt1             ;increase ring counter
                mov     ax,ds:Ringcnt1          ;
                cmp     ax,ds:ComRing           ;up to ring counter ?
                jl      ?mret                   ;not yet.
                cmp     ds:TsrPopReq,1          ;already popup req ?
                jz      ?mret                   ;yes
                mov     ds:PopUpState,POPUP_ATA ;
                mov     ds:TsrPopReq,1          ;
?mret:          ret                             ;
manresp_000:    mov     ds:Ringcnt0,0           ;
                mov     ds:Ringcnt1,0           ;
                cmp     ds:ComResp,RESP_CONNFAX ;connect fax income ?
                jz      manresp_001             ;no,
                cmp     ds:ComResp,RESP_S       ;
                jnz     manresp_002             ;
                sub     bx,11                   ;
manresp_001:    mov     ds:ComState,COMM_CONN   ;yes, connect state
               ;mov     ds:Rcvrtc,0             ;
                mov     ds:comrdcnt,0           ;
                mov     ds:debugl,0             ;
                mov     ds:debugh,0             ;
                mov     ax,ds:comrdbase         ;
                mov     ds:comrdhead,ax         ;
                mov     ds:TimerCom,18*60       ;wait for 60 seconds
                mov     ds:PopUpState,POPUP_OPEN;
                mov     ah,40                   ;
                push    si                      ;
                lea     si,ds:ConnMsg           ;
                jmp     manresp_003             ;
manresp_002:    cmp     ds:ComResp,RESP_DISC    ;disconnect ?
                jnz     manresp_005             ;no
                cmp     byte ptr ds:[bx+10],'1' ;fail ?
                jnz     ?mret                   ;no, success
                cmp     ds:Comrdfh,0            ;
                jg      ?mret                   ;
                mov     ds:PopUpState,POPUP_DISC;
                mov     ah,24                   ;
                push    si                      ;
                lea     si,ds:LogFaxnum         ;
                dec     bx                      ;
manresp_003:    mov     al,ds:[bx+13]           ;move connect fax parameters
                cmp     al,0dh                  ;
                jz      manresp_004             ;
                dec     ah                      ;
                jle     manresp_004             ;
                mov     ds:[si],al              ;
                inc     si                      ;
                inc     bx                      ;
                jmp     manresp_003             ;
manresp_004:    mov     al,' '                  ;
                mov     ds:[si],al              ;
                pop     si                      ;
                mov     al,09h                  ;yes, low RTS.
                mov     dx,ds:ComMCR            ;MCR
                out     dx,al                   ;RTS low
                mov     ds:TsrPopReq,1          ;
                ret                             ;
manresp_005:    cmp     ds:ComResp,RESP_NOCARRIER
                jnz     manresp_ret             ;
                mov     ds:TsrPopReq,1          ;
                mov     ds:PopUpState,POPUP_RESET
                cmp     ds:ComState,COMM_IDLE   ;
                jz      manresp_ret             ;
                mov     ds:ComState,COMM_IDLE   ;
                mov     ds:PopUpState,POPUP_DISC
manresp_ret:    ret                             ;

ManResp         endp

RespData0       db      3,'OK',0dh              ;
RespData1       db      6,'ERROR',0dh           ;
RespData2       db      5,'RING',0dh            ;
RespData3       db      6,'ZyXEL',0dh           ;
RespData4       db      11,'NO CARRIER',0dh     ;
RespData5       db      13,'CONNECT FAX/S'      ;
RespData6       db      10,'DISCONNECT'         ;
RespData7       db      2,'/S'                  ;
RespDataPtr     dw      RespData0,RespData1,RespData2,RespData3,RespData4
                dw      RespData5,RespData6,RespData7
; **************************************************************************
; *             ChkResp
; *
; **************************************************************************
ChkResp         proc    near

                .push   cx,si,di,es             ;
                cld                             ;
                mov     ax,cs                   ;
                mov     es,ax                   ;
                mov     ax,7                    ;
                xor     cx,cx                   ;
                ;-----------------------------
chkresp_000:    mov     si,bx                   ;
                lea     di,ds:RespDataPtr       ;
                add     di,ax                   ;
                add     di,ax                   ;
                mov     di,ds:[di]              ;
                mov     cl,ds:[di]              ;
                inc     di                      ;
                repe    cmpsb                   ;
                jcxz    chkresp_001             ;
                dec     ax                      ;
                jge     chkresp_000             ;
                ;-------------------------------
chkresp_001:    mov     ds:ComResp,ax           ;
                cmp     ax,0                    ;
                .pop    cx,si,di,es             ;
                ret

ChkResp         endp


; **************************************************************************
; *             SendStr
; *
; **************************************************************************
SendStr         proc    near

                sti
sendstr_000:    mov     ah,cs:[si]              ;
                cmp     ah,0                    ;
                clc                             ;
                jz      sendstr_ret             ;
                mov     dx,cs:ComLSR            ;
                mov     cs:TimeTick00,4         ;
sendstr_001:    cmp     cs:TimeTick00,0         ;
                jz      sendstr_err             ;com port error
                in      al,dx                   ;
                and     al,20h                  ;
                jz      sendstr_001             ;
                mov     dx,cs:ComRBR            ;
                mov     al,ah                   ;
                out     dx,al                   ;
                inc     si                      ;
                jmp     sendstr_000             ;
sendstr_err:    stc                             ;
                mov     cs:ErrLvl0,ERR_COMERR   ;
sendstr_ret:    ret                             ;

SendStr         endp

; **************************************************************************
; *             SendCmd
; *
; **************************************************************************
SendCmd         proc    near

                sti
                mov     cs:TimeTick00,4         ;
?s0:            cmp     cs:TimeTick00,0         ;
                jnz     ?s0                     ;
                mov     cs:ComResp,RESP_IDLE    ;
                call    SendStr                 ;
                jc      sendcmd_002             ;
                lea     si,CrLfStr              ;
                call    SendStr                 ;
                jc      sendcmd_002             ;
                mov     cs:TimeTick00,9         ;
sendcmd_000:    cmp     cs:TimeTick00,0         ;
                jz      sendcmd_001             ;
                cmp     cs:ComResp,RESP_IDLE    ;
                jz      sendcmd_000             ;
                cmp     cs:ComResp,RESP_OK      ;
                jz      sendcmd_ret             ;
                mov     cs:ErrLvl0,ERR_NOTZYXEL ;
                jmp     sendcmd_002             ;
sendcmd_001:    mov     cs:ErrLvl0,ERR_COMERR   ;
sendcmd_002:    stc                             ;
                ret                             ;
sendcmd_ret:    mov     cs:TimeTick00,4         ;
?s1:            cmp     cs:TimeTick00,0         ;
                jnz     ?s1                     ;
                clc                             ;
                ret                             ;

SendCmd         endp

