
TsrIn           db      0                       ;
;***************************************************************
;*                                                             *
;* File: tsrargs.inc                                           *
;*                                                             *
;* Process default arguments for ZFAX programs                 *
;*                                                             *
;--------------------------------------------------------------------
MainMsg         db      'ZFAX Version 2.23, Copyright (c) 1990, 1993 '
                db      'ZyXEL Communications Corp.',13,10,10,'$'
ArgHelpMsg      db      'Syntax:  RCVFAX cmdtype [options]',13,10,10
                db      'cmdtype: 0->Background rcvfax, rcvfax 0',13,10
                db      '         1->Answer and rcvfax, rcvfax 1',13,10
                db      '         2->Receive data only, rcvfax 2',13,10
                db      'options:',13,10
                db      '/?       Display this help screen',13,10
                db      '/s       Stop the TSR temporarily',13,10
                db      '/g       Resume the TSR after an /s operation',13,10
                db      '/u       Uninstall the TSR program if possible',13,10
                db      '/p:#     COM port number, 0-3:COM1-COM4',13,10
                db      '/r:#     Answer RING number, 0-manual answer',13,10
                db      '         If r=0, press LeftShift and TAB for manual '
                db      'reception',13,10
                db      '/w:PATH  Receive work sheet PATH',13,10,13,10,'$'
ArgUnMsg        db      'Rcvfax did not be loaded !!',7,13,10,'$'
ArgErrMsg       db      0,' option invalid',7,13,10,'$'
ComErrMsg       db      'COM port not ready !!!',7,13,10,'$'
UnMsg           db      'Uninstall Rcvfax ok !!!',7,13,10,'$'
NotUnMsg        db      'CAN NOT remove Rcvfax, stop it now',7,13,10
                db      'Please use /g option to resume it !!!',7,13,10,'$'
StopMsg         db      'Stop the Rcvfax temporarily',7,13,10
                db      'Please use /g option to resume it !!!',7,13,10,'$'
ResumeMsg       db      'Resume Rcvfax OK !!!',7,13,10,'$'
LowDosMsg       db      'Error: Requires MSDOS/PCDOS 3.0 or above)',7,13,10,'$'
NoPath          db      'Can not find the working path !!!',7,13,10,'$'
HelloMsg        db      'Install Rcvfax ok !!!',7,13,10,'$'
TsrInMsg        db      'Rcvfax has been installed already !!!',7,13,10,'$'
UnInst          db      0                               ;

;***************************************************************
; Default command processor
ChkArg          proc    near


                lea     dx,cs:MainMsg           ;
                mov     ah,9                    ;
                int     21h                     ;
                ;-------------------------------
                ; check if the TSR has been installed
                mov     TsrIn,0                 ;
                mov     ah,TsrSig               ;
                xor     al,al                   ;
                int     2fh                     ;
                cmp     al,'Z'                  ;already installed ?
                jnz     chkarg_start            ;
                mov     TsrIn,1                 ;
                ;-------------------------------
chkarg_start:   xor     cx,cx                   ;
                xor     ax,ax                   ;
                mov     si,80h                  ;
                mov     cl,es:[si]              ;
                inc     cl                      ;
                ;-------------------------------
                ; skip leading white space in command line
skipblank:      dec     cl                      ;
                jz      chkarg_help             ;
                inc     si                      ;
                mov     al,es:[si]              ;
                cmp     al,' '                  ;
                jz      skipblank               ;
                cmp     al,9                    ;
                jz      skipblank               ;
                cmp     al,13                   ;
                jz      skipblank               ;
                cmp     al,10                   ;
                jz      skipblank               ;
                cmp     al,'0'                  ;
                jl      chkarg_help             ;error argument
                cmp     al,'2'                  ;
                jg      chkarg_help             ;error argument.
                sub     al,'0'                  ;
                mov     Arg_func,ax             ;
chkarg_000:     jcxz    chkarg_ret              ;
                ;--------------------------------
chkarg_001:     inc     si                      ;
                mov     al,es:[si]              ;
                dec     cx                      ;
                jz      chkarg_ret              ;
                cmp     al,'/'                  ;
                jz      chkarg_opt              ;options,
                cmp     al,' '                  ;
                jz      chkarg_001              ;
                cmp     al,0dh                  ;
                jz      chkarg_ret              ;
chkarg_help:    lea     dx,ArgHelpMsg           ;
chkarg_msg:     mov     ah,9                    ;
                int     21h                     ;
                mov     Arg_func,-1             ;
chkarg_ret:     ret
                ;--------------------------------
                ; check options
chkarg_opt:     inc     si                      ;
                dec     cx                      ;
                mov     al,es:[si]              ;
                or      al,020h                 ;convert to lower case
                mov     ArgErrMsg,al            ;
                cmp     al,'?'                  ;
                jz      chkarg_help             ;
                cmp     al,'s'                  ;
                jz      chkarg_oper             ;
                cmp     al,'g'                  ;
                jz      chkarg_oper             ;
                cmp     al,'u'                  ;
                jz      chkarg_oper             ;
                cmp     al,'r'                  ;
                jz      chkarg_ring             ;
                cmp     al,'p'                  ;
                jz      chkarg_comport          ;
                cmp     al,'w'                  ;
                jnz     chkarg_000              ;
                lea     dx,cs:ArgErrMsg         ;
                inc     si                      ;
                cmp     byte ptr es:[si],':'    ;
                jnz     chkarg_msg              ;invalid option
                call    ChkDir                  ;
                jc      chkarg_msg              ;
                jmp     chkarg_000              ;
chkarg_oper:    call    ChkOption               ;
                jc      chkarg_msg              ;
                jmp     chkarg_000              ;
                ;-------------------------------
chkarg_comport: mov     ah,'4'                  ;
                lea     bp,cs:ComPort           ;
                jmp     chkarg_cmd              ;
chkarg_ring:    mov     ah,'9'                  ;
                lea     bp,cs:ComRing           ;
chkarg_cmd:     lea     dx,cs:ArgErrMsg         ;
                cmp     byte ptr es:[si+1],':'  ;
                jnz     chkarg_msg              ;invalid option
                add     si,2                    ;
                mov     al,es:[si]              ;
                cmp     al,ah                   ;
                ja      chkarg_msg              ;
                sub     al,'0'                  ;
                jl      chkarg_msg              ;
                xor     ah,ah                   ;
                mov     cs:[bp],ax              ;
                cmp     bp,offset cs:ComPort    ;
                jnz     chkarg_cmd0             ;
                lea     bp,cs:ComAddr           ;
                add     bp,cs:ComPort           ;
                add     bp,cs:ComPort           ;
                mov     bp,cs:[bp]              ;
                cmp     bp,0                    ;
                jz      chkarg_cmd0             ;
                mov     cs:ComBaddr,bp          ;
                lea     bp,cs:IrqAddr           ;
                add     bp,cs:ComPort           ;
                mov     al,cs:[bp]              ;
                mov     ComIrqnum,al            ;
chkarg_cmd0:    sub     cx,2                    ;
                jle     chkarg_ret1             ;
                jmp     chkarg_000              ;end of string
chkarg_ret1:    ret

ChkArg          endp


                ;-------------------------------
ChkDir          proc    near

                mov     cs:Comfpthcnt,0         ;
                lea     bx,cs:Comrdfpth         ;
                lea     di,cs:Logfpth           ;
chkarg_wpath:   inc     si                      ;
                mov     al,es:[si]              ;
                cmp     al,' '                  ;next argument ?
                jz      chkarg_wpath0           ;yes,
                cmp     al,0dh                  ;no, end of string ?
                jz      chkarg_wpath0           ;yes,
                mov     cs:[bx],al              ;
                mov     cs:[di],al              ;
                inc     cs:Comfpthcnt           ;
                inc     di                      ;
                inc     bx                      ;
                dec     cx                      ;
                jnz     chkarg_wpath            ;
chkarg_wpath0:  cmp     cs:Comfpthcnt,0         ;
                jz      chkarg_wpath1           ;
                cmp     byte ptr cs:[bx-1],'\'  ;
                jz      chkarg_wpath1           ;
                mov     byte ptr cs:[bx],'\'    ;
                mov     byte ptr cs:[di],'\'    ;
                inc     cs:Comfpthcnt           ;
                inc     bx                      ;
chkarg_wpath1:  mov     byte ptr cs:[bx],'*'    ;
                mov     byte ptr cs:[bx+1],'.'  ;
                mov     byte ptr cs:[bx+2],'*'  ;
                mov     byte ptr cs:[bx+3],0    ;
                lea     dx,cs:Comrdfpth         ;
                xor     cx,cx                   ;
                mov     ah,4eh                  ;
                int     21h                     ;
                jnc     chkdir_ok               ;
                cmp     ax,03h                  ;
                clc                             ;
                jnz     chkdir_ok               ;
                lea     dx,cs:NoPath            ;
                stc                             ;
chkdir_ok:      ret


ChkDir          endp



ChkOption       proc    near

                ;-------------------------------
                ; operation on option
                lea     dx,cs:ArgErrMsg         ;
                cmp     cs:Arg_func,0           ;
                jnz     chkarg_oper1            ;not TSR, can not support
                lea     dx,ArgUnMsg             ;
                cmp     TsrIn,1                 ;
                jnz     chkarg_oper1            ;not install yet.
                ;--------------------------------
                mov     ah,al                   ;
                mov     al,2                    ;go
                lea     dx,cs:ResumeMsg         ;
                cmp     ah,'g'                  ;
                jz      chkarg_oper0            ;
                lea     dx,cs:StopMsg           ;
                mov     al,3                    ;stop
                cmp     ah,'s'                  ;
                jz      chkarg_oper0            ;
                lea     dx,cs:UnMsg             ;
                mov     al,1                    ;uninstall
chkarg_oper0:   mov     ah,cs:TsrSig            ;
                int     2fh                     ;
                cmp     al,0                    ;
                jz      chkarg_oper1            ;success
                lea     dx,cs:NotUnMsg          ;fail to uninstall
chkarg_oper1:   stc                             ;
                ret

ChkOption       endp

