;***************************************************************
;*              RCVFAX.ASM                                     *
;*                                                             *
;*                                                             *
; * Copyright 1991,1993, ZyXEL Comm. Corp.
;***************************************************************
                ; load macros
include         rmac.inc                        ;macro


; Begin code
_TEXT           segment para public
                assume cs:_TEXT,ds:_TEXT,ss:_TEXT

                org     100h
public          start
start           proc    near
                ; jump to tran sient startup code
                jmp     tsrstart
ZcfgFpth        db      81      dup(0)          ;
start           endp

                ; Include variables
include         rvars.inc

                ; Include interrupt routines
include         rints.inc                       ;
include         comints.inc                     ;communication interrupt
include         rfunc.inc                       ;include main function

; **************************************************************
; *             Go_Popup
; *
; **************************************************************
Go_Popup        proc    near

                inc     cs:TsrPoped             ; mark poped up status
                cli
                mov     cs:HostSS,ss            ; save and switch stack
                mov     cs:HostSP,sp            ;
                mov     ss,cs:TsrSS             ;
                mov     sp,cs:TsrSP             ;
                sti
                .push   ax,bx,cx,dx,si,di,bp,ds,es
                ;-------------------------------
                ; make sure CLD is done
                cld
                ;-------------------------------
                ; save DOS SWAP memory
                mov     ax,cs                   ;
                mov     es,ax                   ;
                mov     ds,ax                   ;
                push    ds                      ;
                lds     si,cs:HostSda           ;
                lea     di,cs:TsrSda            ;
                mov     cx,cs:SdaSafeCnt        ;
                cmp     byte ptr ds:[si+1],0    ;
                jz      pop_000                 ;
                mov     cx,cs:SdaInDosCnt       ;
pop_000:        mov     cs:HostSdaCnt,cx        ;
                rep     movsb                   ;ax = cs
                mov     cx,70h                  ;
                mov     ds,cx                   ;
                mov     cx,100h                 ;
                xor     si,si                   ;
                lea     di,cs:TsrSda1           ;
                rep     movsb                   ;
                pop     ds                      ;
                ;-------------------------------
                ; get and set host crit err, break, and ^C vectors
                STOVECT 1Bh,host1b_o            ;Ctrl-Break
                STOVECT 23h,host23_o            ;Ctrl-C
                STOVECT 24h,host24_o            ;Critical-Error
                SETVECT 1BH,tsrint1b            ;
                SETVECT 23H,tsrint23            ;
                SETVECT 24H,tsrint24            ;
                ;-------------------------------
                ; get tsrpsp
                mov     ah,62h                  ;
                int     21h                     ;
                mov     cs:HostPsp,bx           ;
                ;-------------------------------
                ; set tsrpsp
                mov     bx,cs:Tsrpsp            ;
                mov     ah,50h                  ;
                int     21h                     ;
                ;-------------------------------
                ; get dta
                mov     ah,2fh                  ;
                int     21h                     ;
                mov     cs:HostDtaS,es          ;
                mov     cs:HostDtaO,bx          ;
                ;-------------------------------
                ; set our dta
                push    ds                      ;
                lds     dx,cs:TsrDta            ;
                mov     ah,1ah                  ;
                int     21h                     ;
                pop     ds                      ;
                ;-------------------------------
                call    MainFunc                ;
                ;-------------------------------
                ; reset  vectors
                RESETVECT 1Bh,host1b_o          ;
                RESETVECT 23h,host23_o          ;
                RESETVECT 24h,host24_o          ;
                ;-------------------------------
                ; reset dta
                push    ds                      ;
                lds     dx,cs:HostDta           ;
                mov     ah,1ah                  ;
                int     21h                     ;
                pop     ds                      ;
                ;-------------------------------
                ; reset tsrpsp                  ;
                mov     bx,cs:HostPsp           ;
                mov     ah,50h                  ;
                int     21h                     ;
                ;-------------------------------
                ; reset DOS SWAP memory
                mov     cx,cs:HostSdaCnt        ;
                les     di,cs:HostSda           ;
                lea     si,cs:TsrSda            ;
                rep     movsb                   ;
                mov     cx,70h                  ;
                mov     es,cx                   ;
                mov     cx,100h                 ;
                xor     di,di                   ;
                lea     si,cs:TsrSda1           ;
                rep     movsb                   ;
                ;-------------------------------
                ; either  we are done, or we couldn't pop up
                .pop    ax,bx,cx,dx,si,di,bp,ds,es
                cli                             ;
                mov     ss,cs:HostSS            ;switch stack back
                mov     sp,cs:HostSP            ;
                sti                             ;
                dec     cs:TsrPoped             ;mark done
                ret

Go_Popup        endp

; **************************************************************
; *             KillTsr
; *
; **************************************************************
KillTsr         proc    near

                .push   ax,bx,dx,es             ;
                ;-------------------------------
                ;here's  the killer
                ;check that we are on top, if not goto softkill
                CMPVECT 09h,tsrint09,softkill   ;
                CMPVECT 10h,tsrint10,softkill   ;
                CMPVECT 13h,tsrint13,softkill   ;
                CMPVECT 08h,tsrint1c,softkill   ;
                CMPVECT 21h,tsrint21,softkill   ;
                CMPVECT 25h,tsrint25,softkill   ;
                CMPVECT 26h,tsrint26,softkill   ;
                CMPVECT 28h,tsrint28,softkill   ;
                CMPVECT 2Ah,tsrint2a,softkill   ;
                CMPVECT 2Fh,tsrint2f,softkill   ;
                call    CheckIrq                ;
                jnc     ?k0                     ;
                ;-------------------------------
                ;Soft kill, just set inactive - TSR can be reactivated
                ;later.  Ring bell to inform user
softkill:       mov     cs:TsrStoped,1          ;
                stc                             ;
                jmp     killtsr_ret             ;
                ;-------------------------------
                ;we are on top, ok to hard kill
?k0:            ;reset all vectors
                call    ResetCom                ;
                RESETVECT 09h,host09_o          ;
                RESETVECT 10h,host10_o          ;
                RESETVECT 13h,host13_o          ;
                RESETVECT 08h,host1c_o          ;
                RESETVECT 21h,host21_o          ;
                RESETVECT 25h,host25_o          ;
                RESETVECT 26h,host26_o          ;
                RESETVECT 28h,host28_o          ;
                RESETVECT 2Ah,host2a_o          ;
                RESETVECT 2Fh,host2f_o          ;
                mov     es,cs:Tsrpsp            ;
                ;-------------------------------
                ; If the environment wasn't free'd do it now
                push    es
                mov     es,es:[2ch]             ;get environment segment
                mov     ah,49h                  ;
                int     21h                     ;free it
                pop     es                      ;free us too
                ;-------------------------------
                ; free  TSR's memory block
                mov     ah,49h                  ;
                int     21h                     ;
                clc                             ;
killtsr_ret:    .pop    ax,bx,dx,es             ;
                ret                             ;

KillTsr         endp


                ;----- Local stack --------------
                db      256     dup(0)
                db      ?
Tstack          EQU     $
TsrLastAddr     EQU     $

; ***************************************************************************
; *             Startup Code
; *
; ***********************************************************************
tsrstart:       mov     ax,cs                   ;
                mov     ds,ax                   ;
                mov     cs:ErrLvl0,0            ;reset error level
                ;mov ss will auto disable interrupt for next inst.
                mov     ss,ax                   ;
                lea     sp,cs:Tstack            ;
                ;check DOS version
                mov     ah,30h                  ;
                int     21h                     ;
                cmp     al,3                    ;
                jge     dosok                   ;
                lea     dx,cs:LowDosMsg         ;
                mov     ah,9                    ;
                int     21h                     ;
                ;--------------------------------
                ; use old style exit  -- might even be DOS 1
                ; (no support for INT 21/4C)
                xor     ah,ah                   ;
                int     21h                     ;
                ;--------------------------------
                ; check for DOS 3.0
                ; (if 3.0, we can't restore extended error info)
                ;------ save PSP ---------------
dosok:          mov     Tsrpsp,es               ;
                mov     UnInst,0                ;
                mov     cs:Comfpthcnt,0         ;
                call    ReadConfig              ;read the configuration
                ;--------------------------------
                call    ChkArg                  ;
                ;--------------------------------
                mov     ah,0fh                  ;get the video segment
                int     10h                     ;
                xor     bl,bl                   ;
                add     bx,0b000h               ;
                cmp     al,7                    ;
                jz      rcvstart_0              ;
                add     bx,800h                 ;
rcvstart_0:     mov     TsrVidseg,bx            ;
                ;--------------------------------
                mov     al,1                    ;
                cmp     Arg_func,0              ;
                jge     rcvstart_000            ;
                ;-------------------------------
                ; return
rcvstart_ret:   mov     ah,4ch                  ;
                int     21h                     ;
                ; prevent break/critical errors from interfering
rcvstart_000:   SETVECT 23h,tsrint23            ;
                SETVECT 24h,tsrint24            ;
                cmp     cs:Arg_func,0           ;
                jz      rcvstart_001            ;
                call    Rcvfax                  ;
                jmp     rcvstart_ret            ;
rcvstart_001:   lea     dx,cs:TsrInMsg          ;
                cmp     cs:TsrIn,0              ;already in ?
                jnz     rcvstart_002            ;yes
                mov     MsgPassPos,57*2         ;
                mov     MsgPassAttr,3*16+12     ;
                ;-------------------------------
                ; get and set timer, kb
                STOVECT 09h,host09_o            ;
                STOVECT 08h,host1c_o            ;
                SETVECT 09H,tsrint09            ;
                SETVECT 08H,tsrint1c            ;
                call    InitCom                 ;
                mov     ax,18*3                 ;
                lea     si,cs:ModeStr           ;
                call    SendCmd                 ;
                jnc     rcvstart_003            ;
                call    ResetCom                ;
                RESETVECT 09h,host09_o          ;
                RESETVECT 08h,host1c_o          ;
                lea     dx,cs:ComErrMsg         ;
rcvstart_002:   mov     ah,9                    ;
                int     21h                     ;
                jmp     rcvstart_ret            ;
                ;--------------------------------
                ; Install it !!!
                ; get disk, video, INT 28. MUX vectors
rcvstart_003:   STOVECT 10h,host10_o            ;
                STOVECT 13h,host13_o            ;
                STOVECT 21h,host21_o            ;
                STOVECT 25h,host25_o            ;
                STOVECT 26h,host26_o            ;
                STOVECT 28h,host28_o            ;
                STOVECT 2Ah,host2a_o            ;
                STOVECT 2Fh,host2f_o            ;
                ;-------------------------------
                ; attach timer, kb, disk, video, MUX, INT 28 vectors
                SETVECT 10H,tsrint10            ;
                SETVECT 13H,tsrint13            ;
                SETVECT 21H,tsrint21            ;
                SETVECT 25H,tsrint25            ;
                SETVECT 26H,tsrint26            ;
                SETVECT 28H,tsrint28            ;
                SETVECT 2AH,tsrint2a            ;
                SETVECT 2FH,tsrint2f            ;
                ;-------------------------------
                ; Install TSR
                ; preserve stack for later
                mov     cs:TsrSS,ss             ;
                mov     cs:TsrSP,sp             ;
                ;-------------------------------
                ; get and save dta
                mov     ah,2fh                  ;
                int     21h                     ;
                mov     cs:TsrDtaO,bx           ;
                mov     cs:TsrDtaS,es           ;
                ;-------------------------------
                ; initial DosSwap
                push    ds
                mov     ax,5d06h                ;
                int     21h                     ;
               ;jc
                mov     cs:HostSdaO,si          ;
                mov     cs:HostSdaS,ds          ;
                mov     cs:SdaSafeCnt,dx        ;
                mov     cs:SdaInDosCnt,cx       ;
                pop     ds                      ;
                ;-------------------------------
                ; Free the environment if user asked
                mov     es,cs:Tsrpsp            ;
                mov     es,es:[2CH]             ;get environment segment
                mov     ah,49h                  ;
                int     21h                     ;free it
                ;-------------------------------
                ; Show message to say hello
                lea     dx,HelloMsg             ;
                mov     ah,9                    ;
                int     21h                     ;
                ;-------------------------------
                ; get size
                mov     dx,TsrSize              ;
                or      dx,dx                   ;
                jnz     Go_Tsr                  ;
                ; if size is 0, calculate size
                lea     dx,TsrLastAddr          ;
                shr     dx,1                    ;
                shr     dx,1                    ;
                shr     dx,1                    ;
                shr     dx,1                    ;
                inc     dx                      ;
Go_Tsr:         mov     ax,3100h                ;
                int     21h                     ; TSR


; **************************************************************************
; *             Rcvfax
; *     ax : 1 - rcvfax with send "ata" command
; *          2 - rcv data only
; *
; **************************************************************************
public          Rcvfax
Rcvfax          proc    near

                mov     cs:Rcvrtc,1             ;
                cmp     cs:ComState,COMM_IDLE   ;
                mov     cs:TsrStoped,1          ;
                ;-------------------------------
                ; get and set timer, kb
                STOVECT 09h,host09_o            ;
                STOVECT 08h,host1c_o            ;
                SETVECT 09H,tsrint09            ;
                SETVECT 08H,tsrint1c            ;
                call    CreatMsgWin             ;
                mov     cs:TimeTick00,9         ;
?s4:            cmp     cs:TimeTick00,0         ;
                jnz     ?s4                     ;
                call    InitCom                 ;
                mov     cs:TimeTick00,9         ;
?s5:            cmp     cs:TimeTick00,0         ;
                jnz     ?s5                     ;
                ;-------------------------------
                mov     cs:TimeTick00,18*6      ;
                cmp     cs:Arg_func,2           ;
                jz      rcvfax_000              ;
                mov     cs:TsrPopReq,0          ;
                mov     cs:PopUpState,POPUP_ATA ;send "ATA"
                call    MainFunc                ;
                jc      rcvfax_j006             ;
                mov     cs:TimeTick00,18*60     ;
rcvfax_000:     cmp     cs:TimeTick00,0         ;
                jz      rcvfax_003              ;
                cmp     cs:EscPress0,0          ;ESC be pressed
                jnz     rcvfax_005              ;
                cmp     cs:ComResp,RESP_NOCARRIER
                jz      rcvfax_004              ;
                call    Send_DC2                ;
                cmp     cs:ComState,COMM_CONN   ;
                jnz     rcvfax_000              ;
                ;-------------------------------
rcvfax_001:     cmp     cs:TimerCom,0           ;
                jz      rcvfax_003              ;
                cmp     cs:EscPress0,0          ;ESC be pressed
                jnz     rcvfax_005              ;
                call    Send_DC2                ;
                cmp     cs:ComState,COMM_CONN   ;
                jnz     rcvfax_002              ;
                mov     dx,cs:ComMSR            ;
                in      al,dx                   ;
                test    al,80h                  ;DCD on ?
                jz      rcvfax_008              ;
                call    _Putbytes               ;
rcvfax_002:     cmp     cs:TsrPopReq,1          ;
                jnz     rcvfax_007              ;
                mov     cs:TsrPopReq,0          ;
                call    MainFunc                ;
                call    PutConMsg               ;
rcvfax_007:     cmp     cs:ComState,COMM_IDLE   ;
                jnz     rcvfax_001              ;
rcvfax_j006:    jmp     rcvfax_006              ;
rcvfax_004:     mov     cs:ErrLvl0,ERR_FAIL     ;respond "NO CARRIER"
                jmp     rcvfax_006              ;
rcvfax_003:     mov     cs:ErrLvl0,ERR_COMERR   ;timer out
                jmp     rcvfax_008              ;
rcvfax_005:     mov     cs:ErrLvl0,ERR_USRABT   ;
rcvfax_008:     mov     cs:PopUpState,POPUP_DISC;
                call    MainFunc                ;
rcvfax_006:     call    ResetCom                ;
                RESETVECT 09h,host09_o          ;
                RESETVECT 08h,host1c_o          ;
                call    CloseMsgWin             ;
                mov     ax,cs:ErrLvl0           ;
                ret                             ;

Rcvfax          endp

; **************************************************************************
;
; **************************************************************************
Send_DC2        proc    near

                cmp     cs:Arg_func,1           ;
                jz      sdc2_ret                ;
                cmp     cs:Rcvrtc,1             ;
                jnz     sdc2_ret                ;
                mov     dx,cs:ComLSR            ;
                in      al,dx                   ;
                test    al,20h                  ;
                jz      sdc2_ret                ;
                mov     al,DC2                  ;
                mov     dx,cs:ComRBR            ;
                out     dx,al                   ;
sdc2_ret:       ret

Send_DC2        endp

IrqAddr         db      4,3,4,3,5,2             ;IRQ 4
userirq         db      0                       ;
ComAddr         dw      03F8h,02F8h,03E8h,02E8h,3E8h,2E8h
userioaddr      dw      0                       ;
; **************************************************************************
;
; **************************************************************************
ReadConfig      proc    near

                lea     dx,ZcfgFpth             ;
                mov     ax,3d00h                ;
                int     21h                     ;
                jc      readcfg_ret             ;
                mov     bx,ax                   ;
                mov     cx,CFGLEN1              ;
                lea     dx,WorkFpth             ;
                mov     ah,3fh                  ;
                int     21h                     ;
                mov     ah,3eh                  ;
                int     21h                     ;
                ;------ read the COM port -------
                mov     ax,UserIO               ;
                mov     userioaddr,ax           ;
                mov     al,UserIrq              ;
                mov     userirq,al              ;
                mov     ax,com_baddr            ;
                mov     ComBaddr,ax             ;
                mov     al,com_irqnum           ;
                mov     ComIrqnum,al            ;
                ;--------------------------------
                mov     cx,65                   ;
                lea     si,RcvFpth              ;
                lea     bx,cs:Comrdfpth         ;
                lea     di,cs:Logfpth           ;
readcfg_000:    mov     al,es:[si]              ;
                mov     cs:[bx],al              ;
                mov     cs:[di],al              ;
                cmp     al,0                    ;next argument ?
                jz      readcfg_001             ;yes,
                inc     cs:Comfpthcnt           ;
                inc     si                      ;
                inc     di                      ;
                inc     bx                      ;
                dec     cx                      ;
                jnz     readcfg_000             ;
readcfg_001:    cmp     cs:Comfpthcnt,0         ;
                jz      readcfg_002             ;
                cmp     byte ptr cs:[bx-1],'\'  ;
                jz      readcfg_002             ;
                mov     byte ptr cs:[bx],'\'    ;
                mov     byte ptr cs:[di],'\'    ;
                inc     cs:Comfpthcnt           ;
readcfg_002:    lea     si,ZlogFpth             ;
                lea     di,ZlogFpth0            ;
                mov     cx,80                   ;
                rep     movsb                   ;
                lea     si,FaxDIS               ;
                lea     di,ModemDIS             ;
                mov     cx,20                   ;
                rep     movsb                   ;
readcfg_ret:    ret

ReadConfig      endp

                ; Include interrupt routines
include         zcfg.inc                        ;
include         rargs.inc                       ;
include         rvideo.inc                      ;

public          TsrMsgAddr
TsrMsgAddr      EQU     $



_TEXT           ends


                end     start

