
CFGFPTR         equ     0e100h
;CFGLENBYTES     equ     1359+82
;CFGLEN          equ     CFGLENBYTES/2
;CFGLEN0         equ     CFGLENBYTES-128-82

;-----------------------------------------------
; Keyboard definitions
ALT     equ     8                               ;
CTRL    equ     4                               ;
LSHIFT  equ     2                               ;
RSHIFT  equ     1                               ;
;
;****** Total = 32+166+207+494+251 = 1150 *********************
;
        public  text_country,comp_ftype,dest_psize,dest_res,dest_scheme
;       public  prn_type,prn_port,text_margin,text_insvcnt,text_inshcnt
;       public  text_max_line,text_type,GraphType,DsplyType,com_baddr
;       public  com_volume,com_irqnum,com_timer,TonePulse,UserIrq,UserIO
;       ;---------------------------------------------------------------
;       public  eng_hbits,eng_vbits,eng_fpth,video_fpth
;       ;---------------------------------------------------------------
;       public  FaxID,FaxDIS,InitStr,EndStr
;       ;---------------------------------------------------------------
;       public  chf_std_hbits,chf_std_vbits,chf_asc_hbits
;       public  chf_asc_vbits,chf_asc_fpth,chf_spc_fpth,chf_sup_fpth
;       public  chf_min_fpth,chf_kai_fpth,chf_li_fpth
;       ;---------------------------------------------------------------
;       public  TsrVidseg,Msg_WinPos,Msg_WinShadow,Msg_WinAttr,SoundOn
;       public  MsgOff,MmnuAttr,MmnuAttr0,LightAttr,MsgAttr,SmnuAttr
;       public  SmnuAttr0,CenAttr,ShdAttr
;       ;---------------------------------------------------------------
;       public  WorkFpth,ChFpth,SourStr,DestStr
;       ;---------------------------------------------------------------
;;      public  func_type,ConnMin,ConnSec,ConnSpeed,ConnPage,ConnCode,ConnRes
;       ;---------------------------------------------------------------
;       public  head_buf,BkPatPos,BkPatSize
                ;------ 32 bytes ---------------
WorkFpth        db      70      dup(0)          ;work sheet path
text_country    dw      -1                      ;country code
comp_ftype      dw      0                       ;destination file format
dest_psize      dw      0                       ;page size
dest_res        dw      1                       ;resolution
dest_scheme     dw      0                       ;coding scheme
prn_type        dw      3                       ;printer type
prn_port        dw      0                       ;print port
text_margin     dw      10                      ;text left margin
text_insvcnt    dw      4                       ;text vert insert bits
text_inshcnt    dw      2                       ;text hori insert bits
text_max_line   dw      60                      ;text max lines per page
text_type       dw      0                       ;text type
GraphType       db      0                       ;graph driver type
DsplyType       db      0                       ;
com_baddr       dw      3F8h                    ;com port base address*
com_volume      db      4                       ;speaker volume*
com_irqnum      db      4                       ;com irq number*
com_timer       db      128                     ;dial timer
TonePulse       db      0                       ;dial type
                ;------ 166 bytes --------------
eng_hbits       dw      16                      ;english font hbits
eng_vbits       dw      28                      ;english font vbits
eng_fpth        db      'zfax.fon',0            ;english font path
                db      72      dup(0)
VfontFpth       db      'zview.fon',0           ;video font path
                db      71      dup(0)
                ;------ 207 bytes --------------
FaxID           db      25      dup(0)          ;fax id on the head*
FaxDIS          db      20      dup(0)          ;fax dis sent to remote*
InitStr         db      'at',0                  ;initial string before dialing
                db      78      dup(0)
EndStr          db      'at&f',0                ;ending string after connection
                db      76      dup(0)
                ;------ 575 bytes --------------
chf_std_hbits   dw      24                      ;font size, horizontal bits
chf_std_vbits   dw      24                      ;font size, vertical bits
chf_asc_hbits   dw      12                      ;font size, horizontal bits
chf_asc_vbits   dw      24                      ;font size, vertical bits
chf_asc_fpth    db      81      dup(0)          ;ascii font for chinese font
chf_spc_fpth    db      81      dup(0)          ;spc font for chinese font
chf_sup_fpth    db      81      dup(0)          ;
chf_usr_fpth    db      81      dup(0)          ;
chf_min_fpth    db      81      dup(0)          ;min font for chinese font
chf_kai_fpth    db      81      dup(0)          ;kai font for chinese font
chf_li_fpth     db      81      dup(0)          ;li font for chinese font
                ;------ 251 bytes ---------------
SourStr         db      81      dup(0)          ;
DestStr         db      81      dup(0)          ;
SfaxNum         db      81      dup(0)                  ;
func_type       dw      0                       ;
Msg_WinPos      dw      0                       ;Y-AXIS offset, X-AXIS offset
Msg_WinShadow   db      1                       ;with shadow
Msg_WinAttr     db      0                       ;window color
SoundOn         db      0                       ;sound effect
MsgOff1         db      0                       ;show the proceeding message
                ;------ 128 bytes --------------
logbuf_year     dw      0                       ;
logbuf_date     dw      0                       ;
logbuf_time     dw      0                       ;
ConnMin         db      0                       ;connect minutes
ConnSec         db      0                       ;connect seconds
ConnSpeed       db      0                       ;2400, 4800, 7200, 9600, 12000,
                                                ;14400.
ConnPage        db      0                       ;A4, B4, A3
ConnCode        db      0                       ;1-DN, 1-DH, 2-DN, 2-DH.
ConnDir         db      0                       ;0-Tranmit, 1-Receive
ErrLvl          dw      0                       ;
logbuf_fname    db      80      dup(0)          ;
logbuf_faxnum   db      25      dup(0)          ;
logbuf_mark     db      7       dup(0)          ;
RecordTimer     db      10                      ;
AutoPrint       db      0                       ;
                ;------ 1240 bytes -------------
ZfaxFpth        db      'zfax.com',0            ;central control program
                db      72      dup(0)          ;
ZtmpFpth        db      'zfax.tmp',0            ;temperal file
                db      72      dup(0)          ;
ZallFpth        db      'zfax.zd1',0            ;send, print, cnvt fax
                db      72      dup(0)          ;
ZvoiceFpth      db      'zfax.zd2',0            ;rcv fax, voice
                db      72      dup(0)          ;
ZfigFpth        db      'zfax.zd3',0            ;configuration
                db      72      dup(0)          ;
ZphbFpth        db      'zphbook.dbf',0         ;phone book
                db      69      dup(0)          ;
ZlogFpth        db      'zfax.log',0            ;transaction log
                db      72      dup(0)          ;
ZschFpth        db      'zfax.sch',0            ;schedule
                db      72      dup(0)          ;
ZansFpth        db      'zvoice.log',0          ;answering machine log file
                db      70      dup(0)          ;
ZgreetFpth      db      81      dup(0)          ;greeting message file
EditFpth0       db      0,'/c '                 ;
EditFpth        db      128     dup(0)          ;
ChFpth          db      70      dup(0)          ;chinese font path
RcvFpth         db      70      dup(0)          ;receive fax path
VoiceRcvFpth    db      70      dup(0)          ;receive voice path
com_port        dw      0                       ;
UserIO          dw      3f8h                    ;
UserIrq         db      4                       ;
HotScan         db      39H                     ;TAB
ShiftMsk        db      ALT                     ;
RingCount       db      0                       ;
RetryCount      db      5                       ;
RetryTimer      db      0                       ;
VoiceComp       db      1                       ;voice compression scheme
VoiceAns        db      0                       ;
VoicePass       db      5       dup(0)          ;voice remote replay password
FaxPass         db      4       dup(0)          ;voice remote replay password
ImgBit          db      0                       ;
FuncType        db      0                       ;
;-----------------------------------------------
; Keyboard definitions
TimeTick0       dw      0                       ;
Msg_StusPos     dw      0                       ;
EscPress        db      0                       ;
ChkScanKey      db      0                       ;
InstCfg         db      0                       ;
;--------- 158 bytes --------------------
zcap_enable     dw      0                       ;
send_imm        dw      0                       ;
cap_prnport     dw      0                       ;
ZcapDirCnt      dw      0                       ;
ZcapTimer       db      2                       ;default 2 seconds
ZcapFpth        db      70 dup(0)               ;
public          HotScan2,ShiftMsk2,ChkScanKey2
HotScan2        db      2Ch                     ;
ShiftMsk2       db      ALT + CTRL              ;
ChkScanKey2     db      0                       ;

public          EndofCfg
EndofCfg        db      0                       ;

CFGLEN1         equ     offset EndofCfg - offset WorkFpth
