'
'  ߿
'                                                                          
'                                                     
'     ߱                               ߱                   
'                          
'       ߱  ߱       ߱    
'     ߱             ߱     
'             ߱             ߱  ߱   
'                 
'                            
'                                                                          
'                                                                          
'  
'    
'
'
'  A QuickBASIC 4.5 program which can be run -inside the QuickBASIC
'  Interpreter supplied as part of MS-DOS 5.0 (and up) using the command:
'
'  QBASIC /RUN READ.BAS
'
'  Or by running the batch file included with this file set called:
'
'  RUN.BAT
'
'  Or compiled to a stand-alone executable file of some 45 K.
'
'  This is a file for my fellow junior propeller hat wearers who want to
'  see how to do this.
'
'  The concept was taken from John Clark Craig's book "QuickBASIC
'  Programmer's ToolBox," 1988 and several programs from Ethan Winer of
'  Crescent Software
'
'  The original -executable- program was uploaded to CompuServe on July
'  26, 1993 as 2READ.EXE. Contains "READ.COM" and one of my smarmy text
'  files about this program.
'
'  That file set did NOT include the source code (this is it!) as
'  "READ.COM" was compiled with Crescent Software's PDQ library to give
'  an eight (8) K executable program; so you couldn't run the source code
'  with QBASIC.EXE alone...
'
'  Should have figured that some one of the "De Palma Inadvertent and
'  Accidental Beta Testers" would have complained (they did) that I
'  didn't upload the source code (this is it!), so THIS IS IT!
'
'  ͸
'                       ****  ATTENTION ****                          
'                                                                     
'                                                                     
'     IF YOU ARE USING THE QBASIC INTERPRETER THAT COMES WITH         
'     MS-DOS 5.0 (and up) and you use the command:                    
'                                                                     
'     QBASIC /RUN READ.BAS                                            
'                                                                     
'     to run this program inside the interpreter, the program will    
'     halt with the QuickBASIC ERROR Message "Advanced Feature        
'     Unavailable."                                                   
'                                                                     
'     What that means is that the QuickBASIC interpreter does not     
'     have the COMMAND$ statement as part of of its internal keyword  
'     list. The program will stop at that line.                       
'                                                                     
'     So all you will have to do is put a comment (') on that         
'     line and remove the comments from the next two (2) program      
'     lines which start with:                                         
'                                                                     
'     "LINE INPUT."                                                   
'     "FileName$="                                                    
'                                                                     
'  ;
'
'
'                       Sat  07-31-1993  10:37:26
'
'                 John De Palma on CompuServe 76076,571
'
' PARAMETERS:      filename.ext  Name of file to view
'                  /n            No Brag box switch

DEFINT A-Z                       'integers take less memory

' Constants

CONST FALSE = 0
CONST True = -1                  'for EOF() of greater than 2000 lines

' Key code numbers, use CVI function, great idea!
' Run KEY.BAS to see how this works

CONST UPARROW = 18432
CONST DOWNARROW = 20480
CONST PGUP = 18688
CONST PGDN = 20736
CONST HOME = 18176
CONST ENDKEY = 20224
CONST ESCAPE = 27


' Functions
DECLARE FUNCTION KeyCode% ()

' Subprograms

DECLARE SUB FileRead (FileName$, lineCount%, f$())
DECLARE SUB ParseWords (FileName$, Drive$, File$, Ext$)
DECLARE SUB BragScreen ()
DECLARE SUB monitor (fgd%, bkgd%, invfgd%, invbkgd%)

' Dimension string array to hold the file, 2000 lines!

DIM f$(1 TO 2000)

' Screen zero, the text screen

SCREEN 0
CLS

' Get the command line parameters, in upper case!

FileName$ = UCASE$(COMMAND$)

' If using QBASIC.EXE INTERPRETER add comment to above
' COMMAND$ statement and REMOVE the comments from the next
' two (2) commands.

'LINE INPUT "Enter the FileName & Extension; "; FileName$
'FileName$ = UCASE$(FileName$)

IF FileName$ = "" THEN GOTO ErrorTrap         'small errortrap

' parse a long full path name to 15 characters to fit on line one

CALL ParseWords(FileName$, Drive$, File$, Ext$)

' Interesting, QB Interpreter converts the COMMAND$ to upper case,
' but NOT with an executable file, need to use UCASE$ for file name.

' prevents the brag screen and removes that switch from the file name
 
Yes = INSTR(FileName$, "/N")
IF Yes THEN                                   'if there is a /n switch
        NoBragFlag% = True
        FileName$ = LEFT$(FileName$, Yes - 1)
END IF

'read the file

CALL FileRead(FileName$, lineCount%, f$())


' Check for monochrome monitor, if true set colors for monochrome

CALL monitor(fgd, bkgd, invfgd, invbkgd)

CLS

'turn off cursor

LOCATE , , 0

'Set line pointer

linePtr% = 1


' Main loop
DO

' Print information bar at top

COLOR invfgd, invbkgd
LOCATE 1, 1
PRINT " Line:" + LEFT$(STR$(linePtr%) + SPACE$(6), 7);
PRINT "File: " + LEFT$(Drive$ + File$ + Ext$ + SPACE$(19), 19);
PRINT "Quit: {Esc}" + SPACE$(1);
PRINT "Move: " + CHR$(24) + " " + CHR$(25) + "  PgUp PgDn Home End "

' Print the text 24 lines at a time from line 2 to 25, the array f$() starts
' at 1; the LOCATE statement starts at row 2

COLOR fgd, bkgd
        FOR i% = 0 TO 23
                LOCATE i% + 2, 1
                PRINT LEFT$(f$(i% + linePtr%) + SPACE$(80), 80);
        NEXT i%

' Wait for a key press

SELECT CASE KeyCode%
       
        CASE UPARROW
            IF linePtr% > 1 THEN
                linePtr% = linePtr% - 1
            END IF
        CASE DOWNARROW
            IF linePtr% < lineCount% THEN
                linePtr% = linePtr% + 1
            END IF
        CASE PGUP
            IF linePtr% > 1 THEN
                linePtr% = linePtr% - 24
                IF linePtr% < 1 THEN
                    linePtr% = 1
                END IF
            END IF
        CASE PGDN
            IF linePtr% < lineCount% - 24 THEN
                linePtr% = linePtr% + 24
                IF linePtr% > lineCount% THEN
                    linePtr% = lineCount%
                END IF
            END IF
        CASE HOME
            IF linePtr% > 1 THEN
                linePtr% = 1
            END IF
        CASE ENDKEY
            IF linePtr% < lineCount% - 24 THEN
                linePtr% = lineCount% - 24
            END IF
        CASE ESCAPE
            quitFlag% = True
        CASE ELSE
            updateFlag% = FALSE
        END SELECT
      
    LOOP UNTIL quitFlag%

'turn the cursor on
LOCATE , , 1

IF NoBragFlag% THEN END
CALL BragScreen
    
END
  
'FileError:

ErrorTrap:
PRINT
PRINT "Type: READ Filename.Ext"
BEEP
END

SUB BragScreen
PRINT "    ͸"
PRINT "         PROGRAM BY: John R. De Palma on CompuServe 76076,571     "
PRINT "    ;"

END SUB

SUB FileRead (FileName$, lineCount%, f$()) STATIC
        FileNumber% = FREEFILE
        OPEN FileName$ FOR INPUT AS FileNumber%
        FOR i% = LBOUND(f$) TO UBOUND(f$)

                LINE INPUT #FileNumber%, f$(i%)
                lineCount% = i%
                        IF EOF(FileNumber%) THEN
                        EXIT FOR
                        END IF
        NEXT i%
        IF NOT EOF(FileNumber%) THEN    'if file greater than 2000 lines
                lineCount% = True       'set EOF to -1 to avoid error
               
        END IF
END SUB

FUNCTION KeyCode% STATIC
        DO
            k$ = INKEY$
        LOOP UNTIL k$ <> ""
        KeyCode% = CVI(k$ + CHR$(0))
END FUNCTION

SUB monitor (fgd, bkgd, invfgd, invbkgd)
DEF SEG = 0
IF PEEK(&H463) = &HB4 THEN        'PEEK to See Type of Monitor
        DEF SEG = &HB000          'MonoChrome Monitor(Memory Location)
        fgd = 7                   'white
        bkgd = 0                  'black
        invfgd = 0                'inverse
        invbkg = 7                'inverse
        ELSE
        fgd = 7
        bkgd = 1
        invfgd = 0
        invbkgd = 3
        DEF SEG = &HB800          'Color Monitor(Memory Location)
END IF

END SUB

'this is clumsy, but it seems a fair way to parse a long full path
'to show a file name
SUB ParseWords (FileName$, Drive$, File$, Ext$) STATIC

ln = LEN(FileName$)

' first get the drive

colon = INSTR(FileName$, ":")
IF colon THEN
        Drive$ = LEFT$(FileName$, colon)
END IF

' next erase a final backslash if it exists

IF RIGHT$(FileName$, 1) = "\" THEN
        temp$ = LEFT$(FileName$, ln - 1)
        ln = ln - 1
        ELSE
        temp$ = FileName$
END IF

' third get the Extension

FOR n = ln TO 1 STEP -1

        Ext$ = MID$(temp$, n)
        IF INSTR(Ext$, ".") THEN
        Ext$ = LEFT$(Ext$, 4)
        temp$ = LEFT$(temp$, n - 1)
        k = n
        EXIT FOR
        ELSE
        Ext$ = ""
        k = ln           'if there is no extension
        END IF
NEXT n

'fourth get the file name but not more than 8 letters...

FOR n = k TO 1 STEP -1
         File$ = MID$(temp$, n)
         IF INSTR(File$, "\") THEN
                 EXIT FOR
         ELSE
                File$ = MID$(temp$, n)
                IF LEN(File$) >= 8 THEN EXIT FOR
         END IF
NEXT n

'fifth add a backslash to the file name

IF INSTR(File$, "\") = 0 THEN
File$ = "\" + File$
END IF

END SUB

