{************************************************************************}
{************************************************************************}
{* Modul:	adansi.pas						*}
{************************************************************************}
{* Inhalt:	Farbige Ausgabe ber ANSI-Treiber			*}
{************************************************************************}
{* Funktion:	Detektierung des ANSI-Treibers wenn STdOut nicht	*}
{*		umgeleitet ist und farbige Ausgabe des Direktories.	*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	10.Jan.1994						*}
{* Vernderung:	Korrektur der Speicherverwaltung.			*}
{************************************************************************}
{* Revision:	0.02 Erste Version (zu ADIR 0.22)			*}
{* 		0.04 Verbesserung der Farbausgabe ber Konfigurations-	*}
{*		     dateien welche mittels Enviroment-Variablen ADIRCOL*}
{*		     eingestellt werden kann.				*}
{*		     Integration der gepackten Dateien als eigener	*}
{*		     Datei-Typ						*}
{*		0.10 Integration des Datenbank-Formats als eigener	*}
{*		     Datei-Typ						*}
{*		0.12 Integration des Text-Formats als eigener Datei-Typ	*}
{*		     Anpassung der Ausgabe auf Suche in Unterverz.	*}
{*		0.14 Minutenangabe fr lngere Sound-Samples.		*}
{*		0.20 Verbesserung der /P-Option im Zusammenspiel mit /S	*}
{*		0.22 Korrektur der Zeilenzhlung bei der Pausen-Funktion*}
{*		     Korrektur der Verzeichnis-Gren-Ausgabe.		*}
{*		0.24 Erweiterung des National-Language Supports durch	*}
{*		     Ausgabe der Texte in Benutzersprache.		*}
{*		     Erweiterung der Ausgabe um Volume-Namen.		*}
{************************************************************************}
{* Routinen:	ReadKey6	(lokal)					*}
{*              AnsiTest	(lokal)					*}
{*		AnsiDetect						*}
{*		AnsiLoad	(lokal)					*}
{*		AnsiPrint						*}
{************************************************************************}

unit ADAnsi;
{$I-,S-}
{$M 8192,8192,655360}

interface
uses dos,crt,NLS,adsort,adstring;

Type     AnsiTyp   = record
                        NamCol : String[10];
                        ExtCol : String[10];
                        SizCol : String[10];
                        DatCol : String[10];
                        TimCol : String[10];
                        KurCol : String[10];
                        Ex1Col : String[10];
                        Ex2Col : String[10];
                        Ex3Col : String[10];
                     end;

Const    AnsiStr   : Array[0..6] of AnsiTyp =
                       ((NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;37;44m';
                         Ex2Col:#$1B'[1;37;44m';
                         Ex3Col:#$1B'[1;37;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'));

Var      Pause     : Boolean;
         PrntB     : Boolean;
         PrntW     : Boolean;
         Path      : PathStr;
         VolNam    : String;
         VolChar   : Char;
         Lines     : Integer;
         Error     : Text;
         Reg       : Registers;
         AF        : File of AnsiTyp;
	 UDirS     : Boolean;
         UDirF     : Boolean;

Function AnsiDetect:Boolean;
Procedure AnsiPrint;

implementation

{************************************************************************}
{* Routine:	ReadKey6						*}
{************************************************************************}
{* Inhalt:	Implementation eines ReadKey's ber DOS-Funktion 6.	*}
{* Definition:	Procedure ReadKey6(Var c:Char;Var P:Boolean)            *}
{* Parameter:	c	- Ausgabe-Character				*}
{*		P	- Key not Pressed-Information			*}
{************************************************************************}

Procedure ReadKey6(Var c:Char;Var P:Boolean);
begin
   Reg.AX:=$0600;
   Reg.DL:=$ff;
   MsDos(Reg);
   c:=char(Reg.AL);
   P:=(Reg.Flags and FZero)=FZero;  
end;

{************************************************************************}
{* Routine:	AnsiTest						*}
{************************************************************************}
{* Inhalt:	Feststellung ob ANSI-Treiber geladen ist ber die       *}
{*		"ESC [ 6n"-Sequenz.					*}
{* Definition:	Function AnsiTest:Boolean				*}
{* Rckwert:	ANSI-Treiber gefunden					*}
{************************************************************************}

Function AnsiTest:Boolean;
Var T:Array[0..9] of Char;
    L:Array[0..9] of Boolean;
    i: Integer;
begin
   Write(chr($1B),'[6n');
   Write(chr($08),chr($08),chr($08),chr($08));
   for i:=0 to 9 do begin
     ReadKey6(T[i],L[i]);
   end;
   if (L[0]) then AnsiTest:=False
   else AnsiTest:=((T[0]=chr($1B)) and (T[1]='['));
end;

{************************************************************************}
{* Routine:	AnsiDetect						*}
{************************************************************************}
{* Inhalt:	berprfung ob StdOut umgeleitet wurde und ein ANSI-	*}
{*		Treiber geladen wurde.					*}
{* Definition:	Function AnsiDetect:Boolean;				*}
{* Rckwert:	ANSI-Treiber gefunden und StdOut nicht umgeleitet.	*}
{************************************************************************}

Function AnsiDetect:Boolean;
Var Ansi: Boolean;
begin
   Reg.AX:=$4400;
   Reg.BX:=1;
   MsDos(Reg);
   if (Reg.DX and $0083)=$0083 then begin
     Reg.AX:=$1A00;
     Intr($2f,Reg);
     if (Reg.AL=$FF) then Ansi:=True
     else Ansi:=AnsiTest;
   end
   else Ansi:=False;
   AnsiDetect:=Ansi;
end;

{************************************************************************}
{* Routine:	AnsiLoad						*}
{************************************************************************}
{* Inhalt:	Ldt die mittels Enviroment-Variable "ADIRCOL" gewhlte *}
{*		Ansi-Sequenz-Tabelle.					*}
{* Definition:	Procedure AnsiLoad;					*}
{************************************************************************}

Procedure AnsiLoad;
Var      S         : String;
         i         : Integer;
begin
   S:=GetEnv('ADIRCOL');
   if S<>'' then begin
     Assign(AF,S);
     Reset(AF);
     if IOResult = 0 then
       for i:=0 to 6 do Read(AF,AnsiStr[i]);
   end;
end;

{************************************************************************}
{* Routine:	AnsiPrint						*}
{************************************************************************}
{* Inhalt:	Farbiger Ausdruck des Verzeichnisses mit entsprechenden	*}
{*		Zusatz-Informationen ber den ANSI-Treiber und		*}
{*		Untersttzung der Pausenfunktion.			*}
{* Definition:	Procedure AnsiPrint;					*}
{************************************************************************}

Procedure AnsiPrint;
Var      I, P, J   : Integer;
         Total     : Longint;
         T         : DateTime;
         N         : NameStr;
         E         : ExtStr;
         Test      : Word;
         D         : DirStr;
         C         : Char;

begin
   AnsiLoad;
   if ((not PrntB) and ((not UDirF) or (not UdirS))) then begin
     Write(AnsiStr[0].Ex1Col, StrVolNam, VolChar);
     if VolNam<>'' then Writeln(StrVolVer, VolNam)
     else Writeln(StrVolNoN);
     Lines := Succ(Lines);
   end;
   if UDirS and (Count = 0) then begin
     if (not UDirF) and (DSLast = 0) then begin
       FSplit(Path,D,N,E);
       Path:=DirStack[0]+N+E;
       if not (PrntB) then begin
         WriteLn(AnsiStr[0].Ex1Col, StrDirHea, Path);
         Lines := Succ(Lines);
       end;
       WriteLn(AnsiStr[0].Ex2Col, StrNoFile);
       Lines :=Succ(Lines);
     end;
     Exit;
   end
   else begin
     if not (PrntB) then begin
       WriteLn(AnsiStr[0].Ex1Col, StrDirHea, Path);
       Lines := Succ(Lines);
     end;
     if Count = 0 then begin
       WriteLn;
       WriteLn(AnsiStr[0].Ex2Col, StrNoFile);
       Exit;
     end;
     UDirF:=True;
   end;
   Total := 0;
   for I := 0 to Count-1 do begin
     with Dir[I]^ do begin
       if PrntB then begin
         Writeln(AnsiStr[FTyp].NamCol,Name);
         Lines := Succ(Lines);
       end
       else if PrntW then begin
         Write(AnsiStr[FTyp].NamCol,Name);
         if (I Mod 5) = 4 then begin
           Writeln;
           Lines := Succ(Lines);
         end
         else Write(' ':16-Length(Name));
       end
       else begin
         P := Pos('.', Name);
         if P > 1 then begin
           N := Copy(Name, 1, P - 1);
           E := Copy(Name, P + 1, 3);
         end
         else begin
           N := Name;
           E := '';
         end;
         Write(AnsiStr[FTyp].NamCol,N, ' ': 9 - Length(N));
         Write(AnsiStr[FTyp].ExtCol, E, ' ': 4 - Length(E));
         if Attr and Directory <> 0 then Write(AnsiStr[FTyp].SizCol,StrDirAbk)
         else Write(AnsiStr[FTyp].SizCol,Size: 8);
         UnpackTime(Time, T);
         Write(AnsiStr[FTyp].DatCol,DateStr(T):10);
         Write(AnsiStr[FTyp].TimCol,TimeStr(T):8);
         if FTyp=1 then begin
           Write(AnsiStr[1].KurCol,Kurz:5);
           Write(AnsiStr[1].Ex1Col,GHor:6,' x',GVer:4,' x',GCol:4);
           if GPal>0 then Write(AnsiStr[1].Ex2Col,GPal:10)
           else Write(AnsiStr[1].Ex2Col,'          ');
           Write(AnsiStr[1].Ex3Col,GPac:5,GGSI:2);
         end;
         if FTyp=2 then begin
           Write(AnsiStr[2].KurCol,Kurz:5);
           Write(AnsiStr[2].Ex1Col,ETit:22);
           if (Kurz='WIN ') then begin
             Write(AnsiStr[2].Ex2Col,Hi(EVer):3,'.',Numstr(Lo(EVer),2),'  ');
             if ((EFlg and 2)=2) then Write('3')
             else Write(' ');
             if ((EFlg and 4)=4) then Write('P')
             else Write(' ');
             if ((EFlg and 8)=8) then Write('F')
             else Write(' ');
           end;
         end;
         if FTyp=3 then begin
           Write(AnsiStr[3].KurCol,Kurz:5);
           Write(AnsiStr[3].Ex1Col,STit:22);
           Write(AnsiStr[3].Ex2Col,SIns:4,AnsiStr[3].Ex3Col);
           if SLen > 0 then Write (SLen div 60:4,':',NumStr(SLen mod 60,2));
           if SLen < 0 then begin
             Write ((-SLen div 600):4,':');
             Write (NumStr((-SLen div 10) mod 60,2),NLSDat.DecPoin);
             Write (-SLen mod 10);
           end;
         end;
         if FTyp=4 then begin
           Write(AnsiStr[4].KurCol,Kurz:5);
           if Kurz='DBF ' then begin
             Write(AnsiStr[4].Ex1Col,DLen:4,StrDbfFel);
             Write(AnsiStr[4].Ex2Col,DSat:6,StrDbfSat);
           end
           else begin
             Write(AnsiStr[4].Ex1Col,DLen:4,StrWksCol);
             Write(AnsiStr[4].Ex2Col,DSat:6,StrWksRow);
           end;
         end;
         if FTyp=5 then begin
           Write(AnsiStr[5].KurCol,Kurz:5);
           Write(AnsiStr[5].Ex1Col,TTit:22);
         end;
         if FTyp=6 then begin
           Write(AnsiStr[6].KurCol,Kurz:5);
           Write(AnsiStr[6].Ex1Col,PFil:4,StrArcFil);
           Write(AnsiStr[6].Ex2Col,PPro:4,' %  ');
           Write(AnsiStr[6].Ex3Col,PTyp);
         end;
         WriteLn;
         Lines := Succ(Lines);
       end;
       if (Pause and (Lines>=24)) then begin
         Writeln(Error, StrPreKey);
         repeat until KeyPressed;
         c:=ReadKey;
         Lines:=1;
       end;
       if (Attr and Directory) = 0 then Inc(Total, Size);
     end;
     FreeMem(Dir[I], 53);
   end;
   Write(AnsiStr[0].Ex3Col);
   if (PrntW) and ((I mod 5)<>4) then Writeln;
   if not (PrntB) then begin
     WriteLn(Count:5, StrNrFile, Total, StrFilSpc,
             DiskFree(Ord(Path[1])-64), StrDskSpc);
     if DSLast>0 then WriteLn;
     Lines := Lines + 2;
   end;
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	- (keine Vorinitialisierung notwendig)			*}
{************************************************************************}

begin
end.
