{************************************************************************}
{************************************************************************}
{* Modul:	adhelp.pas						*}
{************************************************************************}
{* Inhalt:	Ausgabe des Hilfe-Textes fr Advanced Directory		*}
{************************************************************************}
{* Funktion:	Ausgabe des Hilfetextes fr Advanced Dir		*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	10.Jan.1994						*}
{* Vernderung:	Anpassung der Revisionsnummer.				*}
{************************************************************************}
{* Revision:	0.10 Erste Version (zu ADIR 0.20)			*}
{*		...							*}
{*		0.32 Anpassung der Revisionsnummer und des HilfeTextes	*}
{*		0.34 Auswahl der Hilfetext-Sprache ber die Variable	*}
{*		     Language aus ADString.				*}
{************************************************************************}
{* Routinen:	HelpGer							*}
{*		HelpEng							*}
{*		HelpSwe							*}
{*		Help							*}
{************************************************************************}
Unit ADHelp;
{$I-,S-}
{$M 8192,8192,655360}

interface

Procedure Help;

implementation
uses nls,adstring;

{************************************************************************}
{* Routine:	HelpGer							*}
{************************************************************************}
{* Inhalt:	Ausgabe des deutschen Hilfe-Bildschirms.		*}
{* Definition:	Procedure HelpGer;					*}
{************************************************************************}

Procedure HelpGer;
begin
   Writeln(' Advanced Dir Vers. 0.50');
   Writeln;
   Writeln('ADIR [Laufwerk:][Pfad][Dateiname] [/P] [/B] [/W] [/A[[:]Attribute]]');
   Writeln('  [/O[[:]Reihenfolge]] [/S] [/D] [/XD] [/XF] [/?]');
   Writeln;
   Writeln(' [Laufwerk:][Pfad][Dateiname]');
   Writeln('             Bezeichnt aufzulistendes Laufwerk, Verzeichnis und/oder Dateien');
   Writeln(' /P          Pausiert nach jeder vollen Bildschirmseite.');
   Writeln(' /B          Verwendet einfaches Format ohne Header und Infos.');
   Writeln(' /W          Verwendet Breitformat fr die Auflistung.');
   Writeln(' /A          Listet Dateien mit bestimmten Attributen. Abkrzungen wie folgt:');
   Writeln('  Attribute  D  Verzeichnisse          R  Schreibgeschtze Dateien');
   Writeln('             H  Versteckte Dateien     A  Zu Archivierende Dateien');
   Writeln('             S  Systemdateien          -  vorangestellt dreht Bedeutung um');
   Writeln(' /O          Listet Dateien sortiert auf. Abkrzungen wie folgt:');
   Writeln('  Sortiert nach: N  Name (alphabetisch)    S  Gre (kleinere zuerst)');
   Writeln('                 K  Kurztyp ( - " - )      D  Datum/Zeit (ltere zuerst)');
   Writeln('                 G  Verzeichnisse zuerst   -  vorangestellt dreht Sortierung um');
   Writeln(' /S          Listet Dateien im Verzeichnis und dessen Unterverzeichnissen auf');
   Writeln(' /D          Benutzt zur Ausgabe ber ANSI-Treiber keine Farbe');
   Writeln(' /XD, /XF    Ausgabe im DESCRIPT.ION bzw. FILES.BBS-Format');
   Writeln(' /?          Gibt diesen Hilfetext aus.');
end;

{************************************************************************}
{* Routine:	HelpEng							*}
{************************************************************************}
{* Inhalt:	Ausgabe des englischen Hilfe-Bildschirms.		*}
{* Definition:	Procedure HelpEng;					*}
{************************************************************************}

Procedure HelpEng;
begin
   Writeln(' Advanced Dir Rel. 0.50');
   Writeln;
   Writeln('ADIR [drive:][path][filename] [/P] [/B] [/W] [/A[[:]attributes]]');
   Writeln('  [/O[[:]sortorder]] [/S] [/D] [/XD] [/XF] [/?]');
   Writeln;
   Writeln(' [drive:][path][filename]');
   Writeln('             Specifies drive, directory, and/or files to list.');
   Writeln(' /P          Pauses after each screenful of information.');
   Writeln(' /B          Uses bare format (no heading information or summary).');
   Writeln(' /W          Uses wide list format.');
   Writeln(' /A          Displays files with specified attributes.');
   Writeln('  attributes D  Directories            R  Read-only files');
   Writeln('             H  Hidden files           A  Files ready for archiving');
   Writeln('             S  System files           -  Prefix meaning "not"');
   Writeln(' /O          List by files in sorted order.');
   Writeln('  sortorder    N  By name (alphabetic)     S  By size (smallest first)');
   Writeln('               K  By short type ( - " - )  D  By date/time (earliest first)');
   Writeln('               G  Group directories first  -  Prefix to reverse order');
   Writeln(' /S          Displays files in specified directory and all subdirectories.');
   Writeln(' /D          Uses no color on output through ANSI-driver');
   Writeln(' /XD, /XF    Uses DESCRIPT.ION resp. FILES.BBS-Format');
   Writeln(' /?          Shows this help page.');
end;

{************************************************************************}
{* Routine:	HelpSwe							*}
{************************************************************************}
{* Inhalt:	Ausgabe des schwedischen Hilfe-Bildschirms.		*}
{* Definition:	Procedure Help;						*}
{************************************************************************}

Procedure HelpSwe;
begin
   Writeln(' Advanced Dir Vers. 0.50');
   Writeln;
   Writeln('ADIR [enhet:][skvg][filnamn] [/P] [/B] [/W] [/A[[:]attribut]');
   Writeln('  [/O[[:]sortord]] [/S] [/D] [/XD] [/XF] [/?]');
   Writeln;
   Writeln(' [enhet:][skvg][filnamn]');
   Writeln('             Anger enhet, katalog och filer som ska visas.');
   Writeln(' /P          Visar information en skrmbild i taget.');
   Writeln(' /B          Ger enkelt format (utan inledande information och sammanfattning).');
   Writeln(' /W          Visar filer och kataloger i kolumner.');
   Writeln(' /A          Visar filer med angivna attribut. Frkortningar som fljer:');
   Writeln('  attribut   D  Kataloger              R  Skrivskyddade filer');
   Writeln('             H  Dolda filer            A  Arkivklara filer');
   Writeln('             S  Systemfiler            -  Prefix fr "inte"');
   Writeln(' /O          Ger en lista enligt angiven sorteringsordning. Frkortningar:');
   Writeln('  Sortera efter: N  Namn (alfabetisk)         S  Storlek (minst frst)');
   Writeln('                 K  Typfrkortning (-"-)      D  Datum och tid (ldst frst)');
   Writeln('                 G  Gruppera kataloger frst  -  Prefix fr omvnd ordning');
   Writeln(' /S          Visar filer i angiven katalog och i alla underkataloger.');
   Writeln(' /D          Anvnder ingen ANSI-frg fr utskriften.');
   Writeln(' /XD, /XF    Utskrift i DESCRIPT.ION resp. FILES.BBS-format.');
   Writeln(' /?          Visar denna hjlptext.');
end;

{************************************************************************}
{* Routine:	Help							*}
{************************************************************************}
{* Inhalt:	Ausgabe des Hilfe-Bildschirms.				*}
{* Definition:	Procedure Help;						*}
{************************************************************************}

Procedure Help;
begin
   if Language='SWE' then HelpSwe
   else if Language='ENG' then HelpEng
   else HelpGer;
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	- (keine Vorinitialisierung notwendig)			*}
{************************************************************************}

begin
end.
