{************************************************************************}
{************************************************************************}
{* Modul:	adinfo.pas						*}
{************************************************************************}
{* Inhalt:	Extraktion von Zusatzinformationen fr ADir		*}
{************************************************************************}
{* Funktion:	Extraktion der Horizontal-, Vertikal- und Farb-Auflsung*}
{*		sowie Paletten- und Pack-Informationen fr Bilder,	*}
{*		Titel, Instrumentenzahl und Lnge fr Musik, Titel und	*}
{*		Betriebssystem fr Programme.				*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	10.Jan.1994						*}
{* Vernderung: Erweiterung des Plain Text-Formats um die Erkennung von	*}
{*		Postscript- u. RTF-Dateien.				*}
{*		Korrektur des ZOO-Formats (Datei-Ende-Erkennung)	*}
{*		Korrektur des SQZ-Formats (Datei-Ende-Erkennung)	*}
{*		Erweiterung des AVI-Formats um bessere Codec-Erkennung.	*}
{************************************************************************}
{* Revision:	0.10 Erste Public Beta-Version				*}
{*		 :							*}
{*		 :   siehe History.Doc					*}
{*		 :							*}
{*		0.30 Aufnahme des Datenbankformats DBF.			*}
{*		     Erweiterung der Graphikformate PCX,BMP,TIFF,TGA auf*}
{*		     Truecolor-Bilder. Die Farbausgabe erfolgt in der	*}
{*		     Palettenspalte.					*}
{*		     Erweiterung der JPG-Auswertung fr HSI-JPEG.	*}
{*		0.32 Aufnahme des Tabellenkalkformats WKS u. WK1.	*}
{*		     Aufnahme von Windows WRI, MS Word TXT u Plain Text.*}
{*		     Aufnahme von WIN-PIF und DV-DVP sowie DOS-SYS.	*}
{*		     Aufnahme von Windows ICO und CUR.			*}
{*		     Aufnahme des Archivformats ZOO.			*}
{*		     Aufnahme des VOC-Soundformats.			*}
{*		0.34 Korrektur der OS/2 BMPs fr OS/2 2.0.		*}
{*		     Aufnahme von OS/2 ICO und PTR.			*}
{*		     Aufnahme des CAS-DCX-Formates.			*}
{*		     Erweiterung der DOS-SYS auf Multidev. und EXE-Dev.	*}
{*		     Erweiterung des VOC-Soundformats auf Stereo.	*}
{*		0.40 Erweiterung der CRIX-Bilder auf Farb-Erkennung.	*}
{*		0.42 Aufnahme von Windows, Advisor und OS/2 Help-Dateien*}
{*		     Aufnahme von Windows GRP-Dateien.			*}
{*		     Aufnahme von SQZ-Archivdateien.			*}
{*		     Aufnahme von Midi-Dateien.				*}
{*		     Ausgabe der Packverfahren fr ZIP,ARC und PAK.	*}
{*		     Korrektur der DVP und PIF-Erkennung (Bug-Fix)	*}
{*		     Untersttzung korrupter VOC-Header (falsche Header-*}
{*		     Lnge).						*}
{*		     Erweiterung um eine Trouble-Shooting Ausgabe ber	*}
{*		     Switch /XT.					*}
{*		     Erweiterung der Suche um einen Test aller nicht	*}
{*		     erkannten DateiTypen auf EXE und Plain-Text ber	*}
{*		     Switch /XX.					*}
{*		0.44 Erweiterung des Tiff-Formats um die Erkennung von	*}
{*		     Motorola-Tiffs					*}
{*		     Erweiterung des ARJ-Formats um ext. Header Block.	*}
{************************************************************************}
{* Routinen:	LongI							*}
{*		Long3							*}
{*		FWord							*}
{*		SFWord							*}
{*		TitStr							*}
{*		BFCompare						*}
{*		CFCompare						*}
{*		PcxInfo							*}
{*		DcxInfo							*}
{*		BmpTest							*}
{*		BmpInfo							*}
{*		RleInfo							*}
{*		WpgInfo							*}
{*		MspInfo							*}
{*		IcoInfo							*}
{*		SciInfo							*}
{*		FliInfo							*}
{*		PicInfo							*}
{*		TgaInfo							*}
{*		RasInfo							*}
{*		TiffInfo						*}
{*		CutInfo							*}
{*		JpgInfo							*}
{*		GifInfo							*}
{*		LbmInfo							*}
{*		ImgInfo							*}
{*		MacInfo							*}
{*		AviInfo							*}
{*		DbfInfo							*}
{*		WksInfo							*}
{*		ExeInfo							*}
{*		ComInfo							*}
{*		PifInfo							*}
{*		NlmInfo							*}
{*		VapInfo							*}
{*		DevInfo							*}
{*		CmfInfo							*}
{*		CmsInfo							*}
{*		OrgInfo							*}
{*		ModInfo							*}
{*		RolInfo							*}
{*		WavInfo							*}
{*		VocInfo							*}
{*		SndInfo							*}
{*		MidiInfo						*}
{*		ArjInfo							*}
{*		ArcInfo							*}
{*		ZipInfo							*}
{*		LzhInfo							*}
{*		ZooInfo							*}
{*		SqzInfo							*}
{*		PTextInfo						*}
{*		WordInfo						*}
{*		HelpInfo						*}
{*		GetInfo							*}
{************************************************************************}

unit ADInfo;
{$I-,S-}
{$M 8192,8192,655360}
interface
uses dos,adsort,nls;
{$I adinfo.inc}

Type     BArrayPtr = ^BArray;
	 CArrayPtr = ^CArray;
	 BArray    = Array[0..255] of Byte;
	 CArray    = Array[0..255] of Char;
Var      Pause     : Boolean;
	 F,F1      : File;
	 D         : DirStr;
	 FBuf      : FBufType;

Procedure GetInfo;

implementation

Var	 Test      : Word;

Function LongI(x:Byte4):Longint;
begin
   LongI:=x[4]+Word(x[3])*256+x[2]*65536+x[1]*16777216;
end;

Function Long3(x:Byte3):Longint;
begin
   Long3:=x[1]+Word(x[2])*256+x[3]*65536;
end;

Function FWord(x:Word):Word;
begin
   FWord:=FBuf.DummyA[x]+Word(FBuf.DummyA[x+1])*256;
end;

Function SFWord(x:Word):Word;
begin
   SFWord:=FBuf.DummyA[x+1]+Word(FBuf.DummyA[x])*256;
end;

Function TitStr(S:TString):TString;
Var      HStr      : String[20];
	 i         : Byte;
begin
   i:=Pos(Chr(0),S);
   if i>0 then HStr:=Copy(S,1,i-1)
   else HStr:=S;
   while Length(HStr)<20 do HStr:=HStr+' ';
   TitStr:=HStr;
end;

Function BFCompare(X,Y:BArrayPtr;n:Byte):Boolean;
Var      i         : Byte;
	 P         : Boolean;
begin
   P:=True;
   for i:=0 to n do
     if x^[i]<>Y^[i] then P:=False;
   BFCompare:=P;
end;

Function CFCompare(X:CArrayPtr;Y:String):Boolean;
Var      i         : Byte;
	 P         : Boolean;
begin
   P:=True;
   for i:=1 to Length(Y) do
     if x^[i-1]<>Y[i] then P:=False;
   CFCompare:=P;
end;

{************************************************************************}
{* Routine:	PcxInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol und GPac fr ZSoft-PCX	*}
{* Definition:	Procedure PcxInfo;					*}
{************************************************************************}

Procedure PcxInfo;
begin
   if FBuf.PcxCre=$0a then
     with Dir[Count]^ do begin
       FTyp:=1;
       GGSI:='  ';
       Kurz:='PCX'+ Char(FBuf.PcxVer+$30);
       if FBuf.PcxVer>=5 then begin
	 GHor:=FBuf.PcxXMa-FBuf.PcxXMi+1;
	 GVer:=FBuf.PcxYMa-FBuf.PcxYMi+1;
       end
       else begin
	 GHor:=FBuf.PcxHRe;
	 GVer:=FBuf.PcxVRe;
       end;
       GCol:=1 shl (FBuf.PcxBpP * FBuf.PcxPla);
       if (GCol=0) then GPal:=Longint(1) shl (FBuf.PcxBpP * FBuf.PcxPla)
       else GPal:=0;
       if FBuf.PcxPaI=2 then GGSI:='GS';
       GPac:='   ';
       if FBuf.PcxEnc=1 then GPac:='RLE';
     end;
end;

{************************************************************************}
{* Routine:	DcxInfo							*}
{************************************************************************}
{* Inhalt:	berprfung des DCX-Headers und Extraktion der Infos	*}
{* Definition:	Procedure DcxInfo;					*}
{************************************************************************}

Procedure DcxInfo;
Var      Anz       : Word;
	 Adr       : Longint;
	 HStr      : String[3];
begin
   if (FBuf.DumLIn[0]=987654321) then begin
     Anz:=1;
     while ((FBuf.DumLIn[Anz+1]<>0) and (Anz<63)) do Inc(Anz);
     Adr:=FBuf.DumLin[1];
     Seek(F1,Adr);
     BlockRead(F1,FBuf,256,Test);
     PcxInfo;
     with Dir[Count]^ do
       if FTyp=1 then begin
	 Kurz[1]:='D';
	 HStr:=NumStr(Anz,2);
	 GPac[1]:=HStr[1];
	 GPac[2]:=HStr[2];
	 GPac[3]:='P';
       end;
   end;
end;

{************************************************************************}
{* Routine:	BmpTest							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol und GPac fr Win3-BMPs	*}
{*		sowie von GHor, GVer und GCol fr OS/2-BMPs		*}
{* Definition:	Procedure BmpTest;					*}
{************************************************************************}

Procedure BmpTest;
begin
   with Dir[Count]^ do begin
     if FBuf.BmpISi=12 then begin
       Kurz[4]:='O';
       GHor:=FBuf.BmcWid;
       GVer:=FBuf.BmcHei;
       GCol:=1 shl (FBuf.BmcBit);
       if GCol=0 then GPal:=Longint(1) shl (FBuf.BmcBit);
     end
     else begin
       if FBuf.BmpISi=40 then Kurz[4]:='W'
       else Kurz[4]:='2';
       GHor:=FBuf.BmpWid;
       GVer:=FBuf.BmpHei;
       GCol:=1 shl (FBuf.BmpBit);
       if GCol=0 then GPal:=Longint(1) shl (FBuf.BmpBit);
       if FBuf.BmpCom>0 then GPac:='RLE';
     end;
   end;
end;

{************************************************************************}
{* Routine:	BmpInfo							*}
{************************************************************************}
{* Inhalt:	berprfung des Bitmap-Headers und Extraktion der Infos	*}
{* Definition:	Procedure BmpInfo;					*}
{************************************************************************}

Procedure BmpInfo;
begin
   if (FBuf.BmpTyp = $4142) then begin
     Seek(F1,14);
     BlockRead(F1,FBuf,256,Test);
   end;
   if (FBuf.BmpTyp = $4D42) then
     with Dir[Count]^ do begin
       FTyp:=1;
       GGSI:='  ';
       GPac:='   ';
       GPal:=0;
       Kurz:='BMP ';
       BmpTest;
     end;
end;

{************************************************************************}
{* Routine:	RleInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol und GPac fr CIS-RLEs	*}
{* Definition:	Procedure RleInfo;					*}
{************************************************************************}

Procedure RleInfo;
begin
   if ((FBuf.DummyA[0] = $1B) and (FBuf.DummyA[1] = $47)) then
     with Dir[Count]^ do begin
       FTyp:=1;
       GGSI:='  ';
       GPac:='RLE';
       Kurz:='RLE ';
       GCol:=2;
       if FBuf.DummyA[2] = $48 then begin
	 GHor:=256;
	 GVer:=192;
       end
       else begin
	 GHor:=128;
	 GVer:=96;
       end;
       GPal:=0;
     end
   else BmpInfo;
end;

{************************************************************************}
{* Routine:	WpgInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr WordPerf.-WPGs	*}
{* Definition:	Procedure WpgInfo;					*}
{************************************************************************}

Procedure WpgInfo;
Var      Adr       : Word;
	 Ad1       : Byte;

  Function WpgAdr:LongInt;
  Var    Adr1      : LongInt;
  begin
     Adr1:=FBuf.WpgDum[Adr+$1];
     Ad1:=2;
     if FBuf.WpgDum[Adr+$1]=$ff then begin
       Adr1:=FBuf.WpgDum[Adr+$2]+(FBuf.WpgDum[Adr+3] and $7f)*256;
       Ad1:=4;
       if (FBuf.WpgDum[Adr+$3] and $80)=$80 then begin
	 Adr1:=Adr1*65536+FBuf.WpgDum[Adr+$2]+FBuf.WpgDum[Adr+3]*256;
	 Ad1:=6;
       end;
     end;
     WpgAdr:=Adr+Adr1+Ad1;
  end;

begin
   if (FBuf.WpgHea='WPC') then
     with Dir[Count]^ do begin
       Adr:=16;
       while ((Adr<1024) and 
	((FBuf.WpgDum[Adr]<>$0b) and (FBuf.WpgDum[Adr]<>$14))) do begin
	 Adr:=WpgAdr;
	 if Adr>256 then BlockRead(F1,FBuf.DummyB,768,Test);
       end;
       if (Adr<1024) then begin
	 Test:=WpgAdr;
	 FTyp:=1;
	 Kurz:='WPG ';
	 GGSI:='  ';
	 if (FBuf.WpgDum[Adr]=$0b) then begin 
	   GHor:=FBuf.WpgDum[Adr+Ad1+$0]+FBuf.WpgDum[Adr+Ad1+$1]*256;
	   GVer:=FBuf.WpgDum[Adr+Ad1+$2]+FBuf.WpgDum[Adr+Ad1+$3]*256;
	   GCol:=1 shl (FBuf.WpgDum[Adr+Ad1+4]);
	 end;
	 if (FBuf.WpgDum[Adr]=$14) then begin
	   GHor:=FBuf.WpgDum[Adr+Ad1+$8]+FBuf.WpgDum[Adr+Ad1+$9]*256;
	   GVer:=FBuf.WpgDum[Adr+Ad1+$0a]+FBuf.WpgDum[Adr+Ad1+$0b]*256;
	   GCol:=1 shl (FBuf.WpgDum[Adr+Ad1+$0c]);
	 end;
	 GPal:=0;
	 GPac:='   ';
       end;
     end;
end;

{************************************************************************}
{* Routine:	MspInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr MS-MSPs		*}
{* Definition:	Procedure MspInfo;					*}
{************************************************************************}

Procedure MspInfo;
begin
   if (FBuf.DumCh4='LinS') or (FBuf.DumCh4='DanM') then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='MSP'+Char(FBuf.DummyA[0]);
       GHor:=FWord($4);
       GVer:=FWord($6);
       GCol:=1 shl (FBuf.DummyA[$0c]);
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
     end;
end;

{************************************************************************}
{* Routine:	IcoInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GVor, GVer und GCol fr Win-ICOs und CURs*}
{* Definition:	Procedure IcoInfo;					*}
{************************************************************************}

Procedure IcoInfo;
begin
   if ((FBuf.IcoKen=0) and (FBuf.IcoTyp<3)) then
     with Dir[Count]^ do begin
       FTyp:=1;
       if (FBuf.IcoTyp = 1) then Kurz:='ICOW';
       if (FBuf.IcoTyp = 2) then Kurz:='CURW';
       GHor:=FBuf.IcoSiX;
       GVer:=FBuf.IcoSiY;
       GCol:=FBuf.IcoCol;
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
     end
   else begin
     if (FBuf.BmpTyp = $4142) then begin
       Seek(F1,14);
       BlockRead(F1,FBuf,256,Test);
     end;
     if ((FBuf.BmpTyp = $4349) or (FBuf.BmpTyp = $4943) or
	 (FBuf.BmpTyp = $5043) or (FBuf.BmpTyp = $5450)) then
       with Dir[Count]^ do begin
	 FTyp:=1;
	 GGSI:='  ';
	 GPac:='   ';
	 GPal:=0;
	 if ((FBuf.BmpTyp = $4349) or (FBuf.BmpTyp = $4943)) then Kurz:='ICO ';
	 if ((FBuf.BmpTyp = $5043) or (FBuf.BmpTyp = $5450)) then Kurz:='CUR ';
	 BmpTest;
       end;
   end;
end;

{************************************************************************}
{* Routine:	SciInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor und GVer fr ColoRIX-SCx		*}
{* Definition:	Procedure SciInfo;					*}
{************************************************************************}

Procedure SciInfo;
begin
   if (FBuf.DumCh4='RIX3') then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='CRIX';
       GHor:=FWord($4);
       GVer:=FWord($6);
       GCol:=1;
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
       if (FBuf.DummyA[$9] and $07)=$04 then GCol:=16;
       if (FBuf.DummyA[$9] and $07)=$00 then GCol:=256;
       if (FBuf.DummyA[$9] and $80)=$80 then GPac:='RIX';
     end;
end;

{************************************************************************}
{* Routine:	FliInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr FLIs		*}
{* Definition:	Procedure FliInfo;					*}
{************************************************************************}

Procedure FliInfo;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     Kurz:='AFLI';
     GHor:=FWord($08);
     GVer:=FWord($0A);
     GCol:=1 shl (FBuf.DummyA[$0c]);
     GPal:=0;
     GGSI:='  ';
     GPac:='   ';
   end;
end;

{************************************************************************}
{* Routine:	PicInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GVor, GVer und GCol fr Pictor-PICs	*}
{* Definition:	Procedure PicInfo;					*}
{************************************************************************}

Procedure PicInfo;
begin
   if (FBuf.DumWrd=$1234) then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='PIC ';
       GHor:=FWord($2);
       GVer:=FWord($4);
       GCol:=1 shl (FBuf.DummyA[$0a]);
       if GCol=0 then GCol:=16;
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
     end;
end;

{************************************************************************}
{* Routine:	TgaInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr TARGA-TGAs	*}
{* Definition:	Procedure TgaInfo;					*}
{************************************************************************}

Procedure TgaInfo;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     Kurz:='TARG';
     GHor:=FWord($0c);
     GVer:=FWord($0e);
     GCol:=1 shl (FBuf.DummyA[$10]);
     if (GCol=0) then GPal:=Longint(1) shl (FBuf.DummyA[$10])
     else GPal:=0;
     GGSI:='  ';
     GPac:='   ';
   end;
end;

{************************************************************************}
{* Routine:	RasInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr Sun-RASs		*}
{* Definition:	Procedure RasInfo;					*}
{************************************************************************}

Procedure RasInfo;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     Kurz:='RAS ';
     GHor:=SFWord($06);
     GVer:=SFWord($0a);
     GCol:=1 shl (FBuf.DummyA[$0f]);
     GPal:=0;
     GGSI:='  ';
     GPac:='   ';
   end;
end;

{************************************************************************}
{* Routine:	TiffInfo						*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol und GPac fr TIFFs (I)	*}
{* Definition:	Procedure TiffInfo;					*}
{************************************************************************}

Procedure TiffInfo;
Var      i         : Integer;
	 Mot       : Boolean;
	 Adr       : Longint;

  Function TiffCopy:LongInt;
  begin
    if (FBuf.TifTag[i].Typ=$300) then 
      TiffCopy:=Swap(FBuf.TifTag[i].IOf)
    else if (FBuf.TifTag[i].Typ=$400) then 
      TiffCopy:=LongI(FBuf.TifTag[i].MOf)
    else
      TiffCopy:=FBuf.TifTag[i].Ofs;
  end;

begin
   if (FBuf.DummyA[0]=$4D) or (FBuf.DummyA[0]=$49) then
     with Dir[Count]^ do begin
       Mot:=False;
       FTyp:=1;
       Kurz:='TIFF';
       GHor:=0;
       GVer:=0;
       GCol:=1;
       GGSI:='  ';
       GPac:='   ';
       if (FBuf.DummyA[0]=$4D) then begin 
	 Mot:=True;
	 Kurz[4]:='M';
	 Adr:=SFWord($06);
	 Adr:=Adr+FBuf.DummyA[$05]*65536;
       end
       else begin
	 Adr:=FWord($04);
	 Adr:=Adr+FBuf.DummyA[$06]*65536;
       end;
       Seek(F1,Adr);
       BlockRead(F1,FBuf,1024,Test);
       GPal:=0;
       if Mot then begin
	 for i:=1 to Swap(FBuf.TifCnt) do begin
	   if FBuf.TifTag[i].Tag = $0001 then GHor:=TiffCopy;
	   if FBuf.TifTag[i].Tag = $0101 then GVer:=TiffCopy;
	   if FBuf.TifTag[i].Tag = $0201 then begin
	     GCol:=1 shl TiffCopy;
	     if (GCol=0) then GPal:=Longint(1) shl TiffCopy;
	   end;
	   if FBuf.TifTag[i].Tag = $0301 then 
	     case TiffCopy of
	       1: GPac:='PBi';
	       2: GPac:='HUF';
	       3: GPac:='Fx3';
	       4: GPac:='Fx4';
	       else GPac:='   ';
	     end;
	  end;
       end
       else begin
	 for i:=1 to FBuf.TifCnt do begin
	   if FBuf.TifTag[i].Tag = $0100 then GHor:=FBuf.TifTag[i].Ofs;
	   if FBuf.TifTag[i].Tag = $0101 then GVer:=FBuf.TifTag[i].Ofs;
	   if FBuf.TifTag[i].Tag = $0102 then begin
	     GCol:=1 shl FBuf.TifTag[i].Ofs;
	     if (GCol=0) then GPal:=Longint(1) shl FBuf.TifTag[i].Ofs;
	   end;
	   if FBuf.TifTag[i].Tag = $0103 then 
	     case FBuf.TifTag[i].Ofs of
	       1: GPac:='PBi';
	       2: GPac:='HUF';
	       3: GPac:='Fx3';
	       4: GPac:='Fx4';
	       else GPac:='   ';
	     end;
	  end;
       end;
     end;
end;

{************************************************************************}
{* Routine:	CutInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor und GVer fr Dr.Halo-CUTs		*}
{* Definition:	Procedure CutInfo;					*}
{************************************************************************}

Procedure CutInfo;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     Kurz:='CUT ';
     GHor:=FWord($00);
     GVer:=FWord($02);
     GCol:=1;
     GPal:=0;
     GGSI:='  ';
     GPac:='   ';
   end;
end;

{************************************************************************}
{* Routine:	JpgInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol fr JPEG-JPGs	*}
{* Definition:	Procedure JpgInfo;					*}
{************************************************************************}

Procedure JpgInfo;
Var      Adr       : Word;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     GPal:=0;
     GGSI:='  ';
     BlockRead(F1,FBuf.DummyB,768,Test);
     if ((FBuf.DummyA[0]=$68) and (FBuf.DummyA[1]=$73)) then begin
       Adr:=2+SFWord(14);
       Kurz:='HSIJ';
     end
     else begin
       Adr:=2;
       Kurz:='JPEG';
     end;
     while ((Adr<1024) and (FBuf.DummyA[Adr+1]<>$c0)) do
       Adr:=Adr+2+SFWord(Adr+2);
     if Adr<1024 then begin
       GHor:=SFWord(Adr+7);
       GVer:=SFWord(Adr+5);
       GCol:=1 shl (FBuf.DummyA[Adr+4]*FBuf.DummyA[Adr+9]);
       if GCol=0 then
	 GPal:=Longint(1) shl (FBuf.DummyA[Adr+4]*FBuf.DummyA[Adr+9]);
     end
     else begin
       GHor:=0;
       GVer:=0;
       GCol:=1;
     end;
     GPac:='DCT';
   end;
end;

{************************************************************************}
{* Routine:	GifInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol, GPal und GPac fr	*}
{*		Compuserve-GIFs						*}
{* Definition:	Procedure GifInfo;					*}
{************************************************************************}

Procedure GifInfo;
begin
   if (FBuf.GifSIG = 'GIF') then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='G'+FBuf.GifVer;
       GHor:=FBuf.GifLSW;
       GVer:=FBuf.GifLSH;
       GCol:=1 shl ((FBuf.GifPF1 mod 8)+1);
       GPal:=1;
       GPal:=GPal shl ((((FBuf.GifPF1 div 16) mod 8)+1)*3);
       GGSI:='  ';
       GPac:='LZW';
     end;
end;

{************************************************************************}
{* Routine:	LbmInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer, GCol und GPac fr IFF-ILBMs	*}
{* Definition:	Procedure LbmInfo;					*}
{************************************************************************}

Procedure LbmInfo;
begin
   if ((FBuf.LbmIff ='FORM') and (FBuf.LbmTyp ='ILBM')) then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='ILBM';
       GHor:=Swap(FBuf.LbmBmX);
       GVer:=Swap(FBuf.LbmBmY);
       GCol:=1 shl (FBuf.LbmBPl);
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
       if FBuf.LbmPac=1 then GPac:='BRL';
     end;
end;

{************************************************************************}
{* Routine:	ImgInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer und GCol von GEM-IMGs		*}
{* Definition:	Procedure ImgInfo;					*}
{************************************************************************}

Procedure ImgInfo;
begin
   with Dir[Count]^ do begin
     FTyp:=1;
     Kurz:='GEM ';
     GHor:=Swap(FBuf.GemPiZ);
     GVer:=Swap(FBuf.GemEle);
     GCol:=1 shl (Swap(FBuf.GemBpP));
     GPal:=0;
     GGSI:='  ';
     GPac:='   ';
   end;
end;

{************************************************************************}
{* Routine:	MacInfo							*}
{************************************************************************}
{* Inhalt:	Identifikation von MAC-PNT und Setzen von GHor, GVer	*}
{*		und GCol						*}
{* Definition:	Procedure MacInfo;					*}
{************************************************************************}

Procedure MacInfo;
begin
   if (FBuf.MacTyp='PNTGMPNT') then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='MAC ';
       GHor:=576;
       GVer:=720;
       GCol:=2;
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
     end;
end;

{************************************************************************}
{* Routine:	AviInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von GHor, GVer fr AVIs			*}
{* Definition:	Procedure AviInfo;					*}
{************************************************************************}

Procedure AviInfo;
begin
   if ((FBuf.AviIff='RIFF') and (FBuf.AviTyp='AVI ')) then
     with Dir[Count]^ do begin
       FTyp:=1;
       Kurz:='AVI ';
       if (FBuf.AviSub='vids') then begin
	 if (UpStr(FBuf.AviCod)='ULTI') then Kurz[4]:='U';
	 if (UpStr(FBuf.AviCod)='MSVC') then Kurz[4]:='M';
	 if (UpStr(FBuf.AviCod)='MRLE') then Kurz[4]:='M';
	 if (UPStr(FBuf.AviCod)='RT21') then Kurz[4]:='I';
	 if (UPStr(FBuf.AviCod)='IV31') then Kurz[4]:='I';
	 if (UpStr(FBuf.AviCod)='CVID') then Kurz[4]:='C';
       end;
       GHor:=FBuf.AviHor;
       GVer:=FBuf.AviVer;
       GCol:=0;
       GPal:=0;
       GGSI:='  ';
       GPac:='   ';
     end;
end;

{************************************************************************}
{* Routine:	DbfInfo							*}
{************************************************************************}
{* Inhalt:	Identifikation von dBase-DBF und Extraktion von DLen	*}
{*		und DSat						*}
{* Definition:	Procedure DbfInfo;					*}
{************************************************************************}

Procedure DbfInfo;
begin
   if ((FBuf.DbfKen and $03) = $03) then
     with Dir[Count]^ do begin
       FTyp:=4;
       Kurz:='DBF ';
       if (FBuf.DbfHSi > 256) then Blockread(F1,FBuf.DummyB,768,Test);
       DLen:=0;
       Test:=32;
       while ((Test<FBuf.DbfHSi) and (FBuf.DbfFld[Test]<>$0d) 
	and (Test<1024)) do begin
	 Inc(DLen);
	 Inc(Test,32);
       end;
       DSat:=FBuf.DbfSat;
     end;
end;

{************************************************************************}
{* Routine:	WksInfo							*}
{************************************************************************}
{* Inhalt:	Identifikation von Lotus-WKS und Extraktion von DLen	*}
{*		und DSat						*}
{* Definition:	Procedure WksInfo;					*}
{************************************************************************}

Procedure WksInfo;
begin
   if ((FBuf.DummyA[0] = $00) and (FBuf.DummyA[1] = $00)) then
     with Dir[Count]^ do begin
       Test:=0;
       FTyp:=4;
       Kurz:='WKS ';
       if FBuf.DummyA[4] = $04 then Kurz[4]:='1';
       if FBuf.DummyA[4] = $05 then Kurz[4]:='S';
       if FBuf.DummyA[4] = $06 then Kurz[4]:='2';
       if FBuf.DummyA[4] = $20 then Kurz[4]:='Q';
       while ((FBuf.DummyA[Test]<>6) and (Test<256)) do 
	 Test:=Test+4+FWord(Test+2);
       if (FBuf.DummyA[Test]=6) then begin
	 DLen:=FWord(Test+4);
	 if DLen=-1 then DLen:=0;
	 DLen:=FWord(Test+8)-DLen+1;
	 DSat:=FWord(Test+6);
	 if DSat=-1 then DSat:=0;
	 DSat:=FWord(Test+10)-DSat+1;
       end;
     end;
end;

Function DevTest(Adr1:Longint):String;
Var      Adr       : Longint;
	 HStr      : String;
	 TOfs      : Word;
begin
   HStr:='';
   Adr:=Adr1;
   TOfs:=0;
   Seek(F1,Adr);
   BlockRead(F1,FBuf,32,Test);
   Adr:=Adr1+FBuf.DevLOf;
   while((FBuf.DevLOf<>$ffff) and (Adr < FileSize(F1)) and 
	 ((FBuf.DevLSe=$0000) or (FBuf.DevLSe>=FBuf.DevLOf)) and
	 (TOfs+16 < FBuf.DevLOf)) do begin
     TOfs:=FBuf.DevLOf;
     if (FBuf.DevAtt and $8000)=$8000 then HStr:=HStr+FBuf.DevNam+'|'
     else HStr:=HStr+NumStr(Ord(FBuf.DevNam[1]),2)+' Laufw|';
     Seek(F1,Adr);
     BlockRead(F1,FBuf,32,Test);
     Adr:=Adr1+FBuf.DevLOf;
   end;
   if ((FBuf.DevLOf=$ffff) and (FBuf.DevLSe=$ffff)) then begin
     if (FBuf.DevAtt and $8000)=$8000 then HStr:=HStr+FBuf.DevNam+'|'
     else HStr:=HStr+NumStr(Ord(FBuf.DevNam[1]),2)+' Laufw|';
     DevTest:=HStr;
   end
   else DevTest:='';
end;

{************************************************************************}
{* Routine:	ExeInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von Betriebsysten, ETit, EFlg und EVer fr	*}
{*		DOS-, WIN und OS/2-EXE-Dateien (incl. Treiber+DLLs)	*}
{* Definition:	Procedure ExeInfo;					*}
{************************************************************************}

Procedure ExeInfo;
Var      HStr      : String;
begin
   if (FBuf.ExeKen = $5A4D) then
     with Dir[Count]^ do begin
       FTyp:=2;
       Kurz:='DOS ';
       ETit:='';
       EFlg:=0;
       EVer:=0;
       if (FBuf.ExeSRe = 64) then begin
	 Seek(F1,FBuf.ExeAdN);
	 BlockRead(F1,FBuf,172,Test);
	 if (FBuf.ExnKen=$454E) then begin
	   if (FBuf.ExnFl2 = 2) then begin
	     Kurz:='WIN ';
	     EVer:=FBuf.ExnVer;
	     EFlg:=FBuf.ExnFl3;
	   end
	   else if (FBuf.ExnFl2 = 1) then
	     if (FBuf.ExnFl1 and $0800)=$0800 then Kurz:='FAPI'
	     else if (FBuf.ExnFl1 and $0300)=$0300 then Kurz:='PM/2'
	     else Kurz:='OS/2'
	   else Kurz[4]:='?';
	   Seek(F1,FBuf.ExnONN);
	   Blockread(F1,FBuf,256,Test);
	   HStr:=FBuf.DumStr;
	   if (Pos('Microsoft',HStr)<>0) and (Length(HStr)>20) then begin
	     Test:=Pos('Microsoft',HStr);
	     HStr:=Copy(HStr,1,Test-1) + 'MS' +
		   Copy(HStr,Test+9,Length(HStr)-Test-8);
	   end;
	   if (Pos('FONTRES',HStr)<>0) and (Length(HStr)>20) then begin
	     Test:=Pos(':',HStr);
	     HStr:='FNT:' + Copy(HStr,Test+1,Length(HStr)-Test);
	   end;
	   ETit:=Copy(HStr,1,20);
	 end
	 else if (FBuf.ExnKen=$454C) then begin
	   Seek(F1,FBuf.ExlONN);
	   Blockread(F1,FBuf,256,Test);
	   Kurz:='W386';
	   HStr:=FBuf.DumStr;
	   if (Pos('Microsoft',HStr)<>0) and (Length(HStr)>20) then begin
	     Test:=Pos('Microsoft',HStr);
	     HStr:=Copy(HStr,1,Test-1) + 'MS' +
		   Copy(HStr,Test+9,Length(HStr)-Test-8);
	   end;
	   ETit:=Copy(HStr,1,20);
	 end
	 else if (FBuf.ExnKen=$584C) then begin
	   if (FBuf.ExlMoT and $0300)=$0300 then Kurz:='PM2L'
	   else Kurz:='OS2L';
	   if FBuf.ExlONN<>0 then begin
	     Seek(F1,FBuf.ExlONN);
	     Blockread(F1,FBuf,256,Test);
	     HStr:=FBuf.DumStr;
	     if (Pos('Presentation Manager',HStr)<>0) and 
		(Length(HStr)>20) then begin
	       Test:=Pos('Presentation Manager',HStr);
	       HStr:=Copy(HStr,1,Test-1) + 'PM' +
		     Copy(HStr,Test+20,Length(HStr)-Test-19);
	     end;
	     if (Pos('Application',HStr)<>0) and 
		(Length(HStr)>20) then begin
	       Test:=Pos('Application',HStr);
	       HStr:=Copy(HStr,1,Test-1) + 'App.' +
		     Copy(HStr,Test+11,Length(HStr)-Test-10);
	     end;
	     ETit:=Copy(HStr,1,20);
	   end;
	 end;
       end
       else begin
	 HStr:=Copy(DevTest(FBuf.ExeGHe*16),1,20);
	 if HStr<>'' then begin
	   Kurz:='DDEV';
	   if Length(HStr)=20 then begin
	     HStr[19]:='.';
	     HStr[20]:='.';
	   end
	   else HStr[Length(HStr)]:=' ';
	   ETit:=HStr;
	 end;
       end;
       ETit:=TitStr(ETit);
     end;
end;

{************************************************************************}
{* Routine:	ComInfo							*}
{************************************************************************}
{* Inhalt:	Test auf verstecktes EXE und Identifikation als COM-Dat.*}
{* Definition:	Procedure ComInfo;					*}
{************************************************************************}

Procedure ComInfo;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else  
     with Dir[Count]^ do begin
       FTyp:=2;
       Kurz:='COM ';
       ETit:='';
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:	PifInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion des Applikations-Namens aus Win- und DV-PIFs.*}
{* Definition:	Procedure PifInfo;					*}
{************************************************************************}

Procedure PifInfo;
Var      PifL      : Word;
begin
   with Dir[Count]^ do begin
     Kurz:='';
     PifL:=FileSize(F1);
     if ((PifL > 256) and (PifL < 1024)) then
       BlockRead(F1,FBuf.DummyB,PifL-256,Test);
     if ((PifL=369) and (FBuf.DummyA[367]=$e0)and (FBuf.DummyA[368]=$60)) then 
       Kurz:='PIF2';
     if ((PifL=545) and (FBuf.DummyA[369]=$4d)and (FBuf.DummyA[370]=$49)) then
       Kurz:='PIF3';
     if (PifL=416) then Kurz:='DVP ';
     if (Kurz<>'') then begin
       FTyp:=2;
       ETit:='';
       EFlg:=0;
       EVer:=0;
       for Test:=2 to 21 do ETit:=ETit+FBuf.Dummy0[Test];
       ETit:=TitStr(ETit);
     end;
   end;
end;

{************************************************************************}
{* Routine:	NlmInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von ETit fr Novell ladbare Module		*}
{* Definition:	Procedure NlmInfo;					*}
{************************************************************************}

Procedure NlmInfo;
begin
   if (FBuf.NlmKen='NetWare Loadable Module') then
     with Dir[Count]^ do begin
       FTyp:=2;
       Kurz:='NLM ';
       ETit:=Copy(FBuf.NlmNam,1,20);
       ETit:=TitStr(ETit);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:	VapInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von ETit fr Novell VAPs			*}
{* Definition:	Procedure VapInfo;					*}
{************************************************************************}

Procedure VapInfo;
Var      Adr       : Longint;
begin
   if (FBuf.ExeKen=$5A4D) then begin
     Adr:=FBuf.ExeGHe*16;
     Seek(F1,Adr);
     BlockRead(F1,FBuf,256,Test);
     if (FBuf.VapKen='NWProc') then
       with Dir[Count]^ do begin
	 FTyp:=2;
	 Kurz:='VAP ';
	 ETit:='';
	 while ((Length(ETit)<20) and (Ord(FBuf.VapInf[Length(ETit)])>=$20)) do 
	   ETit:=ETit+FBuf.VapInf[Length(ETit)];
	 ETit:=TitStr(ETit);
	 EFlg:=0;
	 EVer:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:	DevInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von ETit fr Dos-Devicetreiber		*}
{* Definition:	Procedure DevInfo;					*}
{************************************************************************}

Procedure DevInfo;
Var      HStr      : String;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else begin
     HStr:=Copy(Devtest(0),1,20);
     if HStr<>'' then
       with Dir[Count]^ do begin
	 FTyp:=2;
	 Kurz:='DDEV';
	 if Length(HStr)=20 then begin
	   HStr[19]:='.';
	   HStr[20]:='.';
	 end
	 else HStr[Length(HStr)]:=' ';
	 ETit:=TitStr(Copy(HStr,1,20));
	 EFlg:=0;
	 EVer:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:	GroupInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von ETit fr WinGroups			*}
{* Definition:	Procedure GroupInfo;					*}
{************************************************************************}

Procedure GroupInfo;
Const    WinGrpId  : Array[0..2] of Byte = ($50,$4D,$43);
Var      Adr       : Longint;
	 HStr      : String;
begin
   if BFCompare(Addr(FBuf),Addr(WinGrpId),2) then
     with Dir[Count]^ do begin
       FTyp:=2;
       Kurz:='WGRP';
       ETit:='';
       Adr:=FWord($16);
       Seek(F1,Adr);
       Blockread(F1,FBuf,32,Test);
       for Adr:=0 to 19 do ETit:=ETit+FBuf.Dummy0[Adr];
       ETit:=TitStr(ETit);
       EFlg:=0;
       EVer:=0;
     end;
end;

{************************************************************************}
{* Routine:	CmfInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von STit und SIns fr SB-CMFs		*}
{* Definition:	Procedure CmfInfo;					*}
{************************************************************************}

Procedure CmfInfo;
Var      i         : Word;
begin
   if (FBuf.CmfFId='CTMF') then
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='CMF ';
       STit:='';
       if (FBuf.CmfOMT <> 0) then begin
	 i:=FBuf.CmfOMT;
	 while (i<FBuf.CmfOMT+20) do begin
	   STit:=STit+FBuf.CmfDum[i];
	   i:=succ(i);
	 end;
       STit:=TitStr(STit);
       end;
       SIns:=FBuf.CmfNIn;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:	CmsInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von STit fr Gameblaster CMSs		*}
{* Definition:	Procedure CmsInfo;					*}
{************************************************************************}

Procedure CmsInfo;
Var      i         : Word;
begin
   if ((FBuf.Dummy0[0]='C') and (FBuf.Dummy0[1]='M')) then
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='CMS ';
       STit:='';
       SIns:=0;
       SLen:=0;
       for i:=2 to 13 do
	 if FBuf.DummyA[i] <> $0 then Inc(SIns);
       for i:=32 to 51 do
	 STit:=STit+FBuf.Dummy0[i];
       STit:=TitStr(STit);
     end;
end;

{************************************************************************}
{* Routine:	OrgInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von STit und SIns fr Intelligent-Organ-ORGs *}
{* Definition:	Procedure OrgInfo;					*}
{************************************************************************}

Procedure OrgInfo;
Var      i         : Word;
begin
   if ((FBuf.Dummy0[0]='C') and (FBuf.Dummy0[1]='M')) then
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='COrg';
       STit:='';
       for i:=32 to 51 do
	 STit:=STit+FBuf.Dummy0[i];
       STit:=TitStr(STit);
       SIns:=4;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:	ModInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von STit, SIns und SLen fr Amiga-MODs	*}
{* Definition:	Procedure ModInfo;					*}
{************************************************************************}

Procedure ModInfo;
Var      i         : Integer;
begin
   if (FBuf.ExeKen=$5A4D) then ExeInfo
   else 
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='MOD ';
       STit:=TitStr(FBuf.ModTit);
       Seek(f1,$3b6);
       Blockread(F1,FBuf.DummyB,140,i);
       if ((FBuf.ModKen='M.K.') or (FBuf.ModKen='FLT4')) then SIns:=31
       else begin
	 SIns:=15;
	 Seek(f1,$1d6);
	 Blockread(F1,FBuf.DummyB,140,i);
       end;
       if (FBuf.ModTEf mod 16)=15 then SLen:=FBuf.ModTPa
       else SLen:=6;
       SLen:=Round(1.25*FBuf.ModPat*SLen);
     end;
end;

{************************************************************************}
{* Routine:	RolInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von SIns fr Adlib-ROLs			*}
{* Definition:	Procedure RolInfo;					*}
{************************************************************************}

Procedure RolInfo;
Type     RolFNot   = record
		       Note   : Integer;
		       Dura   : Integer;
		     end;
	 RolEvnt   = record
		       Filler : Array[1..15] of Byte;
		       NumEvt : Integer;
		     end;
	 RolIEvn   = record
		       TimTic : Integer;
		       InsNam : Array[1..9] of Char;
		       Reser1 : Char;
		       Reser2 : Integer;
		     end;
Var      LastI     : Integer;
	 Flg       : Boolean;
	 RFNot     : RolFNot;
	 REvnt     : RolEvnt;
	 RIEvn     : RolIEvn;
	 INamen    : Array[0..100] of String[9];
	 Voice     : Integer;
	 i,j       : Integer;

begin
   with Dir[Count]^ do begin
     FTyp:=3;
     Kurz:='ROL ';
     STit:='';
     LastI:=0;
     Seek(f1,203+(6*FBuf.RolTEv));
     for Voice:=0 to 10 do begin
       BlockRead(f1,REvnt,17);
       while REvnt.NumEvt > 0 do begin
	 BlockRead(f1,RFNot,4);
	 REvnt.NumEvt:=REvnt.NumEvt - RFNot.Dura;
       end;
       BlockRead(f1,REvnt,17);
       for i:=1 to REvnt.NumEvt do begin
	 BlockRead(f1,RIEvn,14);
	 j:=0;
	 Flg:=True;
	 INamen[LastI]:=RIEvn.InsNam;
	 Delete(INamen[LastI],Pos(Char(0),INamen[LastI]),9);
	 while ((j < LastI) and Flg) do begin
	   if INamen[j]=INamen[LastI] then Flg:=False;
	   j:=Succ(j);
	 end;
	 if Flg then LastI:=Succ(LastI);
       end;
       BlockRead(f1,REvnt,17);
       Seek(f1,FilePos(f1)+(6*REvnt.NumEvt));
       BlockRead(f1,REvnt,17);
       Seek(f1,FilePos(f1)+(6*REvnt.NumEvt));
     end;
     SIns:=LastI;
     SLen:=0;
   end;
end;

{************************************************************************}
{* Routine:	WavInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von SIns und SLen fr MS-WAVs		*}
{* Definition:	Procedure WavInfo;					*}
{************************************************************************}

Procedure WavInfo;
begin
   if ((FBuf.WavIff='RIFF') and (FBuf.WavTyp='WAVE')) then
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='WAVE';
       STit:='';
       while Length(STit)<20 do STit:=STit+' ';
       SIns:=FBuf.WavCha;
       SLen:=-Round(FBuf.WavDLe*10.0/FBuf.WavMSp);
     end;
end;

{************************************************************************}
{* Routine:	VocInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von SIns und SLen fr SB-VOCs		*}
{* Definition:	Procedure VocInfo;					*}
{************************************************************************}

Procedure VocInfo;
Var      Adr,Spd   : Longint;
	 Spd2      : Longint;
	 Len       : Word;
	 Fak,Rep   : Word;
	 NewT      : Boolean;
begin
   if (FBuf.VocHea='Creative Voice File') then
     with Dir[Count]^ do begin
       NewT:=False;
       FTyp:=3;
       Kurz:='VOC ';
       SIns:=1;
       STit:='';
       Len:=0;
       Fak:=1;
       Rep:=1;
       Adr:=FBuf.VocOfs;
       Seek(F1,Adr);
       BlockRead(F1,FBuf.DummyB,64,Test);
       if (FBuf.VocTyp > 10) then begin
	 Adr:=Adr mod 256;
	 Seek(F1,Adr);
	 BlockRead(F1,FBuf.DummyB,64,Test);
       end;
       while (FBuf.VocTyp<>0) and (FBuf.VocTyp<20) do begin
	 if (FBuf.VocTyp = 1) then begin
	   if (FBuf.VocDum[5]<3) then Fak:=FBuf.VocDum[5]+1;
	   if NewT then Spd:=Spd2
	   else Spd:=Round(1000000/(256-FBuf.VocDum[4]));
	   Len:=Len+Round(100*Fak*Rep*Long3(FBuf.VocLen)/Spd);
	 end;
	 if (FBuf.VocTyp = 2) then
	   Len:=Len+Round(100*Fak*Rep*Long3(FBuf.VocLen)/Spd);
	 if (FBuf.VocTyp = 3) then begin
	   Spd:=Round(1000000/(256-FBuf.VocDum[6]));
	   Len:=Len+Round(100*Rep*(FBuf.VocDum[4]+FBuf.VocDum[5]*256)/Spd);
	 end;
	 if (FBuf.VocTyp = 5) then begin
	   Test:=4;
	   while ((Length(STit)<20) and (FBuf.VocDum[Test]<>0)) do begin
	     STit:=STit+Chr(FBuf.VocDum[Test]);
	     Inc(Test);
	   end;
	 end;
	 if (FBuf.VocTyp = 6) then
	   Rep:=FBuf.VocDum[4]+FBuf.VocDum[5]*256;
	 if (FBuf.VocTyp = 7) then
	   Rep:=1;
	 if (FBuf.VocTyp = 8) then begin
	   NewT:=True;
	   SIns:=FBuf.VocDum[7]+1;
	   Spd2:=(65536-(FBuf.VocDum[4]+Word(FBuf.VocDum[5])*256))*SIns;
	   Spd2:=Round(256000000/Spd2);
	 end;
	 Adr:=Adr+4+Long3(FBuf.VocLen);
	 Seek(F1,Adr);
	 BlockRead(F1,FBuf.DummyB,64,Test);
       end;
       STit:=TitStr(STit);
       SLen:=-Round(Len/10);
     end;
end;

{************************************************************************}
{* Routine:	SndInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von STit fr IFF-8SVX und MAC-FSSs		*}
{* Definition:	Procedure SndInfo;					*}
{************************************************************************}

Procedure SndInfo;
Var      IffVar    : IffType;
	 Adr,i     : LongInt;
begin
   with Dir[Count]^ do begin
     if (FBuf.SVXIff='FORM') then begin  
       FTyp:=3;
       Kurz:=FBuf.SvxTyp;    {'8SVX'}
       STit:='';
       Adr:=LongI(FBuf.SvxHLe)+$14;
       IffVar.Typ[1]:=' ';
       while ((Adr<256) and (IffVar.Typ<>'BODY')) do begin
	 move(FBuf.SvxDum[Adr],IffVar,28);
	 if (IffVar.Typ='NAME') then begin
	   STit:=TitStr(IffVar.Par);
	   Adr:=2000;
	 end;
	 Adr:=Adr+LongI(IffVar.Len)+8;
       end;
       SIns:=0;
       SLen:=0;
     end
     else if ((FBuf.MacTyp='FSSDJOSH') or (FBuf.MacTyp='FSSDSFX!')) then
       begin
	 FTyp:=3;
	 Kurz:='MACS';
	 STit:=TitStr(Copy(FBuf.MacTit,1,20));
	 SIns:=0;
	 SLen:=0;
       end;
   end;
end;

{************************************************************************}
{* Routine:	MidiInfo						*}
{************************************************************************}
{* Inhalt:	Erkennung von Midi-Dateien				*}
{* Definition:	Procedure MidiInfo;					*}
{************************************************************************}

Procedure MidiInfo;
Var      MidVar    : MidType;
	 Adr,Adr1  : LongInt;
begin
   if (FBuf.MidKen='MThd') then
     with Dir[Count]^ do begin
       FTyp:=3;
       Kurz:='MIDI';
       STit:='';
       SIns:=0;
       Adr:=LongI(FBuf.MidHLe)+8;
       while (Adr<FileSize(F1)) do begin
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,256,Test);
	 Inc(SIns);
	 Adr:=Adr+LongI(FBuf.MidHLe)+8;
	 if SIns=1 then begin
	   Adr1:=8;
	   while (Adr1<220) do begin
	     move(FBuf.MidDum[Adr1],MidVar,24);
	     if ((MidVar.Typ=$03) and (MidVar.Evt=$ff00)) then begin
	       STit:=TitStr(MidVar.Stg);
	       Adr1:=2000;
	     end;
	     Adr1:=Adr1+MidVar.Len+4;
	   end;
	 end;
       end;
       SLen:=0;
     end;
end;

{************************************************************************}
{* Routine:	ArjInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr ARJs			*}
{* Definition:	Procedure ArjInfo;					*}
{************************************************************************}

Procedure ArjInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,XSi   : Word;
begin
   if (FBuf.ArjKen=$EA60) then
     with Dir[Count]^ do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (FBuf.ArjHSi <> 0) do begin
	 if FBuf.ArjHSi>244 then
	   Blockread(F1,FBuf.DummyB,FBuf.ArjHSi-240,Test);
	 if FBuf.ArjTyp = 2 then Adr:=Adr+FBuf.ArjHSi+10
	 else Adr:=Adr+FBuf.ArjHSi+10+FBuf.ArjCSi;
	 XSi:=FBuf.ArjHSi+8;
	 XSi:=FBuf.ArjDum[XSi]+FBuf.ArjDum[XSi+1]*256;
	 if XSi<>0 then Adr:=Adr+XSi+4;
	 if FBuf.ArjTyp < 2 then begin
	   GeSi:=GeSi+FBuf.ArjUSi;
	   CoSi:=CoSi+FBuf.ArjCSi;
	   Inc(Anz);
	 end;
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,256,Test);
       end;
       FTyp:=6;
       Kurz:='ARJ ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:='';
     end;
end;

{************************************************************************}
{* Routine:	ArcInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr ARCs und PAKs		*}
{* Definition:	Procedure ArcInfo;					*}
{************************************************************************}

Procedure ArcInfo;
Const    MetStr    : Array[0..11] of TString=
		     ('EOF-Tag   ','Stored old','Stored    ','Packed    ',
		      'Squeezed  ','crunched o','crunched  ','crunched S',
		      'Crunched  ','Squashed  ','Crushed   ','Distilled ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;

begin
   if (FBuf.ArcKen=$1a) then
     with Dir[Count]^ do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while ((FBuf.ArcKen=$1a) and (FBuf.ArcTyp<>0)) do begin
	 Adr:=Adr+FBuf.ArcCSi+29;
	 GeSi:=GeSi+FBuf.ArcUSi;
	 CoSi:=CoSi+FBuf.ArcCSi;
	 Inc(Anz);
	 if Met < FBuf.ArcTyp then Met:=FBuf.ArcTyp;
	 Seek(F1,Adr);
	 BlockRead(F1,FBuf,64,Test);
       end;
       FTyp:=6;
       if FBuf.ArcTyp <> 11 then Kurz:='ARC '
       else Kurz:='PAK ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:	ZipInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr ZIPs			*}
{* Definition:	Procedure ZipInfo;					*}
{************************************************************************}

Procedure ZipInfo;
Const    MetStr    : Array[0..11] of TString=
		     ('Stored    ','Shrinked  ','Reduced 1x','Reduced 2x',
		      'Reduced 3x','Reduced 4x','Imploded  ','Method 07 ',
		      'Inflated  ','Method 09 ','Method 10 ','Method 11 ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;

begin
   if ((FBuf.ZipKen=$4b50) and (FBuf.ZipTyp=$0403)) then
     with Dir[Count]^ do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while (FBuf.ZipTyp=$0403) do begin
	 Adr:=Adr+FBuf.ZilCSi+FBuf.ZilNSi+FBuf.ZilESi+30;
	 GeSi:=GeSi+FBuf.ZilUSi;
	 CoSi:=CoSi+FBuf.ZilCSi;
	 Inc(Anz);
	 if Met < FBuf.ZilMet then Met:=FBuf.ZilMet;
	 Seek(F1,Adr);
	 BlockRead(F1,FBuf,64,Test);
       end;
       FTyp:=6;
       Kurz:='ZIP ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:	LzhInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr LZHs und ICEs		*}
{* Definition:	Procedure LzhInfo;					*}
{************************************************************************}

Procedure LzhInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz       : Word;
begin
   if ((FBuf.LzhMet[1]='l') and (FBuf.LzhMet[2]='h')) then
     with Dir[Count]^ do begin
       Adr:=0;
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (FBuf.LzhHSi <> 0) do begin
	 Adr:=Adr+FBuf.LzhHSi+2+FBuf.LzhCSi;
	 GeSi:=GeSi+FBuf.LzhUSi;
	 CoSi:=CoSi+FBuf.LzhCSi;
	 Inc(Anz);
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,64,Test);
       end;
       FTyp:=6;
       Kurz:='LZH ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:='';
     end;
end;

{************************************************************************}
{* Routine:	ZooInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr ZOOs			*}
{* Definition:	Procedure ZooInfo;					*}
{************************************************************************}

Procedure ZooInfo;
Const    MetStr    : Array[0..3] of TString=
		     ('Stored    ','ZOO Norm. ','ZOO High  ','Reserved  ');
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz,Met   : Word;
begin
   if ((FBuf.ZooRe1[0]='Z') and (FBuf.ZooRe1[1]='O')) then
     with Dir[Count]^ do begin
       Adr:=FBuf.DummyA[$18];
       Seek(F1,Adr);
       Blockread(F1,FBuf,64,Test);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       Met:=0;
       while ((FBuf.ZooKe1 <> 0) or (FBuf.ZooUSi <> 0)) do begin
	 Adr:=FBuf.ZooOfs;
	 GeSi:=GeSi+FBuf.ZooUSi;
	 CoSi:=CoSi+FBuf.ZooCSi;
	 Inc(Anz);
	 if Met < FBuf.ZooKe1 then Met:=FBuf.ZooKe1;
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,64,Test);
       end;
       FTyp:=6;
       Kurz:='ZOO ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:=MetStr[Met];
     end;
end;

{************************************************************************}
{* Routine:	SqzInfo							*}
{************************************************************************}
{* Inhalt:	Extraktion von PFil und PPro fr SQZs			*}
{* Definition:	Procedure SqzInfo;					*}
{************************************************************************}

Procedure SqzInfo;
Var      GeSi,CoSi : Longint;
	 Adr       : Longint;
	 Anz       : Word;
begin
   if ((FBuf.DummyA[0]=$48) and (FBuf.DummyA[1]=$4C)) then
     with Dir[Count]^ do begin
       Adr:=8;
       Seek(F1,Adr);
       Blockread(F1,FBuf,64,Test);
       GeSi:=0;
       CoSi:=0;
       Anz:=0;
       while (FBuf.SqzTyp <> 0) do begin
	 if (FBuf.SqzTyp < 18) then Adr:=Adr+Fbuf.SqzCUS+3
	 else begin
	   Adr:=Adr+FBuf.SqzCSi+FBuf.SqzTyp+2;
	   GeSi:=GeSi+FBuf.SqzUSi;
	   CoSi:=CoSi+FBuf.SqzCSi;
	   Inc(Anz);
	 end;
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,64,Test);
       end;
       FTyp:=6;
       Kurz:='SQZ ';
       PFil:=Anz;
       PPro:=Round(100-((CoSi*100.0)/GeSi));
       PTyp:='';
     end;
end;

{************************************************************************}
{* Routine:	PTextInfo						*}
{************************************************************************}
{* Inhalt:	Extraktion von 						*}
{* Definition:	Procedure PTextInfo;					*}
{************************************************************************}

Procedure PTextInfo;
Var      Test      : Integer;
begin
   if (FileSize(F1)<250) then Test:=FileSize(F1)-1
   else Test:=250;
   while ((Test>=0) and (FBuf.DummyA[Test]>$06)) do Dec(Test);
   if (Test=-1) then
     with Dir[Count]^ do begin
       FTyp:=5;
       Kurz:='PTXT';
       TTit:='';
       if CFCompare(Addr(FBuf.Dummy0[0]),'%!PS-Adobe-') then begin
	 Kurz:='PS-x';
	 Kurz[4]:=FBuf.Dummy0[11];
       end;
       if CFCompare(Addr(FBuf.Dummy0[0]),'{\rtf') then begin
	 Kurz:='RTF ';
       end;
     end;
end;

{************************************************************************}
{* Routine:	WordInfo						*}
{************************************************************************}
{* Inhalt:	Extraktion von 						*}
{* Definition:	Procedure WordInfo;					*}
{************************************************************************}

Procedure WordInfo;
begin
   if ((FBuf.DummyA[0]=$31) and (FBuf.DummyA[1]=$BE)) then
     with Dir[Count]^ do begin
       FTyp:=5;
       if ((FBuf.DummyA[$60]<>0) and (FBuf.DummyA[$62]=0)) then Kurz:='WWRI'
       else Kurz:='WORD';
       TTit:='';
     end
   else PTextInfo;
end;

{************************************************************************}
{* Routine:	HelpInfo						*}
{************************************************************************}
{* Inhalt:	Extraktion von 						*}
{* Definition:	Procedure HelpInfo;					*}
{************************************************************************}

Procedure HelpInfo;
Const    WinHlpId  : Array[0..2] of Byte = ($3f,$5F,$03);
	 AdvHlpId  : Array[0..2] of Byte = ($4C,$4E,$02);
	 Os2HlpId  : Array[0..4] of Byte = ($48,$53,$50,$10,$9B);
Var      Adr       : Longint;
	 HAdr      : Byte;
	 P         : Boolean;
begin
   if BFCompare(Addr(FBuf),Addr(WinHlpId),2) then
     with Dir[Count]^ do begin
       FTyp:=5;
       Kurz:='WHLP';
       TTit:='';
       P:=False;
       Adr:=FBuf.DumLIn[1]+$37;
       Seek(F1,Adr);
       Blockread(F1,FBuf,256,Test);
       for HAdr:=0 to 240 do
	 if FBuf.Dummy0[HAdr] ='|' then begin
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'CONTEXT') then Kurz:='WH31';
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'TOMAP') then Kurz:='WH30';
	   if CFCompare(Addr(FBuf.Dummy0[HAdr+1]),'SYSTEM') then begin
	     Adr:=FWord(HAdr+8) + FBuf.DummyA[HAdr+10]*65536 + $15;
	     P:=True;
	   end;
	 end;
       if P then begin
	 if Kurz='WH31' then Inc(Adr,4);
	 Seek(F1,Adr);
	 Blockread(F1,FBuf,256,Test);
	 for HAdr:=0 to 19 do TTit:=TTit+FBuf.Dummy0[HAdr];
	 TTit:=TitStr(TTit);
       end;
     end
   else if BFCompare(Addr(FBuf),Addr(AdvHlpId),2) then
     with Dir[Count]^ do begin
       FTyp:=5;
       Kurz:='AHLP';
       TTit:='';
       for HAdr:=16 to 35 do TTit:=TTit+FBuf.Dummy0[HAdr];
       TTit:=TitStr(TTit);
     end
   else if BFCompare(Addr(FBuf),Addr(Os2HlpId),4) then
     with Dir[Count]^ do begin
       FTyp:=5;
       Kurz:='OHLP';
       TTit:='';
       for HAdr:=$6B to $7E do TTit:=TTit+FBuf.Dummy0[HAdr];
       TTit:=TitStr(TTit);
     end
   else PTextInfo;
end;

{************************************************************************}
{* Routine:	GetInfo							*}
{************************************************************************}
{* Inhalt:	Auswahl der Info-Routine anhand der File-Extension	*}
{* Definition:	Procedure GetInfo;					*}
{************************************************************************}

Procedure GetInfo;
Var      P,Test    : Integer;
	 E         : String[3];
begin
   with Dir[Count]^ do begin
     P := Pos('.', Name);
     if P > 1 then E := Copy(Name, P + 1, 3)
     else E := '';
     if (Attr and (Directory)) = 0 then begin   {Modifikat. F.Decker}
       if PrntT then Write(Name:8);
       Assign(F1,D+Name);
       Reset(F1,1);
       Test:=IOResult;
       if Test=5 then begin
	 Filemode:=64;
	 Reset(F1,1);
	 Test:=IOResult;
	 Filemode:=0;
       end;
       if Test=0 then begin
	 BlockRead(F1,FBuf,256,Test);
	 if PrntT then Write('...read');

	 if E = 'GIF' then GifInfo;

	 if E = 'PCX' then PcxInfo;

	 if E = 'DCX' then DcxInfo;

	 if ((E = 'BMP') or (E = 'DIB')) then BmpInfo;

	 if ((E = 'ICO') or (E = 'ICW') or (E = 'IC2') or 
	     (E = 'CUR') or (E = 'PTR')) then 
	   IcoInfo;

	 if E = 'RLE' then RleInfo;

	 if ((E = 'LBM') or (E ='IFF') or (E = 'BBM')) then LbmInfo;

	 if E = 'IMG' then ImgInfo;

	 if ((E = 'JPG') or (E = 'JIF')) then JpgInfo;

	 if E = 'MSP' then MspInfo;

	 if ((Copy(E,1,2) = 'SC') or (E = 'RIX') or (E ='VMG')) then SciInfo;

	 if E = 'FLI' then FliInfo;

	 if E = 'AVI' then AviInfo;

	 if E = 'CUT' then CutInfo;

	 if E = 'PIC' then PicInfo;

	 if E = 'TGA' then TgaInfo;

	 if E = 'RAS' then RasInfo;

	 if E = 'WPG' then WpgInfo;

	 if E = 'TIF' then TiffInfo;

	 if ((E = 'MAC') or (E = 'PNT')) then
	   MacInfo;

	 if ((E = 'DBF') or (E = 'DBK') or (E = 'CAT')) then DbfInfo;

	 if ((E = 'WKS') or (E = 'WK1') or (E = 'WQ1')) then WksInfo;

	 if ((E = 'EXE') or (E = 'DLL') or (E = 'DRV') or 
	     (E = 'FON') or (E = 'FOT') or (E = '386') or
	     (E = 'ADD') or (E = 'IFS') or (E = 'VBX') or
	     (E = 'CPL') or (E = 'VXD') or (E = 'FLT')) then
	   ExeInfo;

	 if E = 'COM' then ComInfo;

	 if ((E = 'NLM') or (E = 'DSK')) then
	   NlmInfo;

	 if E = 'VAP' then VapInfo;

	 if E = 'SYS' then DevInfo;

	 if E = 'GRP' then GroupInfo;

	 if ((E = 'PIF') or (E = 'DVP')) then
	   PifInfo;

	 if E = 'CMF' then CmfInfo;

	 if E = 'CMS' then CmsInfo;

	 if E = 'ORG' then OrgInfo;

	 if E = 'MOD' then ModInfo;

	 if E = 'ROL' then RolInfo;

	 if E = 'WAV' then WavInfo;

	 if E = 'VOC' then VocInfo;

	 if ((E = 'SND') or (E = 'TUN')) then
	   SndInfo;

	 if E = 'MID' then MidiInfo;

	 if ((E = 'TXT') or (E = 'WRI')) then
	   WordInfo;

	 if (E = 'HLP') then HelpInfo;

	 if ((E = 'ASM') or (E = 'PAS') or (E = 'CPP') or 
	     (E = 'LST') or (E = 'BAT') or (E = 'INI') or
	     (E = 'RTF') or (E = 'DOC') or (E = 'INC') or
	     (E = 'PS') or (E = 'C') or (E = 'H')) then
	   PTextInfo;

	 if E = 'ARJ' then ArjInfo;

	 if E = 'ZIP' then ZipInfo;

	 if ((E = 'ARC') or (E = 'PAK') or (E = 'SDN')) then ArcInfo;

	 if ((E = 'LZH') or (E = 'ICE')) then LzhInfo;

	 if E = 'ZOO' then ZooInfo;

	 if E = 'SQZ' then SqzInfo;

	 if (SSearch and (FTyp = 0)) then ExeInfo;
	 if (SSearch and (FTyp = 0)) then PTextInfo;

	 Close(F1);  {Mofifikation F.Decker}
	 if PrntT then Writeln('...OK!');
       end
     end;
   end;
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	- (keine Vorinitialisierung notwendig)			*}
{************************************************************************}

begin
end.
