{************************************************************************}
{* Programm:	AdvDirCol	(Advanced Dir - Color-Konfiguration)	*}
{************************************************************************}
{* Autor:	Thomas Mainka						*}
{* Stand:	18.Jan.1994						*}
{* Version:	0.10							*}
{************************************************************************}
{* Support-BBS:	MOEBIUS MAIL +49-911-4712969 (FIDO 2:2490/1517)		*}
{************************************************************************}
{* Module:	adircol.pas	0.04					*}
{************************************************************************}
{************************************************************************}
{* Modul:	adircol.pas						*}
{************************************************************************}
{* Inhalt:	Farb-Konfiguration fr ADir				*}
{************************************************************************}
{* Funktion:	Erstellen und Bearbeiten der Farb-Schema-Parameterdatei	*}
{*		fr mein Advanced Dir.					*}
{************************************************************************}
{* Version:	0.10							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	18.Jan.1994						*}
{* Vernderung:	Einfhrung des National-Language Supports mit Ausgabe	*}
{*		der Texte in Benutzersprache.				*}
{************************************************************************}
{* Revision:	0.02 Erste regulre Version				*}
{*		0.04 Anpassung der Demo-Texte an erweiterte Ausgabe	*}
{*		     innerhalb von ADIR.				*}
{*		     Korrektur der Men-berschriften (Sound<->Programm)*}
{************************************************************************}
{* Routinen:	AnsiLoad						*}
{*		AnsiSave						*}
{*		AnsiVal							*}
{*		AnsiImport						*}
{*		AnsiLn							*}
{*		AnsiExport						*}
{*		WCol							*}
{*		FilePrint						*}
{*		WCBar							*}
{*		WMenu2							*}
{*		UMenu2							*}
{*		Menu2							*}
{*		WMenu1							*}
{*		Menu1							*}
{************************************************************************}

Program AdirCol;
{$I-,S-}
{$M 8192,8192,655360}

uses dos,crt,nls,adcolstr;

Type     AnsiTyp   = record
                        NamCol : String[10];
                        ExtCol : String[10];
                        SizCol : String[10];
                        DatCol : String[10];
                        TimCol : String[10];
                        KurCol : String[10];
                        Ex1Col : String[10];
                        Ex2Col : String[10];
                        Ex3Col : String[10];
                     end;

         ColTyp    = Array[0..6,0..8,0..1] of Byte;

Const    AnsiStr   : Array[0..6] of AnsiTyp =
                       ((NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;37;44m';
                         Ex2Col:#$1B'[1;37;44m';
                         Ex3Col:#$1B'[1;37;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'),
                        (NamCol:#$1B'[1;37;44m';
                         ExtCol:#$1B'[1;33;44m';
                         SizCol:#$1B'[1;31;44m';
                         DatCol:#$1B'[1;35;44m';
                         TimCol:#$1B'[1;32;44m';
                         KurCol:#$1B'[1;36;44m';
                         Ex1Col:#$1B'[1;33;44m';
                         Ex2Col:#$1B'[1;33;44m';
                         Ex3Col:#$1B'[1;33;44m'));

         CConv     : Array[0..7] of Byte =
                     (0,4,2,6,1,5,3,7);

Var      Pause     : Boolean;
         S         : String;
         FTyp      : Byte;
         FCol      : Byte;
         Path      : PathStr;
         Lines     : Integer;
         Error     : Text;
         FColors   : ColTyp;
         Reg       : Registers;
         AF        : File of AnsiTyp;
         c,d       : Char;

{************************************************************************}
{* Routine:	AnsiLoad						*}
{************************************************************************}
{* Inhalt:	Ldt die mittels Enviroment-Variable "ADIRCOL" gewhlte *}
{*		Ansi-Sequenz-Tabelle.					*}
{* Definition:	Procedure AnsiLoad;					*}
{************************************************************************}

Procedure AnsiLoad;
Var      i         : Integer;
begin
   if ParamCount>0 then S:=ParamStr(1)
   else S:=GetEnv('ADIRCOL');
   if S='' then S:='ADIRCOL.CFG';
   Assign(AF,S);
   Reset(AF);
   i:=IOResult;
   if i = 0 then begin
     for i:=0 to 6 do Read(AF,AnsiStr[i]);
     Close(AF);
   end;
end;

{************************************************************************}
{* Routine:	AnsiSave						*}
{************************************************************************}
{* Inhalt:	Speichert die Ansi-Sequenz-Tabelle wieder in die	*}
{*		gewhlte Datei.						*}
{* Definition:	Procedure AnsiSave;					*}
{************************************************************************}

Procedure AnsiSave;
Var      i         : Integer;
begin
   Assign(AF,S);
   ReWrite(AF);
   if IOResult = 0 then begin
     for i:=0 to 6 do Write(AF,AnsiStr[i]);
     Close(AF);
   end;
end;

{************************************************************************}
{* Routine:	AnsiVal							*}
{************************************************************************}
{* Inhalt:	Erzeugung eines TP-Farb-Werts aus einer Ansi-Seqenz	*}
{* Definition:	Function AnsiVal(S:String):Word;			*}
{************************************************************************}

Function AnsiVal(S:String):Word;
Var      Par1,Par2 : Byte;
begin
   Par1:=0;
   Par2:=0;
   if ((Length(S)=10) and (S[1]=#$1B) and (S[2]='[')) then begin
     if S[3]='1' then Par1:=8;
     Par1:=Par1+CConv[Ord(S[6])-48];
     Par2:=CConv[Ord(S[9])-48];
   end
   else Par1:=7;
   AnsiVal:=Par2*256+Par1;
end;

{************************************************************************}
{* Routine:	AnsiImport						*}
{************************************************************************}
{* Inhalt:	Umwandlung der Ansi-Sequenzen aus der Parameterdatei in *}
{*		TP-Color-Werte.						*}
{* Definition:	Procedure AnsiImport;					*}
{************************************************************************}

Procedure AnsiImport;
Var      i         : Integer;
begin
   for i:=0 to 6 do begin
      FColors[i][0][0]:= Lo(AnsiVal(AnsiStr[i].NamCol));
      FColors[i][1][0]:= Lo(AnsiVal(AnsiStr[i].ExtCol));
      FColors[i][2][0]:= Lo(AnsiVal(AnsiStr[i].SizCol));
      FColors[i][3][0]:= Lo(AnsiVal(AnsiStr[i].DatCol));
      FColors[i][4][0]:= Lo(AnsiVal(AnsiStr[i].TimCol));
      FColors[i][5][0]:= Lo(AnsiVal(AnsiStr[i].KurCol));
      FColors[i][6][0]:= Lo(AnsiVal(AnsiStr[i].Ex1Col));
      FColors[i][7][0]:= Lo(AnsiVal(AnsiStr[i].Ex2Col));
      FColors[i][8][0]:= Lo(AnsiVal(AnsiStr[i].Ex3Col));
      FColors[i][0][1]:= Hi(AnsiVal(AnsiStr[i].NamCol));
      FColors[i][1][1]:= Hi(AnsiVal(AnsiStr[i].ExtCol));
      FColors[i][2][1]:= Hi(AnsiVal(AnsiStr[i].SizCol));
      FColors[i][3][1]:= Hi(AnsiVal(AnsiStr[i].DatCol));
      FColors[i][4][1]:= Hi(AnsiVal(AnsiStr[i].TimCol));
      FColors[i][5][1]:= Hi(AnsiVal(AnsiStr[i].KurCol));
      FColors[i][6][1]:= Hi(AnsiVal(AnsiStr[i].Ex1Col));
      FColors[i][7][1]:= Hi(AnsiVal(AnsiStr[i].Ex2Col));
      FColors[i][8][1]:= Hi(AnsiVal(AnsiStr[i].Ex3Col));
   end;
end;

{************************************************************************}
{* Routine:	AnsiLn							*}
{************************************************************************}
{* Inhalt:	Erzeugung einer Ansi-Sequenz aus einem TP-Farb-Paar	*}
{* Definition:	Function AnsiLn(Par1,Par2:Byte):String;			*}
{************************************************************************}

Function AnsiLn(Par1,Par2:Byte): String;
Var      S         : String;
begin
   S:=#$1B+'[';
   if (Par1>=8) then S:=S+'1;3'+chr(CConv[Par1-8]+48)+';4'
   else S:=S+'0;3'+chr(CConv[Par1]+48)+';4';
   S:=S+chr(CConv[Par2 mod 8]+48)+'m';
   AnsiLn:=S;
end;

{************************************************************************}
{* Routine:	AnsiExport						*}
{************************************************************************}
{* Inhalt:	Umwandlung der TP-Color-Werte in Ansi-Sequenzen fr die	*}
{*		Parameterdatei.						*}
{* Definition:	Procedure AnsiExport;					*}
{************************************************************************}

Procedure AnsiExport;
Var      i         : Integer;
begin
   for i:=0 to 6 do begin
      AnsiStr[i].NamCol:=AnsiLn(FColors[i][0][0],FColors[i][0][1]);
      AnsiStr[i].ExtCol:=AnsiLn(FColors[i][1][0],FColors[i][1][1]);
      AnsiStr[i].SizCol:=AnsiLn(FColors[i][2][0],FColors[i][2][1]);
      AnsiStr[i].DatCol:=AnsiLn(FColors[i][3][0],FColors[i][3][1]);
      AnsiStr[i].TimCol:=AnsiLn(FColors[i][4][0],FColors[i][4][1]);
      AnsiStr[i].KurCol:=AnsiLn(FColors[i][5][0],FColors[i][5][1]);
      AnsiStr[i].Ex1Col:=AnsiLn(FColors[i][6][0],FColors[i][6][1]);
      AnsiStr[i].Ex2Col:=AnsiLn(FColors[i][7][0],FColors[i][0][1]);
      AnsiStr[i].Ex3Col:=AnsiLn(FColors[i][8][0],FColors[i][0][1]);
   end;
end;

{************************************************************************}
{* Routine:	WCol							*}
{************************************************************************}
{* Inhalt:	Einstellung von Text-Color und -Backgr. ber Parameter	*}
{* Definition:	Procedure WCol;						*}
{************************************************************************}

Procedure WCol(i:Byte);
begin
   TextColor(FColors[FTyp][i][0]);
   TextBackground(FColors[FTyp][i][1]);
end;

{************************************************************************}
{* Routine:	FilePrint						*}
{************************************************************************}
{* Inhalt:	Farbiger Ausdruck der Beispielzeile entsprechend ADIR	*}
{*		ber TP-Textcolor.					*}
{* Definition:	Procedure FilePrint;					*}
{************************************************************************}

Procedure FilePrint;
Const    E         : Array[0..6] of String[3] = 
                       ('DAT','GIF','EXE','SND','DBF','HLP','ZIP');
Var      I, P, J   : Integer;
         Total     : Longint;
         T         : DateTime;
         Test      : Word;
         C         : Char;

begin
   T.Year:=1990;
   T.Month:=1;
   T.Day:=10;
   T.Hour:=0;
   T.Min:=8;
   T.Sec:=0;
   WCol(0);
   Write(UpStr(StrFilNam),' ');
   WCol(1);
   Write(E[FTyp], ' ');
   WCol(2);
   Write(54321: 8);
   WCol(3);
   Write(DateStr(T):10);
   WCol(4);
   Write(TimeStr(T):8);
   if FTyp=1 then begin
     WCol(5);
     Write(' G87a');
     WCol(6);
     Write(320:6,' x',200:4,' x',256:4);
     WCol(7);
     Write(16777216:10);
     WCol(8);
     Write('LZW':5);
   end;
     if FTyp=2 then begin
     WCol(5);
     Write(' WIN ');
     WCol(6);
     Write(StrExeTit:22);
     WCol(7);
     Write(2:3,'.03  ');
     Write('3');
     Write('P');
     Write('F');
   end;
   if FTyp=3 then begin
     WCol(5);
     Write(' SND ');
     WCol(6);
     Write(StrSngTit:22);
     WCol(7);
     Write(1:4);
     WCol(8);
     Write (1:4,':','32');
   end;
   if FTyp=4 then begin
     WCol(5);
     Write(' DBF ');
     WCol(6);
     Write(6:3,StrDbfFel);
     WCol(7);
     Write(20:6,StrDbfSat);
   end;
   if FTyp=5 then begin
     WCol(5);
     Write(' WHLP');
     WCol(6);
     Write(StrHlpTit:22);
   end;
   if FTyp=6 then begin
     WCol(5);
     Write(' ZIP ');
     WCol(6);
     Write(5:3,StrArcFil);
     WCol(7);
     Write(56:4,' % ');
     WCol(8);
     Write('Imploded  ');
   end;
   WriteLn;
   Lines := Succ(Lines);
end;

{************************************************************************}
{* Routine:	WCBar							*}
{************************************************************************}
{* Inhalt:	Darstellung des Farbbalkens im Untermen		*}
{* Definition:	Procedure WCBar;					*}
{************************************************************************}

Procedure WCBar;
begin
   Write(':':13);
   TextColor(0);
   Write('');
   TextColor(1);
   Write('');
   TextColor(2);
   Write('');
   TextColor(3);
   Write('');
   TextColor(4);
   Write('');
   TextColor(5);
   Write('');
   TextColor(6);
   Write('');
   TextColor(7);
   Write('');
   TextColor(8);
   Write('');
   TextColor(9);
   Write('');
   TextColor(10);
   Write('');
   TextColor(11);
   Write('');
   TextColor(12);
   Write('');
   TextColor(13);
   Write('');
   TextColor(14);
   Write('');
   TextColor(15);
   Write('');
   TextColor(7);
   Writeln(':');
end;

{************************************************************************}
{* Routine:	WMenu2							*}
{************************************************************************}
{* Inhalt:	Ausgabe des festen Men-Textes des Untermens		*}
{* Definition:	Procedure WMenu2;					*}
{************************************************************************}

Procedure WMenu2;
Var      i         : Byte;
begin
   GotoXY(1,1);
   Writeln(' ':9,StrTitLin);
   Writeln;
   Writeln(' ':18,FTyp+1,'. ',StrTypLin[FTyp+1]);
   Writeln;
   for i:=1 to 9 do
     Writeln('<':14,Char(i+64),'> ',StrColLin[i]);
   Writeln('<Z> ':17,StrColLin[10]);
   Writeln;
   Writeln(StrTxtCol,'<F3  F4>':61);
   WCBar;
   Writeln(StrHGrCol,'<F5  F6>':61);
   Writeln;
   Writeln;
   Writeln(StrFilNam,':');
end;

{************************************************************************}
{* Routine:	UMenu2							*}
{************************************************************************}
{* Inhalt:	Ausgabe des vernderlichen Men-Anteils vom Untermen	*}
{* Definition:	Procedure UMenu2;					*}
{************************************************************************}

Procedure UMenu2;
begin
   GotoXY(5,FCol+5);
   Write('-->');
   GotoXY(15+(3*FColors[FTyp][FCol][0]),16);
   Write('i');
   GotoXY(15+(3*FColors[FTyp][FCol][1]),18);
   Write('i');
   GotoXY(1,23);
   FilePrint;
   TextColor(7);
   TextBackground(0);
end;

{************************************************************************}
{* Routine:	Menu2							*}
{************************************************************************}
{* Inhalt:	Untermen mit Wahl des zu bearbeitenden Feldes und der	*}
{*		Farb-Einstellung.					*}
{* Definition:	Procedure Menu2;					*}
{************************************************************************}

Procedure Menu2;
Var      E         : Char;
begin
   ClrScr;
   repeat
     WMenu2;
     UMenu2;
     repeat until KeyPressed;
     d:=Readkey;
     if UpCase(D) in ['A'..'I'] then FCol:=Ord(Upcase(d))-Ord('A');
     if d=#00 then begin
        e:=ReadKey;
        if e=#62 then 
          FColors[FTyp][FCol][0]:=(FColors[FTyp][FCol][0]+1) mod 16;
        if e=#61 then 
          FColors[FTyp][FCol][0]:=(FColors[FTyp][FCol][0]+15) mod 16;
        if e=#64 then 
          FColors[FTyp][FCol][1]:=(FColors[FTyp][FCol][1]+1) mod 8;
        if e=#63 then 
          FColors[FTyp][FCol][1]:=(FColors[FTyp][FCol][1]+7) mod 8;
     end;
   until UpCase(d)='Z';
end;

{************************************************************************}
{* Routine:	WMenu1							*}
{************************************************************************}
{* Inhalt:	Ausgabe des Men-Textes fr das Hauptmen		*}
{* Definition:	Procedure WMenu1;					*}
{************************************************************************}

Procedure WMenu1;
Var      i         : Byte;
begin
   TextColor(7);
   TextBackground(0);
   ClrScr;
   Writeln(' ':9,StrTitLin);
   Writeln;
   Writeln(' ':16,S);
   Writeln;
   for i:=1 to 7 do
     Writeln('<':14,i,'> ',StrTypLin[i]);
   Writeln;
   Writeln('<9> ':17,StrTypLin[ 9]);
   Writeln('<0> ':17,StrTypLin[10]);
end;

{************************************************************************}
{* Routine:	Menu1							*}
{************************************************************************}
{* Inhalt:	Hauptmen mit Wahl des Datei-Typs			*}
{* Definition:	Procedure Menu1;					*}
{************************************************************************}

Procedure Menu1;
begin
   WMenu1;
   repeat
     repeat until KeyPressed;
     c:=ReadKey;
     if c in ['1'..'7'] then begin
       FTyp:=Ord(c)-49;
       FCol:=0;
       Menu2;
       WMenu1;
     end;
     if c='9' then begin
       AnsiExport;
       AnsiSave;
     end;
   until c='0'
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	Laden und Importieren des Farb-Schemas und Start des	*}
{*		Hauptmens						*}
{************************************************************************}

begin
   AnsiLoad;
   AnsiImport;
   Menu1;
end.
