{************************************************************************}
{************************************************************************}
{* Modul:	adsort.pas						*}
{************************************************************************}
{* Inhalt:	Quick-Sort des Advanced Directory			*}
{************************************************************************}
{* Funktion:	Sortierung der Dateien nach gewhlten Ordnungskriterien	*}
{*		ber Quicksort-Algorithmus.				*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* Datum:	10.Jan.1994						*}
{* Vernderung:	Vergrerung der MaxDirSize und des DirStack-Arrays	*}
{************************************************************************}
{* Revision:	0.10 Erste Public Beta-Version				*}
{*		0.12 berarbeitung und Zusammenfassung der "LESS"-	*}
{*		     Routinen zu einer einzigen Flag-gesteuerten	*}
{*		     Vergleichsroutine.					*}
{*		0.14 Korrektur der Variablen SLen von Word auf Integer	*}
{*		     zur Unterscheidung von kurzen Samples und langen	*}
{*		     Songs.						*}
{*		0.22 Anpassung von Variablen an die Aufnahme von ADAnsi	*}
{* 		0.24 Anpassung des DirRec-Types zur Untersttzung von	*}
{*		     gepackten Dateien.					*}
{*		0.32 Anpassung der Variablen zur Suche in Unterverz.	*}
{*		0.42 Anpassung der Variablen zur Erweiterten Suche und	*}
{*		     der Trouble-Sooting Ausgabe.			*}
{************************************************************************}
{* Routinen:	Less		(Local)					*}
{*		QuickSort						*}
{************************************************************************}

unit ADSort;
{$I-,S-}
{$M 8192,8192,655360}

interface

const
  MaxDirSize = 800;

Type     DirPtr    = ^DirRec;
         TString   = String[20];
         DirRec    = record
                       Attr: Byte;
                       Time: Longint;
                       Size: Longint;
                       Name: string[12];
                       Kurz: string[4];
                       case FTyp: Byte of
                         0: (Dumm: Array[1..25] of Byte;);
                         1: (GHor: Word;
                             GVer: Word;
                             GCol: Word;
                             GPal: Longint;
                             GGSI: Array[1..2] of Char;
                             GPac: Array[1..3] of Char;
                             GDum: Array[1..10] of Byte;);
                         2: (ETit: TString;
                             EVer: Word;
                             EFlg: Word;);
                         3: (STit: TString;
                             SIns: Word;
                             SLen: Integer;);
                         4: (DLen: Word;
                             DSat: Word;
                             DMem: Byte;
                             DInd: Byte;
                             DDum: Array[1..19] of Byte;);
                         5: (TTit: TString;
                             TDum: Array[1..4] of Byte;);
                         6: (PFil: Word;
                             PPro: Word;
                             PTyp: TString;);
                     end;
         DirList   = array[0..MaxDirSize - 1] of DirPtr;

Var      SortF     : Boolean;
         SortO     : Boolean;
         SortM     : Boolean;
         SortD     : Boolean;
         SortH     : Byte;
         PrntT     : Boolean;
         SSearch   : Boolean;
         Dir       : DirList;
         DirStack  : Array[0..200] of String[80];
         DSLast    : Integer;
         DSFrst    : Integer;
         Count     : Integer;

procedure QuickSort(L, R: Integer);

implementation

{************************************************************************}
{* Routine:	Less							*}
{************************************************************************}
{* Inhalt:	Bestimmung der Grer/Kleiner-Relation im Bezug auf die *}
{*		gewhlten Sortierkriterien.				*}
{* Definition:	Function Less(X,Y:DirPtr):Boolean;			*}
{************************************************************************}

function Less(X, Y: DirPtr): Boolean;
Var      Sort      : Boolean;
begin
  case (SortH and $07) of
    2: Sort := X^.Name < Y^.Name;
    3: Sort := X^.Name > Y^.Name;
    4: Sort := X^.Time < Y^.Time;
    5: Sort := X^.Time > Y^.Time;
    6: Sort := X^.Size < Y^.Size;
    7: Sort := X^.Size > Y^.Size;
    else Sort:=False;
  end;
  case (SortH and $18) of
    16: Sort := (Sort and (X^.Kurz = Y^.Kurz)) or (X^.Kurz < Y^.Kurz);
    24: Sort := (Sort and (X^.Kurz = Y^.Kurz)) or (X^.Kurz > Y^.Kurz);
    else begin end;
  end;
  case (SortH and $060) of
    64: Sort := (Sort and (X^.FTyp = Y^.FTyp)) or (X^.FTyp < Y^.FTyp);
    96: Sort := (Sort and (X^.FTyp = Y^.FTyp)) or (X^.FTyp > Y^.FTyp);
    else begin end;
  end;
  if (SortD) then
    Sort:= (Sort and ((X^.Attr and $10) = (Y^.Attr and $10))) or
           ((X^.Attr and $10) > (Y^.Attr and $10));
  Less := Sort;
end;

{************************************************************************}
{* Routine:	QuickSort						*}
{************************************************************************}
{* Inhalt:	Realisierung des Quick-Sort Algorithmus zum Sortieren	*}
{*		der Verzeichnisliste nach gewhlten Kriterien.          *}
{* Copyright:	Fa. Borland (Beispielprogramm)				*}
{* Definition:	Procedure QuickSort(L,R:Integer);			*}
{************************************************************************}

procedure QuickSort(L, R: Integer);
var
  I, J: Integer;
  X, Y: DirPtr;
begin
  I := L;
  J := R;
  X := Dir[(L + R) div 2];
  repeat
    while Less(Dir[I], X) do Inc(I);
    while Less(X, Dir[J]) do Dec(J);
    if I <= J then
    begin
      Y := Dir[I];
      Dir[I] := Dir[J];
      Dir[J] := Y;
      Inc(I);
      Dec(J);
    end;
  until I > J;
  if L < J then QuickSort(L, J);
  if I < R then QuickSort(I, R);
end;

{************************************************************************}
{* Routine:	Hauptprogramm						*}
{************************************************************************}
{* Inhalt:	- (keine Vorinitialisierung notwendig)			*}
{************************************************************************}

begin
end.
