{************************************************************************}
{************************************************************************}
{* Modul:	adstring.pas						*}
{************************************************************************}
{* Inhalt:	TextStrings fr National-Language Support in ADIR	*}
{************************************************************************}
{* Funktion:	Bestimmung der richtigen Textstrings in Abhngigkeit	*}
{*              der Country-Information bzw. der Enviromentvar. ADIRLANG*}
{************************************************************************}
{* Version:	0.50							*}
{* Autor:	Thomas Mainka						*}
{* bersetzer:	Peter Karlsson	(Schwedisch)				*}
{* Datum:	10.Jan.1994						*}
{* Vernderung:	Korrektur der englischen und schwdischen Texte.		*}
{************************************************************************}
{* Revision:	0.02 Erste Version (zu ADIR 0.44)			*}
{************************************************************************}
{* Routinen:	-							*}
{************************************************************************}
Unit ADString;
interface

Var      StrInvOpt : String;
         StrInvSOp : String;
         StrInvAOp : String;
         StrInvDOp : String;
         StrVolNam : String;
         StrVolVer : String;
         StrVolNoN : String;
         StrVolNum : String;
         StrDirHea : String;
         StrNoFile : String;
         StrNrFile : String;
         StrFilSpc : String;
         StrDskSpc : String;
         StrDirAbk : String[8];
         StrDbfSat : String;
         StrDbfFel : String;
         StrWksRow : String;
         StrWksCol : String;
         StrArcFil : String;
         StrPreKey : String;
         Language  : String[3];

implementation
uses nls,dos;

Var      S         : String;

begin   
   if ((Country=$2e) or (Country=$2f) or (Country=$2d)) then Language:='SWE'
   else 
     if ((Country=$01) or (Country=$2c) or (Country=$3d)) then Language:='ENG'
     else Language:='GER';

   S:=GetEnv('ADIRLANG');
   if S<>'' then Language:=Copy(UpStr(S),1,3);

   if Language='SWE' then begin
     StrInvOpt := 'Ogiltig vxel: ';
     StrInvSOp := 'Ogiltig sorteringsvxel: ';
     StrInvAOp := 'Ogiltig attributvxel: ';
     StrInvDOp := 'Ogiltig utmatningsformatsvxel: ';
     StrVolNam := ' Volym i enhet ';
     StrVolVer := ' r ';
     StrVolNoN := ' saknar etikett';
     StrVolNum := ' Volymen har serienummer ';
     StrDirHea := ' Katalog i ';
     StrNoFile := 'Fil saknas';
     StrNrFile := ' fil(er), ';
     StrFilSpc := ' byte, ';
     StrDskSpc := ' byte lediga';
     StrDirAbk := '<KAT>   ';
     StrDbfSat := ' sats. ';
     StrDbfFel := ' flt  ';
     StrWksRow := ' rader ';
     StrWksCol := ' kolum.';
     StrArcFil := ' filer';
     StrPreKey := 'Tryck valfri tangent...';
   end
   else if Language='ENG' then begin
     StrInvOpt := 'Invalid option: ';
     StrInvSOp := 'Invalid order option: ';
     StrInvAOp := 'Invalid attribute option: ';
     StrInvDOp := 'Invalid output format option: ';
     StrVolNam := ' Volume in drive ';
     StrVolVer := ' is ';
     StrVolNoN := ' has no label';
     StrVolNum := ' Volume Serial Number is ';
     StrDirHea := ' Directory of ';
     StrNoFile := 'File not found';
     StrNrFile := ' file(s), ';
     StrFilSpc := ' bytes, ';
     StrDskSpc := ' bytes free';
     StrDirAbk := '<DIR>   ';
     StrDbfSat := ' Record';
     StrDbfFel := ' Fields';
     StrWksRow := ' Rows  ';
     StrWksCol := ' Colum.';
     StrArcFil := ' Files';
     StrPreKey := 'Press any key...';
   end
   else begin
     StrInvOpt := 'Ungltige Option: ';
     StrInvSOp := 'Ungltige Sortier-Option: ';
     StrInvAOp := 'Ungltige Attribut-Option: ';
     StrInvDOp := 'Ungltige Ausgabe-Option: ';
     StrVolNam := ' Datentrger in Laufwerk ';
     StrVolVer := ' ist ';
     StrVolNoN := ' hat keinen Datentrgernamen';
     StrVolNum := ' Datentrgernummer:';
     StrDirHea := ' Verzeichnis von ';
     StrNoFile := 'Datei nicht gefunden';
     StrNrFile := ' Datei(en), ';
     StrFilSpc := ' Bytes, ';
     StrDskSpc := ' Bytes frei';
     StrDirAbk := '<DIR>   ';
     StrDbfSat := ' Stze ';
     StrDbfFel := ' Felder';
     StrWksRow := ' Zeilen';
     StrWksCol := ' Spalt.';
     StrArcFil := ' Files';
     StrPreKey := 'Bitte Taste drcken...';
   end;
end.
