{************************************************************************}
{************************************************************************}
{* Modul:       nls.pas                                                 *}
{************************************************************************}
{* Inhalt:      National Language Support                               *}
{************************************************************************}
{* Funktion:    Auswertung der Country-Informationen und Bereitstellung *}
{*              von Ausgaberoutinen, die Landes- und Sprachspezifische  *}
{*              Eigenheiten in der Darstellung von Informationen        *}
{*              bercksichtigen.                                        *}
{************************************************************************}
{* Version:     0.20                                                    *}
{* Autor:       Thomas Mainka                                           *}
{* Datum:       10.Jan.1994                                             *}
{* Vernderung: Erweiterung um UpStr-Routine auch fr Sonderzeichen     *}
{************************************************************************}
{* Revision:	0.10 Erste Version					*}
{*              0.12 Rckmeldung des Landes in der Country-Variablen    *}
{************************************************************************}
{* Routinen:    UpStr                                                   *}
{*              NumStr                                                  *}
{*              DateStr                                                 *}
{*              TimeStr                                                 *}
{*              CurrStr                                                 *}
{*              SetSwChar                                               *}
{*              GetSwChar                                               *}
{*              GetNLS                                                  *}
{************************************************************************}

Unit NLS;

interface

uses     Dos;
Type     NLSType   = record
                       DateFor : Word;
                       CurrSym : Array[1..5] of Char;
                       ThouSep : Char;
                       ThouSep2: Char;
                       DecPoin : Char;
                       DecPoin2: Char;
                       DateSep : Char;
                       DateSep2: Char;
                       TimeSep : Char;
                       TimeSep2: Char;
                       CurrFor : Byte;
                       CurrDig : Byte;
                       TimeFor : Byte;
                       UpCaOfs : Word;
                       UpCaSeg : Word;
                       ListSep : Char;
                       ListSep2: Char;
                       Reserved:Array[0..9] of Byte;
                     end;

Var      NLSDat    : NLSType;
         Country   : Word;
         SwiChar   : Char;

Function UpStr(S:String):String;
Function NumStr(N, D: Integer):String;
Function DateStr(Dat:DateTime):String;
Function TimeStr(Tim:DateTime):String;
Function CurrStr(Amount: Real;i,j: Integer):String;
Procedure SetSwChar(SChar:Char);
Procedure GetSwChar;
Procedure GetNLS(Cntry:Byte);

implementation

Var      Reg       : Registers;

{************************************************************************}
{* Routine:     UpStr                                                   *}
{************************************************************************}
{* Inhalt:      Erzeugung eines UpCase-Strings mit Sonderzeichen        *}
{* Definition:  Function UpStr(S:String):String                         *}
{************************************************************************}

Function UpStr(S:String):String;
Var      HStr      : String;
         i         : Integer;
         P1        : Pointer;
         C1        : Char;

begin
   HStr:=S;
   P1:=Ptr(NLSDat.UpCaSeg,NLSDat.UpCaOfs);
   for i:=1 to Length(S) do 
     if Ord(HStr[i])<128 then HStr[i]:=UpCase(HStr[i])
     else begin
       C1:=HStr[i];
       inline(
         $8A/$86/C1/
         $ff/$9e/P1/
         $88/$86/C1);
       {asm 
         mov  AL,C1
         call [P1]
         mov  C1,AL
       end;}
       HStr[i]:=C1;
     end;
   UpStr:=HStr;
end;

{************************************************************************}
{* Routine:     NumStr                                                  *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Ziffern-Strings mit Vornullen           *}
{* Copyright:   Fa. Borland (Beispielprogramm)                          *}
{* Definition:  Function NumStr(N,D:Integer):String;                    *}
{************************************************************************}

Function NumStr(N, D: Integer): String;
begin
  NumStr[0] := Chr(D);
  while D > 0 do begin
    NumStr[D] := Chr(N mod 10 + Ord('0'));
    N := N div 10;
    Dec(D);
  end;
end;

{************************************************************************}
{* Routine:     DateStr                                                 *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Datum-Strings mit num. Monatsangabe     *}
{*              und 2stelliger Jahresangabe                             *}
{* Definition:  Function DateStr(Dat:DateTime):String                   *}
{************************************************************************}

Function DateStr(Dat:DateTime):String;
Var      HString   : String;
begin
   case NLSDat.DateFor of
     0: HString:=NumStr(Dat.Month,2)+NLSDat.DateSep+
                 NumStr(Dat.Day,2)+NLSDat.DateSep+NumStr(Dat.Year mod 100,2);
     1: HString:=NumStr(Dat.Day,2)+NLSDat.DateSep+
                 NumStr(Dat.Month,2)+NLSDat.DateSep+NumStr(Dat.Year mod 100,2);
     2: HString:=NumStr(Dat.Year mod 100,2)+NLSDat.DateSep+
                 NumStr(Dat.Month,2)+NLSDat.DateSep+NumStr(Dat.Day,2);
   end;
   DateStr:=HString;
end;

{************************************************************************}
{* Routine:     TimeStr                                                 *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Uhrzeit-Strings mit Stunde und Minute   *}
{* Definition:  Function TimeStr(Tim:DateTime):String                   *}
{************************************************************************}

Function TimeStr(Tim:DateTime):String;
Var HString        : String;
    HHour          : Integer;
    AM_PM          : Char;
begin
   if NLSDat.TimeFor=1 then
     HString:=NumStr(Tim.Hour,2)+NLSDat.TimeSep+NumStr(Tim.Min,2)+' '
   else begin
     if Tim.Hour>12 then begin
       HHour:=Tim.Hour-12;
       AM_PM:='p';
     end
     else begin
       HHour:=Tim.Hour;
       AM_PM:='a';
     end;
     HString:=NumStr(HHour,2)+NLSDat.TimeSep+NumStr(Tim.Min,2)+AM_PM
   end;
   if HString[1]='0' then HString[1]:=' ';
   TimeStr:=HString;
end;

{************************************************************************}
{* Routine:     CurrStr                                                 *}
{************************************************************************}
{* Inhalt:      Erzeugung eines Whrungs-Strings                        *}
{* Definition:  Function CurrStr(Amount:Real; i,j:Integer):String;      *}
{************************************************************************}

Function CurrStr(Amount: Real;i,j: Integer):String;
Var      HStr      : String;
         PStr      : String[10];
         MCurr,Curr: Integer;
         TCurr     : Integer;
         KorrFak   : Real;
         F,l       : Integer;
begin
  if Amount<>0 then KorrFak:=Amount/Abs(Amount)*0.01
  else KorrFak:=0;
  With NLSDat do begin
    case CurrDig of
      0 : F:=1;
      1 : F:=10;
      2 : F:=100;
      3 : F:=1000;
    end;
    MCurr:=Abs(Trunc(Frac(Amount)*F+KorrFak));
    Curr:=Trunc(Frac(Amount/1000)*1000+KorrFak);
    TCurr:=Trunc(Amount/1000);
    if CurrDig<>0 then begin
      Str(MCurr,PStr);
      while Length(PStr)<CurrDig do PStr:='0'+PStr;
      HStr:=DecPoin+PStr;
    end
    else HStr:='';
    Str(Curr,PStr);
    if TCurr<>0 then begin
      Curr:=Abs(Curr);
      Str(Curr,PStr);
      While Length(PStr)<3 do PStr:='0'+PStr;
      HStr:=ThouSep+PStr+HStr;
      Str(TCurr,PStr);
    end;
    HStr:=PStr+HStr;
    PStr:='';
    l:=1;
    While CurrSym[l]<>#$00 do begin
      PStr:=PStr+CurrSym[l];
      l:=Succ(l);
    end;
    if CurrFor=0 then begin
      HStr:=PStr+HStr;
      While Length(HStr)<j+Length(PStr) do HStr:=' '+HStr;
    end
    else begin
      While Length(HStr)<j do HStr:=' '+HStr;
      case CurrFor of
        1 : HStr:=HStr+PStr;
        2 : HStr:=PStr+HStr;
        3 : HStr:=HStr+' '+PStr;
      end;
    end;
  end;
  While Length(HStr)<i do HStr:=' '+HStr;
  CurrStr:=HStr;
end;

{************************************************************************}
{* Routine:     SetSwChar                                               *}
{************************************************************************}
{* Inhalt:      Setzen des Switch-Characters                            *}
{* Definition:  Procedure SetSwChar(SChar: Char);                       *}
{************************************************************************}

Procedure SetSwChar(SChar: Char);
begin
   Reg.AX:=$3701;
   Reg.DL:=Byte(SChar);
   MsDos(Reg);
end;

{************************************************************************}
{* Routine:     GetSwChar                                               *}
{************************************************************************}
{* Inhalt:      Holen des Switch-Charakters                             *}
{* Definition:  Procedure GetSwChar;                                    *}
{************************************************************************}

Procedure GetSwChar;
begin
   Reg.AX:=$3700;
   MsDos(Reg);
   if (Reg.AH<>Byte(#$ff)) then SwiChar:=Char(Reg.DL)
   else SwiChar:='/';
end;

{************************************************************************}
{* Routine:     GetNLS                                                  *}
{************************************************************************}
{* Inhalt:      Holen der NLS-Informationen eines Landes                *}
{* Definition:  Procedure GetNLS(Country: Byte);                        *}
{************************************************************************}

Procedure GetNLS(Cntry: Byte);
begin
   Reg.AX:=$3800+Cntry;
   Reg.DS:=Seg(NLSDat);
   Reg.DX:=Ofs(NLSDat);
   MsDos(Reg);
   Country:=Reg.BX;
end;

{************************************************************************}
{* Routine:     Unit-Hauptprogramm (Initialisierung)                    *}
{************************************************************************}
{* Inhalt:      Holt die aktuell gesetzte Country-Information           *}
{************************************************************************}

begin
   GetNLS(0);
end.
