
 ============================
 === THE ELECTRONIC GAMER ===
 ============================

 DUNGEON MASTER Walkthru

 INTRODUCTION

 From the Chronicles of Theron

 Now that the Grey Lord has been restored, he has asked me to document the
means we used to defeat Lord Chaos. It is our hope that others who read
this tale may gain the wisdom that would be sorely needed should the menace
of Chaos ever return. Since one never knows which scraps of information
will prove most valuable to others, I will attempt to cover as many details
of our adventure as possible. In addition to describing the monsters we
faced and the mysteries that were solved, I am also including general
information on the items we found, as well as the spells that were
discovered.

 Before recounting the events that transpired in the dungeon, I will cover
some general areas of importance. These are topics that proved to be
significant -- not in specific instances so much as they were keys to the
group's success throughout their ordeal.

 MAPPING

 As the party progressed, they made a painstakingly detailed map of each
level of the dungeon. Making this map was extremely difficult due to the
twisted nature of the mazes. There were illusionary walls that could only
be discovered by walking into them, as well as sections of wall that would
disappear after we activated the proper mechanisms. There were dozens of
devices that served to trigger various traps or other hidden mechanisms.
The group quickly learned that virtually every section of wall and floor
would need to be examined in order to successfully explore the dungeon.
Whenever a new item, trap, or device was found, the location was marked on
the map. This map constantly served as a guide through the labyrinth and
saved their lives many times. Any individual embarking on a similar venture
would be advised to make a similar map of their own surroundings.

 BALANCE

 Perhaps the most basic concept in all of this world is that of balance.
Only those who have achieved balance are truly whole. The Grey Lord's lack
of balance nearly destroyed the world. Only by seeking balance were the
champions who undertook this quest able to gain the power to overcome Chaos.
Each individual needed to advance in the four classes: Fighter, Ninja,
Priest, and Wizard. Only a champion skilled in all these areas realized his
true potential. If one advanced only as a Fighter, for example, he would
soon find that by ignoring the other three skills, he had made himself a
much weaker warrior than he might have been. Such a man will find that the
dexterity and health he gains when he progresses as a Ninja will aid him
greatly.

 There are also times when force of arms is not sufficient and the spells of
a Wizard are needed. Likewise, an aspiring Wizard will find great comfort
in the added strength and vitality that advancement as a Fighter will grant
him, as well as the healing powers of priesthood. True understanding only
comes to one who ceases to think of himself as a Fighter or Priest and who
wishes to augment his abilities with powerful champion, indeed.

 Once a champion has chosen to strive for balance he must learn how to
attain it. Gothmog, Hissssa, Leif, and Sonja provide outstanding examples
of people who did what needed to be done in order to succeed. These four
individuals came together to form a team. The needs or wants of each was
made secondary to the needs of the group. If Leif and Hissssa were up front
doing the hand-to-hand fighting, Gothmog and Sonja would throw darts, shoot
arrows, or cast spells to soften the enemy. The party used many methods to
help them achieve balance; the more basic ones are described below.

 The easiest class to maintain balance in was that of Fighter. When one of
the front line members would advance a level as a Fighter, that person
would immediately trade places with one of the members in the back row. In
this way, no member would be more than one level higher than the others.
Spellcasting was also relatively easy in which to achieve balance. Each
member constantly practiced spellcasting, even as they walked through the
halls of the dungeon. In the beginning, two members practiced Priest spells
while the other two practiced Wizard spells. When a person advanced a level
in one of these skills, he would immediately switch to the other class.

 Spellcasting is such an intricate task that the group quickly learned to
practice spells whenever the mana was available even if it meant "wasting"
attack spells on the dungeon walls. The champion who had the most difficult
time advancing as a spellcaster was Sonja. She carried only a minimal
amount of mana at the time of her reincarnation. Because of her
exceptionally low mana, virtually all of even the most simple spells were
denied her. Through experimentation, she did learn that she was able to
invoke the syllables LO-YA if she rested between syllables. By attempting
to cast this spell over and over, she eventually gained some small skill as
a Priest.

 Through continued perseverance, Sonja became as powerful a spellcaster as
any champion in the group. While it seemed almost obsessive, this practice
was well rewarded. Each of the four champions grew quite powerful both as
Wizards and Priests. This power served the team well when it encountered
the monstrosities in the lower levels of the dungeon. Healing potions were
consumed in great quantity, and the powerful attack spells they rained upon
their opponents saved them on several occasions.

 The most difficult skill to continue advancing in was the path of the Ninja.
During combat, the two members in the rear would shoot arrows or throw
objects. As time went on, however, missile combat alone was not enough to
provide sufficient practice to advance at the same pace as the group was
progressing in the other skills. Against weaker opponents, the champions on
the front line would sheathe their swords and fight barehanded to hone
their Ninja skills. Since this practice was not advisable against many
opponents, the party was forced to engage in training sessions to gain
enough practice in the Ninja skill.

 To begin a training session, the party would find an area that was
relatively safe from surprise attacks. The sessions were essentially a
lengthy mock combat. The group would begin by practicing spells until each
member had exhausted their mana. While the group was waiting to recover
mana, the members would begin throwing objects against a nearby wall (to
practice Ninja skills) or swinging a weapon through the air (to practice
Fighter skills) until the mana was fully restored. They seemed to learn
more slowly from this type of practice than from actual combat, but they
did progress. The group would repeat this cycle until the members felt they
had learned enough. These training sessions tended to be somewhat lengthy
and the party always made certain that there was plenty of food and water
on hand before beginning.

 LEVEL ONE

 With the words of Lord Librasulus still ringing in my ears, I proceeded
into the dungeon. The burden of choosing which champions would live again
was a heavy one. After studying each of the individuals enshrined in the
Hall of Champions, I began to form some opinions on which champions would
prove most able to complete the quest. Halk looked to be a powerful warrior
but his complete lack of mana meant that he would be far too limited to be
of any real help. Tiggy was the exact opposite of Halk. Tiggy had
outstanding potential as a Wizard and Priest but was so weak physically
that I knew another champion would be better suited to the task ahead.

 After eliminating those champions that were essentially one-dimensional,
there were many that still looked promising. After much deliberation, the
four champions were finally selected.

 Hissssa was chosen because he possessed the greatest physical strength and
showed sufficient potential in other areas as well.

 Sonja was selected for her strength as well as outstanding overall balance
in her other attributes. Sonja's very low mana almost dissuaded me from
selecting her; however, through constant practice I knew that she could
quickly match the others in spellcasting ability.

 Gothmog was selected for his resistance to spells in addition to his
overall attributes in the other areas.

 Finally, Leif was not outstanding in any one category but was well above
average in all of them. This balance made him well suited to contribute to
any needs the party might have.

 For those who may be interested in the champions that rested in the hall, I
have compiled the following list. While the champions I selected proved
their worth admirably, there were many legendary figures in the hall that
might have served equally well.

LEVEL
NAME     H  S  M St  D  W  V AM AF F N P W  ITEMS
----------------------------------------------------------------------
Alex    50 57 13 44 55 45 40 35 40 0 3 0 2 Leather Pants and Jerkin,
Boots, Sling
Azizi   61 77  7 47 48 42 45 30 35 2 3 0 0 Barbarian Hide, Halter,
Hide Shield, 2 Daggers
Boris   35 65 28 35 45 55 40 45 40 0 2 0 3 Leather Boots and Pants,
Tunic, Rabbit's Foot
Chani   47 67 20 37 47 57 37 47 37 2 0 0 3 Moonstone, Shirt, Sandals
Daroou 100 65  6 50 30 35 45 30 45 3 0 0 1 None
Elija   60 58 22 42 40 42 36 53 40 2 0 3 0 Magic Box, Robe, Sandals
Gando   39 63 26 39 45 47 33 48 43 0 3 0 2 Leather Pants and Jerkin,
Boots, 2 Poison Darts
Gothmog 60 55 18 40 43 48 34 50 59 0 0 0 4 Cloak of Night
Halk    90 75  0 55 43 30 46 38 48 4 0 0 0 Berserker Helm, Sandals,
Barbarian Hide, Club
Hawk    70 85 10 45 35 38 55 35 35 2 0 3 0 Leather Pants and Jerkin,
Suede Boots, 2 Arrows
Hissssa 80 61  5 58 48 35 35 43 55 3 2 0 0 None
Iaido   48 65 11 43 55 40 35 45 50 3 0 2 0 Samurai Sword, Ghi,
Ghi Trousers
Leif    75 70  7 46 40 39 50 45 45 3 0 2 0 Leather Jerkin and Boots
Leather Pants
Leyla   48 60  3 40 53 45 47 45 35 0 4 0 0 Leather Pants and Boots,
Silk Shirt, Rope
Linflas 65 50 12 45 45 47 35 50 35 3 0 0 2 Elven Boots and Doublet
Elven Huke, Bow
Mophus  55 55 19 42 35 40 48 40 45 0 0 4 0 Sandals, Robe, Apple,
Cheese, Bread
Nabi    55 65 15 41 36 45 45 55 55 0 0 3 2 Tunic, Pants, Sandals,
Staff
Sonja   65 70  2 54 45 39 49 40 40 4 0 0 0 Halter, Gunna, Choker,
Sandals, Sword
Stamm   75 80  0 52 43 35 50 35 55 4 0 0 0 Leather Pants, Tunic, Axe,
Suede Boots
Syra    53 72 15 38 35 43 45 42 40 0 0 2 3 Elven Doublet, Tabard,
Apple
Tiggy   25 45 36 30 45 50 35 59 40 0 2 0 3 Gunna, Kirtle, Sandals,
Wand
Wu Tse  45 47 20 38 35 53 45 47 40 0 2 3 0 Silk Shirt, 3 Throwing
Stars, Sandals, Tabard
Wuuf    40 50 30 33 57 45 40 35 40 0 3 2 0 Leather Jerkin, Flask
Zed     60 60 10 40 40 40 50 40 40 2 2 2 2 Mail Aketon, Hosen, Pants,
Torch

 The key to the above table is as follows: H=Health, S=Stamina, M=Mana, St=
Strength, D=Dexterity, W=Wisdom, V=Vitality, AM=Anti-Magic, AF=Anti-Fire, F=
Fighter, N=Ninja, P=Priest, W=Wizard.

 Levels of Advancement: 1 - Neophyte     9 - LO Master
2 - Novice      10 - UM Master
3 - Apprentice  11 - ON Master
4 - Journeyman  12 - EE Master
5 - Craftsman   13 - PAL Master
6 - Artisan     14 - MON Master
7 - Adept       15 - Arch Master
8 - Expert

 Having decided which champions would pursue our goals, I was now faced with
the choice of how to revive them. Resurrection had the advantage of
allowing the heroes to retain their prior knowledge and experience, thereby
making the group more powerful at the beginning of the quest. Reincarnation,
on the other hand, had two significant advantages. First, the attributes of
each champion are raised at the time of reincarnation to compensate for the
loss of experience. Second, as the heroes regain their prior levels of
experience, their health, mana, and other attributes will continue to rise.
The net result is that in a short period of time not only will a
reincarnated champion regain his prior level experience, but he will be far
more powerful overall than if he had simply been resurrected. The choice
seemed clear. While resurrection would serve the party well initially, only
reincarnation would allow the group to realize its full potential in the
long run.

 Having settled on a definite course of action, I immediately reincarnated
the party. It quickly became obvious that the group was oblivious to my
presence. Since they had lost all memory of their prior lives, there was a
great deal of confusion at first. Desperate to get the expedition moving
toward its goal, I attempted to tell Gothmog what needed to be done. I
failed to communicate directly but I somehow managed to project a few
fragmented images directly into his mind. While the message was very
confused, he did manage to pick up the two most important elements of the
quest. He explained his sudden vision to the group and related to them the
need to recover the Firestaff and warned of the menace of Lord Chaos. The
others interpreted his vision as an omen and promptly named him leader of
the expedition.

 Upon settling things in the Hall of Champions the group stepped on a
pressure plate that opened an iron gate. Beyond the gate they found several
pieces of food and an Altar of Vi. If one of the champions were killed,
placing his bones on the altar would serve to resurrect him, although the
revived champion would find himself somewhat weaker than before his death.
No foes were found on this floor so the group was free to explore the area
quickly. Having accomplished this, the party descended the stairs, little
imagining the terrors awaiting them below.

 LEVEL TWO

 As the party descended the stairs, they could see nothing but darkness
ahead. The gloom before them was completely impenetrable. After a moment
Hissssa began to light the torch we had found upstairs. Upon seeing this,
Gothmog advised Hissssa to extinguish his torch. The others cried out in
dismay until Gothmog explained to them that they should use the information
on the scroll they had found upstairs. After all, the group possessed only
one torch, had no way of knowing if they would find any additional ones,
and it was certainly doubtful that there would be enough brands to see the
group safely through the entire dungeon. Further, Gothmog argued, casting
the magic torch spells would help the party begin to learn the art of
Wizardry. Since such power would doubtless come in handy, the sooner they
started the better. The others immediately saw the wisdom of his arguments
and acquiesced.

 The first area explored was that to the right of the stairway. Almost
immediately the group noticed two things. The first was a club lying in
front of an iron gate. Since only Sonja had been armed at this point,
Hissssa felt much more confident now that he had a weapon in hand.
Unfortunately, they also saw that there was a mummy waiting for them on the
other side of that same gate. The sight of the gruesome creature filled the
group with a feeling of dread and loathing. Despite their obvious fear,
Sonja opened the gate and the party immediately attacked. The battle was
brief but furious. The mummy groped for Hissssa and staggered him with a
powerful blow. Sonja hacked away at the undead thing with her sword;
Hissssa quickly recovered his balance and began battering it with his
newfound club. As the two warriors pressed the attack, it soon became
apparent that the mummy was no match for them. Suddenly, the mummy burst
into a cloud of ash leaving all four champions momentarily dumbfounded.

 As the ash settled to the floor, they realized that they had utterly
destroyed the creature. Elated that they had emerged victorious from their
first battle, the group let out a shout of exultation. Their jubilation was
short lived as they heard their shouts echo through the lonely corridors
beyond. As the four champions looked at each other, they all realized they
had just alerted every creature within hundreds of yards of their presence.
Feeling somewhat subdued by their folly, the party resolutely searched the
area and found more weapons as well as food. As Hissssa removed a sword
from its secret alcove, his confidence was bolstered still more. Not only
had the party made its first kill, but now everyone in the group was armed.
Buoyed by their new weapons as well as their successful initiation into
battle, the champions left the area not only with higher morale but also a
greater maturity.

 The group found many apparently impassable doors as they wound their way
through the maze. As they continued to explore and map the maze, they
discovered the keys to these doors could be found in nearby areas. Through
continued exploration and returning to these locked doors, the party
eventually penetrated all of these passages. It was in this area that the
party first encountered a creature that would prove to be very significant.
The creature looked like a giant green mushroom and was known as a Screamer.
When these monsters are killed, they disintegrate into a pile of edible
screamer slices. These slices were an extremely useful supplement to the
other food found as the champions traveled through the dungeon.

 Shortly after passing through one door, the champions encountered a room
30'x30' that had a pressure plate on each of the 9 sections of floor.
Beyond the room was a pair of iron gates. Stepping on each plate would
activate one of the gates. The party took the following path through the
room. Upon entering the room they stepped on the first pressure plate, then
took a step backward, then stepped forward into the room once again. They
then took a step to the right, then forward twice. Finally, they stepped to
the left and then forward to exit.

 "Step inside; take a ride." The party found a shimmering blue field near
this message carved into the wall. Needless to say, all were skeptical
about blindly following the instructions. Their fears were not eased when
they threw a torch into the field only to have it disappear before their
eyes. Unfortunately, the group was at an apparent dead end with a locked
door nearby and no key to open it. It was clear if they wished to continue
exploring, they would have to take a chance on the blue field. They could
only pray that it would not prove to be some sort of lethal magic.
Gathering their courage, the four champions joined hands and jumped into
the field. They experienced great relief when they emerged on the other
side of the teleportation field. The group picked up the torch they had
thrown as well as a key and an apple. Since there was nothing else in the
small room, they stepped into another blue field identical to the one that
had sent them here. The group was not surprised to emerge back at the
initial field. Using the key they had found, the party continued on its way.

 After passing through the door, the party found a pressure plate and a pit
shortly after that. When the group stepped on the pressure plate the pit
closed. When the group stepped off the plate to continue, the pit
immediately reopened. The group was briefly puzzled as to how to proceed.
After a moment's thought, Gothmog removed a scroll from his pocket and set
it down upon the plate. With the weight of an object resting on the plate,
the pit remained closed and the party made its way safely past.

 As the champions made their way through a hallway, they stepped on a
pressure plate from which they could see writing on a wall ahead. However,
the inscription disappeared when they stepped forward to read it.
Remembering that they had found it necessary to leave items on two earlier
pressure plates to open passageways, Leif suggested they drop an item on
this one as well. As he suspected, they found that when they dropped a
torch on the plate the writing remained on the wall when they stepped
forward. They read the message there with some chagrin before retrieving
their torch.

 The party next entered a large room with several valuable items in it.
While the exit door was closed, they found a large button that opened the
way out. In their haste to leave, the group stepped on a pressure plate
between the button and the exit. The exit door closed immediately when the
plate was stepped on. The group pushed the button again and was careful to
avoid the plate on the way out. The party next found a hallway with levers
on each end. The way was cleared only by pulling both levers. Upon leaving
this hallway, the group was faced with a hallway branching off into two
different directions. Taking the path to the right, the champions made
their way to a blue field identical to the one they had seen before. They
stepped into it and were surprised that there was no apparent affect. On a
hunch, Sonja tried dropping a dagger she was carrying. The dagger
disappeared and a passage opened up nearby. As the group explored the newly
opened area, they recovered the dagger as well as two other items that
would prove to be very useful.

 "This fountain accepts one wish." Gothmog was certain this riddle was some
kind of trick. The answer seemed so obvious, he couldn't believe it was
really true. Nevertheless, he dropped a copper coin into the fountain. The
door immediately opened much to Gothmog's surprise and delight. As the
group entered this new area they immediately passed a closed gate with a
sword behind it. Passing on, they came to a room with a lever in the wall.
Hissssa pulled the lever and the sound of a gate was heard by all. The
party returned to the gate they had just passed to find it open. They
entered and took the sword. They also found a lever on the wall near the
sword. They pulled on the lever, but there was no apparent effect. Somewhat
disappointed they returned to the room with the first lever. They were
surprised to find that a section of wall had disappeared revealing a new
passageway. Obviously, pulling the second lever had had an effect after all.

 Once the party had gathered all the treasure in the vicinity, they
journeyed on. They found that it was only a short way to the stairs leading
to the next dungeon level. The group made it to the stairs without major
incident and prepared to descend.

 LEVEL THREE

 Each of the four champions felt a surge of pride as they descended the
stairs into this new level. Leaving behind the prior level gave the party a
sense of real progress and accomplishment. The group found a long hallway
waiting for them at the foot of the stairs. After taking several steps down
the hallway, they found a small button on the wall to their left. When they
pushed the button, a nearby section of wall disappeared revealing a
passageway beyond. In this passage were numerous food items as well as
armor. In addition, there was a blinking blue field at the end of the hall.
The party tried to walk through it but they were instantly teleported back
up the hallway.

 Moving more cautiously this time, they approached the field again. This
time they watched the field blink in and out of existence until they had a
sense of its timing. Waiting for the perfect moment, they rushed forward
and passed through the area of the field before it could reappear. In the
space beyond they found a compass that proved to be of tremendous value in
navigating the dungeon corridors as well as mapping them.

 CHAMBERS OF THE GUARDIAN

 After entering this area, the group encountered an unfamiliar monster that
appeared to be living rock. This rock monster was very resistant to their
weapons and inflicted poisonous wounds with its bite. The party patiently
whittled away at the monster while drinking healing potions. When the two
healing potions on hand were both consumed, Hissssa created more so Gothmog
and Leif could continue to press the attack. When the fight was over, they
quickly drank an antidote to the creature's poison and continued.

 The group discovered a long hallway with many closed gates. Behind one gate
was a chest. The party pressed a button on the wall in an effort to open
the gate and claim the chest. To their surprise the chest disappeared in a
flash of blue. They quickly discovered that the chest had reappeared behind
another gate. Pushing the button to the left of this gate caused the chest
to disappear a second time. The group continued this process and the chest
disappeared several times before finally appearing at the end of the
hallway. The group found a mirror in the chest. They held this mirror up to
the "eye" on the north wall of the hallway. This opened up a new area in
which they found one of the keys needed to leave this level.

 THE VAULT: CAST YOUR INFLUENCE, CAST YOUR MIGHT

 This was a two step puzzle. To cast influence, Leif threw a ZO spell at the
gate ahead. To cast might, Hissssa threw a torch in the same direction. The
torch landed on a pressure plate that closed the pit and the party was free
to continue. They immediately found a silver coin in a small alcove. When
Sonja took the coin, the door leading further in closed immediately. She
tried placing a torch into the alcove and the door reopened. With the way
cleared, the group delved further into the area and found a chest with some
coins and a magical box. Gothmog took one of the copper coins and inserted
it into a slot on the wall. A new passage appeared and they discovered a
button on the wall inside. Pushing the button opened up a second secret
area to the southeast. In this new area they found several useful items
including the second key that would help them leave this level.

 THE MATRIX
 
 This area was a peculiar maze that held many areas which would magically
"spin" the party to face a different direction than they previously had
been. While this confused the party immensely, Gothmog eventually managed
to map out a path through all of these "spinners." The group found an arrow
directly to the south upon entering the maze. They proceeded south and
discovered an illusionary wall hiding some food and a shield. Since there
were no "spinners" along the east wall, retrieving these items proved to be
a simple task. The party returned to the maze entrance and prepared to
explore its remaining areas. After considerable experimentation, they
finally found the following safe path through the maze. First, they took
two steps north from the maze entrance. They then proceed to the west six
paces where they found some food. From there, they went four steps south
and entered an alcove to the west. In the alcove was a button that revealed
a secret area to the south when pushed. The group left the alcove and
continued south to the newly opened area where they discovered another key
as well as a powerful sword.

 TIME IS OF THE ESSENCE

 Following the instructions on the wall, the party pushed a large blue
button and ran down the hallway. Just before they reached the passage at
the end of the hall, a wall suddenly materialized in front of them to block
the way. A determined group marched back to the button to try again. This
time they started running the instant the button was pushed. They rushed
through the portal mere moments before the wall materialized behind them.
Shortly after this, they found another large button that caused a blue
field to appear to the north. After pushing the button, Hissssa quickly
threw a torch into the field and a trapdoor that had been blocking the
group's progress closed. Next, the group found yet another blue button that
briefly closed a pit when pushed. They found that the only way to get past
the pit before it reopened was to run backward the instant the button was
pushed. The remainder of this area was explored with little incident, and
the group easily recovered the key that lay in the most distant passages.

 ROOM OF THE GEM

 "Step right up." The champions stepped forward off the pressure plate with
some trepidation and found that a pit had opened beneath their feet. Their
only consolation for this blunder was finding a drumstick on the floor of
the pit. After leaving the pit, the party left a torch on the pressure
plate and stepped forward again. This time, the floor remained firm and
they passed unharmed. They explored the corridors beyond this area for some
time before finding a button on the wall of an alcove. Pushing the button
opened the way to a large gem. Taking the gem back to the area where they
first entered the "Room of the Gem," they placed the gem into the hole in
the wall. The nearby door opened and the group gained the treasure that lay
beyond which included a gold key.

 CREATURE CAVERN

 There were no tricks or puzzles to solve in this area. Unfortunately, there
were numerous monsters that the champions had to defeat. After several
trying battles, the party claimed the final gold key, and left the area.

 Having gathered all the gold keys and explored each of the six areas
adjacent to the central hub of this level, the group returned to the
corridor off of the entrance stairs. Proceeding east down the corridor led
to a series of doors which the gold keys unlocked. Immediately after these
three doors, there was a small alcove which held a RA key. The group was
unaware of it at the time, but this was one of four RA keys that would be
needed to free the Firestaff from its resting place.

 Near the exit stairs to this level was a door that opened into a small room.
On the east wall of this room was a button. Pushing the button had no
visible effect, but when the champions left the room, they discovered a
passage had opened to the east. They happily claimed some food and a sword
from this secret area.

 Finally, the party decided to take stock before descending the stairs to
the fourth level. The party had more than three full chests of food
accumulated, more than enough to allow them to tarry for while. However,
the water was beginning to run low. The champions decided to make a quick
visit back up to the second dungeon level to use one of the fountains there
to replenish their water supply. They also decided they could have
performed better in the numerous combats in the Creature Cavern. Since they
had plenty of food and water, they decided to do some training to try and
improve their combat and spellcasting skills. After they had made some real
progress, they restocked their water supply once again, and made their way
down the stairs to the next level.

 LEVEL FOUR

 Upon entering this level, the party found a crossroads with one passage
leading north and the other leading west. They decided to explore to the
north first and then return to see where the other path led. The north path
quickly moved west and they learned in fairly short order that the path was
a dead end. After exploring the entire area and gathering the items they
had discovered, they returned to the crossroads. Taking the west path this
time they came to a closed wooden door with an axe lying nearby. With a
wicked grin on her face Sonja snatched the axe from the ground. She swung
the axe with all her might and the door exploded into splinters.

 The group passed into a long hallway with a closed gate at the end. As the
party walked down the hallway, they stepped on a small pressure plate that
opened the gate. Unfortunately, as they stepped forward they triggered a
second plate that closed the gate. Taking a step backward, the gate
reopened. The champions looked around and discovered a button on the south
wall. After some experimentation, they discerned the button's purpose. They
pushed the button and dashed down the hallway without delay clearing the
gate just as it closed behind them.

 While the party was exploring the area beyond the gate, Leif thought he saw
something out of the corner of his eye. The party was only three steps west
of the gate and one step north when this happened. Upon closer examination,
he found a gold key lying in the drain on the south wall.

 Immediately after finding the key, the party was startled to see a floating
apparition approaching them. Panic held them for a moment as they saw their
weapons pass through the ghost with no apparent effect. Suddenly, Gothmog
recalled a scroll they had found earlier and cast the DES EW spell. The
creature was instantly dissipated much to the relief of everyone in the
group.

 The party continued to explore and headed south. After going a short
distance, they discovered a pair of giant purple worms. After the encounter
with the ghost, the group was relieved to see solid foes they could strike
with weapons. This relief turned to terror as their blows seemed to have
little effect, while the worms were inflicting horrible wounds with the
razor sharp teeth in their huge maws. Gothmog and Leif had been at the
forefront in the beginning of the battle and they staggered back to let
Sonja and Hissssa take a turn at these monsters.

 This proved to be a fortuitous move, not only because the first two were
near death, but also because the crafty Hissssa had devised a strategy to
deal with these beasts. He and Sonja each struck at the worms and then
jumped to the left before the monsters could retaliate. The champions then
made a quick turn to the right and waited for the worms to step into the
range of their weapons. They again made a quick strike and stepped to the
side. As I watched this battle progress it seemed to take on the quality of
a dance. The champions would strike, step, and turn. The monsters would
step forward and the cycle began again. The longer the fight went on, the
more firmly the rhythm of the cycle was established and the more sure-
footed the party became.

 Finally, the worms were destroyed and the party was pleased to find that
the remains of the worms proved to be edible. While these "worm rounds"
were heavier than most food and not as filling, they were grateful for a
new food source nonetheless. After quaffing a few healing draughts and
poison antidotes, the weary champions rested for a few moments. As they
prepared to move on, they could hear something moving a short distance
ahead. Secretly, each of the champions prayed that whatever was moving
ahead was anything but more of these cursed worms. To be prepared, each
member readied a fireball spell and they moved forward. They saw a glimpse
of purple in the shadows ahead and they had just enough time to loose a
volley of fireballs before closing with the beasts.

 The party slowly battled its way through this treacherous maze one step at
a time. Behind almost every door was another pair of worms, although some
concealed less fearsome monsters. A few times, the party was forced to flee
and rest in the relative safety of a locked room after which they would
return to the battle. One battle nearly proved to be fatal, however. The
party had cleared a number of areas and had closed the door behind them as
they moved on. After defeating one pair of worms the party moved into the
next area and left the door open behind them without thinking about it.
They pressed on and engaged yet another pair of worms. As they battled
these worms, they were horrified when a second pair approached from behind
the party and attacked.

 Caught between two groups of these deadly foes, the group seemed destined
for certain death. Screaming with desperate rage, Gothmog cast a fireball
more powerful than any he had ever tried directly at the pair of worms the
beleaguered party had been fighting. The spell exploded into the monsters
with a deafening roar. When the smoke cleared, the only thing remaining was
a few charred worm rounds. There was no time for celebration as the party
was still faced with a pair of murderous foes. There were only two now,
however, and just as the champions had slain the pairs they had fought
earlier, they defeated these two as well.

 When the battle was over, the four champions tried to figure out where the
second pair of worms had come from. They knew that they had thoroughly
explored the area behind them and had killed every creature in that area.
The only explanation was that these worms had somehow been created after
the party had left the area. None of the four champions could explain how
such a thing could happen, but the evidence was undeniable. Needless to say,
the group was very, very careful to close doors behind them from that point
on as they continued deeper into the dungeon.
 
 The group continued to explore the maze and made its way toward the
northeast corner of the level. They found an iron gate that opened into a
small room filled with screamers. The party entered the room and gathered
all the screamer slices after dispatching the creatures. What the party
would later discover is that the screamers in this room were recreated
every time the group left this level and returned. Essentially, this room
would create an endless supply of screamers and, more importantly, an
endless supply of screamer slices. This unlimited source of food allowed
the party a kind of security it had previously only dreamed of. While they
could still only carry a limited amount of food, they could return here at
any time to replenish their stores if needed.

 Immediately after leaving the screamer room, the party found a pressure
plate that closed the door to the room if it was open. Two paces north from
this plate was an illusionary wall. They gathered the items concealed by
the illusion and continued.

 The group came to a pit with a mummy on the other side. A message on the
wall warned not to harm the "prisoner." Knowing that the message had to be
from Lord Chaos, the champions sensed they would have to ignore the message
if they were to succeed. Hissssa threw a fireball at the mummy and watched
it go up in a puff of smoke. Immediately, they heard a gate opening in the
distance. They later discovered that the gate had blocked the stairs down
to the next level. They would not have been able to descend without killing
the mummy. Unfortunately, when the group chopped down the door leading to
the exit, they learned the price of defying Chaos. Behind the door were
several pair of hungry purple worms.

 When the last of the worms were defeated and the path to the stairs was
clear, the champions could scarcely believe it. They were running very low
an water and there was some disagreement as to whether or not they should
try to return to the second level to get more before braving the unknown
fifth level. Gothmog finally convinced the others to enter the fifth level
just a short distance to see if any water was readily available. They could
scarcely believe their good fortune when they found a fountain at the very
foot of the stairs.

 After drinking their fill and refilling their skins, the party found a
stairway leading up just five steps south of the stairs and two steps east.
Curious to find a stairway leading back up to the level from which they had
just come, the group ascended the stairs. They found themselves in a very
small room with a button on one of the walls. Pushing the button caused a
section of wall to disappear. The group found that the newly opened hallway
was just of the east of the room containing the screamers.

 Since the party now found itself in an area with an unlimited amount of
food available as well as a fountain just a short distance away, they
decided to stay here for a while and train. First, they practiced
spellcasting and Ninja techniques. Finally, they decided to see just how
many of the monsters on this level were renewed after the party had left
the area. They were only slightly surprised to find that the majority of
the areas were once again inhabited. The group made their way back to the
beginning of the level and then back again. As they did this, they grew in
power and experience. The purple worms that had seemed invincible when they
had first encountered them, now seemed almost easy to kill. Finally, the
group had had enough of the killing and decided to continue to the fifth
level of the dungeon. The considerable amount of time here was well spent,
however. The endless combat had transformed each of the champions into a
powerful warrior and all of their skills had reached a considerable level.

 LEVEL FIVE

 Upon descending to this level, the party soon found a hallway that led to a
somewhat large room with one door on each of the four walls. They opened
the door to the south and decided to explore it first. As they proceeded
down the hallway, they came to an offshoot heading east. The group took the
offshoot and made it to a large, irregularly shaped room. This room proved
to be something of a puzzle. It seemed that there were various buttons,
most hidden by walls. However, hitting one button would cause some walls to
disappear and other walls to reappear. In time, the champions discovered a
pattern, and pushed the proper buttons in sequence to reveal a new area
containing treasure.

 First, they pushed the button on the south wall. They then took three paces
north and one step west and pushed the button they found there. Finally,
they took one step north and four steps east and pushed the button there.
This opened a new area in the southeast corner of the room. The party was
pleased to find a full suit of chain armor in this new area. Having fully
examined the offshoot area, the group returned to the main corridor. They
continued to the south and found a door with no apparent means to open it.
Upon closer examination they discovered a device on the section of wall to
the south of the door. Manipulating the device took only a moment and the
door opened revealing the treasure beyond.

 Through the west door, the group came upon a room filled with the
mysterious blue teleportation fields. They stepped into the room and found
themselves surrounded by the fields on all three sides leading further into
the room. Taking a deep breath the party took a step to the right. In a
flash they were teleported and found a mirror lying at their feet. They
picked up the mirror and took a step backward, then forward, left, right,
and finally back. The champions covered the rest of this area with few
events of import.
 
 Entering the east door, the party soon entered a large room. The group
started south down the western wall and found a button in the corner. Leif
pushed the button but it had no visible effect. The party tried to go east
along the southern wall but soon found that they were somehow prohibited
from making progress beyond a certain point. Since they couldn't proceed
east, they decided to see which directions they could move in. The group
went back to the southwest corner and started north along the eastern wall.

 They reached that corner and went east along the northern wall. They were
somewhat surprised to make it to the northeast corner of the room.
Apparently, the magic keeping them from progressing east, did not work
along the northern wall. Finally, the group went south along the eastern
wall and found an exit from the room in the corner.

 The party found numerous caverns to explore as well as several valuable
items to recover in the area beyond. After exploring the last of these
passages, the champions started back out of the area. As they drew closer
to the magical room, they were startled to find that a new passageway had
appeared. While the passage only extended a short distance, it contained a
rare Illumulet.

 The party opened the north door last and was confronted by a room full of
pits. As the group studied the room, they saw that the pits would open or
close depending on where they stepped. Taking a deep breath, they prepared
to navigate the room. They turned around and closed the door to be certain
that they would not be attacked while on such treacherous footing. Then,
they took steps in the following directions:

 Two north, two east, two west, and south. North, east, four north, south,
and west. Two south, east, north, east, two north, and finally east to
leave the room. After retrieving the items in the room beyond, the group
returned to the pit room. They stepped onto the first plate and took the
following path from there.

 Two west, east, south, west, two south, and two west. North, south, three
north, and west to exit. The champions entered a hallway and explored to
the south. They found a drumstick and discovered an illusionary wall to the
west of it. They discovered some potions in this hidden area and found a
second illusionary wall on the southern end of the corridor. The group
returned to the main hallway and began to search toward the north. The
party hit a "spinner" as they progressed down the hallway. They quickly
reoriented themselves and continued.

 Finally, they came to a set of stairs descending down to the next level. On
the wall to the left of the stairs was a button that opened a passage to
the southwest. The champions were pleased to discover this passage would
allow access to the corridor containing the stairways back up to the fourth
level. Faced with two downward staircases, the party arbitrarily selected
the one in the northwest section of the level.

 LEVEL SIX

 The party descended the stairs and found themselves in a small room with a
passage leading to the east. After gathering the items in the room, they
started down the passage. The passage ended almost immediately but a quick
search revealed a button on the wall that cleared the path to the east. The
party found itself entering a large room with a blue field in it. This room
was obviously directly beneath the "pit room" on the fifth level. The
champions avoided the blue field and searched the room. They discovered an
illusionary wall two paces to the north of the corridor that hid a small
treasure room. After a complete search of the remainder of the room, the
group found only a piece of food. Since there were no doors and no apparent
devices to open a new passage, the group could proceed no further. They
decided to go back to the fifth level and try the stairway in the southwest
area.

 After using the second set of stairs the party entered a large room with
several small alcoves. The champions examined these alcoves and found that
each alcove had a riddle engraved on the wall near it. The answer to each
of the riddles was an object in the group's possession. After a moment's
consideration, Gothmog placed the Mirror of Dawn in the first alcove. He
then placed a gold coin in the next one, and a blue gem and a bow in the
final alcoves. After placing the items in the alcoves, the gate on the east
wall opened and a new alcove appeared next to it. The party found a key in
this new alcove and claimed it as their own.

 The champions left the riddle room and entered a long corridor. The
corridor had three doors on the east wall, one at the southern end, and one
passage leading from the west wall. The party went to the southernmost door
and opened it. They found a room with three pressure plates on the floor, a
blue field, and a pit. There was also a closed door in the southwest corner
of the room. It was readily apparent these objects formed a twisted puzzle.
The object was to open the door and enter the area beyond. After several
failed attempts to do so, Gothmog discovered the solution. First, he pushed
a button on the wall near the door. Next he dropped a torch into the field
and the door opened. The group took the key they found in the room, went
back to the field, and stepped into it. They reclaimed their torch and
pushed a button on the wall. This closed the pit and allowed them to exit
the room.

 The party moved north up the corridor and entered the grave of King Filius.
The champions explored the room thoroughly and discovered a number of
buttons on the walls. They pushed a button on the north wall of an alcove
in the southeast corner, then pushed one in the northeast alcove of the
room. This opened a secret passage on the east wall where they found
another key and some armor.

 The champions continued northward along the corridor and entered the grave
of King Milias. They found a hole in the southwest corner of the room. They
read a message on the wall and considered its meaning. After a moment,
Gothmog stepped forward and placed a gold coin in the hole. A passage to
the east appeared where they found the final key needed to continue.

 The champions came to a crossroads with a bold message engraved on the wall.
This writing proclaimed: "If you want to stay alive, you better turn and
run." Sonja let out a loud snort of derision and the party proceeded into
the southern path. The passage led to a cavernous room with many twists and
turns. The group explored immediately to the east of the entry area and
found a button on the wall. Pushing the button caused an audible clicking
sound but no visible effect was immediately obvious.

 Continuing deeper into the room, they followed the east wall toward the
southern end of the room. In the southeast corner of the room they
discovered a magical box in a small chamber. Each of the champions had a
strong suspicion that this area had probably been closed until they had
pushed the button. Their suspicions were strengthened when they found a
second button near the box. After pushing the button, they went back to the
first button and found that the section of wall had disappeared to reveal a
secret area.

 Inside this new area they found a key and a valuable piece of plate armor.
Hissssa eagerly donned the new armor and they renewed their search of the
room. As the group explored the western portion of the room, they stepped
on one particular area and heard a noise as if they had stepped on a
pressure plate. They looked down, but could see nothing unusual at their
feet. Puzzled, they took a step forward and noticed a wall appear to the
south. They slowly stepped back on the invisible plate and saw the wall to
the south disappear again. Using a trick that had worked many times before,
they stepped off of the plate and placed a torch on it. Unfortunately, the
torch did not trigger the plate. Undaunted, they placed several heavy
chests onto the area, but still the device was not activated. Finally, they
realized that objects alone would not trigger the plate. The device was
only triggered when all four champions stood in the area. The party stood
there for a while trying to discover a way to enter the hidden area. As
they stood there, they heard noises in the distance. As the sounds came
closer, it soon became clear that a group of enemies was approaching.

 Almost immediately, a group of skeletons came into view. As they approached,
Hissssa's face slowly broke into a wide grin until he burst out with an
eerie reptilian laughter. The others looked at him in shock as he laughed,
but he continued and motioned them to stand back away from the plate. The
skeletons moved forward until they had stepped onto the plate and were
directly in front of the party. Leif took a mighty swing at the closest one,
causing Hissssa to laugh even louder. Just as everyone was certain that he
was crazed, he pulled the magical box they had just found out of his pack
and opened it while pointing it at the skeletons. Instantly, the monsters
were frozen into place like statues. Laughing harder than ever, Hissssa
made a grand gesture toward the south wall. As the party turned and saw the
south wall now held open by the paralyzed skeletons, they could not help
but join in Hissssa's good natured mirth. Hurrying forward, lest the spell
wear off and the way be closed again, they ran into the secret area. As
their laughter subsided, they all congratulated Hissssa on his ingenuity.
They gathered up the treasure there and prepared to go out and deal with
the skeletons on a more permanent basis.

 The champions found no new exits from the large room, so they made their
way back to the crossroads. Taking the northern path, they unlocked one
door and came to a hallway going north. As they entered the corridor, Leif
suddenly tripped and began to fall. Arms flailing, he reached out to grab a
metal ring on the wall in an effort to stop his fall. As he grabbed the
ring, he was surprised to see that it came off in hands. Everyone in the
group was even more surprised when a section of wall right next to where
the ring had been, disappeared. Obviously, the ring had been the means to
enter this secret passage and they had almost passed it by unknowingly. The
champions explored this new area thoroughly, discovering a number of useful
items. In the northernmost hallway of the area they found a button on the
south wall. Pushing the button revealed yet another secret area to the
north where they found a vorpal sword.

 The champions opened a door leading into a hallway. After they had taken
just a couple of steps into the passage, the door closed behind them,
cutting off all retreat. At the other end of the hall was a locked door
which none of their keys would open. The only unexplored area was a side
passage with a blue field in it. The group approached the field and saw
that it was blinking in and out of existence at a rapid but steady pace.
Watching it a for a while to get the timing down, they leaped forward at
the right moment and ran through.

 They escaped the area of the field before it reappeared but they kept
running forward just as another field materialized ahead. The stunned party
was immediately teleported back to the outer hallway to try again. This
time, they managed to stop short after clearing the first field and
gathered themselves for the attempt to clear the second. Finally, when they
were sure the time was right, they rushed through into the room beyond. In
the room they found a key and a button on the wall near it. Pushing the
button, they left the room and reentered the hallway. The button had
reopened the door that had closed off their retreat. They tried the
newfound key on the locked door and were pleased to find that it fit
perfectly.

 The party passed through the door and were immediately confronted with a
challenge etched into the wall to "test your strength." Seeing a long
hallway filled with blue fields, Hissssa confidently stepped up and hefted
a torch in his powerful claws. Grinning, he threw the torch forward with a
flick of his wrist. The torch flew down the hallway until it hit the far
wall and fell to the floor. The instant it fell, the sound of a gate
opening was heard. The party went back to the main hallway and traveled
down it until they came to the open gate.

 They explored the area beyond and were gratified to find some powerful
weapons and armor. After thoroughly examining this area of the dungeon
level, the party took the sole remaining path into the northwest area of
the level. They entered a fairly long hallway and discovered a button on
the north wall. Pushing the button opened a path into a new area. Upon
entering this hidden passage, the group immediately realized these were the
same rooms they had discovered when they had come down the first set of
stairs from the fifth level. Since they had already explored this area,
they left it and returned to the main hallway.

 Slowly, the champions wound their way through the mazes of this dungeon
level. They found some rooms with treasure and others that were empty.
Finally, they made their way to the southwest area of the dungeon where
another puzzle presented itself. They pulled a lever on a wall which opened
a gate to the north. They moved north to enter the portal but just as they
stepped in front of it, the gate came crashing down. They went back and
pulled the lever again, then made their way back to the door, carefully
avoiding the plate. They knew they could not enter the door without
stepping on it but they hoped to do it in their own way.

 Standing two paces back from the door, the champions sped forward onto the
plate and continued rushing forward. The gate came thundering down closing
just behind the party. Inside the room, they gathered the treasure inside
and searched for a means to leave. They found a large button that opened
the door when pushed. Unfortunately, there was another pressure plate on
this side of the door so they were forced to make the same kind of mad dash
to get out safely. The group left this room and continued to follow a long
corridor leading east. Finally, it led them to a set of stairs leading down.
They smiled knowing they had completed another step of their quest. However,
their smiles were decidedly weary ones. This level had seemed like an
endless array of riddles and the champions were beginning to tire of such
constant deceptions. They paused for a while to rest and eat, then
descended the stairs to the next level.

 LEVEL SEVEN

 After a brief exploration, the party found that the way to the main areas
of this floor would not yet be possible. They found a door that was opened
by the RA key they had found on the third level. After passing through this
door, they came to an identical obstacle just up the hallway. Near this
second door, they found a scroll. The contents of the scroll convinced
every member of the group that the keys to continue exploring this level
would only be found on the lower floors.

 Before taking the stairs down to the eighth level, however, the champions
decided to set up a camp of sorts on this level. The location would be
ideal for resting since there were no monsters in the small area that was
open to them. The location was further attractive because it was not too
terribly far from the water on the fifth level or the food on the fourth,
nor would it be too far to retreat back to from the lower levels they were
preparing to enter. The group carefully divided their belongings into
categories and placed their excess items into neat piles. A great quantity
of food was left here as well as many magic items for which the party had
no immediate use. Feeling greatly unburdened, they descended the stairs to
the eighth level.

 Having collected the two RA keys from the ninth and twelfth levels, the
party returned to explore the remainder of this floor. They used the keys
on two doors in short order and proceeded up the hallway beyond them. They
came to a series of highly ornate, locked doors. Taking advantage of my
incorporeal state, I ducked into the rooms to see what was inside. In the
first room I found the Scepter of Lyf, an Illumulet, and the Gem of Ages.
In the second room were the Dragon Spit and Boots of Speed. The third room
contained the Crown of Nerra and a magical box. Finally, the fourth room
held Flamebain and the Lightning Sword.

 Since the party had no key to open these doors, they continued their
explorations. Immediately after these doors they came upon a door that was
unlocked by the ruby key from the eleventh level as well as a passage
leading south. They decided to explore to the south first and entered the
passage. They came to an energy barrier with a massive stone golem on the
other side of it. They opened the barrier and immediately began shooting
arrows at the creature and threw all of their missile weapons at it. The
lumbering hulk kept coming so they cut loose with a furious barrage of
lightning bolts and fireballs. The spells did nothing to slow the advance
of the golem. Despite the creature's durability, the party waited with
confidence to engage the creature in close combat. Hissssa and Sonja stood
up front wearing their finest armor and wielding their most powerful
weapons. When the golem approached, they whirled into action attacking with
their usual ferocity.

 The slow-moving golem finally swung his massive club and landed a
pulverizing blow directly on Hissssa's shield arm. Despite the protection
of the Shield and Armor of Darc, Hissssa's shield arm was smashed instantly
and hung uselessly by his side. Sonja, amazed at what had happened to her
comrade, redoubled her attacks but the golem barely seemed to take heed.
Furious, she screamed in rage and rained blows upon the golem that should
have caused utter destruction on any living thing. In response, the golem
swung its club once again and smashed Sonja in the midsection. Sonja,
hurled by the force of the blow, flew back 10 feet through the air before
smashing into the ground. Her ribs crushed, she struggled in vain to rise
and continue the fight.

 At this point Gothmog ordered Hissssa, who was still trying to carry on the
battle swinging Hardcleave with his one good arm, to stand behind Leif and
himself. As soon as Hissssa was safely out of the way, Gothmog pulled a
magical box out of his pack and turned it on the stone creature.
Fortunately, this magic had its desired effect and the monster froze in
place. Gothmog and Leif pressed the attack with vicious blows against the
immobile creature. Finally, the stone monolith began to crack and then
crumbled to dust.

 Gothmog carefully administered healing potions to Sonja and Hissssa and the
two champions recovered fully. The struggle against the golem had been by
far the most grueling battle in which the party had yet engaged. While no
one voiced the thought, each of the four champions knew this was the
closest they had come to death. Exhausted, the group collapsed on the floor
and slept.

 When the champions awoke, they realized with some chagrin they had not even
bothered to explore the hallway beyond where they had first encountered the
stone golem. They approached the second door in the hallway and were more
than a little apprehensive when they saw a second stone golem waiting
behind the door. The champions stopped and worked out a plan of attack they
felt would give them a good chance of defeating the golem without taking
the same kind of punishment the first one had inflicted on them.

 They opened the door and waited for the golem to approach. As soon as the
creature stepped into the doorway, they pushed the button to close the door
and attacked the monster vigorously with all of the weapons in their
arsenal. The combined punishment of the door pounding at the golem as well
as the group's attacks finally drove the golem back a step. With the golem
out of the doorway, the door finally closed. The champions took a few
moments to heal their wounds and reopened the door. This cycle was repeated
several times before the golem was defeated.

 When it finally fell, the relief that washed over the party was almost
tangible. They continued down the hallway and found several useful items
and one of surpassing value. At the end of the hallway, in a small alcove
lay one of the most powerful weapons in all the world. The Inquisitor lay
there, dazzling all who beheld its beauty. Sonja picked the sword up
lovingly and caressed the blade. With the Inquisitor and Hardcleave both in
the group's possession, their confidence was restored somewhat from the
beating they had taken at the hands of the stone golem. While the champions
felt far from invincible, they did feel better about their chances of
survival.
 
 They returned to the main passage, used the ruby key to open the door, and
found a wizard's workshop. After examining the contents of the room, they
took the passage on the eastern side of the room to explore further. The
passage was a long corridor with four small side passages off the main
hallway. Three of these side passages contained useful items. They
continued and entered a room with two small alcoves. In one of the alcoves
was a turquoise key that would open any one of the ornate doors in the main
hallway. As it turned out, this was to be the only turquoise key in the
dungeon, so the party would only be able to enter one of the four rooms and
claim its treasure.

 Upon exploring the remainder of the room carefully, the party found a
button on the south wall that opened a secret passage in the southeast
corner of the room. The party read the scrolls there with great interest
and claimed the final RA key. Upon reading these scrolls, Gothmog paused in
thought. The party discussed the possible meanings of the messages, but
they all agreed that the meanings were clear. They would not take the
Firestaff back to Lord Librasulus. When they recovered the staff they would
attempt to attach the Power Gem to it and attack Lord Chaos.

 The party left this room and began to make its way back down the corridor.
As they walked along, something caught Leif's eye. He stopped and looked
more closely at an area on the north wall. He found a small button there
and pushed it. While pushing it had no apparent effect at the time, they
soon learned what it had done. As they returned to the entrance room of the
workshop, they found a passage had opened in the northwest corner of the
room. Before entering this area, the party decided to use the RA key on the
locked door just outside the workshop.

 The champions tried the RA key in the locked door and were pleased to
discover that it did indeed open the door. They passed through the doorway
into a series of long corridors. They followed these passages with little
difficulty until reaching the central area. They discovered a small chamber
with two locked doors leading into it. Near each of the two doors was
another stone golem. While the golems did not seem to react when the party
drew near, they decided not to wait for something to rouse the creatures.
It would be far better to kill both of them now than to wait for the
monsters to attack, possibly at the same time.
 
 None of the champions harbored any illusions about their chances to survive
a battle against two of these juggernauts at one time. The group was able
to defeat the two golems by using a magical box on each of them, although
not without absorbing some punishing blows. After disposing of the
guardians, they used the master key from the twelfth level to enter the
small chamber. The champions entered the room and their spirits soared as
they saw what lay before them. Gothmog stepped forward and grasped the
Firestaff with both hands. Immediately, he seemed to draw new power from
the staff. With the Firestaff in their possession, they had only to find
the Power Gem and they would be ready to face Lord Chaos.

 Firestaff in hand, the champions returned to the secret passage in the
wizard's workshop. After a short twisting corridor, they entered a very
long hallway leading south. They began walking down the corridor, but found
a button on the east wall after a short distance. When they pushed the
button, they heard a noise to the north. The party backtracked up the
hallway and found that a secret passage had opened up at the northern end
of the corridor. Inside, they found a winged key. They took the key and
continued back down the hall. The hall led them to an area where they
encountered yet another stone golem, and then to a stairway leading down.
The party descended the stairs, eager to see where they led. They traveled
down a series of stairs before they finally landed on the thirteenth level.

 LEVEL EIGHT

 The party entered the eighth level and was immediately confronted by a
ghost. Gothmog and Sonja fumbled in their packs attempting to pull out the
vorpal blades. As soon as the weapons were in hand, they struck the wraith
with the blades and watched it dissipate into nothingness. As the champions
began to explore the area, they found they were constantly accosted by a
number of skeletons, mummies, ghosts, and even giggling thieves who would
snatch an item and run away laughing. The group patiently dispatched these
enemies as the need arose. The battles on this level were of little
consequence for the most part. Most of the challenge that this floor of the
dungeon presented related to the numerous secret mechanisms scattered about.
The champions had to find the buttons to open the secret doors that were so
numerous on this level.

 The party began searching to the south of the stairs. Continuing to the
south and east, they passed between a pit an a blue field. Just to the
south of the pit was a button on the wall. Leif pushed the button and the
party thought they heard a noise to the west, on the other side of the wall.
They retraced their steps and found that a section of wall to the west of
the pit had disappeared.

 After gathering the treasure in the hidden area, they returned to the place
where they had found the button and continued. As the champions traveled
east along the south wall, they came upon another blue field. They entered
the field and found another button on the wall. Pushing the button revealed
a secret passageway. The party entered this new area and explored the
winding passage until they came to a very long hallway. They stood at the
beginning of the hall and began walking forward. After proceeding a total
of 26 paces, the party paused momentarily so that Gothmog could take a
drink of water. After they had stood there for a few moments, the group was
surprised to see a section of wall suddenly disappear just to the east.
They hurried through the opening and found an empty room with an exit door
on the east wall. They opened the door, and traveled down a short passage
into a small room. Pushing a button on the north wall revealed a secret
chamber containing two magical weapons. The group discovered no other exits,
so they made their way back to the main area of the level.

 After returning to the main area of the dungeon level, the group continued
along the outer wall. After taking several steps both east and north,
another button was found on the wall. The button revealed a secret passage
nearby in the east wall. The champions gratefully gathered the weapons
there and continued. They made their way to the northeast corner of the
level and found a blue field. They passed through the field and found a
button on the wall to the south. Pushing the buttoned opened a passage to
the east in the area they had just left.

 The party found the Staff of Manar in the passage and returned to the
button. From there, they continued to follow the outer wall north and west.
They had gone a fair distance when Hissssa suddenly stopped and faced south.
Staring intently, he moved forward slowly and picked up an object from the
floor. He turned and showed it to the rest of the group, and it was
revealed to be a key. It was fortunate that Hissssa had seen a flash of
light reflect off the key as he was walking past it. The rest of the group
had failed to see it and, as it turned out, the key would be needed to
leave this level.

 The party continued west along the north wall and finally found another
button just to the west of a blue field. The button opened a secret alcove
off the north wall, through the field. There was a large green button in
the alcove that deactivated the field. The group later realized that
eliminating this field also removed the threat of the fireballs that had
been plaguing the group during the time they had spent on this level.

 They continued west into a short passage and found a chest containing a
skeleton key. Pocketing the key, the group began moving southward along the
west wall and found a passage leading to a door. The solid key opened the
door and they continued into the passages beyond. After making their way
through the twisting passages, the champions found a downward staircase. On
the wall opposite the stairs was a large skull. Taking the skeleton key,
Gothmog approached the figure and pushed the key into one of the eyes. This
caused a section of wall to the north to disappear.

 Entering the new area, they found a second descending staircase as well as
a passage leading back out to the main area of the level. The party tried
descending the set of stairs they had found in the secret area first.
Unfortunately, they found only another set of stairs leading down with
walls on both sides prohibiting them from exploring anywhere else. After
descending several flights of stairs before finally hitting a dead end,
they returned to the eighth level. This time, they used the first set of
stairs they had found, and descended to the ninth level.

 LEVEL NINE

 When the party first began exploring the area around the stairs, they
wondered if they had not reached another dead end. They discovered a small
room to the northwest of the stairs that contained an informative scroll,
but no exits were visible. Finally, their attention was drawn to an
inscription on the wall reading "When is Rock not Rock?" While this
question seemed almost meaningless at first, the answer eventually became
clear. A rock is not rock when it is only an illusion. The section of wall
to the east of the message was just such an illusion.

 After passing through the illusionary wall, the party was faced with a
corridor that led both east and west. Taking the east path, they found a
door and entered a large, irregularly-shaped area. In the northeastern most
section of this new area was a short corridor. On the west wall of this
corridor they discovered a button that opened a secret wall to the
southwest. The champions were pleased to find that the hidden area
contained some useful treasures to help them on their way.

 Finding no further avenues of progress, they made their way back to the
illusionary wall to explore the passage bearing west. Almost immediately
after passing the illusionary wall, the group entered a short corridor.
After walking to what appeared to be the end of the hallway, they found
themselves back at the beginning of the hallway near the "When is Rock..."
puzzle. Sensing a strange magic at work, Gothmog cast a magic footprints
spell. The party reentered the short hallway and after taking two steps
found that they were suddenly facing their trail of footprints. Before
taking another step, they turned around and continued down the hall. This
time they made it safely through to the other side. The champions then made
their way to a door that opened into a large maze-like room. In the
northwest corner of the room, they found a button on one of the walls. A
secret chamber was revealed to the north and once again they gathered
hidden treasure.

 As the champions continued their exploration, they came to a locked gate
with a lever next it. They could see that a chest lay on the other side of
the gate. Hoping to open the gate and gain access to the chest, Leif pulled
the lever. Instead of opening the gate, however, it opened a pit under the
chest and it disappeared from sight. They pulled the lever again to close
the pit. Still hoping to find the chest, they entered a new area through a
door to the southwest of the gate and found a set of stairs going down in
the northeast corner of the room. The stairs led to a small room where the
chest had fallen.
 
 They took the chest and found a small gem inside it. Going back up the
stairs they found that the gate was still locked and the only path left to
explore was to the east of the gate. Making their way through the twisted
corridors, the party found a stairway leading up to a small room containing
two items of importance. First, they found a button that opened up a secret
area in the southern portion of the room. Second, they found a pit at the
northern edge of the room with an inscription that stated "Put the Gem
Back." Since there could be little doubt as to what was required, Leif
stepped to the edge of the pit and dropped the gem into it. The party went
back downstairs and found that the locked gate was now open.

 The group next came to an a room twenty feet wide with two rows of three
pressure plates. Not knowing what to expect, they stepped onto the first
plate and all were stunned to see a fireball suddenly rushing toward them
from the wall thirty feet ahead. Their hesitation almost cost them dearly,
but at the last moment they managed to jump aside as the flames went
roaring by. The champions sat back for a moment and discussed ways they
might pass these plates without suffering the effects of the fireballs.
They considered casting a number of Fireshield spells to protect them as
much as possible and then simply walking through the fireballs. However,
none were eager to subject themselves to the flames unless it was necessary.
Instead they carefully approached the first plate and placed a scroll on it.
Immediately, they jumped to the side and watched the ball of fire sail by
with time to spare. Next they approached the plate to the left of the one
with the scroll resting on it and did the same thing. With a scroll resting
on each of the two plates closest to them, they now had to step forward
onto the plate to see if the scrolls had been effective in keeping the
mechanism triggered. Gingerly they stepped forward and found that the
plates were no longer activated by their presence.

 Carefully, they placed objects on each of the remaining plates in a similar
fashion. Soon, they had made it safely to the far side of the room and
hurriedly made their way north to escape the line of fire in the room
behind them.

 After leaving the fireball room, the party continued north and made their
way westward through a series of caverns. Finally, when they seemed to hit
a dead end, they found a button in an alcove located in the far western
area that opened a secret door leading still further west. The group found
a skeleton key inside the revealed room as well as several pieces of food.
Finding no further avenues of progress, they made their way back to the
fireball room to explore the passage leading south from there.

 In the northeast corner of this level, the champions found a room with its
gate sitting open. The party soon learned that this room was a magical area
that created an endless supply of the giant rats that had been attacking
ever since they had entered this level. Finding nothing of value in the
room, the party made certain to close the door as they left the area in
order to restrict the movement of the huge rodents.

 Next, the group came to a door with an inscription reading "Lighter than a
Feather," and a small alcove next to it. They placed the corbamite that had
been found in the northwest area of the level into the small alcove and the
door opened immediately. Beyond this door was a set of stairs leading down.
Passing the stairs by for the moment, they next found a room just to the
west of the stairs that contained a RA key. Excitedly, they claimed the key
knowing they were one step closer to claiming the Firestaff, and returned
to the descending stairway.

 LEVEL TEN

 The party entered this level and was immediately confronted by this
challenge engraved into the stone wall: "Beware my Twisted Humor, The
Deceiver, The Snake." Beyond this challenge lay a maze with numerous
passages. Most of these passages contained invisible teleportation fields.
Stepping into any of these fields teleported the group back to the entry
stairs. Taking their cue from the message on the wall, the champions
decided to take a serpentine, winding path through the passages. First,
they went to the far south and took the passage there. Next, they followed
the corridor to the far north and went through that hall. Finally, they
went to the far south once again and continued.

 The party next came to a pair of locked doors with a single key lying on
the ground between them. A message on the wall instructed them to "Choose
One Door." They arbitrarily chose the south door and used the key to open
it. After entering the corridors beyond the door, the group was confronted
by four skeletons. After killing the last of the undead creatures Hissssa
found a second Key of B among their possessions. They continued and came to
a second locked door. They used the Key of B to open the door and were
almost immediately confronted with another puzzle.

 Etched into the wall in front of them was the word ZOOOOOM. Beyond the word
on the wall was a series of pressure plates on the floor in a series of
hallways that formed a rectangle. The group stepped forward and was
immediately whisked away down the corridor. Somehow, the plates held a
magic that propelled the champions irresistibly around the rectangle of
pressure plates over and over again.

 While they were stunned initially, the champions quickly recovered their
composure and began to try and escape from the corridor. As they were
traveling down one of the hallways they could see an area beyond the
pressure plates. Unfortunately, when they tried to jump onto the safe area
as they passed by, nothing happened. Despite repeated attempts to jump to
solid ground they remained trapped in the corridor. Finally, they began to
realize that more than the speed of their progress was involved with their
difficulty. Magic must somehow be working to their detriment. To test their
theory, the champions tried leaping to their right while approaching the
solid ground. Suddenly, they lurched forward and found themselves standing
once more on firm footing. They rested for a few moments to recover from
their dizziness before exploring further.

 After leaving the ZOOOOOM area behind, the party explored a winding
corridor leading southwest. They came to a door and opened it. After
entering the room, they found a button in the shape of a cross just inside
the doorway. They decided not to push it unless it became necessary (we
later learned that they would only have freed monsters to attack if they
had pushed the button). As the champions tried to explore the room, they
were repeatedly attacked by a series of beholders, skeletons, and thieves.
After dispatching all of these creatures, they discovered a button on the
north wall that revealed a small chamber nearby.

 Finally, there was nothing left to do in this room so the group exited
through a corridor on the south wall. A short distance down the hall, they
found a door on the north wall of the corridor. Weary from the battles in
the previous room, they decided to enter this new room and rest. They slept
for several hours before finally awakening. Taking care to search the room
before taking their leave of it, they found a button that revealed a
chamber on the south wall. They were quite pleased to find the legendary
Moonstone inside the chamber.

 The party reentered the corridor and continued eastward. Before long, the
hall opened up into a small chamber. In the northwest corner of this
chamber they found a button. Pushing the button opened a secret passage in
the southeast corner off the room. After searching the hidden chamber, the
group discovered a second button. Pushing this button revealed a second
hidden chamber adjacent to the first button in the northwest corner of the
room. Exploring this chamber revealed that the western wall was only an
illusion hiding more treasure. Next, the champions began exploring the
passages beyond this room, mostly heading east and then north.

 After traveling north for no small amount of time, the party discovered
first one door, and then another to the north and east of the first one.
Both doors were exits to the area that the group was currently in. Neither
of the doors were particularly distinctive, so they selected the first door
and opened it. Immediately after passing through the doorway was an alcove
to the east. Inside the alcove, they pushed a button that revealed a secret
chamber. Inside the chamber they found another button. This button opened a
second chamber a short distance to the northeast. The champions found it
necessary to search for a short time until they found the location of the
chamber.

 Inside the chamber lay one of the most powerful weapons known to exist in
the world, Hardcleave. The ebon axe lay before the group fairly challenging
each of the heroes to see who would have the courage to claim it. Hissssa
stepped forward and grasped the axe in one of his powerful hands. The
others watched in silence as he slashed the air with his new weapon. He
already moved as if the axe were an extension of his body. No one even
suggested that another might be better suited to wield Hardcleave than
Hissssa.

 The group searched westward from the location where they had found
Hardcleave. They came to a small chamber containing a magnifying glass as
well as a button on the wall. The button activated a blue teleportation
field inside the room. Stepping into the field sent the party back to the
room where they had rested earlier. Fortunately, a field had also been
activated in that room so they were able to return to the first teleporter
without having to walk all the way back. Continuing westward, the champions
discovered the set of stairs leading down to the next level.

 LEVEL ELEVEN

 The champions entered this level only to be confronted by perhaps the most
twisted puzzle in the entire dungeon. At the foot of the stairs was a
series of four corridors that formed a square. This area (known as "The
Clockwise Room") appeared to be a single square room. In reality, it was a
collection of four identical rooms, each with an invisible teleport field.
After several unsuccessful attempts to escape this area, the group finally
hit upon a winning strategy. They began at the entrance to the first room
just to the west of the entry stairs. Then, they turned around and began to
walk BACKWARDS, in a counter-clockwise direction.

 As they progressed through the rooms they spotted an iron key on the ground
that they had missed before. The key was difficult to see due to the
similarity of its color to that of the floor. Taking the key, they
continued walking backwards until they came to a closed gate with a keyhole
next to it. The iron key opened the gate after a brief delay and the party
entered the short passage beyond the gate. They opened the chest there and
found a solid key. They returned to the room and once again began their
backward march. Finally, they found a gold keyhole on the wall and they
inserted the solid key. They continued marching backward until they made
their way back to the corridor with the chest. The solid key had apparently
opened a secret passage at the end of the corridor because the way was now
open to leave the Clockwise Room. Relieved to finally be walking in the
normal way again, the champions entered the corridor to explore the area
beyond.

 The group took a southern path after leaving the clockwise room. They
followed the hallway south and west until they finally reached a small
alcove that held a magic sword, Diamond Edge. Leif approached and took the
sword. Immediately, the hallway was flooded with poison gas. The party
waited while it slowly dissipated. Since holding the sword seemed to
trigger the gas, Leif threw the sword to the end of the hall. They stepped
forward cautiously but no more gas was released. They made it to the end of
the hall safely and picked up the sword on the way out. Finding no further
exits, the party returned to the area outside the Clockwise Room and took
the northern path.

 Almost immediately they found a closed door. Opening the door revealed a
small room containing a magic sword, Fury. The party continued to the north
and east, bypassing a corridor that led to the south. When the party had
progressed as far to the east as possible, they found an alcove to the
south. Finding nothing after entering the alcove, they began to leave.
However, after taking just one step north and a second step to the west
they heard a distinctive click behind them. They stopped and returned to
the alcove. They found that a section of wall had disappeared. The group
entered the new area and found a button on the wall. Pushing the button
revealed a secret chamber, this one holding a skeleton key.

 The champions returned to the southward branch that they had passed earlier.
They quickly found a room with three locked doors and a single key. The
group took the key and chose to open the middle door. They entered this new
area and quickly discovered a creature that appeared to be living water.
This creature caused the heroes considerable consternation at first, as
their weapons seemed to pass through the monster with no effect. Noting how
similar the situation was to their first fight against ghosts, Gothmog cast
a DES EW spell. As he expected, the spell ripped into the creature causing
it to recoil. Now that they knew how to fight it, the champions made short
work of the water elemental. They continued to explore the area and found
two copper coins. Finally, they stepped on a pressure plate that opened an
exit door.

 The party continued down the hallway to the west until they found an alcove
in the southwest corner of the level. Inside the alcove was a button on one
of the walls. Pushing the button opened a portal two paces on the other
side of a wall south. Inside the secret chamber the group found a suit of
the most powerful armor they had yet discovered. Sonja gladly donned the
armor, and the group went back to a passage they had bypassed to the
northeast.

 The group proceeded down the hallway, first heading south then east. They
traveled down the corridor until they came to a series of three halls
branching off the north wall. The first corridor led to a hallway with the
words "Enlarge My View" on the east wall. Next to the words was an eye on
the wall. Gothmog stepped forward and held the magnifying glass they had
found on the tenth level up to the eye. Instantly, a secret passage was
revealed to the north.

 As they stepped forward onto a pressure plate inside the newly opened area,
they were propelled down the hallway until they were dropped in front of a
small alcove holding a ruby key. After taking the key, they were hurled
around the corner and back out into the hallway. On the west wall of the
hallway was another lock opened by the skeleton key. The champions opened
the passage to the central staircase. Since they were running low on water,
they made a quick trip back to the 9th level to restock their supply.

 After returning, they went back to the main corridor to see what the other
two offshoots held. The second hallway led to a downward staircase. The
final passage led to a small room with several coin slots. Sonja took the
two copper coins they had found earlier and inserted one into the first
coin slot. Near the slot a small alcove appeared holding a VEN potion. She
inserted her final coin into the second slot and more treasure was revealed.

 I decided to take advantage of my etherealness to see what was in each of
the alcoves. Starting with the one on the south wall and continuing in a
clockwise direction, I found: VEN potion, FUL Bomb, FUL Bomb and Green
Magic Box, 2 Copper Coins, Cross Key, Chest full of food, Green Magic Box.
Finally, having explored the area fully, it was time to move on. The group
rested briefly, then took the stairs down to the twelfth level.

 LEVEL TWELVE

 The four heroes arrived on this level and were greeted by the sound of
clanging metal in the distance. The sound was incessant and the champions
found it mildly unnerving. Brushing aside the unease all of them felt,
Sonja pushed ahead into the corridor where the stairs had led them in and
continued. Roused from their disquiet, the others quickly followed her.

 The hallway progressed to the south and ended as it opened up into a large
room. Just before the hall ended, a large pressure plate filled a section
of floor. The champions had no choice but to step on it before entering the
room.

 Once inside the room, they decided to search to the west first. Just as
they stepped forward Hissssa shouted for them to stop. The others were
stunned by the sudden noise and looked at him in alarm. Hissssa quickly
showed them the nearly invisible lines on the floor that outlined a series
of pits. It was impossible to continue west without stepping into one of
the pits. The group tried stepping on the pressure plate at the end of the
hallway a second time and they soon saw that doing so closed the pits. They
left the room through a hallway on the west wall. The hall led to a locked
door which the party was unable to open.

 Bypassing this room for now, they found a small chamber to the southwest
that contained a large button on the wall of an alcove. They pushed the
button but saw no discernible effect. They continued to the north and found
a button on the west wall of the corridor. The button revealed a secret
chamber just to the south. The group tried to continue, but after going
just a short distance, they encountered another locked door. With two
locked doors and no further avenues of progress, the heroes decided to go
back and begin exploring the eastern half of the dungeon.

 They went back to the large room that had held all of the pits and exited
through the corridor on the eastern wall. They soon entered a large chamber
with a small room in the center of it. The group was unaware of it, but the
door to the room was open only because they had pushed the button in the
western area they had just left. Coming out of the room and toward the
champions was a knight clad in full plate mail. Gothmog cast a fireball but
the knight continued to approach as if it had felt nothing. Since the armor
appeared to impervious to flame, Gothmog decided to try electricity in its
place. He cast a powerful Lightning Bolt spell and it seemed to have a
small impact.

 By now the knight had reached the party and Sonja leaped to the attack with
Leif charging right behind her. Both of their weapons struck the armored
foe squarely but did little real damage. The knight then retaliated.
Swinging two swords with ease, it struck Leif twice in rapid succession and
wounded him sorely. The battle continued with Sonja and Leif striking to
little effect while the knight concentrated its attacks on Leif with great
success.

 Finally, with Leif near death, Hissssa surged forward while Leif retreated
to the rear. The lizard man swung Hardcleave with all of his might and
landed a crushing blow on the knight's head. The armor clad fiend was
rocked for only a moment before it recovered and returned the attack
twofold. As the fight raged on, Hissssa and Sonja both gulped down several
healing potions to preserve their lives. Ultimately, the combination of
numerous Lightning Bolts thrown by Leif and Gothmog and the relentless
pounding that Sonja and Hissssa subjected the knight to took its toll.

 After Hissssa landed one final blow, the armor suddenly collapsed into a
heap on the ground. If there had ever been a man inside the armor, there
was certainly no sign of it. The armor that lay before them had been proved
painfully effective but none of the champions had any desire to claim even
a single piece of it to wear for themselves. The armor was obviously cursed
and none of the heroes had any intention of entrusting their lives to the
evil magic of which the armor fairly reeked.

 With the knight defeated, the party was free to explore the small room in
the center of the chamber. They found a Topaz Key inside. Remembering the
two locked doors in the western area they decided to try this new key and
see if it would open one of them. The group returned to the first locked
door and found that it did indeed open it. They were forced to dispatch
another knight but they found an Emerald Key where the armor had fallen.
Taking this key, they went on to the second locked door and discovered that
the Emerald Key unlocked it easily. In the room beyond this door was a
small alcove that held a RA key.

 Next, they took a corridor on the north wall. Just two paces north, a
hallway branched off to the east. Exploring this passage led to a small
chamber. In this chamber was another button. Pushing this button had no
obvious effect although it actually opened up access to a room in the
northeast corner of the level. At this point Gothmog decided they had
explored enough of the western half of the dungeon level for the present.
His instincts told him they were meant to fully explore the eastern area
before proceeding any further in the west.

 The others accepted his wishes with a shrug. While he tended to act a bit
strangely, Gothmog had yet to lead them astray. For my part, I, too, was
amazed at the way Gothmog had led the party through the maze of traps and
puzzles in the dungeon. I can only guess that when I communicated with him
at the beginning of the quest, a lot more information must have been passed
to him than I realized. It is possible that he absorbed everything I know
about these dungeons. While he does not seem to be aware of this
information, he could have retained it deep in his mind. Of course, Chaos
has altered these caverns immensely, but a knowledge of what his puzzles
are based on and twisted from can aid one greatly to determine the solution.

 The champions returned to the large cavern where they had found the Topaz
key and exited through a hallway in the southeast corner of the chamber.
They found a long hallway leading north with two doors on the east wall of
the corridor. On the wall between the two doors was a button. Pushing the
button opened a secret passage in the room behind the southern door. They
explored the new passage and saw that it led to a series of hallways.

 After the champions had gone a short distance to the north and east, they
were faced with a hallway leading both north and south. The party decided
to explore the southern segment first. In the hallways and alcoves beyond,
they found the most powerful suit of armor known to exist. The armor of
Darc was a most welcome discovery although only Hissssa possessed the
strength to wear the armor without becoming seriously encumbered. The group
then returned to the crossroads and took the northward path. They continued
without incident and passed through a door. After passing through the door
they were faced with a second crossroads. They took the western path and
quickly came to a corridor that appeared to be a dead end. Despite
searching the area for a time they could find nothing, so the party began
walking back down the hall to leave.

 Suddenly, they heard a noise behind them and saw that a secret passage had
opened up back at the end of the corridor. After defeating the knight
inside the secret chamber the champions discovered a number of valuable
items. They returned to the doorway next and took the eastern passage. They
soon came to a room that they were only able to enter because they had
pushed the button in the western area of the dungeon. After a near fatal
clash with the guardians of this room (two more of the armored knights),
the champions collected the numerous useful items inside. Hissssa claimed
the final piece of the armor of Darc while Gothmog gathered up the
remaining items including the skeleton key for this level. With no more
avenues left to explore, the party realized that it was time to return to
the eastern half of this dungeon level.

 The party returned to the room where they had found the RA key and once
again exited through the corridor on the north wall. They followed many
twisting passages up to the northwest corner of this level and then found a
long hallway leading to the east. Off the south wall of this hallway was an
alcove with a button on one of the walls. The button caused the section of
wall to the south to disappear, opening a shortcut of sorts back to areas
the group had already explored.

 Since there was no need to revisit these areas, they continued eastward
down the long hallway. The corridor twisted, first to the east, then to the
south. Finally, it headed back toward the west. After going only a short
distance to the west, the champions saw that the hall led to a large
chamber. Just at the end of the hallway, before entering the chamber, was a
button on the wall. They pushed the button and heard a noise back to the
southeast in the area they had just left.

 They went back up the corridor and found that a new passage was open
leading to three doors surrounding a pressure plate on the floor. The
heroes stepped forward onto the pressure plate and all three doors opened
at once. Giant creatures that vaguely resembled spiders came streaming out
into the corridor and attacked viciously. The champions were being attacked
on three sides and could see that the battle would be lost if that
situation remained unchanged.

 They hurriedly stepped back into the narrow hallway, limiting the number of
monsters that could approach at one time. They still found it necessary to
swallow a number of healing potions, but eventually the last of the
abominations had been destroyed and the path forward was clear. In the room
beyond, the group found several useful items including the Helm of Lyte.

 The party returned to the button that had opened the secret passage and
went into the room beyond. Just past the room, they found a door that led
to a short hallway. At the end of the hallway was a second door and a
button nearby. This button appeared to control both doors. Beyond the
second door was a cluster of four pits that formed a square. Each of the
pits was opening and closing at a rapid rate. As they watched, a pattern
seemed to emerge. It became clear that if they could time the opening of
the pits correctly, they would be able to make it across safely. Finally,
they charged across the floor and were on solid ground before any of the
pits had time to collapse under their feet.

 Immediately after the pits, they found a small alcove containing a Master
Key. To the north of the alcove, they found a staircase leading down. To
the south they discovered the now familiar skull on the wall for the
skeleton key. This time, however, Gothmog opted to keep the key instead of
using it. He believed that the quest was nearing its completion. The next
levels would certainly be the most dangerous and they might have need of a
skeleton key but not have the time to search for one. The group also
decided that they would take the two RA keys they had discovered since
leaving level seven and return there. These two keys would hopefully allow
them to fully explore the areas up there that had been denied them so far.

 LEVEL THIRTEEN

 The four champions immediately sensed the presence of Lord Chaos when they
entered this level. This was a matter of no small concern because even
though they had recovered the Firestaff, they had yet to attach the Power
Gem to the staff. They would not be ready to face Chaos until this was done.
Since they had thoroughly explored all the levels above this one, they
could only assume that the Power Gem must rest on a floor lower than the
thirteenth. They carefully began searching for a stairway leading down and
found one to the southwest. Before them was a skull on the wall just
waiting for a skeleton key to open the passage to the stairs it guarded.
The party members were grateful that Gothmog had kept the skeleton key on
the twelfth level for future use. He calmly pulled out the key and used it.
The group stepped forward and descended to the fourteenth level.

 The four champions returned to this level with the transformed Firestaff in
their possession. Each of the heroes seemed ill at ease, but none spoke
openly their fears. They were near the fulfillment of their long quest, but
the oppressive presence of Lord Chaos so permeated this level of the
dungeon, it was impossible for them to resist having some feelings of
apprehension.

 Showing their true courage, they moved forward and found a passage leading
east. This passage led to a large, open room with black flame dotting the
floor and demons roaming in large numbers. The group quickly cast a number
of Fireshield spells and moved into the room. Since the area to the north
seemed to hold the greatest concentration of monsters, the group headed
south. They were not here to waste time with lesser evils; Chaos was their
chosen target. They would look to the south and hope to fight him away from
the other creatures that might support him in battle.

 The party walked along the southern wall when Chaos suddenly appeared
before them. The master of Chaos was adorned in pitch black robes and a
horned helmet. The heroes knew they had to surround him with a Fluxcage
before attempting to Fuse him. Gothmog, had an idea that the wall would
probably work as well as a Fluxcage and would be easier to work out. Since
Chaos was approaching them along the southern wall, they quickly stepped
away from the wall and forward so that Chaos was standing directly between
the heroes and the south wall.

 Not bothering to strike any physical blows at Chaos, the champions leaped
to the left and cast a Fluxcage in front of them. Next, they immediately
leaped back in front of Chaos before he could move. Then, they jumped to
the right and cast a second Fluxcage. Once again, they charged back in
front of Chaos before he could follow them. They now had Fluxcages on
either side of Chaos with only the front left to cover. The heroes stepped
back and cast the third and final Fluxcage. The cage appeared in front of
them and they immediately stepped forward into the cage to bar Chaos's
escape. He was now completely encircled by the cage.

 With great exultation, Gothmog cast the Fuse spell from the Firestaff and
it struck Chaos squarely in the chest. There was a series of exploding
lights and great noise that forced each of the heroes to turn their heads.
When they were able to see again, the Grey Lord stood before them fully
restored. I was also returned to solid form, although no one noticed my
presence at first. The Grey Lord praised the four champions for their
unswerving devotion to defeating Chaos as well as their unquestionable
valor. Finally, I introduced myself to these four people that I had come to
know so well. Our problems were over. At least for the present....

 LEVEL FOURTEEN
 
 The champions descended the central staircase to this level only to find a
locked door in front of them. The winged key from the seventh level
unlocked the door and they entered the hallway beyond. The corridor made
its way to the east and then came to an end with a lever on the wall. Leif
pulled the lever and a passage opened in the south wall that revealed a
spacious cavern.

 The party began exploring to the west when a large ball of flame burst into
their midst. The group turned to find the source of the attack and were
stunned to see a huge red dragon lumbering forward. They saw a large,
square column in the center of the room a little further to the west and
ran for it. They positioned themselves so that the column was between the
dragon and themselves. The column was fully ten feet wide and would provide
a perfect shield against the dragon's fiery breath. Still, the dragon was
coming and the heroes had little doubt that if they attempted to stand toe
to toe with this monster, it would make their earlier fights against the
stone golems look easy in comparison. They simply had to use hit and run
tactics, or there was no hope of survival.

 Since none of the heroes was particularly interested in committing suicide,
they listened intently while Hissssa outlined his plan. Once again, the sly
lizardman had hatched a battle plan that held great promise. They waited
patiently behind the column for the dragon to approach. When it finally
came around the corner of the column, Hissssa and Sonja quickly struck the
beast with Hardcleave and the Inquisitor. Then, before the dragon could
retaliate, they quickly stepped backwards and then to the side behind the
column once again. Once again they waited for the dragon to round the
corner and they struck again, retreating before it could strike any blows
of its own.

 They continued this process for what seemed like hours. When they had the
chance, the champions would prepare their most powerful Lightning Bolt
spells and cast those at the great beast as well. The dragon withstood all
of these attacks for a very long time but, ultimately, the damage began to
have an effect and the behemoth finally fell dead.

 With the dragon defeated, the party began to search its lair. They found a
number of worthless items as well as some that were more valuable. The only
really important item was just one step to the south and east from the
hallway they had used to enter the cavern. Hidden under some ashes was a
Square Key.

 The key opened the door to the west and the group eagerly entered the room.
On the northern wall of the room was the Power Gem held in an energy field.
A scroll nearby advised that the only way to free the gem was to use the
proper spell. Gothmog thought for a moment before chanting a ZO KATH RA
spell and placing it on the gem. The energy field immediately changed its
appearance but the gem remained in place. Gothmog thrust the Firestaff into
the field and aimed directly for the gem. As he pulled the staff back, the
Power Gem was firmly attached to the staff. The staff was now transformed
and there was nothing to stop the heroes from confronting Lord Chaos.

 Before leaving the room, however, Gothmog stopped short as if he sensed
something was amiss. Suddenly, he threw the staff to the south through the
doorway into the dragon's den. I was now certain that he must have absorbed
my knowledge of the dungeons. Only the Grey Lord and I knew of the
protective spells that would cause all stairways above the thirteenth level
to be closed off if anyone were to carry the Power Gem out of its storage
room. By throwing the staff out the door, Gothmog had evaded the alarm and
would be free to return to the upper levels if necessary. He quietly
retrieved the staff and the group took the stairs back up to the thirteenth
level for their final battle.
 
 SPELLS

 During the course of their journey through the dungeons, the heroes
discovered many spells that proved invaluable to them. The following is a
complete list of all those spells as well as the syllables needed to invoke
them.

 PRIEST SPELLS

 Darkness (DES-IR-SAR): Reduces the level of light available. It has been
claimed by some that certain monsters need light to see and are hampered by
total darkness. Unfortunately, the champions were unable to find any
monsters that were effected. They also found that they were handicapped
themselves by the darkness. As a result, the spell went largely unused.

 Fireshield (FUL-BRO-NETA): Reduces the amount of damage taken from
fireballs and dragon flame. These spells provide cumulative protection if
more than one is cast.

 Shield (YA-IR): This spell should reduce the damage absorbed from normal
weapons.

 BRO Potion (VI-BRO): Cures the poisoned.

 DANE Potion (YA-BRO-DAIN): Temporarily raises one's wisdom.

 EE Potion (ZO-BRO-RA): Restores some used mana.

 KU Potion (FUL-BRO-KU): Temporarily raises one's strength.

 MA Potion (YA): Restores some lost stamina.

 NETA Potion (YA-BRO-NETA): Temporarily raises one's vitality.

 ROS Potion (OH-BRO-ROS): Temporarily raises one's dexterity.

 VEN Potion (ZO-VEN): Poison bomb will create a cloud of poison when thrown.

 VI Potion (VI): Restores some lost health.

 YA Potion (YA-BRO): This potion should have an effect similar to the Shield
spell except that it will only protect one person.

 WIZARD SPELLS

 Cloud of Poison (OH-VEN): Casts forward a cloud of poison. The cloud will
continue forward until it strikes a creature or wall. After impact the
cloud hovers in place while slowly dissipating.

 Fireball (FUL-IR): Casts forward a ball of flame. The flame will continue
until it strikes a creature or wall.

 Harm Non-Material Being (DES-EW): Harms all immaterial or "summoned"
monsters such as ghosts, water elementals, and black flame. The spell
travels forward as a bolt and continues until it strikes a creature or wall.
 
 Invisibility (OH-EW-SAR): Makes you invisible for a brief period of time.
Certain monsters do not use sight to find you, and will be uneffected. The
groups attempts to use this spell met with repeated failure. This spell is
highly unreliable, and the party quickly learned not to depend on it.

 Light (OH-IR-RA): Will increase the available light. Longer lasting than
the Magic Torch spell.

 Lightning Bolt (OH-KATH-RA): Casts forward a bolt of lighting. The bolt
will continue forward until it strikes a creature or wall.

 Magic Footprints (YA-BRO-ROS): Leaves a temporary trail of footprints
behind the caster.

 Magic Torch (FUL): Will increase the available light.

 Open Door (ZO): This will open some doors.

 Poison (DES-VEN): Casts forward a bolt of poison. The bolt will continue
forward until it strikes a creature or wall.

 Thieves' Eye (OH-EW-RA): Will allow you to momentarily see through a
section of wall or a closed door.

 Zokathra (ZO-KATH-RA): Will create a ball of weightless plasma. It was
necessary for the heroes to use this spell just once during their quest.

 Virtually all of the spells listed become more powerful as the power of the
first syllable is increased. The exceptions to this rule are the BRO Potion,
the Open Door spell, and the Zokathra spell. All of these perform their
normal function regardless of the power syllable spoken. A fireball, on the
other hand, will do far more damage if you speak the MON symbol than if you
choose LO. Increasing the power also increases the difficulty level of
casting. The inexperienced spellcaster will have to be content with
relatively weak spells. Fortunately, the dedicated student can quickly cast
spells that grow more and more potent.

 ITEMS

 As we traveled through the dungeon, we found a great many items of varying
usefulness. Some had an obvious use while others had a more subtle effect
on the champions. The following list details each of the more unusual items
that were found, and briefly discloses what we believed its function to be.
Some of these items were left behind, although the heroes were always
careful to leave them in a place where they could be retrieved if necessary.
They found the area outside the screamer room on level 4 to be a good place
to store items at first. After they had progressed further, they moved
their base camp to the seventh level for easier access. Keeping both their
excess food as well as excess magic items greatly aided the group in
retrieving things that they had not thought they would need. The following
is by no means an exhaustive list of everything we found, but it does
include all of the more unusual items and those whose function were not
immediately obvious.

 Armor of Darc: Heavier than normal plate armor but also the strongest armor
in the world. Only a very strong champion would be able to wear the
complete set without being encumbered.

 Armor of Lyte: Lighter and stronger than ordinary plate armor.

 Boots of Speed: Will significantly increase the speed of the wearer.
Unfortunately, no group can move more quickly than its slowest member.
Unless everyone in a party has a pair, there will be no impact on that
group's speed of movement.

 Calista: This crown has no apparent use or function.

 Choker: This device has no known function.

 Cloak of Night: Increases the wearer's dexterity 15 points.

 Crown of Nerra: Increases the wisdom of the wearer 10 points.

 Dragonspit: Raises the maximum mana of the bearer.

 Ekkhard Cross: This talisman is reputed to protect the wearer and lessen
the amount of experience needed to advance as a priest. After testing this
item extensively I have been unable to confirm that it has any effect on
the wearer at all.

 Elven Boots: Adds to the maximum load a champion may carry.

 Firestaff: Before attaching the Power Gem the Firestaff could be used to
Parry attacks, Brandished to frighten monsters, and create a Fireshield.
After attaching the gem the Firestaff will Invoke a random attack spell,
create a Fluxcage, or Fuse an opponent. Finally, the Firestaff will add one
level of achievement to each class of the champion wielding it before the
gem is attached and it will raise each class two levels after the gem is
attached.

 Flamebain: This mail raises the wearer's Anti-Fire score by 12 points.

 Flamitt: This ring can cast a limited number of fireballs.

 FUL Bomb: Acts like a fireball when thrown.

 Fury: In addition to acting as a normal sword, it can cast a limited number
of fireballs.

 Gem of Ages: Reputed to increase the mana of the wearer. In truth, the gem
has no effect that I can determine.

 Hardcleave: This axe is one of the two most powerful weapons known to exist
along with the Inquisitor.

 Hellion: Reputed to combine psychic, magic and energy interchangeably into
any form you wish. While the legend is very impressive, I could not
discover any use or function for this amulet.

 Horn of Fear: Will sometimes frighten monsters into fleeing.

 Illumulet: Increases the available light but only from total darkness.

 Inquisitor: The finest sword in the world. Also raises the maximum mana of
the bearer.

 Jewel Symal: Raises the Anti-Magic score of wearer 15 points.

 Mace of Order: Increases the bearer's strength 5 points. While this is
useful for allowing a weak hero to carry a heavier burden, the mace is not
particularly effective in combat.

 Magical Box: Freezes enemies in place during combat for a short time.

 Magnifier: Used to solve a couple of puzzles but otherwise useless.

 Mirror of Dawn: No apparent use other than to solve a puzzle or two.

 Moonstone: Adds 3 to the wearer's maximum mana.
 
 Pendant Feral: Adds one level to a champions's wizard status.

 Rabbit's Foot: This item is reputed to increase the luck of the champion
who wears it in certain situations. Unfortunately, it is impossible to
determine which situations these might be and how effective it is.

 Scepter of Lyf: Restores all lost health to a champion at the cost of 1
point of mana per 5 points of health restored.

 Snakestaff: In addition to possibly frightening monsters, the staff can be
used to Heal champions or Calm enemies. Also adds to bearer's maximum mana.

 Staff of Claws: Will sometimes frighten monsters into fleeing. Also adds to
the bearer's maximum mana.

 Staff of Manar: Can be used to dispel non-material beings or create a
Fireshield. Also adds to bearer's maximum mana.

 Stormring: Can cast a limited number of lightning bolts.

 Teowand: Casts Calm, Spellshield, and Fireshield. Also adds to the mana of
the bearer.

 Vorpal Blade: The only sword that harms non-material beings. Also adds to
the bearer's maximum mana.

 Wand: Can cast a Calm spell on monsters, Spellshield, and Heal. For most
champions the wand will also add to the maximum mana of the bearer although
for some champions it may actually lower mana.

 Yew Staff: Can be used to Parry attacks, cast a Light spell, and dispel
non-material beings. Also adds to the bearer's maximum mana.

 DUNGEON MASTER is published and distributed by FTL Games.

 This walkthru is copyright (c) 1991 by Joseph Boone and THE ELECTRONIC 
GAMER (tm). All rights reserved. Not to be distributed without permission.
